/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.web.job;

import com.franciaflex.faxtomail.FaxToMailApplicationContext;
import com.franciaflex.faxtomail.FaxToMailConfiguration;
import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFileImpl;
import com.franciaflex.faxtomail.persistence.entities.AttachmentImpl;
import com.franciaflex.faxtomail.persistence.entities.Client;
import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.EmailAccount;
import com.franciaflex.faxtomail.persistence.entities.EmailImpl;
import com.franciaflex.faxtomail.persistence.entities.ExtensionCommand;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailTopiaPersistenceContext;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.MailFilter;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.services.DecoratorService;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.services.FaxToMailServiceUtils;
import com.franciaflex.faxtomail.services.service.ClientService;
import com.franciaflex.faxtomail.services.service.ConfigurationService;
import com.franciaflex.faxtomail.services.service.EmailService;
import com.franciaflex.faxtomail.services.service.MailFolderService;
import com.franciaflex.faxtomail.web.job.AbstractFaxToMailJob;
import com.franciaflex.faxtomail.web.job.MailFilterJob;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.PdfWriter;
import gui.ava.html.Html2Image;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.util.StringUtil;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.xhtmlrenderer.pdf.ITextRenderer;

@DisallowConcurrentExecution
public class MailFilterJob
extends AbstractFaxToMailJob {
    private static final Log log = LogFactory.getLog(MailFilterJob.class);
    protected FaxToMailApplicationContext applicationContext;
    protected FaxToMailConfiguration config;
    protected ConfigurationService configurationService;
    protected EmailService emailService;
    protected MailFolderService mailFolderService;
    protected ClientService clientService;
    protected DecoratorService decoratorService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        this.applicationContext = this.getApplicationContext(jobExecutionContext);
        try (FaxToMailTopiaPersistenceContext persistenceContext = null;){
            persistenceContext = this.applicationContext.newPersistenceContext();
            FaxToMailServiceContext serviceContext = this.applicationContext.newServiceContext(persistenceContext);
            this.config = serviceContext.getApplicationConfig();
            if (log.isInfoEnabled()) {
                log.info((Object)("Running MailFilterJob at " + serviceContext.getNow()));
            }
            this.emailService = serviceContext.getEmailService();
            this.mailFolderService = serviceContext.getMailFolderService();
            this.configurationService = serviceContext.getConfigurationService();
            this.clientService = serviceContext.getClientService();
            this.decoratorService = serviceContext.getDecoratorService();
            List emailAccounts = this.configurationService.getEmailAccounts();
            for (EmailAccount account : emailAccounts) {
                this.checkEmails(account);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("MailFilterJob ended at " + serviceContext.getNow()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void checkEmails(EmailAccount account) {
        block19: {
            Properties properties = new Properties();
            switch (1.$SwitchMap$com$franciaflex$faxtomail$persistence$entities$EmailProtocol[account.getProtocol().ordinal()]) {
                case 1: {
                    properties.setProperty("mail.imap.ssl.enable", "true");
                }
                case 2: {
                    properties.setProperty("mail.store.protocol", "imap");
                    properties.setProperty("mail.imap.host", account.getHost());
                    properties.setProperty("mail.imap.port", String.valueOf(account.getPort()));
                    properties.setProperty("mail.imap.connectiontimeout", "2000");
                    break;
                }
                case 3: {
                    properties.setProperty("mail.pop3.ssl.enable", "true");
                }
                case 4: {
                    properties.setProperty("mail.store.protocol", "pop3");
                    properties.setProperty("mail.pop3.host", account.getHost());
                    properties.setProperty("mail.pop3.port", String.valueOf(account.getPort()));
                    properties.setProperty("mail.pop3.connectiontimeout", "2000");
                }
            }
            Session session = Session.getInstance((Properties)properties);
            Store store = null;
            Folder defaultFolder = null;
            Folder inbox = null;
            store = session.getStore();
            store.connect(account.getLogin(), account.getPassword());
            defaultFolder = store.getDefaultFolder();
            inbox = defaultFolder.getFolder("INBOX");
            this.checkEmailsOfFolder(account, inbox);
            this.close(inbox);
            this.close(defaultFolder);
            try {
                if (store != null && store.isConnected()) {
                    store.close();
                }
                break block19;
            }
            catch (MessagingException e) {
                log.error((Object)"Error while closing the store", (Throwable)e);
            }
            break block19;
            catch (Exception e) {
                try {
                    log.error((Object)"Error while getting emails from the mailbox", (Throwable)e);
                }
                catch (Throwable throwable) {
                    this.close(inbox);
                    this.close(defaultFolder);
                    try {
                        if (store != null && store.isConnected()) {
                            store.close();
                        }
                    }
                    catch (MessagingException e2) {
                        log.error((Object)"Error while closing the store", (Throwable)e2);
                    }
                    throw throwable;
                }
                this.close(inbox);
                this.close(defaultFolder);
                try {
                    if (store != null && store.isConnected()) {
                        store.close();
                    }
                }
                catch (MessagingException e3) {
                    log.error((Object)"Error while closing the store", (Throwable)e3);
                }
            }
        }
    }

    protected void close(Folder folder) {
        if (folder != null && folder.isOpen()) {
            try {
                boolean expunge = this.config.isMailExpunge();
                folder.close(expunge);
            }
            catch (Exception e) {
                log.error((Object)"Error while closing the folder", (Throwable)e);
            }
        }
    }

    protected void checkEmailsOfFolder(EmailAccount emailAccount, Folder folder) {
        int importedCount = 0;
        try {
            folder.open(2);
            int count = folder.getMessageCount();
            int unread = folder.getUnreadMessageCount();
            if (log.isDebugEnabled()) {
                log.debug((Object)(count + " messages, " + unread + " unread"));
            }
            for (int i = 0; i < count; ++i) {
                try {
                    Attachment attachment;
                    Address[] ccRecipients;
                    EmailImpl email = new EmailImpl();
                    email.setFax(emailAccount.isFaxAccountType());
                    int messageNumber = count - i;
                    Message message = folder.getMessage(messageNumber);
                    Charset charset = FaxToMailServiceUtils.getCharset((Part)message);
                    ArrayList<String> modifiedProperties = new ArrayList<String>();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Message %d/%d : %s", i, count, message.getSubject()));
                    }
                    ArrayList<Address> recipients = new ArrayList<Address>();
                    Address[] toRecipients = message.getRecipients(Message.RecipientType.TO);
                    if (toRecipients != null) {
                        recipients.addAll(Arrays.asList(toRecipients));
                    }
                    if ((ccRecipients = message.getRecipients(Message.RecipientType.CC)) != null) {
                        recipients.addAll(Arrays.asList(ccRecipients));
                    }
                    MailFilter filter = null;
                    for (Address address : recipients) {
                        String recipient = address.toString();
                        recipient = recipient.replaceFirst("^.*<(.*)>$", "$1");
                        Collection filters = this.mailFolderService.getFiltersForRecipient(recipient = recipient.toLowerCase());
                        if (!CollectionUtils.isNotEmpty((Collection)filters)) continue;
                        filter = (MailFilter)filters.iterator().next();
                        email.setRecipient(recipient);
                        modifiedProperties.add("recipient");
                        break;
                    }
                    if (filter == null) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)" ==> No filter found for this message");
                        if (!log.isTraceEnabled()) continue;
                        for (Address address : recipients) {
                            log.trace((Object)(" - for recipient " + address.toString()));
                        }
                        continue;
                    }
                    MailFolder filterFolder = filter.getMailFolder();
                    while (!filterFolder.isUseCurrentLevelCompany() && filterFolder.getParent() != null) {
                        filterFolder = filterFolder.getParent();
                    }
                    String company = filterFolder.getCompany();
                    Address[] addresses = message.getFrom();
                    if (addresses != null && addresses.length > 0) {
                        FaxToMailUser personInCharge;
                        String object;
                        String sender = addresses[0].toString();
                        sender = sender.replaceFirst("^.*<(.*)>$", "$1");
                        sender = sender.toLowerCase();
                        Client client = this.clientService.getClientForEmailAddress(sender, (Email)email, company);
                        modifiedProperties.add("sender");
                        if (client != null) {
                            String faxNumber;
                            String contact = sender;
                            if (email.isFax() && StringUtils.isNumeric((CharSequence)(faxNumber = contact.substring(0, contact.indexOf(64)).replaceAll(" ", "")))) {
                                contact = StringUtils.leftPad((String)faxNumber, (int)10, (char)'0');
                            }
                            ArrayList<String> objectItems = new ArrayList<String>();
                            if (StringUtils.isNotEmpty((CharSequence)client.getCaracteristic1())) {
                                objectItems.add(client.getCaracteristic1());
                            }
                            if (StringUtils.isNotEmpty((CharSequence)client.getCaracteristic2())) {
                                objectItems.add(client.getCaracteristic2());
                            }
                            if (StringUtils.isNotEmpty((CharSequence)client.getCaracteristic3())) {
                                objectItems.add(client.getCaracteristic3());
                            }
                            if (StringUtils.isNotEmpty((CharSequence)client.getCode())) {
                                objectItems.add(client.getCode());
                            }
                            if (StringUtils.isNotEmpty((CharSequence)client.getName())) {
                                objectItems.add(client.getName());
                            }
                            objectItems.add(contact);
                            objectItems.add(DateFormat.getDateInstance(2).format(new Date()));
                            object = StringUtils.join(objectItems, (String)" / ");
                            modifiedProperties.add("client");
                        } else {
                            object = I18n.t((String)"faxtomail.email.object.noClient", (Object[])new Object[0]);
                        }
                        email.setObject(object);
                        email.setClient(client);
                        modifiedProperties.add("object");
                        MailFolder mailFolder = null;
                        if (!filter.isFilterFolderPriority() && client != null && (personInCharge = client.getPersonInCharge()) != null) {
                            mailFolder = this.mailFolderService.getFolderForFaxToMailUser(personInCharge);
                        }
                        if (mailFolder == null) {
                            mailFolder = filter.getMailFolder();
                        }
                        email.setMailFolder(mailFolder);
                        modifiedProperties.add("mailFolder");
                        if (client == null && emailAccount.isRejectAllowed()) {
                            Boolean reject = null;
                            String rejectMessage = null;
                            String senderEmail = null;
                            for (MailFolder rejectMailFolder = mailFolder; !(Boolean.FALSE.equals(reject) || rejectMailFolder == null || reject != null && rejectMailFolder.isUseCurrentLevelRejectResponseMessage() && rejectMailFolder.isUseCurrentLevelRejectResponseMailAddress()); rejectMailFolder = rejectMailFolder.getParent()) {
                                if (reject == null) {
                                    reject = rejectMailFolder.getRejectUnknownSender();
                                }
                                if (rejectMessage == null && rejectMailFolder.isUseCurrentLevelRejectResponseMessage()) {
                                    rejectMessage = rejectMailFolder.getRejectResponseMessage();
                                }
                                if (senderEmail != null || !rejectMailFolder.isUseCurrentLevelRejectResponseMailAddress()) continue;
                                senderEmail = rejectMailFolder.getRejectResponseMailAddress();
                            }
                            if (Boolean.TRUE.equals(reject)) {
                                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{senderEmail, rejectMessage})) {
                                    if (!log.isWarnEnabled()) continue;
                                    log.warn((Object)"Can't send reject message due to invalid configuration");
                                    continue;
                                }
                                String recipient = email.getSender();
                                if (email.isFax()) {
                                    recipient = FaxToMailServiceUtils.addFaxDomainToFaxNumber((String)recipient, (MailFolder)mailFolder);
                                }
                                this.emailService.rejectEmail(senderEmail, recipient, I18n.t((String)"faxtomail.email.subject.re", (Object[])new Object[]{message.getSubject()}), rejectMessage);
                                this.deleteMail(message);
                                continue;
                            }
                        }
                    }
                    Date receivedDate = new Date();
                    email.setReceptionDate(receivedDate);
                    modifiedProperties.add("receptionDate");
                    Date now = new Date();
                    Decorator dateDecorator = this.decoratorService.getDecoratorByType(Date.class, "date");
                    String projectRef = I18n.t((String)"faxtomail.email.projectReference.default", (Object[])new Object[]{dateDecorator.toString((Object)now)});
                    email.setProjectReference(projectRef);
                    modifiedProperties.add("projectReference");
                    email.setDemandStatus(DemandStatus.UNTREATED);
                    modifiedProperties.add("demandStatus");
                    StringBuilder emailSource = new StringBuilder();
                    Enumeration headerLines = ((MimeMessage)message).getAllHeaderLines();
                    while (headerLines.hasMoreElements()) {
                        String headerLine = (String)headerLines.nextElement();
                        emailSource.append(headerLine).append("\n");
                    }
                    String originalContent = IOUtils.toString((InputStream)message.getInputStream(), (Charset)charset);
                    emailSource.append("\n").append(originalContent);
                    email.setOriginalEmail(emailSource.toString());
                    ArrayList<Attachment> attachments = new ArrayList<Attachment>();
                    if (message.isMimeType("multipart/*")) {
                        String htmlContent = this.decomposeMultipartEmail(attachments, (Part)message, (Email)email, this.emailService);
                        if (htmlContent != null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Converting html content to pdf : " + message.getSubject()));
                            }
                            if ((attachment = this.convertHTMLToPdf(attachments, htmlContent, I18n.t((String)"faxtomail.email.content.attachment.htmlfileName", (Object[])new Object[0]))) != null) {
                                String plainTextFileName = I18n.t((String)"faxtomail.email.content.attachment.plainfileName", (Object[])new Object[0]) + ".pdf";
                                for (Attachment a : attachments) {
                                    if (!plainTextFileName.equals(a.getOriginalFileName())) continue;
                                    attachments.remove(a);
                                    break;
                                }
                                attachments.add(attachment);
                            }
                        }
                    } else {
                        String content = IOUtils.toString((InputStream)message.getInputStream(), (Charset)charset);
                        attachment = this.convertTextToPdf(content, I18n.t((String)"faxtomail.email.content.attachment.plainfileName", (Object[])new Object[0]));
                        attachments.add(0, attachment);
                    }
                    this.emailService.saveEmail((Email)email, attachments, null, email.getClient() != null ? email.getClient().getCode() : null, null, modifiedProperties.toArray(new String[modifiedProperties.size()]));
                    ++importedCount;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(" ==> Message plac\u00e9 dans le dossier " + email.getMailFolder().getName()));
                    }
                    this.deleteMail(message);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)"Error while reading the email", (Throwable)e);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"End of emails");
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while reading the emails", (Throwable)e);
        }
        if (importedCount > 0 && log.isInfoEnabled()) {
            log.info((Object)String.format("Imported %d mail for account %s@%s", importedCount, emailAccount.getLogin(), emailAccount.getHost()));
        }
    }

    protected void deleteMail(Message message) throws MessagingException {
        if (this.config.isMailDelete()) {
            message.setFlag(Flags.Flag.DELETED, true);
        }
    }

    protected String decomposeMultipartEmail(List<Attachment> attachments, Part part, Email email, EmailService emailService) throws Exception {
        String result = null;
        DataSource dataSource = part.getDataHandler().getDataSource();
        MimeMultipart mimeMultipart = new MimeMultipart(dataSource);
        int multiPartCount = mimeMultipart.getCount();
        for (int j = 0; j < multiPartCount; ++j) {
            String contentID;
            String fileName;
            MimeBodyPart bp;
            block9: {
                bp = (MimeBodyPart)mimeMultipart.getBodyPart(j);
                String disposition = bp.getDisposition();
                if (bp.isMimeType("text/*") && !"attachment".equals(disposition)) {
                    Charset charset = FaxToMailServiceUtils.getCharset((Part)bp);
                    String content = IOUtils.toString((InputStream)bp.getInputStream(), (Charset)charset);
                    if (bp.isMimeType("text/plain")) {
                        Attachment attachment = this.convertTextToPdf(content, I18n.t((String)"faxtomail.email.content.attachment.plainfileName", (Object[])new Object[0]));
                        attachments.add(attachment);
                        continue;
                    }
                    result = content;
                    continue;
                }
                if (bp.isMimeType("multipart/*")) {
                    String htmlContent = this.decomposeMultipartEmail(attachments, (Part)bp, email, emailService);
                    if (htmlContent == null) continue;
                    result = htmlContent;
                    continue;
                }
                fileName = bp.getFileName();
                String[] headers = bp.getHeader("Content-ID");
                contentID = null;
                if (headers != null) {
                    contentID = headers[0];
                    contentID = contentID.replaceFirst("^<(.*)>$", "$1");
                }
                if (fileName == null && contentID == null) break;
                if (fileName == null) {
                    fileName = contentID;
                }
                try {
                    fileName = MimeUtility.decodeText((String)fileName);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("FileName : " + fileName + ", Content-ID : " + contentID));
                    }
                }
                catch (UnsupportedEncodingException ex) {
                    if (!log.isWarnEnabled()) break block9;
                    log.warn((Object)"Can't debug email file name", (Throwable)ex);
                }
            }
            DataHandler dh = bp.getDataHandler();
            AttachmentImpl attachment = new AttachmentImpl();
            attachment.setAddedByUser(false);
            AttachmentFile attachmentFile = emailService.getAttachmentFileFromStream(dh.getInputStream());
            attachmentFile.setFilename(fileName);
            attachment.setOriginalFile(attachmentFile);
            attachment.setContentId(contentID);
            this.convertIfNecessary((Attachment)attachment);
            attachments.add((Attachment)attachment);
        }
        return result;
    }

    protected Attachment convertIfNecessary(Attachment attachment) throws IOException {
        ExtensionCommand command;
        String filename = attachment.getOriginalFileName();
        String extension = FilenameUtils.getExtension((String)filename);
        if (StringUtils.isNotBlank((CharSequence)extension) && (command = this.configurationService.getExtensionCommand(extension)) != null && StringUtils.isNotBlank((CharSequence)command.getConvertToPdfCommand())) {
            attachment = this.convertToPdf(attachment, command);
        }
        return attachment;
    }

    protected Attachment convertToPdf(Attachment attachment, ExtensionCommand extensionCommand) throws IOException {
        File outfile;
        File file;
        block9: {
            String filename = attachment.getOriginalFileName();
            String basename = FilenameUtils.getBaseName((String)filename);
            String extension = FilenameUtils.getExtension((String)filename);
            file = File.createTempFile("faxtomail-" + basename, "." + extension);
            file.deleteOnExit();
            String fullname = StringUtils.removeEnd((String)file.getAbsolutePath(), (String)("." + extension));
            outfile = new File(fullname + ".pdf");
            outfile.deleteOnExit();
            FileUtils.writeByteArrayToFile((File)file, (byte[])attachment.getOriginalFile().getContent());
            String command = extensionCommand.getConvertToPdfCommand();
            String[] args = StringUtil.split((String)command, (String)" ");
            ArrayList<String> comArgs = new ArrayList<String>();
            String[] arr$ = args;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String arg;
                String localArg = arg = arr$[i$];
                localArg = localArg.replace("%f", file.getAbsolutePath());
                localArg = localArg.replace("%o", outfile.getAbsolutePath());
                comArgs.add(localArg);
            }
            ProcessBuilder pb = new ProcessBuilder(comArgs);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Convert attachment with command : " + comArgs));
            }
            try {
                Process process = pb.start();
                process.waitFor();
                byte[] outContent = FileUtils.readFileToByteArray((File)outfile);
                if (outContent.length >= 1) {
                    AttachmentFileImpl editedFile = new AttachmentFileImpl();
                    editedFile.setContent(outContent);
                    editedFile.setFilename(basename + "-converted.pdf");
                    attachment.setEditedFile((AttachmentFile)editedFile);
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)"Can't convert extension to pdf (content is empty)");
                }
            }
            catch (IOException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Cannot run convert command", (Throwable)e);
                }
            }
            catch (InterruptedException e) {
                if (!log.isErrorEnabled()) break block9;
                log.error((Object)"Cannot run convert command", (Throwable)e);
            }
        }
        file.delete();
        outfile.delete();
        return attachment;
    }

    protected Attachment convertTextToPdf(String content, String name) throws IOException, DocumentException {
        Document document = new Document();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)os);
        writer.open();
        document.setPageSize(PageSize.A4);
        document.open();
        document.add((Element)new Paragraph(content));
        document.close();
        writer.close();
        AttachmentFileImpl attachmentFileNew = new AttachmentFileImpl();
        attachmentFileNew.setContent(os.toByteArray());
        attachmentFileNew.setFilename(name + ".pdf");
        AttachmentImpl attachment = new AttachmentImpl();
        attachment.setOriginalFile((AttachmentFile)attachmentFileNew);
        attachment.setOriginalFileName(name + ".pdf");
        attachment.setAddedByUser(false);
        return attachment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Attachment convertHTMLToPdf(List<Attachment> attachments, String content, String name) throws IOException {
        AttachmentImpl result = null;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ArrayList<File> fileToDelete = new ArrayList<File>();
        try {
            content = content.replaceAll("<meta (.*?)>(</meta>)?", "");
            for (Attachment attachment : attachments) {
                String key = attachment.getContentId();
                if (key == null) {
                    key = attachment.getOriginalFileName();
                }
                AttachmentFile attachmentFile = attachment.getOriginalFile();
                File file = attachmentFile.getFile();
                fileToDelete.add(file);
                content = content.replaceAll("(\\w+)=([\"'])cid:" + Pattern.quote(key) + "([\"'])", "$1=$2file://" + file.getAbsolutePath() + "$3");
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Mapping attachment id " + key + " to file " + file.getAbsolutePath()));
            }
            Html2Image image = Html2Image.fromHtml((String)content);
            org.w3c.dom.Document doc = image.getParser().getDocument();
            ITextRenderer renderer = new ITextRenderer();
            renderer.setDocument(doc, null);
            renderer.layout();
            renderer.createPDF((OutputStream)os);
            AttachmentFileImpl attachmentFileNew = new AttachmentFileImpl();
            attachmentFileNew.setContent(os.toByteArray());
            attachmentFileNew.setFilename(name + ".pdf");
            result = new AttachmentImpl();
            result.setOriginalFile((AttachmentFile)attachmentFileNew);
            result.setOriginalFileName(name + ".pdf");
            result.setAddedByUser(false);
        }
        catch (OutOfMemoryError er) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Can't convert html content to pdf", (Throwable)er);
            }
        }
        catch (DocumentException ex) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Can't convert html content to pdf", (Throwable)ex);
            }
        }
        finally {
            for (File file : fileToDelete) {
                file.delete();
            }
        }
        return result;
    }
}

