package com.franciaflex.faxtomail.web;

/*
 * #%L
 * FaxToMail :: Web
 * $Id: FaxToMailSession.java 173 2014-06-10 08:14:35Z echatellier $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.2/faxtomail-ui-web/src/main/java/com/franciaflex/faxtomail/web/FaxToMailSession.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserImpl;
import com.google.common.collect.Lists;

import java.io.Serializable;
import java.util.Collection;
import java.util.UUID;

public class FaxToMailSession implements Serializable {

    public static final String SESSION_PARAMETER = "faxToMailSession";

    protected Collection<String> messages;

    protected Collection<String> errorMessages;

    protected String authenticatedUserId;

    protected transient FaxToMailUser authenticatedFaxToMailUser;

    public Collection<String> getMessages() {
        if (messages == null) {
            messages = Lists.newLinkedList();
        }
        return messages;
    }

    public void addMessage(String message) {
        getMessages().add(message);
    }

    public Collection<String> getErrorMessages() {
        if (errorMessages == null) {
            errorMessages = Lists.newLinkedList();
        }
        return errorMessages;
    }

    public void addErrorMessages(String errorMessage) {
        getErrorMessages().add(errorMessage);
    }

    public String getAuthenticatedUserId() {
        //return authenticatedUserId;
        return UUID.randomUUID().toString();
    }

    public void setAuthenticatedUserId(String authenticatedUserId) {
        //this.authenticatedUserId = authenticatedUserId;
    }

    public FaxToMailUser getAuthenticatedFaxToMailUser() {
        //return authenticatedFaxToMailUser;
        FaxToMailUser result = new FaxToMailUserImpl();
        result.setTopiaId(UUID.randomUUID().toString());
        result.setFirstName("Demo");
        result.setLastName("Demo");
        result.setLogin("demo");
        return result;
    }

    public void setAuthenticatedFaxToMailUser(FaxToMailUser authenticatedFaxToMailUser) {
        //this.authenticatedFaxToMailUser = authenticatedFaxToMailUser;
    }

    public void logout() {
        setAuthenticatedUserId(null);
        setAuthenticatedFaxToMailUser(null);
    }
}
