<%--
  #%L
  FaxToMail :: Web
  $Id: layout.jsp 153 2014-06-09 14:38:49Z echatellier $
  $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.1/faxtomail-ui-web/src/main/webapp/WEB-INF/decorators/layout.jsp $
  %%
  Copyright (C) 2014 Franciaflex, Code Lutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as
  published by the Free Software Foundation, either version 3 of the
  License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public
  License along with this program.  If not, see
  <http://www.gnu.org/licenses/gpl-3.0.html>.
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html>
<%@ taglib prefix="s"         uri="/struts-tags" %>
<%@ taglib prefix="decorator" uri="http://www.opensymphony.com/sitemesh/decorator" %>
<html>
    <head>
            <meta charset="utf-8">
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
            <meta http-equiv="X-UA-Compatible" content="IE=edge">
            <meta name="viewport" content="width=device-width, initial-scale=1">
            <title>FaxToMail : <decorator:title default="FaxToMail"/></title>
            <link rel="stylesheet" type="text/css" href="<s:url value='/nuiton-js/faxtomail.css' />" />
            <script type="text/javascript" src="<s:url value='/nuiton-js/faxtomail.js' />"></script>
            <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
            <!--[if lt IE 9]>
              <script type="text/javascript" src="<s:url value='/nuiton-js/faxtomail-ie8.js' />"></script>
            <![endif]-->
            <decorator:head/>
    </head>

    <body>
        <div id="wrap-global">
            <div id="wrap-main" class="<decorator:getProperty property="page.wide-display"/>">
                <div id="faxtomail-body">
                    <s:actionerror theme="bootstrap"/>
                    <s:actionmessage theme="bootstrap"/>
                    <s:fielderror theme="bootstrap"/>
                    
                    <!-- navbar -->
                    <header class="navbar navbar-inverse navbar-static-top" role="banner">
                      <div class="container">
                        <div class="navbar-header">
                          <a href="<s:url value='/' />" class="navbar-brand">FaxToMail</a>
                        </div>
                        <s:if test="authenticated">
                          <nav class="collapse navbar-collapse" role="navigation">
                            <ul class="nav navbar-nav">
                              <li><a href="<s:url action='ldap-input' namespace="/admin" />">
                                <span class="fa fa-database"></span> Ldap</a></li>
                              <li><a href="<s:url action='configuration-input' namespace="/admin" />">
                                <span class="fa fa-cog"></span> Configuration</a></li>
                              <li><a href="<s:url action='import-input' namespace="/admin" />">
                                <span class="fa fa-upload"></span> Import</a></li>
                              <li><a href="<s:url action='user-folder-input' namespace="/admin" />">
                                <span class="fa fa-folder-open"></span> Dossiers utilisateur</a></li>
                            </ul>

                            <ul class="nav navbar-nav navbar-right">
                              <li><a><span class="fa fa-user"></span>
                                <s:property value="authenticatedUser.firstName" /> <s:property value="authenticatedUser.lastName" /></a></li>
                              <li><a href="<s:url action='logout' namespace="/" />">
                                <span class="fa fa-power-off"></span> Déconnexion</a></li>
                            </ul>
                          </nav>
                        </s:if>
                      </div>
                    </header>

                    <decorator:body/>
                </div>
            </div>
        </div>
    </body>
</html>
