/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.web;

import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.services.service.FaxToMailWebApplicationContext;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class DefaultFaxToMailWebApplicationContext
implements FaxToMailWebApplicationContext {
    private static final Log log = LogFactory.getLog(DefaultFaxToMailWebApplicationContext.class);
    protected String instanceUrl;

    public DefaultFaxToMailWebApplicationContext(String instanceUrl) {
        this.instanceUrl = instanceUrl;
    }

    protected String formatUrl(String actionUrl) {
        Map emptyMap = Collections.emptyMap();
        return this.formatUrl(actionUrl, emptyMap);
    }

    protected String formatUrl(String actionUrl, Map<String, String> parameters) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.instanceUrl).append("/").append(actionUrl);
        if (!parameters.isEmpty()) {
            TreeSet queryStringElements = Sets.newTreeSet();
            try {
                for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                    String queryStringElement = parameter.getKey() + '=' + URLEncoder.encode(parameter.getValue(), Charsets.UTF_8.name());
                    queryStringElements.add(queryStringElement);
                }
            }
            catch (UnsupportedEncodingException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"should never occur", (Throwable)e);
                }
                throw new ApplicationTechnicalException((Throwable)e);
            }
            stringBuilder.append('?').append(Joiner.on((char)'&').join((Iterable)queryStringElements));
        }
        return stringBuilder.toString();
    }

    public String getAdministrationUrl(FaxToMailUser extranetUser) {
        ImmutableMap params = ImmutableMap.of((Object)"yearlyDeclarationId", (Object)extranetUser.getTopiaId());
        return this.formatUrl("administration/edit-user!input", (Map)params);
    }
}

