/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.actions;

import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.services.service.EmailService;
import com.franciaflex.faxtomail.services.service.exceptions.AlreadyLockedMailException;
import com.franciaflex.faxtomail.services.service.exceptions.FolderNotReadableException;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractMainUIFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.MainUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandesUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import jaxx.runtime.swing.JAXXWidgetUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ShowDemandeAction
extends AbstractMainUIFaxToMailAction {
    private static final Log log = LogFactory.getLog(ShowDemandeAction.class);
    protected boolean takeEmail;
    protected JFrame frame;

    public ShowDemandeAction(MainUIHandler handler) {
        super(handler, false);
        this.setActionDescription(I18n.t((String)"faxtomail.action.goto.demand.tip", (Object[])new Object[0]));
    }

    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        DemandeUIModel currentEmail = this.getContext().getCurrentEmail();
        String topiaId = currentEmail.getTopiaId();
        if (StringUtils.isNotBlank((CharSequence)topiaId)) {
            FaxToMailUser currentUser = this.getContext().getCurrentUser();
            int answer = -1;
            try {
                FaxToMailServiceContext serviceContext = this.getContext().newServiceContext();
                EmailService emailService = serviceContext.getEmailService();
                Email email = emailService.lockEmail(topiaId, currentUser);
                FaxToMailUser takenBy = email.getTakenBy();
                if (takenBy != null && !currentUser.equals(takenBy)) {
                    String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"faxtomail.alert.alreadyTakenBy.message", (Object[])new Object[]{this.decorate(takenBy)}), I18n.t((String)"faxtomail.alert.alreadyTakenBy.help", (Object[])new Object[0]));
                    answer = JOptionPane.showConfirmDialog(((MainUIHandler)this.getHandler()).getTopestUI(), htmlMessage, I18n.t((String)"faxtomail.alert.alreadyTakenBy.title", (Object[])new Object[0]), 1, 3);
                }
                if (answer == 2) {
                    result = false;
                    emailService.unlockEmail(topiaId);
                } else if (answer == 1) {
                    currentEmail.setEditable(false);
                    this.takeEmail = false;
                } else if (answer == 0) {
                    this.takeEmail = true;
                    currentEmail.setEditable(true);
                }
            }
            catch (AlreadyLockedMailException ex) {
                result = false;
                String htmlMessage = I18n.t((String)"faxtomail.alert.alreadyLockedBy.message", (Object[])new Object[]{this.decorate(ex.getLockedBy())});
                JOptionPane.showMessageDialog(((MainUIHandler)this.getHandler()).getTopestUI(), htmlMessage, I18n.t((String)"faxtomail.alert.alreadyLockedBy.title", (Object[])new Object[0]), 0);
            }
            catch (FolderNotReadableException e) {
                result = false;
                String htmlMessage = I18n.t((String)"faxtomail.alert.userNotAuthorizedToReadEmail.message", (Object[])new Object[]{e.getForbiddenFolder().getName()});
                JOptionPane.showMessageDialog(((MainUIHandler)this.getHandler()).getTopestUI(), htmlMessage, I18n.t((String)"faxtomail.alert.userNotAuthorizedToReadEmail.title", (Object[])new Object[0]), 0);
            }
        }
        return result;
    }

    @Override
    public void doAction() throws Exception {
        DemandeUIModel currentEmail = this.getContext().getCurrentEmail();
        FaxToMailServiceContext serviceContext = this.getContext().newServiceContext();
        if (StringUtils.isNotBlank((CharSequence)currentEmail.getTopiaId())) {
            Email email = serviceContext.getEmailService().openEmail(currentEmail.getTopiaId(), this.getContext().getCurrentUser(), this.takeEmail);
            MailFolder currentFolder = currentEmail.getMailFolder();
            MailFolder actualFolder = email.getMailFolder();
            if (currentFolder != null && !currentFolder.equals(actualFolder)) {
                this.displayWarningMessage(I18n.t((String)"faxtomail.alert.emailMoved.title", (Object[])new Object[0]), I18n.t((String)"faxtomail.alert.emailMoved.message", (Object[])new Object[]{currentFolder.getName(), actualFolder.getName(), currentEmail.getTitle()}));
            }
            currentEmail.fromEntity(email);
            MailFolder folder = currentEmail.getMailFolder();
            if (currentEmail.getArchiveDate() != null || !folder.isFolderWritable() || !currentEmail.getDemandStatus().isEditableStatus()) {
                currentEmail.setEditable(false);
            }
        }
        MailFolder folder = currentEmail.getMailFolder();
        List allowedClients = serviceContext.getClientService().getClientsForFolder(folder);
        currentEmail.setAllowedClients(allowedClients);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        DemandeUIModel currentEmail = this.getContext().getCurrentEmail();
        this.frame = this.getContext().getFrameForDemande(currentEmail);
        if (this.frame == null) {
            DemandesUI screenUI = new DemandesUI((FaxToMailUI)this.getUI());
            String screenTitle = I18n.t((String)"faxtomail.demand.title", (Object[])new Object[0]);
            ImageIcon icon = JAXXWidgetUtil.createActionIcon((String)"email-group");
            screenUI.getDemandsPanel().setLeftDecoration((JComponent)new JLabel(icon));
            this.frame = ((MainUIHandler)this.getHandler()).openFrame(screenUI, screenTitle, new Dimension(800, 600));
            this.getContext().setFrameForDemande(currentEmail, this.frame);
            for (DemandeUIModel demande : currentEmail.getGroupedDemandes()) {
                this.getContext().setFrameForDemande(demande, this.frame);
            }
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    DemandeUIModel currentEmail = ShowDemandeAction.this.getContext().getCurrentEmail();
                    ShowDemandeAction.this.getContext().setFrameForDemande(currentEmail, null);
                    for (DemandeUIModel demande : currentEmail.getGroupedDemandes()) {
                        ShowDemandeAction.this.getContext().setFrameForDemande(demande, null);
                    }
                }
            });
            this.getContext().addPropertyChangeListener("busy", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!ShowDemandeAction.this.getContext().isBusy()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (ShowDemandeAction.this.frame != null) {
                                    ShowDemandeAction.this.frame.toFront();
                                    ShowDemandeAction.this.frame = null;
                                }
                            }
                        });
                        ShowDemandeAction.this.getContext().removePropertyChangeListener("busy", this);
                    }
                }
            });
        }
    }
}

