/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SASLBindRequest;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class EXTERNALBindRequest
extends SASLBindRequest {
    public static final String EXTERNAL_MECHANISM_NAME = "EXTERNAL";
    private static final long serialVersionUID = 7520760039662616663L;
    private int messageID = -1;
    private final String authzID;

    public EXTERNALBindRequest() {
        this((String)null, StaticUtils.NO_CONTROLS);
    }

    public EXTERNALBindRequest(String authzID) {
        this(authzID, StaticUtils.NO_CONTROLS);
    }

    public EXTERNALBindRequest(Control ... controls) {
        this((String)null, controls);
    }

    public EXTERNALBindRequest(String authzID, Control ... controls) {
        super(controls);
        this.authzID = authzID;
    }

    public String getAuthorizationID() {
        return this.authzID;
    }

    public String getSASLMechanismName() {
        return EXTERNAL_MECHANISM_NAME;
    }

    protected BindResult process(LDAPConnection connection, int depth) throws LDAPException {
        this.messageID = connection.nextMessageID();
        ASN1OctetString creds = this.authzID == null ? null : new ASN1OctetString(this.authzID);
        return this.sendBindRequest(connection, "", creds, this.getControls(), this.getResponseTimeoutMillis(connection));
    }

    public EXTERNALBindRequest getRebindRequest(String host, int port) {
        return new EXTERNALBindRequest(this.authzID, this.getControls());
    }

    public int getLastMessageID() {
        return this.messageID;
    }

    public EXTERNALBindRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    public EXTERNALBindRequest duplicate(Control[] controls) {
        EXTERNALBindRequest bindRequest = new EXTERNALBindRequest(this.authzID, controls);
        bindRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return bindRequest;
    }

    public void toString(StringBuilder buffer) {
        Control[] controls;
        buffer.append("EXTERNALBindRequest(");
        boolean added = false;
        if (this.authzID != null) {
            buffer.append("authzID='");
            buffer.append(this.authzID);
            buffer.append('\'');
            added = true;
        }
        if ((controls = this.getControls()).length > 0) {
            if (added) {
                buffer.append(", ");
            }
            buffer.append("controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

