/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.attachment;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentListener;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentModelAware;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailBeanUIModel;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class AttachmentEditorUIModel
extends AbstractFaxToMailBeanUIModel<AttachmentModelAware, AttachmentEditorUIModel> {
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_INLINE_ATTACHMENTS = "inlineAttachments";
    public static final String PROPERTY_SELECTED_ATTACHMENT = "selectedAttachment";
    public static final Comparator<Attachment> ATTACHMENT_COMPARATOR = new Comparator<Attachment>(){

        @Override
        public int compare(Attachment o1, Attachment o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1.isLessImportant() ^ o2.isLessImportant()) {
                return o1.isLessImportant() ? 1 : -1;
            }
            return ObjectUtils.compare((Comparable)((Object)StringUtils.lowerCase((String)o1.getOriginalFileName())), (Comparable)((Object)StringUtils.lowerCase((String)o2.getOriginalFileName())));
        }
    };
    protected boolean editable = true;
    protected final List<Attachment> attachments = new ArrayList<Attachment>();
    protected final List<Attachment> inlineAttachments = new ArrayList<Attachment>();
    protected Attachment selectedAttachment;
    protected List<AttachmentListener> openingListeners = new ArrayList<AttachmentListener>();
    protected static Binder<AttachmentEditorUIModel, AttachmentModelAware> toBeanBinder = BinderFactory.newBinder(AttachmentEditorUIModel.class, AttachmentModelAware.class);
    protected static Binder<AttachmentModelAware, AttachmentEditorUIModel> fromBeanBinder = BinderFactory.newBinder(AttachmentModelAware.class, AttachmentEditorUIModel.class);

    protected AttachmentEditorUIModel() {
        super(fromBeanBinder, toBeanBinder);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        Boolean oldValue = this.isEditable();
        this.editable = editable;
        this.firePropertyChange(PROPERTY_EDITABLE, oldValue, editable);
    }

    public List<Attachment> getAttachment() {
        return this.attachments;
    }

    public void addAllAttachment(List<Attachment> attachments) {
        ArrayList<Attachment> oldValue = new ArrayList<Attachment>(this.getAttachment());
        this.attachments.addAll(attachments);
        this.firePropertyChange("attachment", oldValue, this.attachments);
    }

    public void addAttachment(Attachment attachment) {
        ArrayList<Attachment> oldValue = new ArrayList<Attachment>(this.getAttachment());
        this.attachments.add(attachment);
        this.firePropertyChange("attachment", oldValue, this.attachments);
    }

    public void removeAttachment(Attachment attachment) {
        ArrayList<Attachment> oldValue = new ArrayList<Attachment>(this.getAttachment());
        this.attachments.remove(attachment);
        this.firePropertyChange("attachment", oldValue, this.attachments);
    }

    public void setAttachment(List<Attachment> attachments) {
        ArrayList<Attachment> oldAttachmentsValue = new ArrayList<Attachment>(this.getAttachment());
        ArrayList<Attachment> oldInlineAttachmentsValue = new ArrayList<Attachment>(this.getInlineAttachments());
        this.attachments.clear();
        this.inlineAttachments.clear();
        if (attachments != null) {
            this.inlineAttachments.addAll(Collections2.filter(attachments, (Predicate)new Predicate<Attachment>(){

                public boolean apply(Attachment input) {
                    return input.isInlineAttachment();
                }
            }));
            this.attachments.addAll(attachments);
            if (this.inlineAttachments.size() > 1) {
                this.attachments.removeAll(this.inlineAttachments);
            } else {
                this.inlineAttachments.clear();
            }
            this.sortAttachments();
        }
        this.firePropertyChange("attachment", oldAttachmentsValue, this.attachments);
        this.firePropertyChange(PROPERTY_INLINE_ATTACHMENTS, oldInlineAttachmentsValue, this.inlineAttachments);
    }

    public List<Attachment> getInlineAttachments() {
        return this.inlineAttachments;
    }

    public void sortAttachments() {
        Collections.sort(this.attachments, ATTACHMENT_COMPARATOR);
        Collections.sort(this.inlineAttachments, ATTACHMENT_COMPARATOR);
    }

    public Attachment getSelectedAttachment() {
        return this.selectedAttachment;
    }

    public void setSelectedAttachment(Attachment selectedAttachment) {
        Attachment oldValue = this.getSelectedAttachment();
        this.selectedAttachment = selectedAttachment;
        this.firePropertyChange(PROPERTY_SELECTED_ATTACHMENT, oldValue, selectedAttachment);
    }

    @Override
    protected AttachmentModelAware newEntity() {
        return null;
    }

    public void addAttachmentListener(AttachmentListener listener) {
        this.openingListeners.add(listener);
    }

    public void removeAttachmentListener(AttachmentListener listener) {
        this.openingListeners.remove(listener);
    }

    public void fireAttachmentOpened(Attachment attachment, boolean original) {
        for (AttachmentListener listener : this.openingListeners) {
            listener.onAttachmentOpened(attachment, original);
        }
    }

    public void fireAttachmentEdited(Attachment attachment) {
        for (AttachmentListener listener : this.openingListeners) {
            listener.onAttachmentEdited(attachment);
        }
    }
}

