/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor.bean;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListModel;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.editor.bean.BeanListHeader;
import jaxx.runtime.swing.editor.bean.BeanUIUtil;
import jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import org.apache.commons.collections.primitives.ArrayIntList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.DecoratorUtil;
import org.nuiton.decorator.JXPathDecorator;
import org.nuiton.decorator.MultiJXPathDecorator;

public class BeanListHeaderHandler<O>
implements PropertyChangeListener {
    public static final Log log = LogFactory.getLog(BeanListHeaderHandler.class);
    protected BeanListHeader<O> ui;
    protected MultiJXPathDecorator<O> decorator;
    protected boolean init;
    private final BeanUIUtil.PopupHandler popupHandler = new BeanUIUtil.PopupHandler(){

        @Override
        public JPopupMenu getPopup() {
            return BeanListHeaderHandler.this.ui.getPopup();
        }

        @Override
        public JComponent getInvoker() {
            return BeanListHeaderHandler.this.ui.getChangeDecorator();
        }
    };

    public BeanListHeaderHandler(BeanListHeader<O> ui) {
        this.ui = ui;
    }

    public void init(JXPathDecorator<O> decorator, List<O> data) {
        if (this.init) {
            throw new IllegalStateException("can not init the handler twice");
        }
        this.init = true;
        if (decorator == null) {
            throw new NullPointerException("decorator can not be null (for type " + this.ui.getBeanType() + ")");
        }
        this.ui.removeDataBinding("resetSelection.enabled");
        this.ui.applyDataBinding("resetSelection.enabled");
        JAXXButtonGroup indexes = this.ui.getIndexes();
        this.decorator = BeanUIUtil.createDecorator(decorator);
        this.ui.getList().setCellRenderer(new DecoratorListCellRenderer(this.decorator));
        this.popupHandler.preparePopup(this.ui.getSelectedToolTipText(), this.ui.getNotSelectedToolTipText(), this.ui.getI18nPrefix(), this.ui.getPopupTitleText(), (ButtonGroup)indexes, this.ui.getPopupSeparator(), this.ui.getPopupLabel(), this.ui.getSortUp(), this.ui.getSortDown(), this.decorator);
        this.ui.addPropertyChangeListener(this);
        this.ui.setData(data);
        indexes.setSelectedButton((Object)this.ui.getIndex());
    }

    public void togglePopup() {
        this.popupHandler.togglePopup();
    }

    protected void setIndex(Integer oldValue, Integer newValue) {
        if (newValue == null || newValue.equals(oldValue)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("check state : <" + oldValue + " to " + newValue + ">"));
        }
        this.updateUI(newValue, this.ui.isReverseSort());
    }

    protected void setSortOrder(Boolean oldValue, Boolean newValue) {
        if (newValue == null || newValue.equals(oldValue)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("check state : <" + oldValue + " to " + newValue + ">"));
        }
        this.updateUI(this.ui.getIndex(), newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateUI(int index, boolean reverseSort) {
        this.decorator.setContextIndex(index);
        String expression = this.decorator.getExpression();
        if (log.isDebugEnabled()) {
            log.debug((Object)("will use expression (index = " + index + ") : " + expression));
        }
        Object[] selection = this.ui.getList().getSelectedValues();
        List<O> datas = this.ui.getData();
        try {
            DecoratorUtil.sort(this.decorator, datas, (int)index, (boolean)reverseSort);
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
        this.ui.getList().setValueIsAdjusting(true);
        try {
            ListModel listModel = this.ui.getList().getModel();
            if (listModel instanceof DefaultListModel) {
                DefaultListModel model = (DefaultListModel)listModel;
                model.removeAllElements();
                for (O data : datas) {
                    model.addElement(data);
                }
            } else {
                this.ui.getList().setListData(datas.toArray(new Object[datas.size()]));
            }
            if (selection.length > 0) {
                ArrayIntList newSelection = new ArrayIntList();
                for (Object o : selection) {
                    if (!datas.contains(o)) continue;
                    newSelection.add(datas.indexOf(o));
                }
                if (!newSelection.isEmpty()) {
                    int[] ints = newSelection.toArray(new int[newSelection.size()]);
                    newSelection.clear();
                    this.ui.getList().setSelectedIndices(ints);
                }
            }
        }
        finally {
            this.ui.getList().setValueIsAdjusting(false);
        }
        this.ui.getList().requestFocus();
    }

    public MultiJXPathDecorator<O> getDecorator() {
        return this.decorator;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("index".equals(propertyName)) {
            this.setIndex((Integer)evt.getOldValue(), (Integer)evt.getNewValue());
            return;
        }
        if ("reverseSort".equals(propertyName)) {
            this.setSortOrder((Boolean)evt.getOldValue(), (Boolean)evt.getNewValue());
            return;
        }
        if ("data".equals(propertyName)) {
            this.setIndex(-1, this.ui.getIndex());
        }
        if ("list".equals(propertyName)) {
            this.ui.removeDataBinding("resetSelection.enabled");
            this.ui.applyDataBinding("resetSelection.enabled");
        }
    }

    public O getSelectedValue() {
        JList list = this.ui.getList();
        return list == null ? null : (O)list.getSelectedValue();
    }
}

