/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.common.COSObjectable;

public class PDTextStream
implements COSObjectable {
    private COSString string;
    private COSStream stream;

    public PDTextStream(COSString str) {
        this.string = str;
    }

    public PDTextStream(String str) {
        this.string = new COSString(str);
    }

    public PDTextStream(COSStream str) {
        this.stream = str;
    }

    public static PDTextStream createTextStream(COSBase base) {
        PDTextStream retval = null;
        if (base instanceof COSString) {
            retval = new PDTextStream((COSString)base);
        } else if (base instanceof COSStream) {
            retval = new PDTextStream((COSStream)base);
        }
        return retval;
    }

    @Override
    public COSBase getCOSObject() {
        return this.string == null ? this.stream : this.string;
    }

    public String getAsString() throws IOException {
        if (this.string != null) {
            return this.string.getString();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputStream is = this.stream.getUnfilteredStream();
        IOUtils.copy(is, out);
        IOUtils.closeQuietly(is);
        return new String(out.toByteArray(), "ISO-8859-1");
    }

    public InputStream getAsStream() throws IOException {
        InputStream retval = this.string != null ? new ByteArrayInputStream(this.string.getBytes()) : this.stream.getUnfilteredStream();
        return retval;
    }
}

