/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.PDTextStream;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDFieldTreeNode;

public abstract class PDVariableText
extends PDField {
    public static final int QUADDING_LEFT = 0;
    public static final int QUADDING_CENTERED = 1;
    public static final int QUADDING_RIGHT = 2;

    PDVariableText(PDAcroForm theAcroForm) {
        super(theAcroForm);
    }

    protected PDVariableText(PDAcroForm theAcroForm, COSDictionary field, PDFieldTreeNode parentNode) {
        super(theAcroForm, field, parentNode);
    }

    public String getDefaultAppearance() {
        COSString defaultAppearance = (COSString)this.getInheritableAttribute(COSName.DA);
        return defaultAppearance.getString();
    }

    public void setDefaultAppearance(String daValue) {
        if (daValue != null) {
            this.setInheritableAttribute(COSName.DA, new COSString(daValue));
        } else {
            this.removeInheritableAttribute(COSName.DA);
        }
    }

    public String getDefaultStyleString() {
        COSString defaultStyleString = (COSString)this.getCOSObject().getDictionaryObject(COSName.DS);
        return defaultStyleString.getString();
    }

    public void setDefaultStyleString(String defaultStyleString) {
        if (defaultStyleString != null) {
            this.getCOSObject().setItem(COSName.DS, (COSBase)new COSString(defaultStyleString));
        } else {
            this.getCOSObject().removeItem(COSName.DS);
        }
    }

    public int getQ() {
        int retval = 0;
        COSNumber number = (COSNumber)this.getInheritableAttribute(COSName.Q);
        if (number != null) {
            retval = number.intValue();
        }
        return retval;
    }

    public void setQ(int q) {
        this.getCOSObject().setInt(COSName.Q, q);
    }

    public String getRichTextValue() throws IOException {
        PDTextStream textStream = this.getAsTextStream(this.getInheritableAttribute(COSName.RV));
        if (textStream != null) {
            return textStream.getAsString();
        }
        return "";
    }

    public PDTextStream getRichTextValueAsStream() throws IOException {
        return this.getAsTextStream(this.getInheritableAttribute(COSName.RV));
    }

    public void setRichTextValue(String richTextValue) {
        if (richTextValue != null) {
            this.getCOSObject().setItem(COSName.RV, (COSBase)new COSString(richTextValue));
        } else {
            this.getCOSObject().removeItem(COSName.RV);
        }
    }

    public void setRichTextValue(PDTextStream richTextValue) {
        if (richTextValue != null) {
            this.getCOSObject().setItem(COSName.RV, richTextValue.getCOSObject());
        } else {
            this.getCOSObject().removeItem(COSName.RV);
        }
    }
}

