/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.enc;

import com.twelvemonkeys.io.enc.DecodeException;
import com.twelvemonkeys.io.enc.Decoder;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class PackBitsDecoder
implements Decoder {
    private final boolean disableNoop;
    private int leftOfRun;
    private boolean splitRun;
    private boolean reachedEOF;

    public PackBitsDecoder() {
        this(false);
    }

    public PackBitsDecoder(boolean bl) {
        this.disableNoop = bl;
    }

    public int decode(InputStream inputStream, ByteBuffer byteBuffer) throws IOException {
        if (this.reachedEOF) {
            return -1;
        }
        while (byteBuffer.hasRemaining()) {
            int n;
            int n2;
            if (this.splitRun) {
                n2 = this.leftOfRun;
                this.splitRun = false;
            } else {
                n = inputStream.read();
                if (n < 0) {
                    this.reachedEOF = true;
                    break;
                }
                n2 = (byte)n;
            }
            if (n2 >= 0 && n2 + 1 > byteBuffer.remaining()) {
                this.leftOfRun = n2;
                this.splitRun = true;
                break;
            }
            if (n2 < 0 && -n2 + 1 > byteBuffer.remaining()) {
                this.leftOfRun = n2;
                this.splitRun = true;
                break;
            }
            try {
                if (n2 >= 0) {
                    PackBitsDecoder.readFully(inputStream, byteBuffer, n2 + 1);
                    continue;
                }
                if (!this.disableNoop && n2 == -128) continue;
                n = PackBitsDecoder.readByte(inputStream);
                for (int i = -n2 + 1; i > 0; --i) {
                    byteBuffer.put((byte)n);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new DecodeException("Error in PackBits decompression, data seems corrupt", indexOutOfBoundsException);
            }
        }
        return byteBuffer.position();
    }

    static byte readByte(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n < 0) {
            throw new EOFException("Unexpected end of PackBits stream");
        }
        return (byte)n;
    }

    static void readFully(InputStream inputStream, ByteBuffer byteBuffer, int n) throws IOException {
        int n2;
        int n3;
        if (n < 0) {
            throw new IndexOutOfBoundsException(String.format("Negative length: %d", n));
        }
        for (n2 = 0; n2 < n; n2 += n3) {
            n3 = inputStream.read(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position() + n2, n - n2);
            if (n3 >= 0) continue;
            throw new EOFException("Unexpected end of PackBits stream");
        }
        byteBuffer.position(byteBuffer.position() + n2);
    }
}

