/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.message.MapMessage;

@Plugin(name="map", category="Lookup")
public class MapLookup
implements StrLookup {
    static final MapLookup MAIN_SINGLETON = new MapLookup(MapLookup.newMap(0));
    private final Map<String, String> map;

    static Map<String, String> initMap(String[] srcArgs, Map<String, String> destMap) {
        for (int i = 0; i < srcArgs.length; ++i) {
            int next = i + 1;
            String value = srcArgs[i];
            destMap.put(Integer.toString(i), value);
            destMap.put(value, next < srcArgs.length ? srcArgs[next] : null);
        }
        return destMap;
    }

    private static HashMap<String, String> newMap(int initialCapacity) {
        return new HashMap<String, String>(initialCapacity);
    }

    public static void setMainArguments(String[] args) {
        if (args == null) {
            return;
        }
        MapLookup.initMap(args, MapLookup.MAIN_SINGLETON.map);
    }

    static Map<String, String> toMap(List<String> args) {
        if (args == null) {
            return null;
        }
        int size = args.size();
        return MapLookup.initMap(args.toArray(new String[size]), MapLookup.newMap(size));
    }

    static Map<String, String> toMap(String[] args) {
        if (args == null) {
            return null;
        }
        return MapLookup.initMap(args, MapLookup.newMap(args.length));
    }

    public MapLookup() {
        this.map = null;
    }

    public MapLookup(Map<String, String> map) {
        this.map = map;
    }

    @Override
    public String lookup(LogEvent event, String key) {
        String obj;
        if (this.map == null && !(event.getMessage() instanceof MapMessage)) {
            return null;
        }
        if (this.map != null && this.map.containsKey(key) && (obj = this.map.get(key)) != null) {
            return obj;
        }
        if (event.getMessage() instanceof MapMessage) {
            return ((MapMessage)event.getMessage()).get(key);
        }
        return null;
    }

    @Override
    public String lookup(String key) {
        if (this.map == null) {
            return null;
        }
        return this.map.get(key);
    }
}

