/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.actions;

import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.SearchFilter;
import com.franciaflex.faxtomail.persistence.entities.WaitingState;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI;
import com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.search.SearchUIModel;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntities;
import org.nuiton.util.pagination.PaginationResult;

public class SearchToGroupAction
extends AbstractFaxToMailAction<SearchUIModel, SearchToGroupUI, SearchToGroupUIHandler> {
    public SearchToGroupAction(SearchToGroupUIHandler handler) {
        super(handler, false);
        this.setActionDescription(I18n.t((String)"faxtomail.action.search.tip", (Object[])new Object[0]));
    }

    @Override
    public void doAction() throws Exception {
        SearchUIModel model = (SearchUIModel)this.getModel();
        SearchFilter searchFilter = (SearchFilter)((Object)model.toEntity());
        FaxToMailServiceContext serviceContext = this.getContext().newServiceContext();
        PaginationResult paginationResult = serviceContext.getEmailService().search(searchFilter, this.getContext().getCurrentUser(), ((SearchUIModel)this.getModel()).getPaginationParameter());
        List emails = paginationResult.getElements();
        ArrayList<DemandeUIModel> result = new ArrayList<DemandeUIModel>();
        ImmutableMap waitingStateById = Maps.uniqueIndex(this.getContext().getWaitingStateCache(), (Function)TopiaEntities.getTopiaIdFunction());
        for (Email email : emails) {
            DemandeUIModel demand = new DemandeUIModel();
            demand.fromEntityExcluding(email, Sets.newHashSet((Object[])new String[]{"history"}));
            demand.recomputeValidRangeRows();
            demand.setValid(((SearchToGroupUIHandler)this.handler).isDemandeValid(demand));
            WaitingState waitingState = email.getWaitingState();
            if (waitingState != null) {
                demand.setWaitingState((WaitingState)waitingStateById.get(waitingState.getTopiaId()));
            }
            result.add(demand);
        }
        model.setResults(result);
        model.setPaginationParameter(paginationResult.getCurrentPage());
        model.setPaginationResult((PaginationResult<Email>)paginationResult);
    }

    protected void releaseAction() {
        super.releaseAction();
        final JFrame frame = ((SearchToGroupUI)this.getUI()).getParentContainer(JFrame.class);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (frame != null) {
                    frame.toFront();
                }
            }
        });
    }
}

