/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.services.service;

import com.franciaflex.faxtomail.persistence.entities.Configuration;
import com.franciaflex.faxtomail.persistence.entities.ConfigurationImpl;
import com.franciaflex.faxtomail.persistence.entities.ConfigurationTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.DemandType;
import com.franciaflex.faxtomail.persistence.entities.DemandTypeImpl;
import com.franciaflex.faxtomail.persistence.entities.DemandTypeTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.EmailAccount;
import com.franciaflex.faxtomail.persistence.entities.EmailAccountImpl;
import com.franciaflex.faxtomail.persistence.entities.EmailAccountTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.EmailProtocol;
import com.franciaflex.faxtomail.persistence.entities.ExtensionCommand;
import com.franciaflex.faxtomail.persistence.entities.ExtensionCommandTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroup;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.GroupChef;
import com.franciaflex.faxtomail.persistence.entities.GroupChefTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.MailField;
import com.franciaflex.faxtomail.persistence.entities.MailFilter;
import com.franciaflex.faxtomail.persistence.entities.MailFilterTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.MailFolderImpl;
import com.franciaflex.faxtomail.persistence.entities.MailFolderTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.WaitingState;
import com.franciaflex.faxtomail.persistence.entities.WaitingStateImpl;
import com.franciaflex.faxtomail.persistence.entities.WaitingStateTopiaDao;
import com.franciaflex.faxtomail.services.FaxToMailServiceSupport;
import com.franciaflex.faxtomail.services.service.ConfigurationService;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntities;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class ConfigurationServiceImpl
extends FaxToMailServiceSupport
implements ConfigurationService {
    private static final Log log = LogFactory.getLog(ConfigurationServiceImpl.class);
    protected static final Function<MailFilter, String> GET_EXPRESSION = new Function<MailFilter, String>(){

        public String apply(MailFilter input) {
            return input == null ? null : input.getExpression();
        }
    };

    @Override
    public Configuration getConfiguration() {
        ConfigurationTopiaDao dao = this.getPersistenceContext().getConfigurationDao();
        Configuration config = (Configuration)dao.forAll().findUniqueOrNull();
        if (config == null) {
            config = new ConfigurationImpl();
        }
        return config;
    }

    @Override
    public List<MailFilter> getMailFilters() {
        MailFilterTopiaDao mailFilterDao = this.getPersistenceContext().getMailFilterDao();
        List result = mailFilterDao.forAll().setOrderByArguments(new String[]{"position asc"}).findAll();
        return result;
    }

    protected void saveConfiguration(Configuration config) {
        ConfigurationTopiaDao dao = this.getPersistenceContext().getConfigurationDao();
        config = config.isPersisted() ? (Configuration)dao.update((TopiaEntity)config) : (Configuration)dao.create((TopiaEntity)config);
    }

    @Override
    public void save(Configuration configuration, List<DemandType> demandTypes, List<WaitingState> waitingStates, List<MailFolder> mailFolders, List<MailFilter> mailFilters, List<EmailAccount> emailAccounts) {
        ArrayList<MailFolder> toDeleteMailFolder = new ArrayList<MailFolder>();
        this.saveConfiguration(configuration);
        this.saveDemandTypes(demandTypes);
        Map<String, WaitingState> waitingStateCache = this.saveWaitingStates(waitingStates);
        Map<String, MailFolder> mailFolderCache = this.saveMailFolders(waitingStateCache, mailFolders, toDeleteMailFolder);
        this.saveMailFilters(mailFolderCache, mailFilters);
        this.saveEmailAccounts(emailAccounts);
        MailFolderTopiaDao mailFilterDao = this.getPersistenceContext().getMailFolderDao();
        mailFilterDao.deleteAll(toDeleteMailFolder);
        this.getPersistenceContext().commit();
    }

    protected void saveDemandTypes(List<DemandType> demandTypes) {
        Binder binderDemandType = BinderFactory.newBinder(DemandType.class);
        DemandTypeTopiaDao demandTypeDAO = this.getPersistenceContext().getDemandTypeDao();
        List allDemandType = demandTypeDAO.findAll();
        HashMap allDemandTypeIndex = new HashMap(Maps.uniqueIndex((Iterable)allDemandType, (Function)TopiaEntities.getTopiaIdFunction()));
        for (DemandType demandType : demandTypes) {
            Object currentDemandType = StringUtils.isBlank((CharSequence)demandType.getTopiaId()) || demandType.getTopiaId().startsWith("new_") ? new DemandTypeImpl() : (DemandType)allDemandTypeIndex.remove(demandType.getTopiaId());
            binderDemandType.copyExcluding((Object)demandType, currentDemandType, new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
            if (currentDemandType.isPersisted()) {
                demandTypeDAO.update((TopiaEntity)currentDemandType);
                continue;
            }
            demandTypeDAO.create((TopiaEntity)currentDemandType);
        }
    }

    protected Map<String, WaitingState> saveWaitingStates(Collection<WaitingState> waitingStates) {
        HashMap<String, WaitingState> cache = new HashMap<String, WaitingState>();
        Binder binderEtatAttente = BinderFactory.newBinder(WaitingState.class);
        WaitingStateTopiaDao waitingStateDAO = this.getPersistenceContext().getWaitingStateDao();
        List allWaitingStates = waitingStateDAO.findAll();
        HashMap allWaitingStateIndex = new HashMap(Maps.uniqueIndex((Iterable)allWaitingStates, (Function)TopiaEntities.getTopiaIdFunction()));
        for (WaitingState waitingState : waitingStates) {
            Object currentWaitingState = StringUtils.isBlank((CharSequence)waitingState.getTopiaId()) || waitingState.getTopiaId().startsWith("new_") ? new WaitingStateImpl() : (WaitingState)allWaitingStateIndex.remove(waitingState.getTopiaId());
            binderEtatAttente.copyExcluding((Object)waitingState, currentWaitingState, new String[]{"topiaId", "topiaCreateDate", "topiaVersion"});
            if (currentWaitingState.isPersisted()) {
                waitingStateDAO.update((TopiaEntity)currentWaitingState);
            } else {
                waitingStateDAO.create((TopiaEntity)currentWaitingState);
            }
            cache.put(waitingState.getTopiaId(), (WaitingState)currentWaitingState);
        }
        waitingStateDAO.deleteAll(allWaitingStateIndex.values());
        return cache;
    }

    protected Map<String, MailFolder> saveMailFolders(Map<String, WaitingState> waitingStateCache, Collection<MailFolder> newMailFolders, Collection<MailFolder> toDeleteMailFolder) {
        MailFolderTopiaDao dao = this.getPersistenceContext().getMailFolderDao();
        List mailFolders = dao.findAll();
        HashMap<String, MailFolder> mailFolderMap = new HashMap<String, MailFolder>((Map<String, MailFolder>)Maps.uniqueIndex((Iterable)mailFolders, (Function)TopiaEntities.getTopiaIdFunction()));
        HashMap<String, MailFolder> mailFolderCache = new HashMap<String, MailFolder>();
        this.saveMailFolders(dao, waitingStateCache, mailFolderMap, null, newMailFolders, mailFolderCache);
        toDeleteMailFolder.addAll(mailFolderMap.values());
        return mailFolderCache;
    }

    protected Collection<MailFolder> saveMailFolders(MailFolderTopiaDao dao, Map<String, WaitingState> waitingStateCache, Map<String, MailFolder> mailFolderMap, MailFolder parent, Collection<MailFolder> mailFolders, Map<String, MailFolder> mailFolderCache) {
        ArrayList result = Lists.newArrayList();
        if (mailFolders == null) {
            return result;
        }
        Binder binderMailFolder = BinderFactory.newBinder(MailFolder.class);
        for (MailFolder mailFolder : mailFolders) {
            Object currentMailFolder = StringUtils.isBlank((CharSequence)mailFolder.getTopiaId()) || mailFolder.getTopiaId().startsWith("new_") ? new MailFolderImpl() : mailFolderMap.remove(mailFolder.getTopiaId());
            binderMailFolder.copyExcluding((Object)mailFolder, currentMailFolder, new String[]{"topiaId", "topiaCreateDate", "topiaVersion", "children", "waitingStates", "parent"});
            currentMailFolder.clearWaitingStates();
            if (mailFolder.getWaitingStates() != null) {
                for (WaitingState waitingState : mailFolder.getWaitingStates()) {
                    currentMailFolder.addWaitingStates(waitingStateCache.get(waitingState.getTopiaId()));
                }
            }
            currentMailFolder.setParent(parent);
            if (!currentMailFolder.isPersisted()) {
                currentMailFolder = (MailFolder)dao.create((TopiaEntity)currentMailFolder);
            }
            Collection<MailFolder> children = this.saveMailFolders(dao, waitingStateCache, mailFolderMap, (MailFolder)currentMailFolder, mailFolder.getChildren(), mailFolderCache);
            currentMailFolder.setChildren(children);
            dao.update((TopiaEntity)currentMailFolder);
            result.add(currentMailFolder);
            mailFolderCache.put(mailFolder.getTopiaId(), (MailFolder)currentMailFolder);
        }
        return result;
    }

    protected void saveMailFilters(Map<String, MailFolder> mailFolderCache, List<MailFilter> mailFilters) {
        MailFilterTopiaDao dao = this.getPersistenceContext().getMailFilterDao();
        int position = 0;
        List filters = dao.findAll();
        HashMap filterByExpression = new HashMap(Maps.uniqueIndex((Iterable)filters, GET_EXPRESSION));
        for (MailFilter mailFilter : mailFilters) {
            boolean create;
            MailFilter filter = (MailFilter)filterByExpression.remove(mailFilter.getExpression().toLowerCase());
            boolean bl = create = filter == null;
            if (create) {
                filter = (MailFilter)dao.newInstance();
            }
            filter.setExpression(mailFilter.getExpression().toLowerCase());
            filter.setFilterFolderPriority(mailFilter.isFilterFolderPriority());
            MailFolder mailFolder = mailFolderCache.get(mailFilter.getMailFolder().getTopiaId());
            filter.setMailFolder(mailFolder);
            filter.setPosition(position);
            filter = create ? (MailFilter)dao.create((TopiaEntity)filter) : (MailFilter)dao.update((TopiaEntity)filter);
            ++position;
        }
        dao.deleteAll(filterByExpression.values());
    }

    @Override
    public List<EmailAccount> getEmailAccountsWithoutPasswords() {
        List<EmailAccount> accounts = this.getEmailAccounts();
        final Binder binderEmailAccount = BinderFactory.newBinder(EmailAccount.class);
        List result = Lists.transform(accounts, (Function)new Function<EmailAccount, EmailAccount>(){

            public EmailAccount apply(EmailAccount input) {
                EmailAccountImpl account = new EmailAccountImpl();
                binderEmailAccount.copyExcluding((Object)input, (Object)account, new String[]{"password"});
                return account;
            }
        });
        return result;
    }

    @Override
    public List<EmailAccount> getEmailAccounts() {
        EmailAccountTopiaDao emailAccountTopiaDao = this.getPersistenceContext().getEmailAccountDao();
        List result = emailAccountTopiaDao.findAll();
        return result;
    }

    protected void saveEmailAccounts(List<EmailAccount> newEmailAccounts) {
        EmailAccountTopiaDao emailAccountTopiaDao = this.getPersistenceContext().getEmailAccountDao();
        List emailAccounts = emailAccountTopiaDao.findAll();
        HashMap emailAccountMap = new HashMap(Maps.uniqueIndex((Iterable)emailAccounts, (Function)TopiaEntities.getTopiaIdFunction()));
        Binder binder = BinderFactory.newBinder(EmailAccount.class);
        for (EmailAccount newEmailAccount : newEmailAccounts) {
            Object emailAccount = StringUtils.isNotBlank((CharSequence)newEmailAccount.getTopiaId()) ? (EmailAccount)emailAccountMap.remove(newEmailAccount.getTopiaId()) : new EmailAccountImpl();
            binder.copyExcluding((Object)newEmailAccount, emailAccount, new String[]{"topiaId", "topiaCreateDate", "topiaVersion", "password"});
            if (StringUtils.isNotEmpty((CharSequence)newEmailAccount.getPassword())) {
                emailAccount.setPassword(newEmailAccount.getPassword());
            }
            if (emailAccount.isPersisted()) {
                emailAccountTopiaDao.update((TopiaEntity)emailAccount);
                continue;
            }
            emailAccountTopiaDao.create((TopiaEntity)emailAccount);
        }
        emailAccountTopiaDao.deleteAll(emailAccountMap.values());
    }

    @Override
    public void saveUserFolders(Map<String, Collection<MailFolder>> userFolders) {
        FaxToMailUserTopiaDao faxToMailUserTopiaDao = this.getPersistenceContext().getFaxToMailUserDao();
        for (Map.Entry<String, Collection<MailFolder>> entry : userFolders.entrySet()) {
            String userId = entry.getKey();
            Collection<MailFolder> mailFolders = entry.getValue();
            FaxToMailUser user = (FaxToMailUser)faxToMailUserTopiaDao.forTopiaIdEquals(userId).findUnique();
            user.clearAffectedFolders();
            for (MailFolder mailFolder : mailFolders) {
                user.addAffectedFolders(mailFolder);
            }
            faxToMailUserTopiaDao.update((TopiaEntity)user);
        }
        this.getPersistenceContext().commit();
    }

    @Override
    public ExtensionCommand getExtensionCommand(String extension) {
        ExtensionCommandTopiaDao extensionCommandDao = this.getPersistenceContext().getExtensionCommandDao();
        ExtensionCommand result = extensionCommandDao.findByExtension(extension);
        return result;
    }

    @Override
    public Set<FaxToMailUser> getUserManagedUsers(FaxToMailUser user) {
        HashSet<FaxToMailUser> result = new HashSet<FaxToMailUser>();
        if (user.getUserGroups() != null) {
            GroupChefTopiaDao groupChefTopiaDao = this.getPersistenceContext().getGroupChefDao();
            List groupChefs = groupChefTopiaDao.forUserGroupIn(user.getUserGroups()).findAll();
            FaxToMailUserTopiaDao faxToMailUserTopiaDao = this.getPersistenceContext().getFaxToMailUserDao();
            for (GroupChef groupChef : groupChefs) {
                if (groupChef.getManagedGroups() != null) {
                    for (FaxToMailUserGroup group : groupChef.getManagedGroups()) {
                        List users = faxToMailUserTopiaDao.forUserGroupsContains(group).findAll();
                        result.addAll(users);
                    }
                }
                if (groupChef.getManagedUsers() == null) continue;
                result.addAll(groupChef.getManagedUsers());
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> checkDirectory(String path) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        File file = new File(path);
        result.put("path", path);
        result.put("exist", file.exists());
        result.put("isDirectory", file.isDirectory());
        result.put("canRead", file.canRead());
        result.put("canWrite", file.canWrite());
        result.put("canExecute", file.canExecute());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> checkMailaccount(EmailAccount account) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        long before = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Check account " + account.getProtocol() + " : " + account.getHost()));
        }
        Properties properties = new Properties();
        if (account.getProtocol() == EmailProtocol.POP3S) {
            properties.setProperty("mail.pop3.ssl.enable", "true");
        }
        switch (account.getProtocol()) {
            case IMAPS: {
                properties.setProperty("mail.imap.ssl.enable", "true");
            }
            case IMAP: {
                properties.setProperty("mail.store.protocol", "imap");
                properties.setProperty("mail.imap.host", account.getHost());
                properties.setProperty("mail.imap.port", String.valueOf(account.getPort()));
                properties.setProperty("mail.imap.connectiontimeout", "2000");
                break;
            }
            case POP3S: {
                properties.setProperty("mail.pop3.ssl.enable", "true");
            }
            case POP3: {
                properties.setProperty("mail.store.protocol", "pop3");
                properties.setProperty("mail.pop3.host", account.getHost());
                properties.setProperty("mail.pop3.port", String.valueOf(account.getPort()));
                properties.setProperty("mail.pop3.connectiontimeout", "2000");
            }
        }
        Session session = Session.getInstance((Properties)properties);
        Store store = null;
        try {
            store = session.getStore();
            store.connect(account.getLogin(), account.getPassword());
            store.close();
            result.put("ok", true);
        }
        catch (MessagingException e) {
            log.error((Object)"Error while getting emails from the mailbox", (Throwable)e);
            result.put("ok", false);
            result.put("error", e.getMessage());
        }
        finally {
            if (store != null) {
                try {
                    store.close();
                }
                catch (MessagingException e) {}
            }
        }
        if (log.isDebugEnabled()) {
            long after = System.currentTimeMillis();
            log.debug((Object)("Checked in  " + (after - before) + " ms"));
        }
        return result;
    }

    @Override
    public long getEmailMaxSize() {
        Configuration conf = this.getConfiguration();
        return conf.getEmailMaxSize();
    }

    @Override
    public List<MailField> getSearchDisplayColumns() {
        Configuration conf = this.getConfiguration();
        return conf.getSearchDisplayColumns();
    }
}

