package com.franciaflex.faxtomail.ui.swing.actions;

/*
 * #%L
 * FaxToMail :: UI
 * %%
 * Copyright (C) 2014 Franciaflex
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.FaxToMailConfiguration;
import com.franciaflex.faxtomail.persistence.ProgressionModel;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailUIHandler;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import org.jdesktop.beans.AbstractBean;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;

import javax.swing.*;
import java.awt.*;

/**
 * FaxToMail base action.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public abstract class AbstractFaxToMailAction <M extends AbstractBean, UI extends FaxToMailUI<M, ?>, H extends AbstractFaxToMailUIHandler<M, UI>>
        extends AbstractApplicationAction<M, UI, H> {

    public abstract void doAction() throws Exception;

    protected AbstractFaxToMailAction(H handler, boolean hideBody) {
        super(handler, hideBody);
    }

    @Override
    public FaxToMailUIContext getContext() {
        return handler.getContext();
    }

    public void setProgressionModel(ProgressionModel progressionModel) {
        super.setProgressionModel(progressionModel);
    }

    @Override
    protected ProgressionModel getProgressionModel() {
        return (ProgressionModel) getContext().getActionUI().getModel().getProgressionModel();
    }

//    public FaxToMailDataContext getDataContext() {
//        return getContext().getDataContext();
//    }

    @Override
    protected FaxToMailConfiguration getConfig() {
        return getContext().getConfig();
    }

    @Override
    protected void sendMessage(String message) {
        getContext().showInformationMessage(message);
    }

    @Override
    protected void createProgressionModelIfRequired(int total) {
        ProgressionModel progressionModel = getProgressionModel();
        if (progressionModel == null) {
            progressionModel = new ProgressionModel();
            progressionModel.setTotal(total);
            progressionModel.setMessage("");
            progressionModel.setCurrent(0);
            setProgressionModel(progressionModel);
        } else {
            progressionModel.adaptTotal(total);
        }
    }

    protected boolean askAdminPassword(String askMessage,
                                       String askMessageTitle,
                                       String errorMessage,
                                       String errorMessageTitle) {

        Component container = getContext().getActionUI();

        String answer;
        boolean result;
        do {
            answer = JOptionPane.showInputDialog(container,
                                                 askMessage,
                                                 askMessageTitle,
                                                 JOptionPane.WARNING_MESSAGE);
//            if (answer != null) {
//                String cryptedAnswer = StringUtil.encodeMD5(answer);
//                String correctAnswer = getConfig().getAdminPassword();
//                result = StringUtils.equals(cryptedAnswer, correctAnswer);
//
//                if (!result) {
//                    JOptionPane.showMessageDialog(container,
//                                                  errorMessage,
//                                                  errorMessageTitle,
//                                                  JOptionPane.ERROR_MESSAGE);
//                }
//
//            } else {
                result = false;
//            }

        } while (!result && answer != null);
        return result;
    }
}
