/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.services.service.imports;

import com.franciaflex.faxtomail.persistence.entities.DemandType;
import com.franciaflex.faxtomail.persistence.entities.HasLabel;
import com.franciaflex.faxtomail.persistence.entities.Priority;
import com.franciaflex.faxtomail.persistence.entities.WaitingState;
import com.franciaflex.faxtomail.services.service.imports.ArchiveImportExportBean;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.nuiton.csv.Common;
import org.nuiton.csv.ValueParserFormatter;
import org.nuiton.csv.ext.AbstractImportExportModel;

public class ArchiveImportExportModel
extends AbstractImportExportModel<ArchiveImportExportBean> {
    protected static final ValueParserFormatter<Date> dateValueParserFormatter = new ValueParserFormatter<Date>(){
        protected DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");

        public Date parse(String value) throws ParseException {
            return this.dateFormat.parse(value);
        }

        public String format(Date value) {
            return this.dateFormat.format(value);
        }
    };

    public ArchiveImportExportModel(char separator, final Map<String, WaitingState> waitingStates, final Map<String, DemandType> demandTypes, final Map<String, Priority> priorities) {
        super(separator);
        this.newColumnForImportExport("receptionDate", "receptionDate", dateValueParserFormatter);
        this.newColumnForImportExport("projectReference", "projectReference");
        this.newColumnForImportExport("sender", "sender", (ValueParserFormatter)new ValueParserFormatter<Object>(){

            public Object parse(String value) throws ParseException {
                value = value.replaceFirst("^.*<(.*)>$", "$1");
                value = value.toLowerCase();
                return value;
            }

            public String format(Object value) {
                return value != null ? value.toString() : "";
            }
        });
        this.newColumnForImportExport("fax", "fax", Common.PRIMITIVE_BOOLEAN);
        this.newColumnForImportExport("recipient", "recipient");
        this.newColumnForImportExport("object", "object");
        this.newColumnForImportExport("archiveDate", "archiveDate", dateValueParserFormatter);
        this.newColumnForImportExport("companyReference", "companyReference");
        this.newColumnForImportExport("originalEmail", "originalEmailContent");
        this.newColumnForImportExport("comment", "comment");
        this.newColumnForImportExport("etatAttente", "waitingState", new HasLabelValueParserFormatter<WaitingState>(){

            public WaitingState parse(String value) throws ParseException {
                return (WaitingState)waitingStates.get(value);
            }
        });
        this.newColumnForImportExport("demandType", "demandType", new HasLabelValueParserFormatter<DemandType>(){

            public DemandType parse(String value) throws ParseException {
                return (DemandType)demandTypes.get(value);
            }
        });
        this.newColumnForImportExport("priority", "priority", new HasLabelValueParserFormatter<Priority>(){

            public Priority parse(String value) throws ParseException {
                return (Priority)priorities.get(value);
            }
        });
        this.newColumnForImportExport("mailFolder", "mailFolderPath");
        this.newColumnForImportExport("client-code", "clientCode");
        this.newOptionalColumn("client-brand", "clientBrand");
        this.newColumnForExport("client-brand", "clientBrand");
        this.newColumnForImportExport("attachments", "attachmentPaths");
        this.newOptionalColumn("error", "error");
        this.newColumnForExport("error", "error");
    }

    public ArchiveImportExportBean newEmptyInstance() {
        return new ArchiveImportExportBean();
    }

    protected abstract class HasLabelValueParserFormatter<E extends HasLabel>
    implements ValueParserFormatter<E> {
        protected HasLabelValueParserFormatter() {
        }

        public String format(E value) {
            return value != null ? value.getLabel() : "";
        }
    }
}

