package com.franciaflex.faxtomail.services;

/*
 * #%L
 * FaxToMail :: Service
 * $Id: FaxToMailServiceContext.java 48 2014-04-25 13:43:04Z echatellier $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.2/faxtomail-service/src/main/java/com/franciaflex/faxtomail/services/FaxToMailServiceContext.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.FaxToMailConfiguration;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailTopiaPersistenceContext;
import com.franciaflex.faxtomail.services.service.FaxToMailWebApplicationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;

public class FaxToMailServiceContext {

    private static final Log log =
            LogFactory.getLog(FaxToMailServiceContext.class);

    protected FaxToMailConfiguration applicationConfig;

    protected FaxToMailTopiaPersistenceContext persistenceContext;

    protected FaxToMailWebApplicationContext webApplicationContext;

    public FaxToMailConfiguration getApplicationConfig() {
        return applicationConfig;
    }

    public void setPersistenceContext(FaxToMailTopiaPersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public FaxToMailTopiaPersistenceContext getPersistenceContext() {
        return persistenceContext;
    }

    public void setApplicationConfig(FaxToMailConfiguration applicationConfig) {
        this.applicationConfig = applicationConfig;
    }

    public <E extends FaxToMailService> E newService(Class<E> serviceClass) {

        E service;

        try {

            Constructor<E> constructor = serviceClass.getConstructor();

            service = constructor.newInstance();

        } catch (NoSuchMethodException e) {

            throw new ApplicationTechnicalException("all services must provide a non-argument constructor", e);

        } catch (InvocationTargetException e) {

            throw new ApplicationTechnicalException("unable to instantiate service", e);

        } catch (InstantiationException e) {

            throw new ApplicationTechnicalException("unable to instantiate service", e);

        } catch (IllegalAccessException e) {

            throw new ApplicationTechnicalException("unable to instantiate service", e);

        }

        service.setServiceContext(this);

        return service;

    }

    public Date getNow() {
        Date now = new Date();
        return now;
    }

    public FaxToMailWebApplicationContext getWebApplicationContext() {
        return webApplicationContext;
    }

    public void setWebApplicationContext(FaxToMailWebApplicationContext webApplicationContext) {
        this.webApplicationContext = webApplicationContext;
    }

}
