package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityEnumTransformer", date = "Fri Oct 03 12:55:20 CEST 2014")

public enum FaxToMailEntityEnum implements TopiaEntityEnum {
    Attachment(Attachment.class, null, "attachment", new String[]{"originalFileName", "originalFile"}),
    AttachmentFile(AttachmentFile.class, null, "attachmentfile", new String[]{"filename", "content"}),
    Client(Client.class, null, "client", new String[]{"code", "company"}, "code", "company"),
    Configuration(Configuration.class, null, "configuration", ArrayUtils.EMPTY_STRING_ARRAY),
    DemandType(DemandType.class, null, "demandtype", new String[]{"label"}, "label"),
    Email(Email.class, null, "email", new String[]{"originalEmail", "mailFolder"}),
    EmailAccount(EmailAccount.class, null, "emailaccount", new String[]{"host", "login", "protocol"}, "host", "login", "protocol"),
    EmailGroup(EmailGroup.class, null, "emailgroup", ArrayUtils.EMPTY_STRING_ARRAY),
    ExtensionCommand(ExtensionCommand.class, null, "extensioncommand", new String[]{"extension"}, "extension"),
    FaxToMailUser(FaxToMailUser.class, null, "faxtomailuser", new String[]{"login"}, "login"),
    FaxToMailUserGroup(FaxToMailUserGroup.class, null, "faxtomailusergroup", new String[]{"name"}, "name"),
    GroupChef(GroupChef.class, null, "groupchef", new String[]{"userGroup"}),
    History(History.class, null, "history", new String[]{"type"}),
    MailFilter(MailFilter.class, null, "mailfilter", new String[]{"expression", "mailFolder"}, "expression"),
    MailFolder(MailFolder.class, null, "mailfolder", new String[]{"name"}, "name", "parent"),
    MailLock(MailLock.class, null, "maillock", new String[]{"lockOn", "lockBy"}),
    Priority(Priority.class, null, "priority", new String[]{"label"}, "label"),
    Range(Range.class, null, "range", new String[]{"label"}, "label"),
    RangeRow(RangeRow.class, null, "rangerow", ArrayUtils.EMPTY_STRING_ARRAY),
    Reply(Reply.class, null, "reply", new String[]{"sentDate", "subject", "sender", "recipient", "replyContent", "sentBy"}),
    ReplyContent(ReplyContent.class, null, "replycontent", new String[]{"source"}),
    WaitingState(WaitingState.class, null, "waitingstate", new String[]{"label"}, "label");

    /**
     * The contract of the entity.
     */
    protected Class<? extends TopiaEntity> contract;

    /**
     * The optional name of database schema of the entity (if none was filled, will be {@code null}).
     */
    protected String dbSchemaName;

    /**
     * The name of the database table for the entity.
     */
    protected String dbTableName;

    /**
     * The fully qualified name of the implementation of the entity.
     */
    protected String implementationFQN;

    /**
     * The implementation class of the entity (will be lazy computed at runtime).
     */
    protected Class<? extends TopiaEntity> implementation;

    /**
     * The array of property involved in the natural key of the entity.
     */
    protected String[] naturalIds;

    /**
     * The array of not null properties of the entity.
     */
    protected String[] notNulls;

    FaxToMailEntityEnum(Class<? extends TopiaEntity> contract, String dbSchemaName, String dbTableName, String[] notNulls, String ... naturalIds) {
        this.contract = contract;
        this.notNulls = Arrays.copyOf(notNulls, notNulls.length);
        this.naturalIds = naturalIds;
        implementationFQN = contract.getName() + "Impl";
    }

    @Override
    public Class<? extends TopiaEntity> getContract() {
        return contract;
    }

    @Override
    public String dbSchemaName() {
        return dbSchemaName;
    }

    @Override
    public String dbTableName() {
        return dbTableName;
    }

    @Override
    public String[] getNaturalIds() {
        return naturalIds;
    }

    @Override
    public boolean isUseNaturalIds() {
        return naturalIds.length > 0;
    }

    @Override
    public String[] getNotNulls() {
        return notNulls;
    }

    @Override
    public boolean isUseNotNulls() {
        return notNulls.length > 0;
    }

    @Override
    public String getImplementationFQN() {
        return implementationFQN;
    }

    @Override
    public void setImplementationFQN(String implementationFQN) {
        this.implementationFQN = implementationFQN;
        this.implementation = null;
    }

    @Override
    public boolean accept(Class<? extends TopiaEntity> klass) {
        FaxToMailEntityEnum constant = valueOf(klass);
        boolean result = constant.getContract() == contract;
        return result;
    }

    @Override
    public Class<? extends TopiaEntity> getImplementation() {
        if (implementation == null) {
            try {
                implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);
            } catch (ClassNotFoundException e) {
                throw new TopiaException("could not find class " + implementationFQN, e);
            }
        }
        return implementation;
    }

    public static FaxToMailEntityEnum valueOf(TopiaEntity entity) {
        return valueOf(entity.getClass());
    }

    public static FaxToMailEntityEnum valueOf(final Class<?> klass) {
        if (klass.isInterface()) {
            return valueOf(klass.getSimpleName());
        }

        Class<?> contractClass = TopiaEntityHelper.getContractClass(FaxToMailEntityEnum.values(), (Class) klass);

        if (contractClass != null) {

            return valueOf(contractClass.getSimpleName());
        }

        throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString(FaxToMailEntityEnum.values()));
    }

    public static FaxToMailEntityEnum[] getContracts() {
        FaxToMailEntityEnum[] result = values();
        return result;
    }

    public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {
        FaxToMailEntityEnum constant = valueOf(klass);
        Class<T> result = (Class<T>) constant.getContract();
        return result;
    }

    public static Class<? extends TopiaEntity>[] getContractClasses() {
        FaxToMailEntityEnum[] values = values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getContract();
        }
        return result;
    }

    public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {
        FaxToMailEntityEnum constant = valueOf(klass);
        Class<T> result = (Class<T>) constant.getImplementation();
        return result;
    }

    public static Class<? extends TopiaEntity>[] getImplementationClasses() {
        FaxToMailEntityEnum[] values = values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getImplementation();
        }
        return result;
    }

    public static String getImplementationClassesAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        String result = buffer.substring(1);
        return result;
    }

} //FaxToMailEntityEnum
