/* The following code was generated by JFlex 1.4.1 on 2/7/12 10:39 PM */

/*
 * 01/24/2005
 *
 * HTMLTokenMaker.java - Generates tokens for HTML syntax highlighting.
 * 
 * This library is distributed under a modified BSD license.  See the included
 * RSyntaxTextArea.License.txt file for details.
 */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.*;


/**
 * Scanner for HTML 5 files.
 *
 * This implementation was created using
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>, so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated HTMLTokenMaker.java</code> file will contain two
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 * @author Robert Futrell
 * @version 0.8
 *
 */

public class HTMLTokenMaker extends AbstractMarkupTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** lexical states */
  public static final int JS_STRING = 12;
  public static final int INTAG_CHECK_TAG_NAME = 5;
  public static final int JS_MLC = 14;
  public static final int INTAG_SCRIPT = 8;
  public static final int JS_CHAR = 13;
  public static final int JS_EOL_COMMENT = 15;
  public static final int INATTR_DOUBLE_SCRIPT = 9;
  public static final int INATTR_SINGLE_SCRIPT = 10;
  public static final int DTD = 3;
  public static final int INATTR_SINGLE = 7;
  public static final int INATTR_DOUBLE = 6;
  public static final int YYINITIAL = 0;
  public static final int INTAG = 4;
  public static final int COMMENT = 1;
  public static final int JAVASCRIPT = 11;
  public static final int PI = 2;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\4\1\2\1\0\1\1\1\26\22\0\1\4\1\50\1\7"+
    "\1\27\1\32\1\47\1\5\1\57\2\56\1\33\1\44\1\43\1\40"+
    "\1\41\1\10\1\22\6\105\1\24\2\21\1\52\1\6\1\3\1\45"+
    "\1\17\1\51\1\27\1\70\1\23\1\12\1\76\1\37\1\36\1\100"+
    "\1\104\1\14\1\106\1\101\1\35\1\74\1\72\1\71\1\15\1\102"+
    "\1\13\1\11\1\16\1\77\1\103\1\20\1\34\1\73\1\20\1\56"+
    "\1\30\1\56\1\46\1\31\1\0\1\111\1\107\1\113\1\116\1\66"+
    "\1\64\1\55\1\60\1\54\1\106\1\112\1\65\1\75\1\115\1\114"+
    "\1\62\1\102\1\110\1\63\1\61\1\25\1\120\1\67\1\121\1\117"+
    "\1\122\1\42\1\46\1\42\1\53\uff81\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\6\0\2\1\1\0\2\1\5\0\2\2\1\3\1\4"+
    "\1\5\1\6\1\1\1\7\5\1\1\10\2\1\1\11"+
    "\1\12\2\13\1\14\1\15\1\16\1\17\1\20\1\21"+
    "\1\22\1\23\2\21\2\23\1\21\2\23\4\21\1\23"+
    "\5\21\1\23\1\21\1\1\1\24\1\1\1\25\1\15"+
    "\1\26\1\27\1\30\1\31\1\32\2\17\1\2\1\33"+
    "\1\17\2\2\1\17\2\34\1\2\1\31\2\17\1\2"+
    "\1\35\1\17\2\2\1\36\17\2\1\1\1\37\1\40"+
    "\1\41\1\1\1\42\1\43\1\44\1\1\1\45\6\1"+
    "\1\46\1\1\1\4\2\47\1\50\1\51\1\6\5\0"+
    "\1\52\31\21\1\23\7\21\1\23\5\21\1\23\33\21"+
    "\1\53\3\0\1\54\1\0\1\55\1\17\1\31\1\2"+
    "\1\17\1\56\1\34\1\57\1\56\1\57\1\56\1\60"+
    "\1\56\2\2\1\61\1\2\1\61\47\2\1\61\1\2"+
    "\1\62\1\63\1\64\1\0\1\65\5\0\1\66\1\47"+
    "\1\0\1\67\4\0\14\21\1\23\63\21\1\0\1\70"+
    "\1\0\1\31\1\2\1\57\1\0\2\60\4\2\1\6"+
    "\57\2\10\0\1\47\1\71\2\0\1\72\20\21\1\23"+
    "\5\21\1\23\14\21\1\0\1\73\1\31\10\2\1\74"+
    "\13\2\1\6\1\2\1\75\15\2\1\0\1\1\3\0"+
    "\1\76\1\0\1\47\2\0\10\21\1\23\13\21\1\0"+
    "\1\31\5\2\1\61\10\2\1\61\10\2\4\0\1\47"+
    "\12\21\1\0\1\31\17\2\2\0\1\77\3\21\1\0"+
    "\7\2\2\0\1\21\1\0\3\2\2\0\1\21\1\100"+
    "\1\2\1\101\1\102";

  private static int [] zzUnpackAction() {
    int [] result = new int[615];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\123\0\246\0\371\0\u014c\0\u019f\0\u01f2\0\u0245"+
    "\0\u0298\0\u02eb\0\u033e\0\u0391\0\u03e4\0\u0437\0\u048a\0\u04dd"+
    "\0\u0530\0\u0583\0\u05d6\0\u0629\0\u067c\0\u06cf\0\u0722\0\u05d6"+
    "\0\u0775\0\u07c8\0\u081b\0\u086e\0\u08c1\0\u05d6\0\u0914\0\u0967"+
    "\0\u05d6\0\u05d6\0\u09ba\0\u0a0d\0\u05d6\0\u0a60\0\u05d6\0\u05d6"+
    "\0\u05d6\0\u0ab3\0\u05d6\0\u0b06\0\u0b59\0\u0bac\0\u0bff\0\u0c52"+
    "\0\u0ca5\0\u0cf8\0\u0d4b\0\u0d9e\0\u0df1\0\u0e44\0\u0e97\0\u0eea"+
    "\0\u0f3d\0\u0f90\0\u0fe3\0\u1036\0\u1089\0\u0ab3\0\u10dc\0\u112f"+
    "\0\u05d6\0\u1182\0\u05d6\0\u11d5\0\u05d6\0\u05d6\0\u05d6\0\u1228"+
    "\0\u05d6\0\u127b\0\u12ce\0\u05d6\0\u05d6\0\u1321\0\u1374\0\u13c7"+
    "\0\u141a\0\u146d\0\u14c0\0\u1513\0\u05d6\0\u1566\0\u15b9\0\u160c"+
    "\0\u05d6\0\u165f\0\u16b2\0\u1705\0\u05d6\0\u1758\0\u17ab\0\u17fe"+
    "\0\u1851\0\u18a4\0\u18f7\0\u194a\0\u199d\0\u19f0\0\u1a43\0\u1a96"+
    "\0\u1ae9\0\u1b3c\0\u1b8f\0\u1be2\0\u1c35\0\u05d6\0\u05d6\0\u1c88"+
    "\0\u1cdb\0\u05d6\0\u1c88\0\u05d6\0\u1d2e\0\u05d6\0\u1d81\0\u1dd4"+
    "\0\u1e27\0\u1e7a\0\u1ecd\0\u1f20\0\u05d6\0\u1f73\0\u1fc6\0\u2019"+
    "\0\u206c\0\u20bf\0\u05d6\0\u05d6\0\u2112\0\u2165\0\u21b8\0\u220b"+
    "\0\u225e\0\u05d6\0\u22b1\0\u2304\0\u2357\0\u23aa\0\u23fd\0\u2450"+
    "\0\u24a3\0\u24f6\0\u2549\0\u259c\0\u25ef\0\u2642\0\u2695\0\u26e8"+
    "\0\u273b\0\u278e\0\u27e1\0\u2834\0\u2887\0\u28da\0\u292d\0\u2980"+
    "\0\u29d3\0\u2a26\0\u2a79\0\u2acc\0\u2b1f\0\u2b72\0\u2bc5\0\u2c18"+
    "\0\u2c6b\0\u2cbe\0\u2d11\0\u2d64\0\u2db7\0\u2e0a\0\u2e5d\0\u2eb0"+
    "\0\u2f03\0\u2f56\0\u2fa9\0\u2ffc\0\u304f\0\u30a2\0\u30f5\0\u3148"+
    "\0\u319b\0\u31ee\0\u3241\0\u3294\0\u32e7\0\u333a\0\u338d\0\u33e0"+
    "\0\u3433\0\u3486\0\u34d9\0\u352c\0\u357f\0\u35d2\0\u3625\0\u3678"+
    "\0\u36cb\0\u371e\0\u3771\0\u37c4\0\u3817\0\u05d6\0\u1566\0\u386a"+
    "\0\u38bd\0\u05d6\0\u3910\0\u3963\0\u38bd\0\u39b6\0\u3a09\0\u3a5c"+
    "\0\u3aaf\0\u3aaf\0\u3aaf\0\u3b02\0\u3b55\0\u3ba8\0\u3bfb\0\u3c4e"+
    "\0\u3ca1\0\u3cf4\0\u1374\0\u3d47\0\u3d9a\0\u3ded\0\u3e40\0\u3e93"+
    "\0\u3ee6\0\u3f39\0\u3f8c\0\u3fdf\0\u4032\0\u4085\0\u40d8\0\u412b"+
    "\0\u417e\0\u41d1\0\u4224\0\u4277\0\u42ca\0\u431d\0\u4370\0\u43c3"+
    "\0\u4416\0\u4469\0\u44bc\0\u450f\0\u4562\0\u45b5\0\u4608\0\u465b"+
    "\0\u46ae\0\u4701\0\u4754\0\u47a7\0\u47fa\0\u484d\0\u48a0\0\u48f3"+
    "\0\u4946\0\u4999\0\u49ec\0\u4a3f\0\u4a92\0\u4ae5\0\u05d6\0\u4b38"+
    "\0\u4b8b\0\u4bde\0\u05d6\0\u4c31\0\u4c84\0\u4cd7\0\u4d2a\0\u4d7d"+
    "\0\u1fc6\0\u4dd0\0\u4e23\0\u05d6\0\u4e76\0\u4ec9\0\u4f1c\0\u4f6f"+
    "\0\u4fc2\0\u5015\0\u5068\0\u50bb\0\u510e\0\u5161\0\u51b4\0\u5207"+
    "\0\u525a\0\u52ad\0\u5300\0\u5353\0\u53a6\0\u53f9\0\u544c\0\u549f"+
    "\0\u54f2\0\u5545\0\u5598\0\u55eb\0\u563e\0\u5691\0\u56e4\0\u5737"+
    "\0\u578a\0\u2d64\0\u57dd\0\u5830\0\u5883\0\u58d6\0\u5929\0\u597c"+
    "\0\u59cf\0\u5a22\0\u5a75\0\u5ac8\0\u5b1b\0\u5b6e\0\u5bc1\0\u5c14"+
    "\0\u5c67\0\u0d4b\0\u5cba\0\u5d0d\0\u5d60\0\u5db3\0\u5e06\0\u5e59"+
    "\0\u5eac\0\u5eff\0\u5f52\0\u5fa5\0\u5ff8\0\u604b\0\u609e\0\u60f1"+
    "\0\u6144\0\u6197\0\u61ea\0\u623d\0\u6290\0\u62e3\0\u6336\0\u6389"+
    "\0\u63dc\0\u642f\0\u6482\0\u64d5\0\u6528\0\u657b\0\u65ce\0\u3aaf"+
    "\0\u6621\0\u6674\0\u66c7\0\u671a\0\u676d\0\u67c0\0\u6813\0\u6866"+
    "\0\u68b9\0\u690c\0\u695f\0\u69b2\0\u6a05\0\u6a58\0\u6aab\0\u6afe"+
    "\0\u6b51\0\u6ba4\0\u6bf7\0\u6c4a\0\u6c9d\0\u6cf0\0\u6d43\0\u6d96"+
    "\0\u6de9\0\u6e3c\0\u6e8f\0\u6ee2\0\u6f35\0\u6f88\0\u6fdb\0\u702e"+
    "\0\u7081\0\u70d4\0\u7127\0\u717a\0\u71cd\0\u7220\0\u7273\0\u72c6"+
    "\0\u7319\0\u736c\0\u73bf\0\u7412\0\u7465\0\u74b8\0\u750b\0\u755e"+
    "\0\u75b1\0\u7604\0\u7657\0\u76aa\0\u76fd\0\u7750\0\u77a3\0\u77f6"+
    "\0\u7849\0\u789c\0\u78ef\0\u7942\0\u7995\0\u79e8\0\u05d6\0\u7a3b"+
    "\0\u7a8e\0\u7ae1\0\u7b34\0\u7b87\0\u7bda\0\u7c2d\0\u7c80\0\u7cd3"+
    "\0\u7d26\0\u7d79\0\u7dcc\0\u7e1f\0\u7e72\0\u7ec5\0\u7f18\0\u7f6b"+
    "\0\u7fbe\0\u8011\0\u8064\0\u80b7\0\u810a\0\u815d\0\u81b0\0\u8203"+
    "\0\u5a22\0\u8256\0\u82a9\0\u82fc\0\u834f\0\u83a2\0\u2f56\0\u83f5"+
    "\0\u8448\0\u849b\0\u84ee\0\u8541\0\u8594\0\u85e7\0\u05d6\0\u863a"+
    "\0\u868d\0\u86e0\0\u8733\0\u8786\0\u87d9\0\u882c\0\u887f\0\u88d2"+
    "\0\u1374\0\u8925\0\u8978\0\u89cb\0\u8a1e\0\u8a71\0\u8ac4\0\u8b17"+
    "\0\u8b6a\0\u8bbd\0\u8c10\0\u8c63\0\u1374\0\u8cb6\0\u1374\0\u8d09"+
    "\0\u8d5c\0\u8daf\0\u8e02\0\u8e55\0\u8ea8\0\u8efb\0\u8f4e\0\u8fa1"+
    "\0\u8ff4\0\u9047\0\u909a\0\u90ed\0\u4b8b\0\u05d6\0\u9140\0\u9193"+
    "\0\u91e6\0\u9239\0\u928c\0\u92df\0\u9332\0\u7ae1\0\u9385\0\u93d8"+
    "\0\u942b\0\u947e\0\u94d1\0\u9524\0\u9577\0\u95ca\0\u961d\0\u961d"+
    "\0\u9670\0\u96c3\0\u9716\0\u9769\0\u97bc\0\u980f\0\u9862\0\u98b5"+
    "\0\u9908\0\u995b\0\u99ae\0\u9a01\0\u9a54\0\u9aa7\0\u9afa\0\u9b4d"+
    "\0\u9ba0\0\u68b9\0\u9bf3\0\u9c46\0\u9c99\0\u9cec\0\u9d3f\0\u9d92"+
    "\0\u9de5\0\u9e38\0\u9e8b\0\u9ede\0\u9f31\0\u9f84\0\u9fd7\0\ua02a"+
    "\0\ua07d\0\ua0d0\0\ua123\0\ua176\0\ua1c9\0\u9239\0\ua21c\0\ua26f"+
    "\0\ua2c2\0\ua315\0\ua368\0\ua3bb\0\ua40e\0\ua461\0\ua4b4\0\ua507"+
    "\0\ua55a\0\ua5ad\0\ua600\0\ua653\0\ua6a6\0\ua6f9\0\ua74c\0\ua79f"+
    "\0\ua7f2\0\ua845\0\ua898\0\ua8eb\0\ua93e\0\ua991\0\ua9e4\0\uaa37"+
    "\0\uaa8a\0\uaadd\0\uab30\0\uab83\0\uabd6\0\u206c\0\uac29\0\uac7c"+
    "\0\uaccf\0\uad22\0\uad75\0\uadc8\0\uae1b\0\uae6e\0\uaec1\0\uaf14"+
    "\0\uaf67\0\uafba\0\ub00d\0\ub060\0\ub0b3\0\ub106\0\ub159\0\ub1ac"+
    "\0\ub1ff\0\ub252\0\ub2a5\0\u05d6\0\ub2f8\0\u05d6\0\u05d6";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[615];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\21\1\22\1\23\1\24\1\25\1\26\115\21\2\27"+
    "\1\30\35\27\1\31\17\27\1\32\3\27\1\33\2\27"+
    "\1\34\33\27\2\35\1\36\46\35\1\37\51\35\2\40"+
    "\1\41\14\40\1\42\103\40\1\43\1\44\1\0\1\43"+
    "\1\25\2\43\1\45\1\46\6\43\1\47\25\43\1\50"+
    "\11\43\1\51\43\43\2\52\1\0\1\52\1\53\2\52"+
    "\2\53\1\54\1\55\1\56\1\57\1\60\1\61\1\53"+
    "\3\52\1\62\1\52\1\63\7\52\1\64\1\65\1\66"+
    "\5\52\1\53\6\52\1\57\2\52\1\53\1\67\1\61"+
    "\1\60\1\54\1\65\1\64\1\66\1\52\1\70\1\71"+
    "\1\72\1\52\2\73\1\74\1\63\1\52\1\75\1\76"+
    "\1\77\1\67\2\52\1\62\1\56\1\70\1\75\1\55"+
    "\1\71\1\72\1\74\1\52\1\77\2\52\7\100\1\101"+
    "\113\100\57\102\1\101\43\102\1\43\1\44\1\0\1\43"+
    "\1\25\2\43\1\103\1\104\6\43\1\105\25\43\1\50"+
    "\11\43\1\106\43\43\7\100\1\107\113\100\57\102\1\107"+
    "\43\102\1\110\1\25\1\111\1\112\1\25\1\113\1\114"+
    "\1\115\1\116\3\117\1\120\2\117\1\121\1\117\1\122"+
    "\1\123\1\117\1\122\1\124\1\125\2\110\2\117\1\126"+
    "\4\117\1\127\1\130\1\131\1\114\1\132\4\126\3\50"+
    "\1\133\1\134\1\131\1\135\1\117\1\136\1\137\1\140"+
    "\1\141\1\142\1\143\1\144\2\117\1\145\12\117\1\122"+
    "\1\117\1\146\1\147\1\150\1\117\1\151\1\117\1\152"+
    "\1\153\1\117\1\154\2\117\2\155\1\156\4\155\1\157"+
    "\20\155\1\160\72\155\2\161\1\162\25\161\1\163\26\161"+
    "\1\164\43\161\2\165\1\166\1\167\27\165\1\170\24\165"+
    "\1\171\3\165\1\172\2\165\1\173\33\165\2\174\1\175"+
    "\1\176\54\174\1\171\3\174\1\172\2\174\1\173\33\174"+
    "\2\21\4\0\116\21\1\22\2\0\1\25\1\0\115\21"+
    "\133\0\1\177\1\200\5\201\1\0\6\201\6\0\4\201"+
    "\10\0\1\202\1\203\2\0\2\201\2\0\3\201\1\200"+
    "\37\201\1\0\1\25\2\0\1\25\116\0\4\26\1\0"+
    "\1\26\1\204\114\26\2\27\1\0\35\27\1\0\17\27"+
    "\1\0\3\27\1\0\2\27\1\0\33\27\40\0\1\205"+
    "\143\0\1\206\115\0\1\207\4\0\1\210\130\0\1\211"+
    "\33\0\2\35\1\0\46\35\1\0\51\35\17\0\1\212"+
    "\103\0\2\40\1\0\14\40\1\0\103\40\2\43\1\0"+
    "\1\43\1\0\2\43\2\0\6\43\1\0\25\43\1\0"+
    "\11\43\1\0\44\43\1\44\1\0\1\43\1\25\2\43"+
    "\2\0\6\43\1\0\25\43\1\0\11\43\1\0\43\43"+
    "\17\0\1\47\103\0\2\52\1\0\1\52\1\0\2\52"+
    "\2\0\6\52\1\0\25\52\1\0\11\52\1\0\45\52"+
    "\1\0\1\52\1\0\2\52\2\0\1\52\1\213\2\52"+
    "\1\214\1\215\1\0\5\52\1\216\11\52\1\217\5\52"+
    "\1\0\11\52\1\0\1\52\1\215\1\214\3\52\1\217"+
    "\1\52\1\220\1\221\2\52\2\222\1\52\1\216\11\52"+
    "\1\220\1\52\1\213\1\221\10\52\1\0\1\52\1\0"+
    "\2\52\2\0\3\52\1\223\2\52\1\0\17\52\1\224"+
    "\5\52\1\0\6\52\1\223\2\52\1\0\6\52\1\224"+
    "\1\52\1\225\1\226\17\52\1\225\2\52\1\226\10\52"+
    "\1\0\1\52\1\0\2\52\2\0\6\52\1\0\5\52"+
    "\1\227\17\52\1\0\11\52\1\0\17\52\1\227\25\52"+
    "\1\0\1\52\1\0\2\52\2\0\1\230\5\52\1\0"+
    "\15\52\1\231\1\232\6\52\1\0\11\52\1\0\3\52"+
    "\1\230\1\232\1\231\4\52\1\233\1\52\2\234\17\52"+
    "\1\233\7\52\1\0\1\52\1\0\2\52\2\0\2\52"+
    "\1\235\3\52\1\0\15\52\1\236\7\52\1\0\11\52"+
    "\1\0\5\52\1\236\2\52\1\237\17\52\1\235\1\237"+
    "\13\52\1\0\1\52\1\0\2\52\2\0\2\52\1\76"+
    "\1\240\1\52\1\76\1\0\3\52\1\241\12\52\1\242"+
    "\1\243\5\52\1\0\6\52\1\240\2\52\1\0\1\244"+
    "\1\76\2\52\1\242\1\52\1\243\1\52\1\245\5\52"+
    "\1\76\5\52\1\244\2\52\1\241\1\76\1\245\4\52"+
    "\1\76\6\52\1\0\1\52\1\0\2\52\2\0\2\52"+
    "\1\76\1\234\2\52\1\0\5\52\1\246\7\52\1\247"+
    "\7\52\1\0\6\52\1\234\1\250\1\52\1\0\5\52"+
    "\1\247\2\52\1\251\1\252\4\52\1\253\1\246\1\250"+
    "\7\52\1\76\1\251\2\52\1\252\1\52\1\253\6\52"+
    "\1\0\1\52\1\0\2\52\2\0\6\52\1\0\15\52"+
    "\1\76\7\52\1\0\11\52\1\0\5\52\1\76\37\52"+
    "\1\0\1\52\1\0\2\52\2\0\3\52\1\254\2\52"+
    "\1\0\17\52\1\255\5\52\1\0\6\52\1\254\2\52"+
    "\1\0\6\52\1\255\1\52\1\256\20\52\1\256\13\52"+
    "\1\0\1\52\1\0\2\52\2\0\2\52\1\257\1\260"+
    "\2\52\1\0\25\52\1\0\6\52\1\260\2\52\1\0"+
    "\11\52\1\261\16\52\1\257\3\52\1\261\10\52\1\0"+
    "\1\52\1\0\2\52\2\0\6\52\1\0\25\52\1\0"+
    "\11\52\1\0\14\52\2\262\5\52\1\263\14\52\1\263"+
    "\4\52\1\0\1\52\1\0\2\52\2\0\2\52\1\76"+
    "\2\52\1\264\1\0\17\52\1\265\5\52\1\0\11\52"+
    "\1\0\1\52\1\264\4\52\1\265\16\52\1\76\2\52"+
    "\1\76\14\52\1\0\1\52\1\0\2\52\2\0\1\266"+
    "\1\267\1\270\1\52\1\271\1\52\1\0\3\52\1\272"+
    "\1\52\1\273\17\52\1\0\11\52\1\0\2\52\1\271"+
    "\1\266\12\52\1\274\1\273\7\52\1\272\1\270\2\52"+
    "\1\267\2\52\1\274\6\52\1\0\1\52\1\0\2\52"+
    "\2\0\4\52\1\275\1\52\1\0\3\52\1\276\1\52"+
    "\1\277\7\52\1\76\7\52\1\0\11\52\1\0\2\52"+
    "\1\275\2\52\1\76\11\52\1\277\7\52\1\276\15\52"+
    "\1\0\1\52\1\0\2\52\2\0\6\52\1\0\17\52"+
    "\1\300\5\52\1\0\11\52\1\0\6\52\1\300\1\52"+
    "\1\301\1\302\17\52\1\301\2\52\1\302\10\52\1\0"+
    "\1\52\1\0\2\52\2\0\6\52\1\0\5\52\1\303"+
    "\11\52\1\304\5\52\1\0\11\52\1\0\6\52\1\304"+
    "\1\52\1\305\6\52\1\303\11\52\1\305\13\52\1\0"+
    "\1\52\1\0\2\52\2\0\3\52\1\306\1\52\1\76"+
    "\1\0\15\52\1\76\1\307\1\310\5\52\1\0\6\52"+
    "\1\306\2\52\1\0\1\52\1\76\2\52\1\307\1\76"+
    "\1\310\1\52\1\311\5\52\1\76\12\52\1\311\4\52"+
    "\1\76\6\52\1\0\1\52\1\0\2\52\2\0\6\52"+
    "\1\0\3\52\1\312\13\52\1\313\5\52\1\0\11\52"+
    "\1\0\6\52\1\313\20\52\1\312\15\52\1\0\1\52"+
    "\1\0\2\52\2\0\3\52\1\314\2\52\1\0\25\52"+
    "\1\0\6\52\1\314\2\52\1\0\10\52\1\315\20\52"+
    "\1\315\11\52\7\100\1\0\113\100\57\102\1\0\43\102"+
    "\17\0\1\316\103\0\1\110\10\0\6\110\1\0\6\110"+
    "\1\0\4\110\1\0\4\110\14\0\2\110\2\0\43\110"+
    "\3\0\1\317\4\0\1\320\34\0\1\50\62\0\1\50"+
    "\37\0\1\50\55\0\10\321\1\322\17\321\1\323\2\321"+
    "\1\324\11\321\1\325\55\321\1\110\10\0\6\117\1\0"+
    "\6\117\1\0\1\110\1\326\2\117\1\0\4\117\14\0"+
    "\2\117\2\0\43\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\2\117"+
    "\2\0\35\117\1\327\5\117\17\0\1\330\25\0\1\50"+
    "\55\0\1\331\10\0\6\331\1\0\1\331\2\122\1\331"+
    "\1\122\1\331\1\0\4\331\1\0\1\331\1\332\1\333"+
    "\1\334\1\0\1\335\12\0\2\331\2\0\4\331\1\333"+
    "\1\332\1\334\7\331\1\333\6\331\1\122\10\331\1\333"+
    "\5\331\10\0\6\331\1\0\1\331\1\336\1\337\1\331"+
    "\1\337\1\331\1\0\4\331\1\0\1\340\1\332\1\333"+
    "\1\334\1\0\1\335\12\0\2\331\2\0\4\331\1\333"+
    "\1\332\1\334\7\331\1\333\6\331\1\337\10\331\1\333"+
    "\2\331\1\340\1\331\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\2\117"+
    "\2\0\35\117\1\341\5\117\45\0\1\50\115\0\1\50"+
    "\4\0\1\50\76\0\2\335\1\0\1\335\60\0\1\335"+
    "\61\0\2\50\55\0\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\2\117"+
    "\2\0\3\117\1\342\1\343\10\117\1\344\17\117\1\345"+
    "\5\117\1\110\10\0\6\117\1\0\6\117\1\0\1\110"+
    "\1\326\2\117\1\0\4\117\14\0\2\117\2\0\34\117"+
    "\1\346\6\117\1\110\10\0\6\117\1\0\6\117\1\0"+
    "\1\110\1\326\2\117\1\0\4\117\14\0\2\117\2\0"+
    "\1\347\27\117\1\350\6\117\1\351\3\117\1\110\10\0"+
    "\6\117\1\0\5\117\1\352\1\0\1\110\1\326\2\117"+
    "\1\0\4\117\14\0\2\117\2\0\30\117\1\353\1\354"+
    "\11\117\1\110\10\0\6\117\1\0\5\117\1\355\1\0"+
    "\1\110\1\326\2\117\1\0\4\117\14\0\2\117\2\0"+
    "\1\356\1\357\5\117\1\360\27\117\1\361\3\117\1\110"+
    "\10\0\6\117\1\0\5\117\1\362\1\0\1\110\1\326"+
    "\2\117\1\0\4\117\14\0\1\363\1\117\2\0\5\117"+
    "\1\364\23\117\1\365\2\117\1\366\6\117\1\110\10\0"+
    "\6\117\1\0\6\117\1\0\1\110\1\326\2\117\1\0"+
    "\4\117\14\0\2\117\2\0\34\117\1\367\6\117\1\110"+
    "\10\0\6\117\1\0\6\117\1\0\1\110\1\326\2\117"+
    "\1\0\4\117\14\0\2\117\2\0\3\117\1\370\1\117"+
    "\1\371\27\117\1\372\2\117\1\373\1\374\1\117\1\110"+
    "\10\0\6\117\1\0\6\117\1\0\1\110\1\326\2\117"+
    "\1\0\4\117\14\0\1\375\1\117\2\0\1\376\42\117"+
    "\1\110\10\0\6\117\1\0\6\117\1\0\1\110\1\326"+
    "\2\117\1\0\4\117\14\0\2\117\2\0\31\117\1\377"+
    "\11\117\1\110\10\0\6\117\1\0\6\117\1\0\1\110"+
    "\1\326\2\117\1\0\4\117\14\0\2\117\2\0\30\117"+
    "\1\u0100\3\117\1\u0101\2\117\1\u0102\3\117\1\110\10\0"+
    "\6\117\1\0\6\117\1\0\1\110\1\326\2\117\1\0"+
    "\4\117\14\0\2\117\2\0\6\117\1\u0103\34\117\1\110"+
    "\10\0\6\117\1\0\6\117\1\0\1\110\1\326\2\117"+
    "\1\0\4\117\14\0\2\117\2\0\27\117\1\u0104\13\117"+
    "\1\110\10\0\6\117\1\0\6\117\1\0\1\110\1\326"+
    "\2\117\1\0\4\117\14\0\2\117\2\0\1\u0105\4\117"+
    "\1\u0106\23\117\1\u0107\2\117\1\u0108\6\117\1\110\10\0"+
    "\6\117\1\0\5\117\1\u0109\1\0\1\110\1\326\2\117"+
    "\1\0\4\117\14\0\2\117\2\0\6\117\1\u010a\22\117"+
    "\1\u010b\11\117\1\110\10\0\6\117\1\0\6\117\1\0"+
    "\1\110\1\326\2\117\1\0\4\117\14\0\2\117\2\0"+
    "\6\117\1\u010c\25\117\1\u010d\6\117\1\110\10\0\6\117"+
    "\1\0\6\117\1\0\1\110\1\326\2\117\1\0\4\117"+
    "\14\0\2\117\2\0\31\117\1\366\2\117\1\u010e\6\117"+
    "\2\155\1\0\4\155\1\0\20\155\1\0\72\155\2\u010f"+
    "\1\0\22\u010f\1\u0110\73\u010f\1\u0111\1\u010f\2\161\1\0"+
    "\25\161\1\0\26\161\1\0\43\161\2\165\2\0\27\165"+
    "\1\0\24\165\1\0\3\165\1\0\2\165\1\0\33\165"+
    "\10\0\1\u0112\122\0\1\u0113\173\0\1\u0114\115\0\1\u0115"+
    "\4\0\1\u0116\130\0\1\u0117\33\0\2\174\2\0\54\174"+
    "\1\0\3\174\1\0\2\174\1\0\33\174\10\0\1\u0118"+
    "\123\0\6\u0119\1\0\6\u0119\6\0\4\u0119\14\0\2\u0119"+
    "\2\0\43\u0119\11\0\1\201\1\u011a\4\201\1\0\6\201"+
    "\6\0\4\201\14\0\2\201\2\0\33\201\1\u011a\7\201"+
    "\11\0\6\201\1\0\6\201\6\0\4\201\14\0\2\201"+
    "\2\0\43\201\40\0\1\u011b\101\0\1\u011c\164\0\1\u011d"+
    "\126\0\1\u011e\117\0\1\u011f\127\0\1\u0120\33\0\2\52"+
    "\1\0\1\52\1\0\2\52\2\0\2\52\1\u0121\3\52"+
    "\1\0\25\52\1\0\11\52\1\0\30\52\1\u0121\14\52"+
    "\1\0\1\52\1\0\2\52\2\0\6\52\1\0\25\52"+
    "\1\0\11\52\1\0\10\52\1\u0122\20\52\1\u0122\13\52"+
    "\1\0\1\52\1\0\2\52\2\0\2\52\1\u0123\3\52"+
    "\1\0\25\52\1\0\11\52\1\0\13\52\1\227\14\52"+
    "\1\u0123\6\52\1\227\5\52\1\0\1\52\1\0\2\52"+
    "\2\0\4\52\1\76\1\52\1\0\3\52\1\76\21\52"+
    "\1\0\11\52\1\0\2\52\1\76\24\52\1\76\15\52"+
    "\1\0\1\52\1\0\2\52\2\0\1\52\1\u0124\1\u0125"+
    "\3\52\1\0\15\52\1\u0126\7\52\1\0\11\52\1\0"+
    "\5\52\1\u0126\22\52\1\u0125\2\52\1\u0124\11\52\1\0"+
    "\1\52\1\0\2\52\2\0\6\52\1\0\25\52\1\0"+
    "\11\52\1\0\14\52\2\u0127\27\52\1\0\1\52\1\0"+
    "\2\52\2\0\6\52\1\0\5\52\1\u0128\17\52\1\0"+
    "\11\52\1\0\17\52\1\u0128\25\52\1\0\1\52\1\0"+
    "\2\52\2\0\6\52\1\0\25\52\1\0\11\52\1\0"+
    "\10\52\1\u0129\20\52\1\u0129\13\52\1\0\1\52\1\0"+
    "\2\52\2\0\5\52\1\u012a\1\0\25\52\1\0\11\52"+
    "\1\0\1\52\1\u012a\43\52\1\0\1\52\1\0\2\52"+
    "\2\0\6\52\1\0\25\52\1\0\11\52\1\0\12\52"+
    "\1\u012b\22\52\1\u012b\7\52\1\0\1\52\1\0\2\52"+
    "\2\0\4\52\1\u0124\1\52\1\0\25\52\1\0\11\52"+
    "\1\0\2\52\1\u0124\7\52\1\u012c\22\52\1\u012c\7\52"+
    "\1\0\1\52\1\0\2\52\2\0\6\52\1\0\15\52"+
    "\1\u012d\7\52\1\0\11\52\1\0\5\52\1\u012d\6\52"+
    "\2\u012e\1\u012a\17\52\1\u012a\6\52\1\0\1\52\1\0"+
    "\2\52\2\0\6\52\1\0\15\52\1\u012a\7\52\1\0"+
    "\11\52\1\0\5\52\1\u012a\37\52\1\0\1\52\1\0"+
    "\2\52\2\0\3\52\1\u012f\2\52\1\0\25\52\1\0"+
    "\6\52\1\u012f\2\52\1\0\45\52\1\0\1\52\1\0"+
    "\2\52\2\0\6\52\1\0\25\52\1\0\11\52\1\0"+
    "\10\52\1\u0130\20\52\1\u0130\13\52\1\0\1\52\1\0"+
    "\2\52\2\0\2\52\1\u0131\3\52\1\0\25\52\1\0"+
    "\11\52\1\0\30\52\1\u0131\14\52\1\0\1\52\1\0"+
    "\2\52\2\0\1\76\3\52\1\u0132\1\52\1\0\25\52"+
    "\1\0\11\52\1\0\2\52\1\u0132\1\76\41\52\1\0"+
    "\1\52\1\0\2\52\2\0\6\52\1\0\25\52\1\0"+
    "\7\52\1\76\1\52\1\0\20\52\1\76\24\52\1\0"+
    "\1\52\1\0\2\52\2\0\6\52\1\0\17\52\1\76"+
    "\5\52\1\0\11\52\1\0\6\52\1\76\2\52\1\u0133"+
    "\22\52\1\u0133\10\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\25\52\1\0\11\52\1\0\10\52\1\u0134"+
    "\20\52\1\u0134\13\52\1\0\1\52\1\0\2\52\2\0"+
    "\2\52\1\u0135\3\52\1\0\25\52\1\0\11\52\1\0"+
    "\30\52\1\u0135\14\52\1\0\1\52\1\0\2\52\2\0"+
    "\5\52\1\227\1\0\25\52\1\0\11\52\1\0\1\52"+
    "\1\227\12\52\2\u012a\27\52\1\0\1\52\1\0\2\52"+
    "\2\0\6\52\1\0\25\52\1\0\11\52\1\0\11\52"+
    "\1\252\22\52\1\252\10\52\1\0\1\52\1\0\2\52"+
    "\2\0\6\52\1\0\25\52\1\0\11\52\1\0\11\52"+
    "\1\u0136\22\52\1\u0136\10\52\1\0\1\52\1\0\2\52"+
    "\2\0\6\52\1\0\14\52\1\u0137\10\52\1\0\11\52"+
    "\1\0\41\52\1\u0137\3\52\1\0\1\52\1\0\2\52"+
    "\2\0\6\52\1\0\17\52\1\u0138\5\52\1\0\11\52"+
    "\1\0\6\52\1\u0138\36\52\1\0\1\52\1\0\2\52"+
    "\2\0\6\52\1\0\3\52\1\227\21\52\1\0\11\52"+
    "\1\0\27\52\1\227\15\52\1\0\1\52\1\0\2\52"+
    "\2\0\5\52\1\u0139\1\0\25\52\1\0\11\52\1\0"+
    "\1\52\1\u0139\43\52\1\0\1\52\1\0\2\52\2\0"+
    "\3\52\1\u013a\2\52\1\0\25\52\1\0\6\52\1\u013a"+
    "\2\52\1\0\11\52\1\u013b\22\52\1\u013b\10\52\1\0"+
    "\1\52\1\0\2\52\2\0\1\u013c\5\52\1\0\25\52"+
    "\1\0\11\52\1\0\3\52\1\u013c\41\52\1\0\1\52"+
    "\1\0\2\52\2\0\1\u013d\5\52\1\0\25\52\1\0"+
    "\11\52\1\0\3\52\1\u013d\41\52\1\0\1\52\1\0"+
    "\2\52\2\0\6\52\1\0\25\52\1\0\11\52\1\0"+
    "\16\52\1\u013e\17\52\1\u013e\6\52\1\0\1\52\1\0"+
    "\2\52\2\0\6\52\1\0\25\52\1\0\11\52\1\0"+
    "\11\52\1\76\22\52\1\76\10\52\1\0\1\52\1\0"+
    "\2\52\2\0\6\52\1\0\25\52\1\0\11\52\1\0"+
    "\12\52\1\u013f\22\52\1\u013f\7\52\1\0\1\52\1\0"+
    "\2\52\2\0\6\52\1\0\25\52\1\0\7\52\1\u0140"+
    "\1\52\1\0\20\52\1\u0140\24\52\1\0\1\52\1\0"+
    "\2\52\2\0\6\52\1\0\3\52\1\u0141\21\52\1\0"+
    "\11\52\1\0\13\52\1\u0142\13\52\1\u0141\7\52\1\u0142"+
    "\5\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\25\52\1\0\11\52\1\0\10\52\1\u0143\20\52\1\u0143"+
    "\13\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\17\52\1\u0144\5\52\1\0\7\52\1\u0145\1\52\1\0"+
    "\6\52\1\u0144\11\52\1\u0145\24\52\1\0\1\52\1\0"+
    "\2\52\2\0\2\52\1\u0146\3\52\1\0\25\52\1\0"+
    "\11\52\1\0\11\52\1\u012b\1\u0147\15\52\1\u0146\3\52"+
    "\1\u012b\1\u0147\7\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\3\52\1\u0148\21\52\1\0\11\52\1\0"+
    "\27\52\1\u0148\15\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\17\52\1\u0149\5\52\1\0\11\52\1\0"+
    "\6\52\1\u0149\36\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\25\52\1\0\11\52\1\0\14\52\2\u014a"+
    "\27\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\25\52\1\0\11\52\1\0\10\52\1\u014b\20\52\1\u014b"+
    "\13\52\1\0\1\52\1\0\2\52\2\0\3\52\1\u014c"+
    "\2\52\1\0\25\52\1\0\6\52\1\u014c\2\52\1\0"+
    "\45\52\1\0\1\52\1\0\2\52\2\0\2\52\1\u014d"+
    "\3\52\1\0\25\52\1\0\11\52\1\0\30\52\1\u014d"+
    "\14\52\1\0\1\52\1\0\2\52\2\0\5\52\1\u014e"+
    "\1\0\17\52\1\u014f\5\52\1\0\11\52\1\0\1\52"+
    "\1\u014e\4\52\1\u014f\36\52\1\0\1\52\1\0\2\52"+
    "\2\0\4\52\1\u0150\1\52\1\0\25\52\1\0\11\52"+
    "\1\0\2\52\1\u0150\42\52\1\0\1\52\1\0\2\52"+
    "\2\0\6\52\1\0\3\52\1\315\21\52\1\0\11\52"+
    "\1\0\27\52\1\315\15\52\1\0\1\52\1\0\2\52"+
    "\2\0\6\52\1\0\25\52\1\0\11\52\1\0\16\52"+
    "\1\u0151\17\52\1\u0151\6\52\1\0\1\52\1\0\2\52"+
    "\2\0\6\52\1\0\25\52\1\0\11\52\1\0\16\52"+
    "\1\u0152\17\52\1\u0152\6\52\1\0\1\52\1\0\2\52"+
    "\2\0\5\52\1\u0153\1\0\25\52\1\0\11\52\1\0"+
    "\1\52\1\u0153\43\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\25\52\1\0\11\52\1\0\26\52\1\u0126"+
    "\16\52\1\0\1\52\1\0\2\52\2\0\5\52\1\u0154"+
    "\1\0\25\52\1\0\11\52\1\0\1\52\1\u0154\43\52"+
    "\1\0\1\52\1\0\2\52\2\0\1\u0147\5\52\1\0"+
    "\25\52\1\0\11\52\1\0\3\52\1\u0147\41\52\1\0"+
    "\1\52\1\0\2\52\2\0\6\52\1\0\25\52\1\0"+
    "\11\52\1\0\23\52\1\76\14\52\1\76\4\52\1\0"+
    "\1\52\1\0\2\52\2\0\1\u0155\5\52\1\0\3\52"+
    "\1\315\11\52\1\231\1\u0156\1\u0157\5\52\1\0\11\52"+
    "\1\0\3\52\1\u0155\1\u0156\1\231\1\u0157\20\52\1\315"+
    "\15\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\15\52\1\u0158\7\52\1\0\11\52\1\0\5\52\1\u0158"+
    "\37\52\1\0\1\52\1\0\2\52\2\0\5\52\1\u0159"+
    "\1\0\25\52\1\0\11\52\1\0\1\52\1\u0159\10\52"+
    "\1\u015a\22\52\1\u015a\7\52\1\0\1\52\1\0\2\52"+
    "\2\0\2\52\1\u015b\1\52\1\76\1\52\1\0\25\52"+
    "\1\0\11\52\1\0\2\52\1\76\25\52\1\u015b\14\52"+
    "\1\0\1\52\1\0\2\52\2\0\2\52\1\76\3\52"+
    "\1\0\25\52\1\0\11\52\1\0\10\52\1\u015c\12\52"+
    "\1\76\4\52\1\76\1\u015c\6\52\1\76\4\52\1\0"+
    "\1\52\1\0\2\52\2\0\6\52\1\0\25\52\1\0"+
    "\11\52\1\0\12\52\1\76\22\52\1\76\7\52\1\0"+
    "\1\52\1\0\2\52\2\0\5\52\1\u015d\1\0\15\52"+
    "\1\76\7\52\1\0\11\52\1\0\1\52\1\u015d\3\52"+
    "\1\76\37\52\1\0\1\52\1\0\2\52\2\0\5\52"+
    "\1\u015e\1\0\25\52\1\0\11\52\1\0\1\52\1\u015e"+
    "\43\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\25\52\1\0\11\52\1\0\16\52\1\76\17\52\1\76"+
    "\6\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\25\52\1\0\11\52\1\0\13\52\1\u015f\23\52\1\u015f"+
    "\5\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\25\52\1\0\11\52\1\0\16\52\1\u0160\17\52\1\u0160"+
    "\6\52\1\0\1\52\1\0\2\52\2\0\2\52\1\76"+
    "\3\52\1\0\25\52\1\0\11\52\1\0\30\52\1\76"+
    "\12\52\11\0\1\u0161\51\0\1\u0161\37\0\10\321\1\u0162"+
    "\17\321\1\323\74\321\1\0\120\321\33\0\1\u0163\67\0"+
    "\1\110\10\0\6\110\1\0\5\110\1\u0164\1\0\4\110"+
    "\1\0\4\110\14\0\2\110\2\0\44\110\10\0\6\117"+
    "\1\0\6\117\1\0\1\110\1\326\2\117\1\0\4\117"+
    "\14\0\2\117\2\0\4\117\1\u0165\36\117\17\0\1\126"+
    "\25\0\1\50\55\0\1\331\10\0\6\331\1\0\6\331"+
    "\1\0\4\331\1\0\4\331\14\0\2\331\2\0\44\331"+
    "\10\0\6\331\1\0\1\331\2\u0166\1\331\1\u0166\1\331"+
    "\1\0\4\331\1\0\4\331\1\u0167\3\0\1\u0167\7\0"+
    "\2\331\2\0\25\331\1\u0166\16\331\10\0\6\331\1\0"+
    "\1\331\2\335\1\331\1\335\1\331\1\0\4\331\1\0"+
    "\2\331\1\333\1\334\14\0\2\331\2\0\4\331\1\333"+
    "\1\331\1\334\7\331\1\333\6\331\1\335\10\331\1\333"+
    "\5\331\10\0\6\331\1\0\1\331\2\336\1\331\1\336"+
    "\1\331\1\0\4\331\1\0\2\331\1\333\1\334\1\0"+
    "\1\335\12\0\2\331\2\0\4\331\1\333\1\331\1\334"+
    "\7\331\1\333\6\331\1\336\10\331\1\333\5\331\10\0"+
    "\6\331\1\0\1\331\1\336\1\337\1\331\1\337\1\331"+
    "\1\0\4\331\1\0\1\331\1\u0168\1\333\1\334\1\0"+
    "\1\335\12\0\2\331\2\0\4\331\1\333\1\u0168\1\334"+
    "\7\331\1\333\6\331\1\337\10\331\1\333\5\331\10\0"+
    "\1\331\1\u0169\4\331\1\0\1\331\4\u0169\1\331\1\0"+
    "\4\331\1\0\2\331\2\u0169\14\0\2\331\2\0\4\331"+
    "\1\u0169\1\331\1\u0169\1\331\1\u0169\5\331\1\u0169\6\331"+
    "\1\u0169\1\331\1\u0169\1\331\1\u0169\1\331\1\u0169\2\331"+
    "\1\u0169\4\331\1\110\10\0\6\117\1\0\6\117\1\0"+
    "\1\110\1\326\2\117\1\0\4\117\14\0\2\117\2\0"+
    "\6\117\1\u016a\34\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\2\117\1\u016b\1\117"+
    "\14\0\2\117\2\0\12\117\1\u016c\30\117\1\110\10\0"+
    "\6\117\1\0\6\117\1\0\1\110\1\326\2\117\1\0"+
    "\4\117\14\0\2\117\2\0\2\117\1\u016d\40\117\1\110"+
    "\10\0\6\117\1\0\6\117\1\0\1\110\1\326\2\117"+
    "\1\0\4\117\14\0\2\117\2\0\1\117\1\u016e\1\117"+
    "\1\u016f\37\117\1\110\10\0\6\117\1\0\6\117\1\0"+
    "\1\110\1\326\2\117\1\0\4\117\14\0\2\117\2\0"+
    "\1\117\1\u0170\41\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\1\u0171"+
    "\1\117\2\0\30\117\1\u0172\12\117\1\110\10\0\6\117"+
    "\1\0\5\117\1\u0173\1\0\1\110\1\326\2\117\1\0"+
    "\4\117\14\0\2\117\2\0\31\117\1\u0174\5\117\1\343"+
    "\3\117\1\110\10\0\6\117\1\0\6\117\1\0\1\110"+
    "\1\326\2\117\1\0\4\117\14\0\2\117\2\0\2\117"+
    "\1\u0175\40\117\1\110\10\0\6\117\1\0\6\117\1\0"+
    "\1\110\1\326\2\117\1\0\4\117\14\0\2\117\2\0"+
    "\27\117\1\u0176\13\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\1\u0177"+
    "\1\117\2\0\34\117\1\u0178\6\117\1\110\10\0\6\117"+
    "\1\0\6\117\1\0\1\110\1\326\2\117\1\0\4\117"+
    "\14\0\2\117\2\0\30\117\1\u0179\2\117\1\u017a\7\117"+
    "\1\110\10\0\6\117\1\0\6\117\1\0\1\110\1\326"+
    "\2\117\1\0\4\117\14\0\2\117\2\0\2\117\1\u017b"+
    "\40\117\1\110\10\0\6\117\1\0\6\117\1\0\1\110"+
    "\1\326\2\117\1\0\4\117\14\0\2\117\2\0\34\117"+
    "\1\u017c\6\117\1\110\10\0\6\117\1\0\6\117\1\0"+
    "\1\110\1\326\2\117\1\0\4\117\14\0\2\117\2\0"+
    "\31\117\1\u017d\11\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\1\u017e"+
    "\1\117\2\0\43\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\2\117"+
    "\2\0\35\117\1\u017f\5\117\1\110\10\0\6\117\1\0"+
    "\6\117\1\0\1\110\1\326\2\117\1\0\4\117\14\0"+
    "\2\117\2\0\35\117\1\u0180\5\117\1\110\10\0\6\117"+
    "\1\0\6\117\1\0\1\110\1\326\2\117\1\0\4\117"+
    "\14\0\2\117\2\0\35\117\1\u0181\5\117\1\110\10\0"+
    "\6\117\1\0\6\117\1\0\1\110\1\326\2\117\1\0"+
    "\4\117\14\0\2\117\2\0\34\117\1\u0182\6\117\1\110"+
    "\10\0\6\117\1\0\6\117\1\0\1\110\1\326\2\117"+
    "\1\0\4\117\14\0\2\117\2\0\5\117\1\u0183\35\117"+
    "\1\110\10\0\6\117\1\0\6\117\1\0\1\110\1\326"+
    "\2\117\1\0\4\117\14\0\2\117\2\0\30\117\1\343"+
    "\12\117\1\110\10\0\6\117\1\0\6\117\1\0\1\110"+
    "\1\326\2\117\1\0\4\117\14\0\2\117\2\0\35\117"+
    "\1\u0184\5\117\1\110\10\0\6\117\1\0\6\117\1\0"+
    "\1\110\1\326\2\117\1\0\4\117\14\0\2\117\2\0"+
    "\33\117\1\u0185\7\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\2\117"+
    "\2\0\3\117\1\u0186\37\117\1\110\10\0\6\117\1\0"+
    "\5\117\1\u0187\1\0\1\110\1\326\2\117\1\0\4\117"+
    "\14\0\2\117\2\0\43\117\1\110\10\0\6\117\1\0"+
    "\6\117\1\0\1\110\1\326\2\117\1\0\4\117\14\0"+
    "\2\117\2\0\31\117\1\u0188\11\117\1\110\10\0\6\117"+
    "\1\0\6\117\1\0\1\110\1\326\2\117\1\0\4\117"+
    "\14\0\2\117\2\0\1\117\1\u0189\1\u018a\40\117\1\110"+
    "\10\0\6\117\1\0\6\117\1\0\1\110\1\326\2\117"+
    "\1\0\4\117\14\0\2\117\2\0\1\117\1\u018b\41\117"+
    "\1\110\10\0\6\117\1\0\6\117\1\0\1\110\1\326"+
    "\2\117\1\0\4\117\14\0\1\u018c\1\117\2\0\43\117"+
    "\1\110\10\0\6\117\1\0\6\117\1\0\1\110\1\326"+
    "\2\117\1\0\4\117\14\0\2\117\2\0\12\117\1\343"+
    "\30\117\1\110\10\0\6\117\1\0\6\117\1\0\1\110"+
    "\1\326\2\117\1\0\4\117\14\0\2\117\2\0\6\117"+
    "\1\u018d\34\117\1\110\10\0\6\117\1\0\6\117\1\0"+
    "\1\110\1\326\2\117\1\0\4\117\14\0\2\117\2\0"+
    "\34\117\1\u018e\6\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\2\117"+
    "\2\0\1\117\1\u018f\41\117\1\110\10\0\6\117\1\0"+
    "\6\117\1\0\1\110\1\326\2\117\1\0\4\117\14\0"+
    "\2\117\2\0\1\117\1\u0190\41\117\1\110\10\0\6\117"+
    "\1\0\6\117\1\0\1\110\1\326\2\117\1\0\4\117"+
    "\14\0\2\117\2\0\3\117\1\u0191\37\117\1\110\10\0"+
    "\6\117\1\0\6\117\1\0\1\110\1\326\2\117\1\0"+
    "\4\117\14\0\2\117\2\0\31\117\1\u0192\11\117\1\110"+
    "\10\0\6\117\1\0\6\117\1\0\1\110\1\326\2\117"+
    "\1\0\4\117\14\0\2\117\2\0\31\117\1\u0193\11\117"+
    "\1\110\10\0\6\117\1\0\6\117\1\0\1\110\1\326"+
    "\2\117\1\0\4\117\14\0\2\117\2\0\1\117\1\u0194"+
    "\1\117\1\u0186\37\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\2\117"+
    "\2\0\35\117\1\u0195\5\117\1\110\10\0\6\117\1\0"+
    "\6\117\1\0\1\110\1\326\2\117\1\0\4\117\14\0"+
    "\2\117\2\0\5\117\1\u0196\35\117\1\110\10\0\6\117"+
    "\1\0\6\117\1\0\1\110\1\326\2\117\1\0\4\117"+
    "\14\0\2\117\2\0\7\117\1\343\33\117\1\110\10\0"+
    "\6\117\1\0\6\117\1\0\1\110\1\326\2\117\1\0"+
    "\4\117\14\0\2\117\2\0\1\117\1\u0197\41\117\1\110"+
    "\10\0\6\117\1\0\6\117\1\0\1\110\1\326\2\117"+
    "\1\0\4\117\14\0\2\117\2\0\4\117\1\u0198\1\u0199"+
    "\21\117\1\u019a\13\117\1\110\10\0\6\117\1\0\5\117"+
    "\1\u019b\1\0\1\110\1\326\2\117\1\0\4\117\14\0"+
    "\2\117\2\0\43\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\1\u019c"+
    "\1\117\2\0\5\117\1\u019d\35\117\12\0\1\u019e\6\0"+
    "\4\u019e\11\0\2\u019e\24\0\1\u019e\1\0\1\u019e\1\0"+
    "\1\u019e\5\0\1\u019e\6\0\1\u019e\1\0\1\u019e\1\0"+
    "\1\u019e\1\0\1\u019e\2\0\1\u019e\16\0\1\u019f\6\0"+
    "\4\u019f\11\0\2\u019f\24\0\1\u019f\1\0\1\u019f\1\0"+
    "\1\u019f\5\0\1\u019f\6\0\1\u019f\1\0\1\u019f\1\0"+
    "\1\u019f\1\0\1\u019f\2\0\1\u019f\15\0\1\u01a0\51\0"+
    "\1\u01a0\120\0\1\u01a1\126\0\1\u01a2\117\0\1\u01a3\127\0"+
    "\1\u01a4\44\0\1\u01a5\51\0\1\u01a5\50\0\2\201\1\u01a6"+
    "\3\201\1\0\6\201\6\0\4\201\14\0\2\201\2\0"+
    "\30\201\1\u01a6\12\201\40\0\1\u01a7\144\0\1\u01a8\126\0"+
    "\1\u011f\106\0\1\u01a9\111\0\1\u01aa\61\0\2\52\1\0"+
    "\1\52\1\0\2\52\2\0\3\52\1\u01ab\2\52\1\0"+
    "\25\52\1\0\6\52\1\u01ab\2\52\1\0\45\52\1\0"+
    "\1\52\1\0\2\52\2\0\1\52\1\u0142\4\52\1\0"+
    "\25\52\1\0\11\52\1\0\12\52\1\76\20\52\1\u0142"+
    "\1\52\1\76\7\52\1\0\1\52\1\0\2\52\2\0"+
    "\3\52\1\u01ac\2\52\1\0\25\52\1\0\6\52\1\u01ac"+
    "\2\52\1\0\11\52\1\u01ad\22\52\1\u01ad\10\52\1\0"+
    "\1\52\1\0\2\52\2\0\5\52\1\u01ae\1\0\25\52"+
    "\1\0\11\52\1\0\1\52\1\u01ae\43\52\1\0\1\52"+
    "\1\0\2\52\2\0\6\52\1\0\25\52\1\0\11\52"+
    "\1\0\23\52\1\u0142\14\52\1\u0142\4\52\1\0\1\52"+
    "\1\0\2\52\2\0\6\52\1\0\17\52\1\u01af\5\52"+
    "\1\0\11\52\1\0\6\52\1\u01af\36\52\1\0\1\52"+
    "\1\0\2\52\2\0\4\52\1\76\1\52\1\0\25\52"+
    "\1\0\11\52\1\0\2\52\1\76\42\52\1\0\1\52"+
    "\1\0\2\52\2\0\2\52\1\u01b0\3\52\1\0\25\52"+
    "\1\0\11\52\1\0\30\52\1\u01b0\14\52\1\0\1\52"+
    "\1\0\2\52\2\0\6\52\1\0\15\52\1\u014a\7\52"+
    "\1\0\11\52\1\0\5\52\1\u014a\37\52\1\0\1\52"+
    "\1\0\2\52\2\0\6\52\1\0\17\52\1\76\5\52"+
    "\1\0\11\52\1\0\6\52\1\76\36\52\1\0\1\52"+
    "\1\0\2\52\2\0\5\52\1\u0142\1\0\25\52\1\0"+
    "\11\52\1\0\1\52\1\u0142\43\52\1\0\1\52\1\0"+
    "\2\52\2\0\6\52\1\0\25\52\1\0\11\52\1\0"+
    "\23\52\1\u01b1\14\52\1\u01b1\4\52\1\0\1\52\1\0"+
    "\2\52\2\0\6\52\1\0\25\52\1\0\7\52\1\u01b2"+
    "\1\52\1\0\20\52\1\u01b2\24\52\1\0\1\52\1\0"+
    "\2\52\2\0\6\52\1\0\25\52\1\0\11\52\1\0"+
    "\14\52\2\u01b3\27\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\25\52\1\0\11\52\1\0\12\52\1\u01b4"+
    "\22\52\1\u01b4\7\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\25\52\1\0\11\52\1\0\13\52\1\u0142"+
    "\23\52\1\u0142\5\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\25\52\1\0\11\52\1\0\10\52\1\u01b5"+
    "\20\52\1\u01b5\13\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\5\52\1\u0147\17\52\1\0\11\52\1\0"+
    "\17\52\1\u0147\25\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\25\52\1\0\7\52\1\u0152\1\52\1\0"+
    "\20\52\1\u0152\24\52\1\0\1\52\1\0\2\52\2\0"+
    "\3\52\1\u01b6\2\52\1\0\25\52\1\0\6\52\1\u01b6"+
    "\2\52\1\0\45\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\25\52\1\0\11\52\1\0\10\52\1\u0146"+
    "\20\52\1\u0146\13\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\25\52\1\0\11\52\1\0\11\52\1\u0147"+
    "\22\52\1\u0147\10\52\1\0\1\52\1\0\2\52\2\0"+
    "\5\52\1\u01b7\1\0\25\52\1\0\11\52\1\0\1\52"+
    "\1\u01b7\43\52\1\0\1\52\1\0\2\52\2\0\6\52"+
    "\1\0\25\52\1\0\11\52\1\0\10\52\1\312\20\52"+
    "\1\312\13\52\1\0\1\52\1\0\2\52\2\0\5\52"+
    "\1\u01b8\1\0\25\52\1\0\11\52\1\0\1\52\1\u01b8"+
    "\43\52\1\0\1\52\1\0\2\52\2\0\1\52\1\u01b9"+
    "\4\52\1\0\25\52\1\0\11\52\1\0\33\52\1\u01b9"+
    "\11\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\25\52\1\0\11\52\1\0\11\52\1\u01ba\22\52\1\u01ba"+
    "\10\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\17\52\1\u01bb\5\52\1\0\11\52\1\0\6\52\1\u01bb"+
    "\36\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\25\52\1\0\11\52\1\0\13\52\1\76\23\52\1\76"+
    "\5\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\25\52\1\0\11\52\1\0\21\52\1\76\10\52\1\76"+
    "\12\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\17\52\1\u01bc\5\52\1\0\11\52\1\0\6\52\1\u01bc"+
    "\36\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\17\52\1\u014a\5\52\1\0\11\52\1\0\6\52\1\u014a"+
    "\36\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\17\52\1\315\5\52\1\0\11\52\1\0\6\52\1\315"+
    "\36\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\25\52\1\0\11\52\1\0\14\52\2\u01bd\27\52\1\0"+
    "\1\52\1\0\2\52\2\0\6\52\1\0\15\52\1\u01be"+
    "\7\52\1\0\11\52\1\0\5\52\1\u01be\37\52\1\0"+
    "\1\52\1\0\2\52\2\0\6\52\1\0\5\52\1\u01bf"+
    "\17\52\1\0\11\52\1\0\17\52\1\u01bf\25\52\1\0"+
    "\1\52\1\0\2\52\2\0\6\52\1\0\25\52\1\0"+
    "\11\52\1\0\14\52\2\76\27\52\1\0\1\52\1\0"+
    "\2\52\2\0\5\52\1\76\1\0\25\52\1\0\11\52"+
    "\1\0\1\52\1\76\43\52\1\0\1\52\1\0\2\52"+
    "\2\0\6\52\1\0\17\52\1\312\5\52\1\0\11\52"+
    "\1\0\6\52\1\312\36\52\1\0\1\52\1\0\2\52"+
    "\2\0\6\52\1\0\25\52\1\0\11\52\1\0\12\52"+
    "\1\u01c0\22\52\1\u01c0\7\52\1\0\1\52\1\0\2\52"+
    "\2\0\6\52\1\0\25\52\1\0\11\52\1\0\16\52"+
    "\1\u01c1\17\52\1\u01c1\6\52\1\0\1\52\1\0\2\52"+
    "\2\0\6\52\1\0\25\52\1\0\11\52\1\0\16\52"+
    "\1\u012a\17\52\1\u012a\6\52\1\0\1\52\1\0\2\52"+
    "\2\0\6\52\1\0\25\52\1\0\11\52\1\0\11\52"+
    "\1\u01c2\22\52\1\u01c2\10\52\1\0\1\52\1\0\2\52"+
    "\2\0\3\52\1\u01c3\2\52\1\0\25\52\1\0\6\52"+
    "\1\u01c3\2\52\1\0\45\52\1\0\1\52\1\0\2\52"+
    "\2\0\6\52\1\0\25\52\1\0\11\52\1\0\10\52"+
    "\1\76\20\52\1\76\13\52\1\0\1\52\1\0\2\52"+
    "\2\0\6\52\1\0\15\52\1\u01c4\7\52\1\0\11\52"+
    "\1\0\5\52\1\u01c4\37\52\1\0\1\52\1\0\2\52"+
    "\2\0\3\52\1\253\2\52\1\0\25\52\1\0\6\52"+
    "\1\253\2\52\1\0\45\52\1\0\1\52\1\0\2\52"+
    "\2\0\2\52\1\u01c5\3\52\1\0\25\52\1\0\11\52"+
    "\1\0\30\52\1\u01c5\14\52\1\0\1\52\1\0\2\52"+
    "\2\0\3\52\1\u01b8\2\52\1\0\25\52\1\0\6\52"+
    "\1\u01b8\1\u01b2\1\52\1\0\20\52\1\u01b2\24\52\1\0"+
    "\1\52\1\0\2\52\2\0\4\52\1\u0132\1\52\1\0"+
    "\25\52\1\0\11\52\1\0\2\52\1\u0132\42\52\1\0"+
    "\1\52\1\0\2\52\2\0\1\52\1\213\4\52\1\0"+
    "\25\52\1\0\11\52\1\0\33\52\1\213\11\52\1\0"+
    "\1\52\1\0\2\52\2\0\2\52\1\u01c6\3\52\1\0"+
    "\25\52\1\0\11\52\1\0\30\52\1\u01c6\14\52\1\0"+
    "\1\52\1\0\2\52\2\0\6\52\1\0\25\52\1\0"+
    "\11\52\1\0\14\52\2\u01c7\27\52\1\0\1\52\1\0"+
    "\2\52\2\0\5\52\1\u01c8\1\0\25\52\1\0\11\52"+
    "\1\0\1\52\1\u01c8\43\52\1\0\1\52\1\0\2\52"+
    "\2\0\6\52\1\0\17\52\1\315\5\52\1\0\11\52"+
    "\1\0\6\52\1\315\1\52\1\76\20\52\1\76\13\52"+
    "\1\0\1\52\1\0\2\52\2\0\6\52\1\0\5\52"+
    "\1\76\17\52\1\0\11\52\1\0\17\52\1\76\25\52"+
    "\1\0\1\52\1\0\2\52\2\0\6\52\1\0\25\52"+
    "\1\0\11\52\1\0\21\52\1\76\1\u01c9\7\52\1\76"+
    "\12\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\15\52\1\u01ca\7\52\1\0\11\52\1\0\5\52\1\u01ca"+
    "\37\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\25\52\1\0\11\52\1\0\10\52\1\u01cb\20\52\1\u01cb"+
    "\13\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\25\52\1\0\11\52\1\0\10\52\1\u01cc\20\52\1\u01cc"+
    "\13\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\25\52\1\0\7\52\1\u01cd\1\52\1\0\20\52\1\u01cd"+
    "\24\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\17\52\1\253\5\52\1\0\11\52\1\0\6\52\1\253"+
    "\34\52\12\0\1\u01ce\100\0\1\u01ce\63\0\2\u0162\17\0"+
    "\1\u0162\35\0\1\u01cf\112\0\1\110\10\0\1\110\1\u01d0"+
    "\4\110\1\0\1\110\4\u01d0\1\110\1\0\4\110\1\0"+
    "\2\110\2\u01d0\14\0\2\110\2\0\4\110\1\u01d0\1\110"+
    "\1\u01d0\1\110\1\u01d0\5\110\1\u01d0\6\110\1\u01d0\1\110"+
    "\1\u01d0\1\110\1\u01d0\1\110\1\u01d0\2\110\1\u01d0\5\110"+
    "\10\0\6\117\1\0\6\117\1\0\1\110\1\326\2\117"+
    "\1\0\4\117\14\0\1\u01d1\1\117\2\0\43\117\1\331"+
    "\10\0\6\331\1\0\1\331\2\u0166\1\331\1\u0166\1\331"+
    "\1\0\4\331\1\0\2\331\1\333\1\331\14\0\2\331"+
    "\2\0\4\331\1\333\11\331\1\333\6\331\1\u0166\10\331"+
    "\1\333\4\331\21\0\2\u0166\1\0\1\u0166\60\0\1\u0166"+
    "\15\0\1\331\10\0\1\331\1\u0169\4\331\1\0\1\331"+
    "\4\u0169\1\331\1\0\4\331\1\0\1\331\1\u0168\2\u0169"+
    "\14\0\2\331\2\0\4\331\1\u0169\1\u0168\1\u0169\1\331"+
    "\1\u0169\5\331\1\u0169\6\331\1\u0169\1\331\1\u0169\1\331"+
    "\1\u0169\1\331\1\u0169\2\331\1\u0169\4\331\1\110\10\0"+
    "\6\117\1\0\6\117\1\0\1\110\1\326\2\117\1\0"+
    "\4\117\14\0\2\117\2\0\3\117\1\370\37\117\1\110"+
    "\10\0\6\117\1\0\6\117\1\0\1\110\1\326\2\117"+
    "\1\0\4\117\14\0\1\u01d2\1\117\2\0\43\117\1\110"+
    "\10\0\6\117\1\0\6\117\1\0\1\110\1\326\2\117"+
    "\1\0\4\117\14\0\2\117\2\0\31\117\1\u01d3\11\117"+
    "\1\110\10\0\6\117\1\0\6\117\1\0\1\110\1\326"+
    "\2\117\1\0\4\117\14\0\2\117\2\0\5\117\1\u01d4"+
    "\26\117\1\u01d5\6\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\2\117"+
    "\2\0\6\117\1\u01d6\34\117\1\110\10\0\6\117\1\0"+
    "\6\117\1\0\1\110\1\326\2\117\1\0\4\117\14\0"+
    "\2\117\2\0\1\117\1\u01d7\41\117\1\110\10\0\6\117"+
    "\1\0\6\117\1\0\1\110\1\326\2\117\1\0\4\117"+
    "\14\0\2\117\2\0\34\117\1\343\6\117\1\110\10\0"+
    "\6\117\1\0\6\117\1\0\1\110\1\326\2\117\1\0"+
    "\4\117\14\0\2\117\2\0\3\117\1\343\37\117\1\110"+
    "\10\0\6\117\1\0\6\117\1\0\1\110\1\326\2\117"+
    "\1\0\4\117\14\0\2\117\2\0\34\117\1\u01d8\6\117"+
    "\1\110\10\0\6\117\1\0\6\117\1\0\1\110\1\326"+
    "\2\117\1\0\4\117\14\0\2\117\2\0\6\117\1\u01d9"+
    "\34\117\1\110\10\0\6\117\1\0\6\117\1\0\1\110"+
    "\1\326\2\117\1\0\4\117\14\0\2\117\2\0\35\117"+
    "\1\u01da\5\117\1\110\10\0\6\117\1\0\6\117\1\0"+
    "\1\110\1\326\2\117\1\0\4\117\14\0\2\117\2\0"+
    "\6\117\1\u01db\34\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\2\117"+
    "\2\0\5\117\1\u01dc\35\117\1\110\10\0\6\117\1\0"+
    "\6\117\1\0\1\110\1\326\2\117\1\0\4\117\14\0"+
    "\2\117\2\0\40\117\1\u01dd\2\117\1\110\10\0\6\117"+
    "\1\0\6\117\1\0\1\110\1\326\2\117\1\0\4\117"+
    "\14\0\2\117\2\0\1\117\1\u01de\41\117\1\110\10\0"+
    "\6\117\1\0\6\117\1\0\1\110\1\326\2\117\1\0"+
    "\4\117\14\0\2\117\2\0\3\117\1\u01df\37\117\1\110"+
    "\10\0\6\117\1\0\6\117\1\0\1\110\1\326\2\117"+
    "\1\0\4\117\14\0\2\117\2\0\32\117\1\u01e0\10\117"+
    "\1\110\10\0\6\117\1\0\6\117\1\0\1\110\1\326"+
    "\2\117\1\0\4\117\14\0\2\117\2\0\6\117\1\366"+
    "\34\117\1\110\10\0\6\117\1\0\6\117\1\0\1\110"+
    "\1\326\2\117\1\0\4\117\14\0\2\117\2\0\30\117"+
    "\1\u01e1\12\117\1\110\10\0\6\117\1\0\6\117\1\0"+
    "\1\110\1\326\2\117\1\0\4\117\14\0\2\117\2\0"+
    "\1\117\1\u01dc\41\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\2\117"+
    "\2\0\1\117\1\u0194\41\117\1\110\10\0\6\117\1\0"+
    "\6\117\1\0\1\110\1\326\2\117\1\0\4\117\14\0"+
    "\2\117\2\0\33\117\1\u01e2\7\117\1\110\10\0\6\117"+
    "\1\0\6\117\1\0\1\110\1\326\2\117\1\0\4\117"+
    "\14\0\2\117\2\0\33\117\1\u01e3\7\117\1\110\10\0"+
    "\6\117\1\0\6\117\1\0\1\110\1\326\2\117\1\0"+
    "\4\117\14\0\2\117\2\0\31\117\1\u01e4\11\117\1\110"+
    "\10\0\6\117\1\0\6\117\1\0\1\110\1\326\2\117"+
    "\1\0\4\117\14\0\2\117\2\0\31\117\1\u01e1\11\117"+
    "\1\110\10\0\6\117\1\0\6\117\1\0\1\110\1\326"+
    "\2\117\1\0\4\117\14\0\2\117\2\0\3\117\1\u0173"+
    "\37\117\1\110\10\0\6\117\1\0\6\117\1\0\1\110"+
    "\1\326\2\117\1\0\4\117\14\0\1\117\1\u01e5\2\0"+
    "\43\117\1\110\10\0\6\117\1\0\6\117\1\0\1\110"+
    "\1\326\2\117\1\0\4\117\14\0\2\117\2\0\31\117"+
    "\1\u01e6\11\117\1\110\10\0\6\117\1\0\6\117\1\0"+
    "\1\110\1\326\2\117\1\0\4\117\14\0\2\117\2\0"+
    "\6\117\1\343\34\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\2\117"+
    "\2\0\15\117\1\343\25\117\1\110\10\0\6\117\1\0"+
    "\6\117\1\0\1\110\1\326\2\117\1\0\4\117\14\0"+
    "\2\117\2\0\5\117\1\u01e7\35\117\1\110\10\0\6\117"+
    "\1\0\6\117\1\0\1\110\1\326\2\117\1\0\4\117"+
    "\14\0\2\117\2\0\6\117\1\u01e8\34\117\1\110\10\0"+
    "\6\117\1\0\6\117\1\0\1\110\1\326\2\117\1\0"+
    "\4\117\14\0\2\117\2\0\34\117\1\u01d5\6\117\1\110"+
    "\10\0\6\117\1\0\6\117\1\0\1\110\1\326\2\117"+
    "\1\0\4\117\14\0\2\117\2\0\1\343\42\117\1\110"+
    "\10\0\6\117\1\0\6\117\1\0\1\110\1\326\2\117"+
    "\1\0\4\117\14\0\2\117\2\0\5\117\1\u0186\35\117"+
    "\1\110\10\0\6\117\1\0\6\117\1\0\1\110\1\326"+
    "\2\117\1\0\4\117\14\0\2\117\2\0\31\117\1\u01e9"+
    "\11\117\1\110\10\0\6\117\1\0\6\117\1\0\1\110"+
    "\1\326\2\117\1\0\4\117\14\0\2\117\2\0\5\117"+
    "\1\u01ea\35\117\1\110\10\0\6\117\1\0\6\117\1\0"+
    "\1\110\1\326\2\117\1\0\4\117\14\0\2\117\2\0"+
    "\6\117\1\u01e5\34\117\1\110\10\0\6\117\1\0\5\117"+
    "\1\u01eb\1\0\1\110\1\326\2\117\1\0\4\117\14\0"+
    "\2\117\2\0\43\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\2\117"+
    "\2\0\1\117\1\u01ec\41\117\1\110\10\0\6\117\1\0"+
    "\6\117\1\0\1\110\1\326\2\117\1\0\4\117\14\0"+
    "\2\117\2\0\30\117\1\u01e5\12\117\1\110\10\0\6\117"+
    "\1\0\6\117\1\0\1\110\1\326\2\117\1\0\4\117"+
    "\14\0\2\117\2\0\3\117\1\u0171\37\117\1\110\10\0"+
    "\6\117\1\0\6\117\1\0\1\110\1\326\2\117\1\0"+
    "\4\117\14\0\2\117\2\0\33\117\1\u018b\7\117\1\110"+
    "\10\0\6\117\1\0\6\117\1\0\1\110\1\326\2\117"+
    "\1\0\4\117\14\0\2\117\2\0\1\117\1\u01ed\1\117"+
    "\1\u01ee\37\117\1\110\10\0\6\117\1\0\6\117\1\0"+
    "\1\110\1\326\2\117\1\0\4\117\14\0\2\117\2\0"+
    "\5\117\1\343\35\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\1\u01ef"+
    "\1\117\2\0\43\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\2\117"+
    "\2\0\31\117\1\u01f0\11\117\1\110\10\0\6\117\1\0"+
    "\6\117\1\0\1\110\1\326\2\117\1\0\4\117\14\0"+
    "\2\117\2\0\6\117\1\u01f1\34\117\1\110\10\0\6\117"+
    "\1\0\5\117\1\u01f2\1\0\1\110\1\326\2\117\1\0"+
    "\4\117\14\0\2\117\2\0\43\117\1\110\10\0\6\117"+
    "\1\0\6\117\1\0\1\110\1\326\2\117\1\0\4\117"+
    "\14\0\2\117\2\0\27\117\1\u01f3\13\117\1\110\10\0"+
    "\6\117\1\0\6\117\1\0\1\110\1\326\2\117\1\0"+
    "\4\117\14\0\2\117\2\0\36\117\1\343\4\117\1\110"+
    "\10\0\6\117\1\0\6\117\1\0\1\110\1\326\2\117"+
    "\1\0\4\117\14\0\2\117\2\0\31\117\1\u01f4\11\117"+
    "\12\0\1\u01f5\6\0\4\u01f5\11\0\2\u01f5\24\0\1\u01f5"+
    "\1\0\1\u01f5\1\0\1\u01f5\5\0\1\u01f5\6\0\1\u01f5"+
    "\1\0\1\u01f5\1\0\1\u01f5\1\0\1\u01f5\2\0\1\u01f5"+
    "\16\0\1\u01f6\6\0\4\u01f6\11\0\2\u01f6\24\0\1\u01f6"+
    "\1\0\1\u01f6\1\0\1\u01f6\5\0\1\u01f6\6\0\1\u01f6"+
    "\1\0\1\u01f6\1\0\1\u01f6\1\0\1\u01f6\2\0\1\u01f6"+
    "\16\0\1\u01f7\100\0\1\u01f7\71\0\1\u01f8\126\0\1\u01a3"+
    "\106\0\1\u01f9\111\0\1\u01fa\73\0\1\u01fb\100\0\1\u01fb"+
    "\20\0\3\201\1\u01fc\2\201\1\0\6\201\6\0\4\201"+
    "\14\0\1\u01fc\1\201\2\0\43\201\52\0\1\u01a9\10\0"+
    "\1\u011f\47\0\1\u01fd\117\0\2\u01fe\1\0\7\u01aa\1\0"+
    "\6\u01aa\1\0\1\u01fe\1\0\1\u01fe\1\u01aa\1\u01fe\4\u01aa"+
    "\2\u01fe\1\0\3\u01fe\1\0\5\u01fe\2\u01aa\2\u01fe\43\u01aa"+
    "\2\52\1\0\1\52\1\0\2\52\2\0\4\52\1\u0147"+
    "\1\52\1\0\25\52\1\0\11\52\1\0\2\52\1\u0147"+
    "\42\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\25\52\1\0\11\52\1\0\21\52\1\u012a\10\52\1\u012a"+
    "\12\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\25\52\1\0\11\52\1\0\12\52\1\234\22\52\1\234"+
    "\7\52\1\0\1\52\1\0\2\52\2\0\3\52\1\u01b8"+
    "\2\52\1\0\25\52\1\0\6\52\1\u01b8\2\52\1\0"+
    "\45\52\1\0\1\52\1\0\2\52\2\0\1\52\1\u0147"+
    "\4\52\1\0\25\52\1\0\11\52\1\0\33\52\1\u0147"+
    "\11\52\1\0\1\52\1\0\2\52\2\0\1\52\1\u012a"+
    "\4\52\1\0\25\52\1\0\11\52\1\0\33\52\1\u012a"+
    "\11\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\25\52\1\0\11\52\1\0\10\52\1\u01ff\20\52\1\u01ff"+
    "\13\52\1\0\1\52\1\0\2\52\2\0\2\52\1\u0200"+
    "\3\52\1\0\25\52\1\0\11\52\1\0\30\52\1\u0200"+
    "\14\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\17\52\1\u0201\5\52\1\0\11\52\1\0\6\52\1\u0201"+
    "\1\52\1\u01bc\20\52\1\u01bc\13\52\1\0\1\52\1\0"+
    "\2\52\2\0\6\52\1\0\25\52\1\0\11\52\1\0"+
    "\16\52\1\u0202\17\52\1\u0202\6\52\1\0\1\52\1\0"+
    "\2\52\2\0\6\52\1\0\25\52\1\0\11\52\1\0"+
    "\14\52\2\u012a\27\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\25\52\1\0\11\52\1\0\12\52\1\u0203"+
    "\22\52\1\u0203\7\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\25\52\1\0\11\52\1\0\10\52\1\u0204"+
    "\20\52\1\u0204\13\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\25\52\1\0\11\52\1\0\11\52\1\307"+
    "\22\52\1\307\10\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\25\52\1\0\11\52\1\0\21\52\1\u0205"+
    "\10\52\1\u0205\12\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\5\52\1\u01bc\17\52\1\0\11\52\1\0"+
    "\17\52\1\u01bc\25\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\16\52\1\u0206\6\52\1\0\11\52\1\0"+
    "\4\52\1\u0206\40\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\25\52\1\0\11\52\1\0\12\52\1\312"+
    "\22\52\1\312\7\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\17\52\1\u0207\5\52\1\0\11\52\1\0"+
    "\6\52\1\u0207\36\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\25\52\1\0\11\52\1\0\16\52\1\u0208"+
    "\17\52\1\u0208\6\52\1\0\1\52\1\0\2\52\2\0"+
    "\2\52\1\u012a\3\52\1\0\25\52\1\0\11\52\1\0"+
    "\30\52\1\u012a\14\52\1\0\1\52\1\0\2\52\2\0"+
    "\5\52\1\u0209\1\0\25\52\1\0\11\52\1\0\1\52"+
    "\1\u0209\43\52\1\0\1\52\1\0\2\52\2\0\6\52"+
    "\1\0\25\52\1\0\11\52\1\0\12\52\1\u020a\22\52"+
    "\1\u020a\7\52\1\0\1\52\1\0\2\52\2\0\1\52"+
    "\1\227\4\52\1\0\25\52\1\0\11\52\1\0\33\52"+
    "\1\227\11\52\1\0\1\52\1\0\2\52\2\0\6\52"+
    "\1\0\17\52\1\u0147\5\52\1\0\11\52\1\0\6\52"+
    "\1\u0147\36\52\1\0\1\52\1\0\2\52\2\0\6\52"+
    "\1\0\17\52\1\u020b\5\52\1\0\11\52\1\0\6\52"+
    "\1\u020b\36\52\1\0\1\52\1\0\2\52\2\0\6\52"+
    "\1\0\25\52\1\0\11\52\1\0\10\52\1\u020c\20\52"+
    "\1\u020c\13\52\1\0\1\52\1\0\2\52\2\0\3\52"+
    "\1\u020d\2\52\1\0\25\52\1\0\6\52\1\u020d\2\52"+
    "\1\0\45\52\1\0\1\52\1\0\2\52\2\0\6\52"+
    "\1\0\5\52\1\u020e\17\52\1\0\11\52\1\0\17\52"+
    "\1\u020e\25\52\1\0\1\52\1\0\2\52\2\0\6\52"+
    "\1\0\25\52\1\0\11\52\1\0\11\52\1\234\22\52"+
    "\1\234\10\52\1\0\1\52\1\0\2\52\2\0\3\52"+
    "\1\u020f\2\52\1\0\25\52\1\0\6\52\1\u020f\2\52"+
    "\1\0\45\52\1\0\1\52\1\0\2\52\2\0\5\52"+
    "\1\u0210\1\0\15\52\1\u0211\7\52\1\0\7\52\1\u0212"+
    "\1\52\1\0\1\52\1\u0210\3\52\1\u0211\12\52\1\u0212"+
    "\24\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\17\52\1\307\5\52\1\0\11\52\1\0\6\52\1\307"+
    "\34\52\13\0\1\u0213\74\0\1\u0213\12\0\1\110\10\0"+
    "\1\110\1\u0214\4\110\1\0\1\110\4\u0214\1\110\1\0"+
    "\4\110\1\0\2\110\2\u0214\14\0\2\110\2\0\4\110"+
    "\1\u0214\1\110\1\u0214\1\110\1\u0214\5\110\1\u0214\6\110"+
    "\1\u0214\1\110\1\u0214\1\110\1\u0214\1\110\1\u0214\2\110"+
    "\1\u0214\5\110\10\0\6\117\1\0\6\117\1\0\1\110"+
    "\1\326\2\117\1\0\4\117\14\0\2\117\2\0\35\117"+
    "\1\u0215\5\117\1\110\10\0\6\117\1\0\6\117\1\0"+
    "\1\110\1\326\2\117\1\0\4\117\14\0\2\117\2\0"+
    "\35\117\1\u0216\5\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\2\117"+
    "\2\0\12\117\1\u01e7\30\117\1\110\10\0\6\117\1\0"+
    "\6\117\1\0\1\110\1\326\2\117\1\0\4\117\14\0"+
    "\2\117\2\0\6\117\1\u0217\34\117\1\110\10\0\6\117"+
    "\1\0\6\117\1\0\1\110\1\326\2\117\1\0\4\117"+
    "\14\0\2\117\2\0\30\117\1\u01ee\12\117\1\110\10\0"+
    "\6\117\1\0\6\117\1\0\1\110\1\326\2\117\1\0"+
    "\4\117\14\0\2\117\2\0\30\117\1\u0218\12\117\1\110"+
    "\10\0\6\117\1\0\6\117\1\0\1\110\1\326\2\117"+
    "\1\0\4\117\14\0\2\117\2\0\31\117\1\u0219\11\117"+
    "\1\110\10\0\6\117\1\0\6\117\1\0\1\110\1\326"+
    "\2\117\1\0\4\117\14\0\2\117\2\0\7\117\1\u021a"+
    "\33\117\1\110\10\0\6\117\1\0\6\117\1\0\1\110"+
    "\1\326\2\117\1\0\4\117\14\0\2\117\2\0\3\117"+
    "\1\u021b\37\117\1\110\10\0\6\117\1\0\6\117\1\0"+
    "\1\110\1\326\2\117\1\0\4\117\14\0\2\117\2\0"+
    "\34\117\1\u021c\6\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\1\u021d"+
    "\1\117\2\0\43\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\2\117"+
    "\2\0\31\117\1\u01f1\11\117\1\110\10\0\6\117\1\0"+
    "\6\117\1\0\1\110\1\326\2\117\1\0\4\117\14\0"+
    "\2\117\2\0\6\117\1\u021e\34\117\1\110\10\0\6\117"+
    "\1\0\6\117\1\0\1\110\1\326\2\117\1\0\4\117"+
    "\14\0\2\117\2\0\6\117\1\u021f\34\117\1\110\10\0"+
    "\6\117\1\0\6\117\1\0\1\110\1\326\2\117\1\0"+
    "\4\117\14\0\2\117\2\0\31\117\1\u0220\11\117\1\110"+
    "\10\0\6\117\1\0\6\117\1\0\1\110\1\326\2\117"+
    "\1\0\4\117\14\0\2\117\2\0\1\117\1\u01e5\41\117"+
    "\1\110\10\0\6\117\1\0\6\117\1\0\1\110\1\326"+
    "\2\117\1\0\4\117\14\0\2\117\2\0\1\u0221\42\117"+
    "\1\110\10\0\6\117\1\0\6\117\1\0\1\110\1\326"+
    "\2\117\1\0\4\117\14\0\2\117\2\0\1\117\1\u0222"+
    "\41\117\1\110\10\0\6\117\1\0\6\117\1\0\1\110"+
    "\1\326\2\117\1\0\4\117\14\0\2\117\2\0\5\117"+
    "\1\u0223\35\117\1\110\10\0\6\117\1\0\6\117\1\0"+
    "\1\110\1\326\2\117\1\0\4\117\14\0\2\117\2\0"+
    "\2\117\1\u0224\40\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\2\117"+
    "\2\0\35\117\1\u0225\5\117\1\110\10\0\6\117\1\0"+
    "\6\117\1\0\1\110\1\326\2\117\1\0\4\117\14\0"+
    "\2\117\2\0\32\117\1\343\10\117\1\110\10\0\6\117"+
    "\1\0\6\117\1\0\1\110\1\326\2\117\1\0\4\117"+
    "\14\0\2\117\2\0\6\117\1\u0226\34\117\1\110\10\0"+
    "\6\117\1\0\6\117\1\0\1\110\1\326\2\117\1\0"+
    "\4\117\14\0\2\117\2\0\30\117\1\u0227\12\117\1\110"+
    "\10\0\6\117\1\0\6\117\1\0\1\110\1\326\2\117"+
    "\1\0\4\117\14\0\2\117\2\0\30\117\1\u0228\12\117"+
    "\1\110\10\0\6\117\1\0\6\117\1\0\1\110\1\326"+
    "\2\117\1\0\4\117\14\0\1\u0229\1\117\2\0\43\117"+
    "\1\110\10\0\6\117\1\0\6\117\1\0\1\110\1\326"+
    "\2\117\1\0\4\117\14\0\2\117\2\0\1\117\1\343"+
    "\41\117\1\110\10\0\6\117\1\0\6\117\1\0\1\110"+
    "\1\326\2\117\1\0\4\117\14\0\2\117\2\0\40\117"+
    "\1\u0186\2\117\1\110\10\0\6\117\1\0\5\117\1\u022a"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\2\117"+
    "\2\0\43\117\1\110\10\0\6\117\1\0\6\117\1\0"+
    "\1\110\1\326\2\117\1\0\4\117\14\0\2\117\2\0"+
    "\1\117\1\u0186\41\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\1\117"+
    "\1\u022b\2\0\43\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\2\117"+
    "\2\0\5\117\1\u018f\35\117\1\110\10\0\6\117\1\0"+
    "\6\117\1\0\1\110\1\326\2\117\1\0\4\117\14\0"+
    "\2\117\2\0\1\117\1\376\41\117\13\0\1\u022c\74\0"+
    "\1\u022c\64\0\1\u01f9\10\0\1\u01a3\47\0\1\u022d\117\0"+
    "\2\u022e\1\0\7\u01fa\1\0\6\u01fa\1\0\1\u022e\1\0"+
    "\1\u022e\1\u01fa\1\u022e\4\u01fa\2\u022e\1\0\3\u022e\1\0"+
    "\5\u022e\2\u01fa\2\u022e\43\u01fa\13\0\1\u022f\74\0\1\u022f"+
    "\23\0\4\201\1\u0230\1\201\1\0\6\201\6\0\4\201"+
    "\14\0\2\201\2\0\2\201\1\u0230\40\201\10\0\1\u01aa"+
    "\112\0\2\52\1\0\1\52\1\0\2\52\2\0\1\76"+
    "\5\52\1\0\25\52\1\0\11\52\1\0\3\52\1\76"+
    "\41\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\25\52\1\0\11\52\1\0\11\52\1\u0231\22\52\1\u0231"+
    "\10\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\25\52\1\0\11\52\1\0\12\52\1\u0147\22\52\1\u0147"+
    "\7\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\17\52\1\u0232\5\52\1\0\11\52\1\0\6\52\1\u0232"+
    "\36\52\1\0\1\52\1\0\2\52\2\0\5\52\1\u0233"+
    "\1\0\25\52\1\0\11\52\1\0\1\52\1\u0233\43\52"+
    "\1\0\1\52\1\0\2\52\2\0\2\52\1\u0234\3\52"+
    "\1\0\25\52\1\0\11\52\1\0\30\52\1\u0234\14\52"+
    "\1\0\1\52\1\0\2\52\2\0\6\52\1\0\25\52"+
    "\1\0\11\52\1\0\22\52\1\u0235\22\52\1\0\1\52"+
    "\1\0\2\52\2\0\6\52\1\0\25\52\1\0\11\52"+
    "\1\0\11\52\1\u0201\22\52\1\u0201\10\52\1\0\1\52"+
    "\1\0\2\52\2\0\1\u01c4\5\52\1\0\25\52\1\0"+
    "\11\52\1\0\3\52\1\u01c4\41\52\1\0\1\52\1\0"+
    "\2\52\2\0\1\u0236\5\52\1\0\25\52\1\0\11\52"+
    "\1\0\3\52\1\u0236\41\52\1\0\1\52\1\0\2\52"+
    "\2\0\6\52\1\0\25\52\1\0\11\52\1\0\13\52"+
    "\1\u0146\23\52\1\u0146\5\52\1\0\1\52\1\0\2\52"+
    "\2\0\1\u01ff\5\52\1\0\25\52\1\0\11\52\1\0"+
    "\3\52\1\u01ff\41\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\25\52\1\0\11\52\1\0\14\52\2\u0237"+
    "\27\52\1\0\1\52\1\0\2\52\2\0\1\52\1\u0238"+
    "\4\52\1\0\25\52\1\0\11\52\1\0\33\52\1\u0238"+
    "\11\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\17\52\1\u012a\5\52\1\0\11\52\1\0\6\52\1\u012a"+
    "\36\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\15\52\1\u01ff\7\52\1\0\11\52\1\0\5\52\1\u01ff"+
    "\37\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\17\52\1\u0239\5\52\1\0\11\52\1\0\6\52\1\u0239"+
    "\36\52\1\0\1\52\1\0\2\52\2\0\3\52\1\300"+
    "\2\52\1\0\25\52\1\0\6\52\1\300\2\52\1\0"+
    "\45\52\1\0\1\52\1\0\2\52\2\0\2\52\1\u023a"+
    "\3\52\1\0\25\52\1\0\11\52\1\0\30\52\1\u023a"+
    "\12\52\14\0\1\u023b\37\0\1\u023b\46\0\1\110\10\0"+
    "\1\110\1\u023c\4\110\1\0\1\110\4\u023c\1\110\1\0"+
    "\4\110\1\0\2\110\2\u023c\14\0\2\110\2\0\4\110"+
    "\1\u023c\1\110\1\u023c\1\110\1\u023c\5\110\1\u023c\6\110"+
    "\1\u023c\1\110\1\u023c\1\110\1\u023c\1\110\1\u023c\2\110"+
    "\1\u023c\5\110\10\0\6\117\1\0\6\117\1\0\1\110"+
    "\1\326\2\117\1\0\4\117\14\0\1\u023d\1\117\2\0"+
    "\43\117\1\110\10\0\6\117\1\0\6\117\1\0\1\110"+
    "\1\326\2\117\1\0\4\117\14\0\1\u023e\1\117\2\0"+
    "\43\117\1\110\10\0\6\117\1\0\6\117\1\0\1\110"+
    "\1\326\2\117\1\0\4\117\14\0\2\117\2\0\15\117"+
    "\1\u023f\25\117\1\110\10\0\6\117\1\0\6\117\1\0"+
    "\1\110\1\326\2\117\1\0\4\117\14\0\2\117\2\0"+
    "\4\117\1\u0240\36\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\2\117"+
    "\2\0\35\117\1\u0241\5\117\1\110\10\0\6\117\1\0"+
    "\6\117\1\0\1\110\1\326\2\117\1\0\4\117\14\0"+
    "\1\u0242\1\117\2\0\43\117\1\110\10\0\6\117\1\0"+
    "\6\117\1\0\1\110\1\326\2\117\1\0\4\117\14\0"+
    "\2\117\2\0\4\117\1\343\36\117\1\110\10\0\6\117"+
    "\1\0\6\117\1\0\1\110\1\326\2\117\1\0\4\117"+
    "\14\0\2\117\2\0\33\117\1\343\7\117\1\110\10\0"+
    "\6\117\1\0\6\117\1\0\1\110\1\326\2\117\1\0"+
    "\4\117\14\0\2\117\2\0\33\117\1\u0243\7\117\1\110"+
    "\10\0\3\117\1\u0244\2\117\1\0\6\117\1\0\1\110"+
    "\1\326\2\117\1\0\2\117\1\u0245\1\117\14\0\2\117"+
    "\2\0\43\117\1\110\10\0\6\117\1\0\6\117\1\0"+
    "\1\110\1\326\2\117\1\0\4\117\14\0\1\117\1\u0186"+
    "\2\0\43\117\1\110\10\0\6\117\1\0\6\117\1\0"+
    "\1\110\1\326\2\117\1\0\4\117\14\0\2\117\2\0"+
    "\30\117\1\u0246\12\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\1\u0247"+
    "\1\117\2\0\43\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\2\117"+
    "\2\0\5\117\1\u0248\35\117\1\110\10\0\6\117\1\0"+
    "\6\117\1\0\1\110\1\326\2\117\1\0\4\117\14\0"+
    "\2\117\2\0\6\117\1\u01e7\34\117\1\110\10\0\6\117"+
    "\1\0\6\117\1\0\1\110\1\326\2\117\1\0\4\117"+
    "\14\0\2\117\2\0\36\117\1\u0171\4\117\1\110\10\0"+
    "\6\117\1\0\6\117\1\0\1\110\1\326\2\117\1\0"+
    "\4\117\14\0\2\117\2\0\31\117\1\u0249\11\117\1\110"+
    "\10\0\6\117\1\0\6\117\1\0\1\110\1\326\2\117"+
    "\1\0\4\117\14\0\2\117\2\0\35\117\1\343\5\117"+
    "\1\110\10\0\6\117\1\0\6\117\1\0\1\110\1\326"+
    "\2\117\1\0\4\117\14\0\2\117\2\0\31\117\1\u024a"+
    "\11\117\1\110\10\0\6\117\1\0\6\117\1\0\1\110"+
    "\1\326\2\117\1\0\4\117\14\0\2\117\2\0\35\117"+
    "\1\u024b\5\117\1\110\10\0\6\117\1\0\6\117\1\0"+
    "\1\110\1\326\2\117\1\0\4\117\14\0\2\117\2\0"+
    "\5\117\1\u01ee\35\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\1\117"+
    "\1\u017b\2\0\43\117\14\0\1\u024c\37\0\1\u024c\56\0"+
    "\1\u01fa\126\0\1\u024d\37\0\1\u024d\57\0\5\201\1\u024e"+
    "\1\0\6\201\6\0\4\201\14\0\2\201\2\0\1\201"+
    "\1\u024e\41\201\2\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\5\52\1\u0127\17\52\1\0\11\52\1\0"+
    "\17\52\1\u0127\25\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\14\52\1\76\10\52\1\0\11\52\1\0"+
    "\41\52\1\76\3\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\17\52\1\u024f\5\52\1\0\11\52\1\0"+
    "\6\52\1\u024f\36\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\17\52\1\u014f\5\52\1\0\11\52\1\0"+
    "\6\52\1\u014f\36\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\5\52\1\u0250\17\52\1\0\11\52\1\0"+
    "\17\52\1\u0250\25\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\25\52\1\0\11\52\1\0\11\52\1\221"+
    "\22\52\1\221\10\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\17\52\1\u01ff\5\52\1\0\11\52\1\0"+
    "\6\52\1\u01ff\36\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\25\52\1\0\11\52\1\0\11\52\1\u014a"+
    "\22\52\1\u014a\10\52\1\0\1\52\1\0\2\52\2\0"+
    "\6\52\1\0\25\52\1\0\11\52\1\0\14\52\2\u0251"+
    "\27\52\1\0\1\52\1\0\2\52\2\0\3\52\1\312"+
    "\2\52\1\0\25\52\1\0\6\52\1\312\2\52\1\0"+
    "\43\52\15\0\1\u0252\44\0\1\u0252\40\0\1\110\10\0"+
    "\1\110\1\117\4\110\1\0\1\110\4\117\1\110\1\0"+
    "\4\110\1\0\2\110\2\117\14\0\2\110\2\0\4\110"+
    "\1\117\1\110\1\117\1\110\1\117\5\110\1\117\6\110"+
    "\1\117\1\110\1\117\1\110\1\117\1\110\1\117\2\110"+
    "\1\117\5\110\10\0\6\117\1\0\6\117\1\0\1\110"+
    "\1\326\2\117\1\0\4\117\14\0\2\117\2\0\1\117"+
    "\1\u0248\41\117\1\110\10\0\6\117\1\0\6\117\1\0"+
    "\1\110\1\326\2\117\1\0\4\117\14\0\2\117\2\0"+
    "\1\117\1\u0224\41\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\2\117"+
    "\2\0\6\117\1\u0253\34\117\1\110\10\0\6\117\1\0"+
    "\6\117\1\0\1\110\1\326\2\117\1\0\4\117\14\0"+
    "\2\117\2\0\31\117\1\u0254\11\117\1\110\10\0\6\117"+
    "\1\0\6\117\1\0\1\110\1\326\2\117\1\0\4\117"+
    "\14\0\2\117\2\0\33\117\1\u0175\7\117\1\110\10\0"+
    "\6\117\1\0\6\117\1\0\1\110\1\326\2\117\1\0"+
    "\4\117\14\0\2\117\2\0\6\117\1\u0255\34\117\1\110"+
    "\10\0\6\117\1\0\6\117\1\0\1\110\1\326\2\117"+
    "\1\0\4\117\14\0\2\117\2\0\1\117\1\u0256\41\117"+
    "\1\110\10\0\6\117\1\0\6\117\1\0\1\110\1\326"+
    "\2\117\1\0\4\117\14\0\2\117\2\0\35\117\1\u0257"+
    "\5\117\1\110\10\0\6\117\1\0\6\117\1\0\1\110"+
    "\1\326\2\117\1\0\4\117\14\0\2\117\2\0\5\117"+
    "\1\u0258\35\117\1\110\10\0\6\117\1\0\6\117\1\0"+
    "\1\110\1\326\2\117\1\0\4\117\14\0\2\117\2\0"+
    "\34\117\1\u0259\6\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\2\117"+
    "\2\0\34\117\1\u0227\6\117\1\110\10\0\6\117\1\0"+
    "\6\117\1\0\1\110\1\326\2\117\1\0\4\117\14\0"+
    "\2\117\2\0\37\117\1\343\3\117\1\110\10\0\6\117"+
    "\1\0\6\117\1\0\1\110\1\326\2\117\1\0\4\117"+
    "\14\0\2\117\2\0\35\117\1\u01e5\5\117\1\110\10\0"+
    "\6\117\1\0\6\117\1\0\1\110\1\326\2\117\1\0"+
    "\4\117\14\0\2\117\2\0\33\117\1\u01ee\7\117\1\110"+
    "\10\0\6\117\1\0\5\117\1\u0186\1\0\1\110\1\326"+
    "\2\117\1\0\4\117\14\0\2\117\2\0\43\117\15\0"+
    "\1\u025a\44\0\1\u025a\55\0\1\u025b\44\0\1\u025b\40\0"+
    "\2\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\14\52\1\u0147\10\52\1\0\11\52\1\0\41\52\1\u0147"+
    "\3\52\1\0\1\52\1\0\2\52\2\0\6\52\1\0"+
    "\25\52\1\0\11\52\1\0\11\52\1\223\22\52\1\223"+
    "\10\52\1\0\1\52\1\0\2\52\2\0\4\52\1\u025c"+
    "\1\52\1\0\25\52\1\0\11\52\1\0\2\52\1\u025c"+
    "\40\52\16\0\1\u025d\42\0\1\u025d\41\0\1\110\10\0"+
    "\6\117\1\0\6\117\1\0\1\110\1\326\2\117\1\0"+
    "\4\117\14\0\2\117\2\0\35\117\1\u025e\5\117\1\110"+
    "\10\0\6\117\1\0\6\117\1\0\1\110\1\326\2\117"+
    "\1\0\4\117\14\0\2\117\2\0\33\117\1\u0186\7\117"+
    "\1\110\10\0\6\117\1\0\6\117\1\0\1\110\1\326"+
    "\2\117\1\0\4\117\14\0\2\117\2\0\35\117\1\u01ee"+
    "\5\117\1\110\10\0\6\117\1\0\6\117\1\0\1\110"+
    "\1\326\2\117\1\0\4\117\14\0\2\117\2\0\6\117"+
    "\1\u019c\34\117\1\110\10\0\6\117\1\0\6\117\1\0"+
    "\1\110\1\326\2\117\1\0\4\117\14\0\2\117\2\0"+
    "\1\117\1\u01e7\41\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\2\117"+
    "\2\0\34\117\1\u025f\6\117\1\110\10\0\6\117\1\0"+
    "\6\117\1\0\1\110\1\326\2\117\1\0\4\117\14\0"+
    "\2\117\2\0\35\117\1\u0260\5\117\16\0\1\u0261\42\0"+
    "\1\u0261\57\0\1\u0262\42\0\1\u0262\41\0\2\52\1\0"+
    "\1\52\1\0\2\52\2\0\6\52\1\0\15\52\1\u0263"+
    "\7\52\1\0\11\52\1\0\5\52\1\u0263\35\52\17\0"+
    "\1\u0264\103\0\1\110\10\0\6\117\1\0\6\117\1\0"+
    "\1\110\1\326\2\117\1\0\4\117\14\0\2\117\2\0"+
    "\1\117\1\u0171\41\117\1\110\10\0\6\117\1\0\6\117"+
    "\1\0\1\110\1\326\2\117\1\0\4\117\14\0\2\117"+
    "\2\0\31\117\1\u0257\11\117\1\110\10\0\6\117\1\0"+
    "\6\117\1\0\1\110\1\326\2\117\1\0\4\117\14\0"+
    "\1\u0265\1\117\2\0\43\117\17\0\1\u0266\122\0\1\u0267"+
    "\103\0\2\52\1\0\1\52\1\0\2\52\2\0\6\52"+
    "\1\0\25\52\1\0\11\52\1\0\10\52\1\223\20\52"+
    "\1\223\11\52\1\110\10\0\6\117\1\0\6\117\1\0"+
    "\1\110\1\326\2\117\1\0\4\117\14\0\2\117\2\0"+
    "\42\117\1\u0256";

  private static int [] zzUnpackTrans() {
    int [] result = new int[45899];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\6\0\2\1\1\0\2\1\5\0\2\1\1\11\4\1"+
    "\1\11\5\1\1\11\2\1\2\11\2\1\1\11\1\1"+
    "\3\11\1\1\1\11\25\1\1\11\1\1\1\11\1\1"+
    "\3\11\1\1\1\11\2\1\2\11\7\1\1\11\3\1"+
    "\1\11\3\1\1\11\20\1\2\11\2\1\1\11\1\1"+
    "\1\11\1\1\1\11\6\1\1\11\5\1\2\11\5\0"+
    "\1\11\103\1\1\11\3\0\1\11\1\0\73\1\1\11"+
    "\2\1\1\0\1\11\5\0\2\1\1\0\1\11\4\0"+
    "\100\1\1\0\1\1\1\0\3\1\1\0\66\1\10\0"+
    "\1\1\1\11\2\0\44\1\1\0\1\11\45\1\1\0"+
    "\1\11\3\0\1\1\1\0\1\1\2\0\24\1\1\0"+
    "\30\1\4\0\13\1\1\0\20\1\2\0\4\1\1\0"+
    "\7\1\2\0\1\1\1\0\3\1\2\0\1\1\1\11"+
    "\1\1\2\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[615];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */

	/**
	 * Type specific to XMLTokenMaker denoting a line ending with an unclosed
	 * double-quote attribute.
	 */
	public static final int INTERNAL_ATTR_DOUBLE			= -1;


	/**
	 * Type specific to XMLTokenMaker denoting a line ending with an unclosed
	 * single-quote attribute.
	 */
	public static final int INTERNAL_ATTR_SINGLE			= -2;


	/**
	 * Token type specific to HTMLTokenMaker; this signals that the user has
	 * ended a line with an unclosed HTML tag; thus a new line is beginning
	 * still inside of the tag.
	 */
	public static final int INTERNAL_INTAG					= -3;

	/**
	 * Token type specific to HTMLTokenMaker; this signals that the user has
	 * ended a line with an unclosed <code>&lt;script&gt;</code> tag.
	 */
	public static final int INTERNAL_INTAG_SCRIPT			= -4;

	/**
	 * Token type specifying we're in a double-qouted attribute in a
	 * script tag.
	 */
	public static final int INTERNAL_ATTR_DOUBLE_QUOTE_SCRIPT = -5;

	/**
	 * Token type specifying we're in a single-qouted attribute in a
	 * script tag.
	 */
	public static final int INTERNAL_ATTR_SINGLE_QUOTE_SCRIPT = -6;

	/**
	 * Token type specifying we're in JavaScript.
	 */
	public static final int INTERNAL_IN_JS					= -7;

	/**
	 * Token type specifying we're in a JavaScript multiline comment.
	 */
	public static final int INTERNAL_IN_JS_MLC				= -8;

	/**
	 * Token type specifying we're in an invalid multi-line JS string.
	 */
	public static final int INTERNAL_IN_JS_STRING_INVALID	= -9;

	/**
	 * Token type specifying we're in a valid multi-line JS string.
	 */
	public static final int INTERNAL_IN_JS_STRING_VALID		= -10;

	/**
	 * Token type specifying we're in an invalid multi-line JS single-quoted string.
	 */
	public static final int INTERNAL_IN_JS_CHAR_INVALID	= -11;

	/**
	 * Token type specifying we're in a valid multi-line JS single-quoted string.
	 */
	public static final int INTERNAL_IN_JS_CHAR_VALID		= -12;

	/**
	 * Whether closing markup tags are automatically completed for HTML.
	 */
	private static boolean completeCloseTags;

	/**
	 * When in the JS_STRING state, whether the current string is valid.
	 */
	private boolean validJSString;


	/**
	 * Constructor.  This must be here because JFlex does not generate a
	 * no-parameter constructor.
	 */
	public HTMLTokenMaker() {
		super();
	}


	/**
	 * Adds the token specified to the current linked list of tokens as an
	 * "end token;" that is, at <code>zzMarkedPos</code>.
	 *
	 * @param tokenType The token's type.
	 */
	private void addEndToken(int tokenType) {
		addToken(zzMarkedPos,zzMarkedPos, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 * @see #addToken(int, int, int)
	 */
	private void addHyperlinkToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so, true);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 */
	public void addToken(char[] array, int start, int end, int tokenType, int startOffset) {
		super.addToken(array, start,end, tokenType, startOffset);
		zzStartRead = zzMarkedPos;
	}


	/**
	 * Sets whether markup close tags should be completed.  You might not want
	 * this to be the case, since some tags in standard HTML aren't usually
	 * closed.
	 *
	 * @return Whether closing markup tags are completed.
	 * @see #setCompleteCloseTags(boolean)
	 */
	public boolean getCompleteCloseTags() {
		return completeCloseTags;
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *        <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;

		// Start off in the proper state.
		int state = Token.NULL;
		switch (initialTokenType) {
			case Token.COMMENT_MULTILINE:
				state = COMMENT;
				start = text.offset;
				break;
			case Token.PREPROCESSOR:
				state = PI;
				start = text.offset;
				break;
			case Token.VARIABLE:
				state = DTD;
				start = text.offset;
				break;
			case INTERNAL_INTAG:
				state = INTAG;
				start = text.offset;
				break;
			case INTERNAL_INTAG_SCRIPT:
				state = INTAG_SCRIPT;
				start = text.offset;
				break;
			case INTERNAL_ATTR_DOUBLE:
				state = INATTR_DOUBLE;
				start = text.offset;
				break;
			case INTERNAL_ATTR_SINGLE:
				state = INATTR_SINGLE;
				start = text.offset;
				break;
			case INTERNAL_ATTR_DOUBLE_QUOTE_SCRIPT:
				state = INATTR_DOUBLE_SCRIPT;
				start = text.offset;
				break;
			case INTERNAL_ATTR_SINGLE_QUOTE_SCRIPT:
				state = INATTR_SINGLE_SCRIPT;
				start = text.offset;
				break;
			case INTERNAL_IN_JS:
				state = JAVASCRIPT;
				start = text.offset;
				break;
			case INTERNAL_IN_JS_MLC:
				state = JS_MLC;
				start = text.offset;
				break;
			case INTERNAL_IN_JS_STRING_INVALID:
				state = JS_STRING;
				validJSString = false;
				start = text.offset;
				break;
			case INTERNAL_IN_JS_STRING_VALID:
				state = JS_STRING;
				validJSString = true;
				start = text.offset;
				break;
			case INTERNAL_IN_JS_CHAR_INVALID:
				state = JS_CHAR;
				validJSString = false;
				start = text.offset;
				break;
			case INTERNAL_IN_JS_CHAR_VALID:
				state = JS_CHAR;
				validJSString = true;
				start = text.offset;
				break;
			default:
				state = Token.NULL;
		}

		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new DefaultToken();
		}

	}


	/**
	 * Sets whether markup close tags should be completed.  You might not want
	 * this to be the case, since some tags in standard HTML aren't usually
	 * closed.
	 *
	 * @param complete Whether closing markup tags are completed.
	 * @see #getCompleteCloseTags()
	 */
	public static void setCompleteCloseTags(boolean complete) {
		completeCloseTags = complete;
	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 */
	private boolean zzRefill() {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream 
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream 
	 */
	public final void yyreset(java.io.Reader reader) {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtEOF  = false;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public HTMLTokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public HTMLTokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 192) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 2: 
          { addToken(Token.IDENTIFIER);
          }
        case 67: break;
        case 60: 
          { addToken(Token.LITERAL_BOOLEAN);
          }
        case 68: break;
        case 50: 
          { /* Skip all escaped chars. */
          }
        case 69: break;
        case 52: 
          { /* Invalid latin-1 character \xXX */ validJSString = false;
          }
        case 70: break;
        case 46: 
          { addToken(Token.ERROR_NUMBER_FORMAT);
          }
        case 71: break;
        case 38: 
          { addToken(start,zzStartRead-1, Token.COMMENT_EOL); addEndToken(INTERNAL_IN_JS); return firstToken;
          }
        case 72: break;
        case 66: 
          { yybegin(YYINITIAL);
							  int temp = zzStartRead;
							  addToken(start,zzStartRead-1, Token.COMMENT_EOL);
							  addToken(temp,temp+1, Token.MARKUP_TAG_DELIMITER);
							  addToken(zzMarkedPos-7,zzMarkedPos-2, Token.MARKUP_TAG_NAME);
							  addToken(zzMarkedPos-1,zzMarkedPos-1, Token.MARKUP_TAG_DELIMITER);
          }
        case 73: break;
        case 39: 
          { int count = yylength();
									addToken(zzStartRead,zzStartRead, Token.MARKUP_TAG_DELIMITER);
									zzMarkedPos -= (count-1); //yypushback(count-1);
									yybegin(INTAG_CHECK_TAG_NAME);
          }
        case 74: break;
        case 23: 
          { start = zzMarkedPos-1; yybegin(INATTR_SINGLE_SCRIPT);
          }
        case 75: break;
        case 14: 
          { yybegin(YYINITIAL); addToken(Token.MARKUP_TAG_DELIMITER);
          }
        case 76: break;
        case 9: 
          { addToken(start,zzStartRead-1, Token.VARIABLE); return firstToken;
          }
        case 77: break;
        case 37: 
          { addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addEndToken(INTERNAL_IN_JS_MLC); return firstToken;
          }
        case 78: break;
        case 61: 
          { addToken(Token.FUNCTION);
          }
        case 79: break;
        case 40: 
          { start = zzMarkedPos-2; yybegin(DTD);
          }
        case 80: break;
        case 26: 
          { addEndToken(INTERNAL_IN_JS); return firstToken;
          }
        case 81: break;
        case 64: 
          { yybegin(YYINITIAL);
								  addToken(zzStartRead,zzStartRead+1, Token.MARKUP_TAG_DELIMITER);
								  addToken(zzMarkedPos-7,zzMarkedPos-2, Token.MARKUP_TAG_NAME);
								  addToken(zzMarkedPos-1,zzMarkedPos-1, Token.MARKUP_TAG_DELIMITER);
          }
        case 82: break;
        case 24: 
          { yybegin(INTAG_SCRIPT); addToken(start,zzStartRead, Token.MARKUP_TAG_ATTRIBUTE_VALUE);
          }
        case 83: break;
        case 34: 
          { addToken(start,zzStartRead-1, Token.ERROR_CHAR); addEndToken(INTERNAL_IN_JS); return firstToken;
          }
        case 84: break;
        case 18: 
          { /* Shouldn't happen */ yypushback(1); yybegin(INTAG);
          }
        case 85: break;
        case 25: 
          { addToken(Token.ERROR_IDENTIFIER);
          }
        case 86: break;
        case 32: 
          { int type = validJSString ? Token.LITERAL_STRING_DOUBLE_QUOTE : Token.ERROR_STRING_DOUBLE; addToken(start,zzStartRead, type); yybegin(JAVASCRIPT);
          }
        case 87: break;
        case 45: 
          { start = zzMarkedPos-2; yybegin(JS_MLC);
          }
        case 88: break;
        case 56: 
          { boolean highlightedAsRegex = false;
										if (firstToken==null) {
											addToken(Token.REGEX);
											highlightedAsRegex = true;
										}
										else {
											// If this is *likely* to be a regex, based on
											// the previous token, highlight it as such.
											Token t = firstToken.getLastNonCommentNonWhitespaceToken();
											if (RSyntaxUtilities.regexCanFollowInJavaScript(t)) {
												addToken(Token.REGEX);
												highlightedAsRegex = true;
											}
										}
										// If it doesn't *appear* to be a regex, highlight it as
										// individual tokens.
										if (!highlightedAsRegex) {
											int temp = zzStartRead + 1;
											addToken(zzStartRead, zzStartRead, Token.OPERATOR);
											zzStartRead = zzCurrentPos = zzMarkedPos = temp;
										}
          }
        case 89: break;
        case 4: 
          { addToken(Token.MARKUP_TAG_DELIMITER); yybegin(INTAG);
          }
        case 90: break;
        case 31: 
          { addToken(start,zzStartRead-1, Token.ERROR_STRING_DOUBLE); addEndToken(INTERNAL_IN_JS); return firstToken;
          }
        case 91: break;
        case 10: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead, Token.VARIABLE);
          }
        case 92: break;
        case 53: 
          { yybegin(JAVASCRIPT); addToken(start,zzStartRead+1, Token.COMMENT_MULTILINE);
          }
        case 93: break;
        case 36: 
          { int type = validJSString ? Token.LITERAL_CHAR : Token.ERROR_CHAR; addToken(start,zzStartRead, type); yybegin(JAVASCRIPT);
          }
        case 94: break;
        case 42: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead+1, Token.PREPROCESSOR);
          }
        case 95: break;
        case 20: 
          { yybegin(INTAG); addToken(start,zzStartRead, Token.MARKUP_TAG_ATTRIBUTE_VALUE);
          }
        case 96: break;
        case 44: 
          { start = zzMarkedPos-2; yybegin(JS_EOL_COMMENT);
          }
        case 97: break;
        case 41: 
          { start = zzMarkedPos-2; yybegin(PI);
          }
        case 98: break;
        case 12: 
          { start = zzMarkedPos-1; yybegin(INATTR_DOUBLE);
          }
        case 99: break;
        case 48: 
          { addToken(Token.LITERAL_NUMBER_HEXADECIMAL);
          }
        case 100: break;
        case 17: 
          { /* A non-recognized HTML tag name */ yypushback(yylength()); yybegin(INTAG);
          }
        case 101: break;
        case 21: 
          { start = zzMarkedPos-1; yybegin(INATTR_DOUBLE_SCRIPT);
          }
        case 102: break;
        case 33: 
          { /* Line ending in '\' => continue to next line. */
								if (validJSString) {
									addToken(start,zzStartRead, Token.LITERAL_STRING_DOUBLE_QUOTE);
									addEndToken(INTERNAL_IN_JS_STRING_VALID);
								}
								else {
									addToken(start,zzStartRead, Token.ERROR_STRING_DOUBLE);
									addEndToken(INTERNAL_IN_JS_STRING_INVALID);
								}
								return firstToken;
          }
        case 103: break;
        case 5: 
          { addToken(Token.WHITESPACE);
          }
        case 104: break;
        case 6: 
          { addToken(Token.DATA_TYPE);
          }
        case 105: break;
        case 19: 
          { addToken(Token.MARKUP_TAG_NAME);
          }
        case 106: break;
        case 35: 
          { /* Line ending in '\' => continue to next line. */
								if (validJSString) {
									addToken(start,zzStartRead, Token.LITERAL_CHAR);
									addEndToken(INTERNAL_IN_JS_CHAR_VALID);
								}
								else {
									addToken(start,zzStartRead, Token.ERROR_CHAR);
									addEndToken(INTERNAL_IN_JS_CHAR_INVALID);
								}
								return firstToken;
          }
        case 107: break;
        case 63: 
          { addToken(zzStartRead,zzStartRead, Token.MARKUP_TAG_DELIMITER);
								  addToken(zzMarkedPos-6,zzMarkedPos-1, Token.MARKUP_TAG_NAME);
								  start = zzMarkedPos; yybegin(INTAG_SCRIPT);
          }
        case 108: break;
        case 28: 
          { addToken(Token.LITERAL_NUMBER_DECIMAL_INT);
          }
        case 109: break;
        case 16: 
          { start = zzMarkedPos-1; yybegin(INATTR_SINGLE);
          }
        case 110: break;
        case 11: 
          { addToken(Token.MARKUP_TAG_ATTRIBUTE);
          }
        case 111: break;
        case 27: 
          { start = zzMarkedPos-1; validJSString = true; yybegin(JS_STRING);
          }
        case 112: break;
        case 51: 
          { /* Invalid Unicode character \\uXXXX */ validJSString = false;
          }
        case 113: break;
        case 57: 
          { start = zzMarkedPos-4; yybegin(COMMENT);
          }
        case 114: break;
        case 30: 
          { start = zzMarkedPos-1; validJSString = true; yybegin(JS_CHAR);
          }
        case 115: break;
        case 49: 
          { addToken(Token.RESERVED_WORD);
          }
        case 116: break;
        case 58: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_MULTILINE); start = zzMarkedPos;
          }
        case 117: break;
        case 55: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead+2, Token.COMMENT_MULTILINE);
          }
        case 118: break;
        case 54: 
          { int count = yylength();
									addToken(zzStartRead,zzStartRead+1, Token.MARKUP_TAG_DELIMITER);
									zzMarkedPos -= (count-2); //yypushback(count-2);
									yybegin(INTAG_CHECK_TAG_NAME);
          }
        case 119: break;
        case 29: 
          { addToken(Token.SEPARATOR);
          }
        case 120: break;
        case 3: 
          { addNullToken(); return firstToken;
          }
        case 121: break;
        case 22: 
          { yybegin(JAVASCRIPT); addToken(Token.MARKUP_TAG_DELIMITER);
          }
        case 122: break;
        case 43: 
          { addToken(Token.MARKUP_TAG_DELIMITER); yybegin(YYINITIAL);
          }
        case 123: break;
        case 7: 
          { addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); return firstToken;
          }
        case 124: break;
        case 15: 
          { addToken(Token.OPERATOR);
          }
        case 125: break;
        case 47: 
          { addToken(Token.LITERAL_NUMBER_FLOAT);
          }
        case 126: break;
        case 13: 
          { addToken(Token.MARKUP_TAG_DELIMITER);
          }
        case 127: break;
        case 62: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_EOL); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_EOL); start = zzMarkedPos;
          }
        case 128: break;
        case 59: 
          { addToken(Token.COMMENT_MULTILINE);
          }
        case 129: break;
        case 8: 
          { addToken(start,zzStartRead-1, Token.PREPROCESSOR); return firstToken;
          }
        case 130: break;
        case 65: 
          { yybegin(YYINITIAL);
							  int temp = zzStartRead;
							  addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE);
							  addToken(temp,temp+1, Token.MARKUP_TAG_DELIMITER);
							  addToken(zzMarkedPos-7,zzMarkedPos-2, Token.MARKUP_TAG_NAME);
							  addToken(zzMarkedPos-1,zzMarkedPos-1, Token.MARKUP_TAG_DELIMITER);
          }
        case 131: break;
        case 1: 
          { 
          }
        case 132: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case JS_STRING: {
              addToken(start,zzStartRead-1, Token.ERROR_STRING_DOUBLE); addEndToken(INTERNAL_IN_JS); return firstToken;
            }
            case 616: break;
            case INTAG_CHECK_TAG_NAME: {
              addToken(zzMarkedPos,zzMarkedPos, INTERNAL_INTAG); return firstToken;
            }
            case 617: break;
            case JS_MLC: {
              addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addEndToken(INTERNAL_IN_JS_MLC); return firstToken;
            }
            case 618: break;
            case INTAG_SCRIPT: {
              addToken(zzMarkedPos,zzMarkedPos, INTERNAL_INTAG_SCRIPT); return firstToken;
            }
            case 619: break;
            case JS_CHAR: {
              addToken(start,zzStartRead-1, Token.ERROR_CHAR); addEndToken(INTERNAL_IN_JS); return firstToken;
            }
            case 620: break;
            case JS_EOL_COMMENT: {
              addToken(start,zzStartRead-1, Token.COMMENT_EOL); addEndToken(INTERNAL_IN_JS); return firstToken;
            }
            case 621: break;
            case INATTR_DOUBLE_SCRIPT: {
              addToken(start,zzStartRead-1, Token.MARKUP_TAG_ATTRIBUTE_VALUE); addEndToken(INTERNAL_ATTR_DOUBLE_QUOTE_SCRIPT); return firstToken;
            }
            case 622: break;
            case INATTR_SINGLE_SCRIPT: {
              addToken(start,zzStartRead-1, Token.MARKUP_TAG_ATTRIBUTE_VALUE); addEndToken(INTERNAL_ATTR_SINGLE_QUOTE_SCRIPT); return firstToken;
            }
            case 623: break;
            case DTD: {
              addToken(start,zzStartRead-1, Token.VARIABLE); return firstToken;
            }
            case 624: break;
            case INATTR_SINGLE: {
              addToken(start,zzStartRead-1, Token.MARKUP_TAG_ATTRIBUTE_VALUE); addEndToken(INTERNAL_ATTR_SINGLE); return firstToken;
            }
            case 625: break;
            case INATTR_DOUBLE: {
              addToken(start,zzStartRead-1, Token.MARKUP_TAG_ATTRIBUTE_VALUE); addEndToken(INTERNAL_ATTR_DOUBLE); return firstToken;
            }
            case 626: break;
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 627: break;
            case INTAG: {
              addToken(zzMarkedPos,zzMarkedPos, INTERNAL_INTAG); return firstToken;
            }
            case 628: break;
            case COMMENT: {
              addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); return firstToken;
            }
            case 629: break;
            case JAVASCRIPT: {
              addEndToken(INTERNAL_IN_JS); return firstToken;
            }
            case 630: break;
            case PI: {
              addToken(start,zzStartRead-1, Token.PREPROCESSOR); return firstToken;
            }
            case 631: break;
            default:
            return null;
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
