/* The following code was generated by JFlex 1.4.1 on 12/23/10 11:06 AM */

/*
 * 12/23/2010
 *
 * ClojureTokenMaker.java - Scanner for Clojure.
 * 
 * This library is distributed under a modified BSD license.  See the included
 * RSyntaxTextArea.License.txt file for details.
 */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.*;


/**
 * Scanner for the Clojure programming language.<p>
 *
 * This was graciously donated by the folks at the
 * <a href="http://pacific.mpi-cbg.de/wiki/index.php/Fiji">Fiji</a> project.
 * Its original location was
 * <a href="http://pacific.mpi-cbg.de/cgi-bin/gitweb.cgi?p=fiji.git;a=tree;f=src-plugins/Script_Editor/fiji/scripting;hb=935d85d9d88dd780c6d5f2765937ddc18b5008ca">here</a>.
 * <p>
 * 
 * This implementation was created using
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>, so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated ClojureTokenMaker.java</code> file will contain two
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 *
 */

public class ClojureTokenMaker extends AbstractJFlexTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** lexical states */
  public static final int EOL_COMMENT = 2;
  public static final int STRING = 1;
  public static final int YYINITIAL = 0;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\56\1\15\1\0\1\36\1\34\22\0\1\57\1\67\1\16"+
    "\1\52\1\71\1\65\1\65\1\12\1\44\1\47\1\64\1\61\1\72"+
    "\1\43\1\17\1\66\1\4\3\7\4\7\2\5\1\2\1\1\1\62"+
    "\1\63\1\60\1\35\1\51\3\6\1\41\1\42\1\41\5\3\1\40"+
    "\13\3\1\37\2\3\1\33\1\11\1\33\1\53\1\70\1\46\1\22"+
    "\1\26\1\23\1\75\1\24\1\14\1\104\1\73\1\32\1\103\1\106"+
    "\1\31\1\76\1\27\1\74\1\21\1\77\1\13\1\20\1\25\1\10"+
    "\1\100\1\30\1\102\1\101\1\105\1\54\1\45\1\55\1\50\uff81\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\1\2\0\1\2\1\3\1\4\1\1\2\5\1\1"+
    "\1\2\2\1\1\6\1\7\14\1\1\10\1\4\1\11"+
    "\1\4\1\10\1\4\1\2\4\4\11\1\1\12\1\13"+
    "\1\14\2\12\1\15\2\12\1\16\2\17\1\20\1\17"+
    "\2\21\1\17\1\5\1\17\1\1\1\22\3\0\6\1"+
    "\1\23\2\1\1\24\51\1\1\23\4\1\4\0\1\4"+
    "\10\1\1\23\12\1\1\12\4\0\1\20\1\21\1\1"+
    "\1\20\2\1\3\0\4\1\1\24\5\1\1\24\6\1"+
    "\2\24\40\1\1\23\1\25\1\24\12\1\1\24\3\1"+
    "\2\0\2\25\7\1\1\23\10\1\1\24\4\1\4\0"+
    "\3\1\2\0\5\1\1\24\4\1\2\24\3\1\2\24"+
    "\3\1\1\26\1\1\1\24\5\1\1\24\3\1\1\24"+
    "\1\1\1\24\3\1\1\24\3\1\2\0\11\1\1\24"+
    "\2\1\1\0\1\27\1\0\1\1\2\0\7\1\1\24"+
    "\37\1\2\0\1\1\1\0\107\1\1\24\27\1";

  private static int [] zzUnpackAction() {
    int [] result = new int[466];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\107\0\216\0\325\0\325\0\u011c\0\u0163\0\u01aa"+
    "\0\u01f1\0\u0238\0\u027f\0\u02c6\0\u030d\0\325\0\325\0\u0354"+
    "\0\u039b\0\u03e2\0\u0429\0\u0470\0\u04b7\0\u04fe\0\u0545\0\u058c"+
    "\0\u05d3\0\u061a\0\u0661\0\325\0\u0163\0\u06a8\0\u06ef\0\u0736"+
    "\0\325\0\u077d\0\u07c4\0\u080b\0\u0852\0\u0899\0\u08e0\0\u0927"+
    "\0\u096e\0\u09b5\0\u09fc\0\u0a43\0\u0a8a\0\u0ad1\0\u0b18\0\u0b5f"+
    "\0\325\0\u0ba6\0\u0bed\0\u0c34\0\325\0\u0c7b\0\u0cc2\0\u0d09"+
    "\0\u0d50\0\u0d97\0\u0dde\0\u0e25\0\u0d97\0\u0e6c\0\u0eb3\0\u0d97"+
    "\0\u0efa\0\u0f41\0\325\0\u0f88\0\u0fcf\0\u1016\0\u105d\0\u10a4"+
    "\0\u10eb\0\u1132\0\u1179\0\u11c0\0\u1207\0\u124e\0\u1295\0\u0163"+
    "\0\u12dc\0\u1323\0\u136a\0\u13b1\0\u13f8\0\u143f\0\u1486\0\u14cd"+
    "\0\u1514\0\u155b\0\u15a2\0\u15e9\0\u1630\0\u1677\0\u16be\0\u1705"+
    "\0\u174c\0\u1793\0\u17da\0\u1821\0\u1868\0\u18af\0\u18f6\0\u193d"+
    "\0\u1984\0\u19cb\0\u1a12\0\u1a59\0\u1aa0\0\u1ae7\0\u1b2e\0\u1b75"+
    "\0\u1bbc\0\u1c03\0\u1c4a\0\u1c91\0\u1cd8\0\u1d1f\0\u1d66\0\u1dad"+
    "\0\u1df4\0\u0163\0\u1e3b\0\u1e82\0\u1ec9\0\u1f10\0\u1f57\0\u1f9e"+
    "\0\u1fe5\0\u202c\0\u2073\0\u20ba\0\u2101\0\u2148\0\u218f\0\u21d6"+
    "\0\u221d\0\u2264\0\u22ab\0\u22f2\0\u2339\0\u2380\0\u23c7\0\u240e"+
    "\0\u2455\0\u249c\0\u24e3\0\u252a\0\u2571\0\u25b8\0\325\0\u25ff"+
    "\0\u2646\0\u268d\0\u26d4\0\u0d97\0\u271b\0\u2762\0\u27a9\0\u27f0"+
    "\0\u2837\0\u287e\0\u28c5\0\u290c\0\u2953\0\u299a\0\u29e1\0\u2a28"+
    "\0\u2a6f\0\u2ab6\0\u2afd\0\u2b44\0\u2b8b\0\u2bd2\0\u2c19\0\u2c60"+
    "\0\u2ca7\0\u2cee\0\u2d35\0\u2d7c\0\u2dc3\0\u2e0a\0\u2e51\0\u2e98"+
    "\0\u2edf\0\u2f26\0\u2f6d\0\u2fb4\0\u2ffb\0\u3042\0\u3089\0\u30d0"+
    "\0\u3117\0\u315e\0\u2a6f\0\u31a5\0\u31ec\0\u3233\0\u327a\0\u32c1"+
    "\0\u3308\0\u334f\0\u3396\0\u33dd\0\u3424\0\u346b\0\u34b2\0\u34f9"+
    "\0\u3540\0\u3587\0\u35ce\0\u3615\0\u365c\0\u36a3\0\u36ea\0\u3731"+
    "\0\u2ffb\0\u3778\0\u37bf\0\u3806\0\u384d\0\u3894\0\u38db\0\u3922"+
    "\0\u3969\0\u39b0\0\u39f7\0\u3a3e\0\u3a85\0\u3acc\0\u3b13\0\u3b5a"+
    "\0\u3ba1\0\u3be8\0\325\0\u202c\0\u3c2f\0\u3c76\0\u3cbd\0\u3d04"+
    "\0\u3d4b\0\u3d92\0\u3dd9\0\u3e20\0\u3e67\0\u3eae\0\u3ef5\0\u3f3c"+
    "\0\u3f83\0\u3fca\0\u4011\0\u4058\0\u409f\0\u40e6\0\u412d\0\u4174"+
    "\0\u41bb\0\u4202\0\u4249\0\u4290\0\u42d7\0\u431e\0\u4365\0\u43ac"+
    "\0\u43f3\0\u443a\0\u4481\0\u44c8\0\u450f\0\u4556\0\u459d\0\u45e4"+
    "\0\u462b\0\u4672\0\u46b9\0\u4700\0\u4747\0\u4700\0\u478e\0\u47d5"+
    "\0\u481c\0\u4863\0\u48aa\0\u48f1\0\u4938\0\u497f\0\u0163\0\u49c6"+
    "\0\u4a0d\0\u4a54\0\u4a9b\0\u4ae2\0\u4b29\0\u4b70\0\u4bb7\0\u4bfe"+
    "\0\u4c45\0\u4c8c\0\u4cd3\0\u4d1a\0\u3cbd\0\u4d61\0\u4da8\0\u4def"+
    "\0\u4e36\0\u4e7d\0\u4ec4\0\u4f0b\0\u4f52\0\u4f99\0\u4fe0\0\u5027"+
    "\0\u506e\0\u50b5\0\u50fc\0\u5143\0\u518a\0\u51d1\0\u5218\0\u525f"+
    "\0\u52a6\0\u52ed\0\u5334\0\u537b\0\u53c2\0\u5409\0\u5450\0\u5497"+
    "\0\u54de\0\u5525\0\u556c\0\u55b3\0\u55fa\0\u5641\0\u5688\0\u56cf"+
    "\0\u5716\0\u575d\0\u57a4\0\u57eb\0\u5832\0\u5879\0\u58c0\0\u5907"+
    "\0\u594e\0\u5995\0\u59dc\0\u5a23\0\u5a6a\0\u5ab1\0\u5af8\0\u5b3f"+
    "\0\u5b86\0\u5bcd\0\u5c14\0\u5c5b\0\u5ca2\0\u5ce9\0\u5d30\0\u5d77"+
    "\0\u5dbe\0\u5e05\0\u5e4c\0\u5e93\0\u5eda\0\u5f21\0\u5f68\0\u5faf"+
    "\0\u537b\0\u5ff6\0\u603d\0\u6084\0\u60cb\0\u6112\0\u6159\0\u61a0"+
    "\0\u61e7\0\u622e\0\u6275\0\u62bc\0\u6303\0\u634a\0\u6391\0\u63d8"+
    "\0\u641f\0\u6466\0\u64ad\0\u64f4\0\u653b\0\u6582\0\u65c9\0\u6610"+
    "\0\u6657\0\u669e\0\u66e5\0\u672c\0\u6773\0\u67ba\0\u6801\0\u6848"+
    "\0\u688f\0\u409f\0\u68d6\0\u691d\0\u6964\0\u69ab\0\u69f2\0\u6a39"+
    "\0\u6a80\0\u6ac7\0\u6b0e\0\u6b55\0\u6b9c\0\u6be3\0\u6c2a\0\u4bb7"+
    "\0\u6c71\0\u6cb8\0\u6cff\0\u6d46\0\u6d8d\0\u6dd4\0\u6e1b\0\u6e62"+
    "\0\u6ea9\0\u6ef0\0\u6f37\0\u6f7e\0\u6fc5\0\u700c\0\u7053\0\u709a"+
    "\0\u70e1\0\u7128\0\u716f\0\u71b6\0\u71fd\0\u7244\0\u728b\0\u72d2"+
    "\0\u7319\0\u7360\0\u73a7\0\u73ee\0\u7435\0\u747c\0\u74c3\0\u750a"+
    "\0\u7551\0\u7598\0\u75df\0\u7626\0\u766d\0\u76b4\0\u76fb\0\u7742"+
    "\0\u7789\0\u77d0\0\u7817\0\u785e\0\u78a5\0\u78ec\0\u7933\0\u797a"+
    "\0\u79c1\0\u7a08";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[466];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\4\1\5\1\6\1\7\1\10\1\11\1\7\1\11"+
    "\1\12\1\13\1\4\1\14\1\15\1\16\1\17\1\20"+
    "\1\21\1\22\1\23\1\24\1\25\1\26\1\27\1\30"+
    "\1\31\1\32\1\33\1\34\1\4\1\35\1\36\4\7"+
    "\1\37\1\40\2\4\1\34\1\41\1\4\1\42\1\41"+
    "\2\34\2\36\1\43\1\35\1\44\1\45\1\46\1\41"+
    "\1\35\1\44\3\4\1\47\1\50\1\51\1\52\1\53"+
    "\1\54\3\7\1\55\1\56\1\57\15\60\1\61\1\62"+
    "\70\60\14\63\1\64\1\65\12\63\1\66\42\63\1\67"+
    "\13\63\112\0\1\70\2\0\1\70\1\0\1\70\2\0"+
    "\2\70\3\0\13\70\2\0\1\70\1\0\5\70\15\0"+
    "\1\70\2\0\1\70\1\0\2\70\3\0\14\70\3\0"+
    "\6\7\2\0\2\7\2\0\14\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\1\71\2\0\1\72\1\73\1\74\1\72\1\73"+
    "\1\72\1\71\1\0\1\72\1\75\2\0\1\76\4\72"+
    "\1\77\4\72\1\100\1\72\2\0\1\7\1\0\1\101"+
    "\1\100\1\75\1\77\1\7\2\0\1\71\2\0\2\71"+
    "\5\0\3\7\1\0\1\7\1\0\2\7\2\71\1\0"+
    "\2\72\1\75\4\72\1\101\4\72\1\71\2\0\1\72"+
    "\2\11\1\72\1\11\1\72\1\71\1\0\1\72\1\75"+
    "\2\0\1\76\4\72\1\77\4\72\1\100\1\72\2\0"+
    "\1\7\1\0\1\72\1\100\1\75\1\77\1\7\2\0"+
    "\1\71\2\0\2\71\5\0\3\7\1\0\1\7\1\0"+
    "\2\7\2\71\1\0\2\72\1\75\11\72\3\0\6\7"+
    "\2\0\2\7\2\0\10\7\1\102\3\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\17\0\1\103\1\104\4\0\1\105\1\0"+
    "\1\106\62\0\6\7\2\0\1\107\1\110\2\0\1\7"+
    "\1\111\1\7\1\112\1\7\1\113\6\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\1\107\1\110\2\0"+
    "\3\7\1\114\4\7\1\115\1\7\1\116\1\117\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\1\7\2\76\1\7\1\76"+
    "\1\7\2\0\2\7\2\0\1\120\13\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\2\7"+
    "\1\121\2\7\1\122\1\123\5\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\1\124\1\125\4\7\1\126\5\7\3\0\6\7\2\0"+
    "\1\127\1\7\2\0\5\7\1\130\6\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\1\7\1\131\1\7\1\132\10\7\3\0\6\7"+
    "\2\0\1\133\1\7\2\0\1\7\1\134\1\135\5\7"+
    "\1\136\1\7\1\137\1\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\11\7"+
    "\1\140\2\7\3\0\6\7\2\0\2\7\2\0\12\7"+
    "\1\141\1\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\1\142\1\143\4\7"+
    "\1\144\5\7\3\0\6\7\2\0\2\7\2\0\10\7"+
    "\1\145\3\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\4\7\1\146\1\147"+
    "\6\7\3\0\6\7\2\0\1\150\1\7\2\0\3\7"+
    "\1\151\7\7\1\152\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\1\153\13\7"+
    "\3\0\6\7\2\0\2\7\2\0\13\7\1\154\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\1\7\1\155\4\7\1\156\5\7\3\0"+
    "\6\7\2\0\2\7\2\0\3\7\1\157\1\7\1\160"+
    "\1\161\4\7\1\162\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\1\7\1\163"+
    "\12\7\3\0\6\7\2\0\2\7\2\0\13\7\1\164"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\1\165\13\7\3\0\6\7\2\0"+
    "\2\7\2\0\3\7\1\166\1\7\1\167\5\7\1\170"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\1\7\1\171\12\7\3\0\6\7"+
    "\2\0\1\7\1\172\2\0\6\7\1\173\1\7\1\174"+
    "\3\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\2\7\1\175\1\176\10\7"+
    "\36\0\1\36\17\0\2\36\32\0\6\7\2\0\2\7"+
    "\2\0\14\7\2\0\1\7\1\0\5\7\14\0\1\120"+
    "\2\7\1\0\1\7\1\0\2\7\3\0\14\7\12\0"+
    "\1\177\35\0\1\200\50\0\1\201\40\0\1\202\36\0"+
    "\6\7\2\0\2\7\2\0\14\7\2\0\1\7\1\0"+
    "\5\7\14\0\1\203\2\7\1\41\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\14\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\41\1\7"+
    "\1\0\2\7\3\0\14\7\63\0\1\41\26\0\6\7"+
    "\2\0\2\7\2\0\2\7\1\204\1\7\1\205\6\7"+
    "\1\206\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\1\7\1\207\12\7\3\0"+
    "\6\7\2\0\2\7\2\0\3\7\1\210\10\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\1\120\1\7"+
    "\2\0\14\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\1\211\1\7\2\0\5\7\1\212\5\7\1\213"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\1\7\1\214\12\7\3\0\6\7"+
    "\2\0\2\7\2\0\3\7\1\215\1\7\1\216\6\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\1\7\1\217\12\7\3\0\5\7"+
    "\1\220\2\0\2\7\2\0\14\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\3\7\1\221"+
    "\1\7\1\222\6\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\5\7\1\223\6\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\5\7\1\224\5\7\1\225\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\14\7"+
    "\3\0\6\7\2\0\2\7\2\0\5\7\1\226\6\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\15\60\2\0\70\60\16\0"+
    "\1\227\70\0\14\63\2\0\12\63\1\0\42\63\1\0"+
    "\13\63\25\0\1\230\4\0\1\231\104\0\1\232\103\0"+
    "\1\233\64\0\6\70\2\0\2\70\3\0\13\70\2\0"+
    "\1\70\1\0\5\70\15\0\1\70\2\0\1\70\1\0"+
    "\2\70\3\0\14\70\1\71\2\0\7\71\1\0\2\71"+
    "\3\0\13\71\4\0\4\71\3\0\1\71\2\0\2\71"+
    "\15\0\2\71\1\0\15\71\2\0\6\72\1\71\1\0"+
    "\2\72\2\0\1\7\13\72\2\0\1\7\1\0\4\72"+
    "\1\7\2\0\1\71\2\0\2\71\5\0\3\7\1\0"+
    "\1\7\1\0\2\7\2\71\1\0\14\72\1\71\2\0"+
    "\1\72\1\73\1\74\1\72\1\73\1\72\1\71\1\0"+
    "\1\72\1\75\2\0\1\76\4\72\1\77\4\72\1\234"+
    "\1\72\2\0\1\7\1\0\1\72\1\234\1\75\1\77"+
    "\1\7\2\0\1\71\2\0\2\71\5\0\3\7\1\0"+
    "\1\7\1\0\2\7\2\71\1\0\2\72\1\75\11\72"+
    "\1\71\2\0\1\72\2\74\1\72\1\74\1\72\1\71"+
    "\1\0\1\72\1\75\2\0\1\76\4\72\1\77\6\72"+
    "\2\0\1\7\1\0\2\72\1\75\1\77\1\7\2\0"+
    "\1\71\2\0\2\71\5\0\3\7\1\0\1\7\1\0"+
    "\2\7\2\71\1\0\2\72\1\75\11\72\1\71\2\0"+
    "\1\72\2\76\1\72\1\76\1\72\1\71\1\0\1\72"+
    "\1\75\2\0\1\7\4\72\1\77\6\72\2\0\1\7"+
    "\1\0\2\72\1\75\1\77\1\7\2\0\1\71\2\0"+
    "\2\71\5\0\3\7\1\0\1\7\1\0\2\7\2\71"+
    "\1\0\2\72\1\75\11\72\1\71\2\0\1\72\2\235"+
    "\1\72\1\235\1\72\1\71\1\0\2\72\2\0\1\7"+
    "\13\72\2\0\1\7\1\0\4\72\1\236\2\0\1\71"+
    "\2\0\2\71\5\0\1\7\1\236\1\7\1\0\1\7"+
    "\1\0\2\7\2\71\1\0\14\72\1\71\2\0\1\72"+
    "\4\237\1\72\1\71\1\0\1\72\1\237\2\0\1\7"+
    "\2\72\3\237\1\72\1\237\4\72\2\0\1\7\1\0"+
    "\2\72\2\237\1\7\2\0\1\71\2\0\2\71\5\0"+
    "\3\7\1\0\1\7\1\0\2\7\2\71\1\0\2\72"+
    "\1\237\11\72\3\0\6\7\2\0\1\240\1\7\2\0"+
    "\13\7\1\241\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\21\0\1\242"+
    "\107\0\1\243\110\0\1\244\65\0\6\7\2\0\2\7"+
    "\2\0\5\7\1\245\6\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\14\7"+
    "\3\0\6\7\2\0\2\7\2\0\13\7\1\246\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\5\7\1\247\6\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\10\7\1\250\3\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\1\7\1\251"+
    "\2\0\1\7\1\252\1\253\1\254\1\255\7\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\2\7\1\256\1\257\1\7\1\260\6\7"+
    "\3\0\6\7\2\0\2\7\2\0\12\7\1\261\1\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\1\7\1\111\12\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\14\7"+
    "\3\0\6\7\2\0\2\7\2\0\14\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\1\7\1\262\12\7\3\0\6\7\2\0\1\245"+
    "\1\7\2\0\10\7\1\263\1\7\1\137\1\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\12\7\1\264\1\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\4\7\1\265\1\7\1\266"+
    "\5\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\4\7\1\120\7\7\3\0"+
    "\6\7\2\0\1\267\1\7\2\0\14\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\14\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\1\7\1\270\12\7\3\0\6\7"+
    "\2\0\1\271\1\7\2\0\14\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\10\7\1\272"+
    "\3\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\3\7\1\120\10\7\3\0"+
    "\6\7\2\0\2\7\2\0\10\7\1\120\2\7\1\273"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\5\7\1\274\6\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\14\7"+
    "\3\0\6\7\2\0\2\7\2\0\1\7\1\275\1\120"+
    "\11\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\2\7\2\0\3\7\1\276\10\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\1\277\1\7\2\0\14\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\1\7\1\300\3\7\1\301\6\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\2\7"+
    "\1\302\11\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\2\7\2\0\14\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\2\7"+
    "\1\120\3\7\1\120\5\7\3\0\6\7\2\0\2\7"+
    "\2\0\6\7\1\303\5\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\14\7"+
    "\3\0\6\7\2\0\2\7\2\0\5\7\1\304\6\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\3\7\1\305\1\7\1\306\6\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\3\7"+
    "\1\50\10\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\5\7"+
    "\1\273\2\0\2\7\2\0\10\7\1\307\3\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\3\7\1\310\10\7\3\0\6\7\2\0"+
    "\2\7\2\0\4\7\1\311\7\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\1\7\1\312"+
    "\12\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\2\7\2\0\12\7\1\313\1\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\3\7\1\314"+
    "\1\7\1\315\6\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\5\7\1\316\2\0\2\7\2\0\14\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\6\7\1\317\5\7\3\0\6\7\2\0\2\7"+
    "\2\0\14\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\13\7\1\320\3\0"+
    "\6\7\2\0\2\7\2\0\14\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\3\7\1\321\10\7\3\0\6\7\2\0\1\322\1\7"+
    "\2\0\5\7\1\323\5\7\1\324\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\10\7\1\325"+
    "\3\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\2\7\2\0\14\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\1\7\1\326"+
    "\12\7\3\0\6\7\2\0\2\7\2\0\6\7\1\321"+
    "\5\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\2\7\2\0\14\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\3\7\1\327"+
    "\10\7\3\0\6\7\2\0\2\7\2\0\11\7\1\330"+
    "\2\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\11\7\1\275\2\7\3\0"+
    "\6\7\2\0\2\7\2\0\14\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\1\120\13\7\3\0\6\7\2\0\2\7\2\0\12\7"+
    "\1\331\1\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\2\7\2\0\6\7\1\332\5\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\6\7"+
    "\1\333\5\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\2\7\2\0\5\7\1\334\6\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\14\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\12\7\1\335\1\7\3\0\6\7"+
    "\2\0\2\7\2\0\6\7\1\172\5\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\1\7"+
    "\1\336\12\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\2\7\2\0\3\7\1\337\1\340\3\7\1\341"+
    "\3\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\1\7\1\342\12\7\3\0"+
    "\6\7\2\0\2\7\2\0\5\7\1\343\6\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\1\7\1\344\2\7\1\120\1\7\1\345\5\7\2\0"+
    "\1\7\1\0\4\7\1\346\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\5\7\1\347\6\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\14\7"+
    "\3\0\6\7\2\0\2\7\2\0\2\7\1\350\11\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\45\0\1\351\112\0\1\352"+
    "\36\0\1\34\13\0\2\34\1\201\24\0\1\34\11\0"+
    "\2\34\27\0\1\202\1\353\13\202\2\353\1\202\1\0"+
    "\34\202\2\353\1\354\27\202\3\0\6\7\2\0\2\7"+
    "\2\0\14\7\2\0\1\7\1\0\5\7\14\0\1\35"+
    "\2\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\1\355\1\7\2\0\14\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\5\7\1\356\2\0\2\7\2\0"+
    "\14\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\2\7\2\0\10\7\1\357\3\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\5\7\1\360\2\0\2\7\2\0\14\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\1\7\1\361\12\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\14\7"+
    "\3\0\6\7\2\0\2\7\2\0\14\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\1\7\1\362\12\7\3\0\6\7\2\0\1\363"+
    "\1\364\2\0\4\7\1\120\5\7\1\277\1\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\1\7\1\365\12\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\5\7\1\366\2\0\2\7\2\0\1\7\1\111\4\7"+
    "\1\367\5\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\2\7\2\0\2\7\1\267\11\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\13\7\1\370\3\0\6\7\2\0\1\250\1\7"+
    "\2\0\6\7\1\371\5\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\3\7"+
    "\1\372\10\7\3\0\6\7\2\0\2\7\2\0\10\7"+
    "\1\373\3\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\2\7\2\0\14\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\1\7"+
    "\1\374\12\7\3\0\6\7\2\0\2\7\2\0\12\7"+
    "\1\375\1\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\2\7\2\0\4\7\1\376\7\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\6\7"+
    "\1\120\1\7\1\377\3\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\14\7"+
    "\3\0\6\7\2\0\1\u0100\1\7\2\0\14\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\2\7\1\u0101\11\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\14\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\6\7\1\375\5\7\21\0\1\u0102\116\0\1\u0103\105\0"+
    "\1\u0104\103\0\1\u0105\61\0\1\71\2\0\1\72\2\235"+
    "\1\72\1\235\1\72\1\71\1\0\1\72\1\75\2\0"+
    "\1\7\13\72\2\0\1\7\1\0\2\72\1\75\1\72"+
    "\1\7\2\0\1\71\2\0\2\71\5\0\3\7\1\0"+
    "\1\7\1\0\2\7\2\71\1\0\2\72\1\75\11\72"+
    "\3\0\1\7\2\235\1\7\1\235\1\7\2\0\2\7"+
    "\2\0\14\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\1\71\2\0"+
    "\1\72\4\237\1\72\1\71\1\0\1\72\1\237\2\0"+
    "\1\7\2\72\3\237\1\72\1\237\2\72\1\234\1\72"+
    "\2\0\1\7\1\0\1\72\1\234\2\237\1\7\2\0"+
    "\1\71\2\0\2\71\5\0\3\7\1\0\1\7\1\0"+
    "\2\7\2\71\1\0\2\72\1\237\11\72\3\0\6\7"+
    "\2\0\2\7\2\0\5\7\1\u0106\6\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\10\7"+
    "\1\u0107\3\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\3\7\1\u0108\10\7"+
    "\22\0\1\u0109\112\0\1\103\110\0\1\u010a\61\0\6\7"+
    "\2\0\2\7\2\0\1\7\1\252\12\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\1\245\1\7\2\0"+
    "\14\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\2\7\2\0\14\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\4\7\1\120"+
    "\7\7\3\0\6\7\2\0\2\7\2\0\14\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\11\7\1\321\2\7\3\0\6\7\2\0"+
    "\2\7\2\0\5\7\1\50\6\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\6\7\1\120"+
    "\5\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\2\7\2\0\5\7\1\262\4\7\1\u010b\1\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\14\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\2\7\1\120\11\7\3\0"+
    "\5\7\1\u010c\2\0\2\7\2\0\14\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\5\7\1\u010d\2\0\2\7\2\0"+
    "\14\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\2\7\2\0\14\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\1\7\1\u010e"+
    "\12\7\3\0\6\7\2\0\2\7\2\0\5\7\1\u010f"+
    "\6\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\2\7\2\0\1\7\1\316\12\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\3\7\1\252"+
    "\10\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\2\7\2\0\14\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\2\7\1\u0110"+
    "\11\7\3\0\6\7\2\0\2\7\2\0\13\7\1\u0111"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\14\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\1\7\1\u0112\12\7"+
    "\3\0\6\7\2\0\2\7\2\0\14\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\1\7"+
    "\1\172\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\4\7\1\262\7\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\1\252\1\7\2\0\14\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\6\7"+
    "\1\u0113\5\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\2\7\2\0\4\7\1\120\7\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\10\7"+
    "\1\252\3\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\2\7\2\0\14\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\13\7"+
    "\1\120\3\0\6\7\2\0\2\7\2\0\14\7\2\0"+
    "\1\120\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\2\7\1\120\11\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\3\7\1\u0114\10\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\14\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\1\7\1\272\12\7\3\0"+
    "\6\7\2\0\2\7\2\0\6\7\1\u0115\5\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\12\7\1\u0116\1\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\6\7\1\120\1\7\1\u0117"+
    "\3\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\2\7\2\0\1\7\1\u0118\12\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\3\7\1\u0119"+
    "\10\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\2\7\2\0\1\7\1\u011a\2\7\1\262\7\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\2\7\1\172\5\7\1\120\3\7\3\0"+
    "\6\7\2\0\2\7\2\0\2\7\1\u011b\11\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\3\7\1\u011c\10\7\3\0\6\7\2\0"+
    "\2\7\2\0\12\7\1\321\1\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\5\7\1\u011d\2\0\2\7\2\0\14\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\14\7\2\0\1\120\1\0\4\7\1\u011e\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\12\7\1\120\1\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\1\u0114\1\7"+
    "\2\0\14\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\2\7\2\0\5\7\1\u011f\6\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\14\7"+
    "\2\0\1\7\1\0\4\7\1\u0120\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\2\7\2\0\5\7\1\u0121\6\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\5\7\1\120"+
    "\6\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\2\7\2\0\14\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\1\7\1\u0122"+
    "\12\7\3\0\6\7\2\0\2\7\2\0\14\7\2\0"+
    "\1\7\1\0\4\7\1\u0123\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\1\7\1\u0124\12\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\14\7"+
    "\3\0\6\7\2\0\2\7\2\0\14\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\2\7\1\u0125\11\7\3\0\6\7\2\0\2\7"+
    "\2\0\12\7\1\u0126\1\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\14\7"+
    "\3\0\6\7\2\0\2\7\2\0\5\7\1\u0127\6\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\12\7\1\u0128\1\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\14\7"+
    "\3\0\6\7\2\0\2\7\2\0\14\7\2\0\1\7"+
    "\1\0\4\7\1\u0129\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\14\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\1\u012a\13\7\3\0\6\7"+
    "\2\0\2\7\2\0\10\7\1\u012b\3\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\14\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\6\7\1\u012c\5\7\3\0\6\7"+
    "\2\0\2\7\2\0\6\7\1\u012d\5\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\14\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\2\7\1\u012e\11\7\3\0\6\7"+
    "\2\0\2\7\2\0\14\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\13\7"+
    "\1\u0125\3\0\6\7\2\0\2\7\2\0\14\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\11\7\1\120\2\7\3\0\6\7\2\0"+
    "\2\7\2\0\2\7\1\172\11\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\1\u012f\1\7\2\0\14\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\6\7\1\u0130\5\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\14\7"+
    "\3\0\6\7\2\0\2\7\2\0\14\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\1\7\1\u0131\12\7\3\0\6\7\2\0\2\7"+
    "\2\0\10\7\1\u0132\3\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\14\7"+
    "\3\0\6\7\2\0\2\7\2\0\10\7\1\u0133\3\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\12\7\1\u0134\1\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\1\7"+
    "\1\270\12\7\46\0\1\u0135\105\0\1\u0136\44\0\6\7"+
    "\2\0\2\7\2\0\13\7\1\u0137\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\1\u0138\1\7\2\0\14\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\14\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\120\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\2\7\2\0\6\7\1\357\5\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\14\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\1\u0139\13\7\3\0\6\7\2\0"+
    "\2\7\2\0\2\7\1\u0121\11\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\5\7\1\u013a"+
    "\6\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\2\7\2\0\10\7\1\172\3\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\3\7\1\u013b\10\7\3\0\6\7\2\0\2\7\2\0"+
    "\1\7\1\300\12\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\7\7\1\311\4\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\13\7\1\u013c\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\2\7\2\0\5\7\1\u013d\6\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\3\7"+
    "\1\120\10\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\1\7\1\u013e\2\0\14\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\13\7\1\u013f"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\6\7\1\u0140\5\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\14\7"+
    "\3\0\6\7\2\0\2\7\2\0\1\7\1\120\12\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\6\7\1\u0141\5\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\14\7"+
    "\3\0\6\7\2\0\2\7\2\0\1\7\1\u0142\12\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\14\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\1\7\1\275\12\7"+
    "\3\0\6\7\2\0\2\7\2\0\14\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\3\7\1\132\10\7\2\0\1\u0143\130\0\1\u0102"+
    "\101\0\1\u0144\110\0\1\u0145\70\0\6\7\2\0\1\7"+
    "\1\303\2\0\14\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\6\7\1\u0146\5\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\2\7\1\124\11\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\23\0"+
    "\1\u0147\114\0\1\u0148\60\0\6\7\2\0\2\7\2\0"+
    "\13\7\1\u0149\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\1\172\1\7\2\0\14\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\4\7\1\321"+
    "\7\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\2\7\2\0\14\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\5\7\1\u014a"+
    "\6\7\3\0\6\7\2\0\1\u014b\1\7\2\0\14\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\14\7\2\0\1\7\1\0\4\7\1\u014c\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\6\7\1\u014d\5\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\10\7\1\254\3\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\5\7\1\u014e\6\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\14\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\6\7\1\120\5\7\3\0"+
    "\6\7\2\0\2\7\2\0\14\7\2\0\1\7\1\0"+
    "\4\7\1\u014f\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\6\7"+
    "\1\u0150\5\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\2\7\2\0\1\7\1\172\12\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\1\u0151\1\7\2\0"+
    "\14\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\2\7\2\0\6\7\1\u0152\5\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\12\7\1\u0134"+
    "\1\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\5\7\1\156"+
    "\2\0\2\7\2\0\14\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\14\7"+
    "\3\0\6\7\2\0\1\321\1\7\2\0\14\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\1\u0153\1\7"+
    "\2\0\14\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\1\7\1\u0154\2\0\14\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\14\7\2\0"+
    "\1\7\1\0\4\7\1\u0155\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\11\7\1\172\2\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\14\7"+
    "\3\0\6\7\2\0\2\7\2\0\14\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\5\7\1\u0156\6\7\3\0\6\7\2\0\1\7"+
    "\1\u0157\2\0\14\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\13\7\1\u0158\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\5\7"+
    "\1\u0159\6\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\2\7\2\0\1\7\1\u015a\12\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\13\7"+
    "\1\u015b\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\2\7\2\0\3\7\1\u015c\1\7\1\u015d\6\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\14\7\2\0\1\7\1\0\4\7\1\u015e\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\2\7\2\0\14\7\2\0\1\7\1\0\4\7"+
    "\1\u015f\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\14\7\2\0"+
    "\1\7\1\0\4\7\1\u0160\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\14\7\2\0\1\7\1\0\4\7\1\u0161\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\3\7\1\156\10\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\3\7\1\u0162\10\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\14\7\2\0\1\7\1\0"+
    "\4\7\1\u0163\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\3\7"+
    "\1\u0164\10\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\2\7\2\0\6\7\1\u0165\5\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\5\7"+
    "\1\u0166\6\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\47\0\1\34"+
    "\107\0\1\u0135\41\0\6\7\2\0\2\7\2\0\10\7"+
    "\1\u0167\3\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\1\u0168\1\7\2\0\14\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\14\7\2\0"+
    "\1\7\1\0\4\7\1\u0101\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\1\7"+
    "\1\120\2\0\14\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\5\7\1\u0169\2\0\2\7\2\0\3\7\1\u016a\1\7"+
    "\1\u016b\6\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\2\7\2\0\14\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\3\7"+
    "\1\u016c\10\7\3\0\6\7\2\0\2\7\2\0\14\7"+
    "\2\0\1\7\1\0\4\7\1\u016d\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\2\7\2\0\10\7\1\120\3\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\6\7\1\u016e"+
    "\5\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\2\7\2\0\5\7\1\172\6\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\14\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\1\7\1\50\12\7\3\0\6\7\2\0"+
    "\2\7\2\0\14\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\6\7\1\u016f"+
    "\5\7\66\0\1\u0170\21\0\2\u0171\6\u0144\1\0\1\u0171"+
    "\2\u0144\2\0\1\u0171\13\u0144\1\u0171\1\0\1\u0171\1\0"+
    "\4\u0144\2\u0171\2\0\4\u0171\6\0\1\u0171\1\0\3\u0171"+
    "\1\u0144\2\u0171\1\u0144\1\u0171\14\u0144\2\0\1\u0143\15\0"+
    "\1\u0102\71\0\6\7\2\0\2\7\2\0\5\7\1\u0172"+
    "\6\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\24\0\1\103\114\0"+
    "\1\u0173\57\0\6\7\2\0\2\7\2\0\4\7\1\u012f"+
    "\7\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\2\7\2\0\5\7\1\u0174\6\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\1\7\1\321"+
    "\12\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\2\7\2\0\14\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\5\7\1\142"+
    "\6\7\3\0\6\7\2\0\2\7\2\0\14\7\2\0"+
    "\1\7\1\0\4\7\1\u0175\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\14\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\2\7\1\u0176\11\7"+
    "\3\0\6\7\2\0\1\7\1\u0177\2\0\1\7\1\u0178"+
    "\5\7\1\u0179\2\7\1\u017a\1\273\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\2\7\1\u017b\11\7\3\0\6\7\2\0\2\7\2\0"+
    "\14\7\2\0\1\7\1\0\4\7\1\u017c\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\2\7\2\0\14\7\2\0\1\7\1\0\4\7"+
    "\1\u017d\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\3\7\1\u017e"+
    "\10\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\2\7\2\0\5\7\1\u017f\6\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\13\7\1\u0180"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\11\7\1\u0181\2\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\14\7"+
    "\3\0\6\7\2\0\2\7\2\0\3\7\1\u010c\10\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\10\7\1\172\3\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\14\7"+
    "\3\0\6\7\2\0\2\7\2\0\10\7\1\341\3\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\3\7\1\u013e\10\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\14\7"+
    "\3\0\6\7\2\0\2\7\2\0\2\7\1\u0182\11\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\10\7\1\321\3\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\14\7"+
    "\3\0\6\7\2\0\2\7\2\0\10\7\1\u0114\3\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\14\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\5\7\1\u0183\6\7"+
    "\3\0\6\7\2\0\2\7\2\0\14\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\3\7\1\u0184\10\7\3\0\6\7\2\0\2\7"+
    "\2\0\10\7\1\u0185\3\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\14\7"+
    "\3\0\6\7\2\0\2\7\2\0\4\7\1\u0186\7\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\1\7"+
    "\1\u0187\2\0\14\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\10\7\1\u0188\3\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\3\7\1\u0189\10\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\14\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\3\7\1\u018a\10\7\3\0\6\7\2\0\2\7\2\0"+
    "\13\7\1\u018b\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\2\7\2\0\14\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\3\7"+
    "\1\u018c\10\7\3\0\6\7\2\0\2\7\2\0\6\7"+
    "\1\u018d\5\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\2\7\2\0\5\7\1\u018e\6\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\12\7"+
    "\1\u018f\1\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\2\7\2\0\4\7\1\u0190\7\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\6\7"+
    "\1\u0191\5\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\2\7\2\0\5\7\1\u0192\6\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\2\7"+
    "\1\u0193\1\u0189\10\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\14\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\1\7\1\u0194\12\7\3\0\6\7\2\0\2\7\2\0"+
    "\14\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\3\7\1\120\10\7\66\0"+
    "\1\u0144\23\0\6\7\2\0\1\u013e\1\7\2\0\14\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\27\0\1\u0147\62\0\6\7"+
    "\2\0\2\7\2\0\14\7\2\0\1\7\1\0\4\7"+
    "\1\u0195\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\3\7\1\252"+
    "\5\7\1\u0196\2\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\14\7\2\0\1\7\1\0"+
    "\4\7\1\u0197\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\12\7"+
    "\1\116\1\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\2\7\2\0\14\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\1\124"+
    "\13\7\3\0\6\7\2\0\2\7\2\0\14\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\1\7\1\155\4\7\1\156\5\7\3\0"+
    "\6\7\2\0\2\7\2\0\14\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\1\7\1\u0158\12\7\3\0\6\7\2\0\2\7\2\0"+
    "\14\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\1\7\1\u0198\12\7\3\0"+
    "\6\7\2\0\2\7\2\0\5\7\1\u0199\6\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\1\7\1\u013a\12\7\3\0\6\7\2\0"+
    "\2\7\2\0\3\7\1\u019a\10\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\10\7\1\u019b"+
    "\3\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\1\7\1\275\2\0\14\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\14\7"+
    "\3\0\6\7\2\0\2\7\2\0\10\7\1\u019c\3\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\14\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\1\u0187\13\7\3\0"+
    "\6\7\2\0\2\7\2\0\3\7\1\u010d\10\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\5\7\1\315\6\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\5\7\1\u019d\6\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\14\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\1\7\1\252\12\7\3\0"+
    "\6\7\2\0\2\7\2\0\14\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\1\7\1\u019e\12\7\3\0\6\7\2\0\2\7\2\0"+
    "\13\7\1\311\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\2\7\2\0\4\7\1\u019f\7\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\1\133\1\7\2\0"+
    "\14\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\2\7\2\0\5\7\1\u01a0\6\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\6\7\1\u0114"+
    "\5\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\2\7\2\0\5\7\1\273\6\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\14\7\2\0"+
    "\1\7\1\0\4\7\1\u01a1\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\10\7\1\u01a2\3\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\14\7"+
    "\3\0\6\7\2\0\2\7\2\0\6\7\1\u01a3\5\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\1\u01a4"+
    "\1\7\2\0\14\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\14\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\1\u01a5\13\7\3\0\6\7\2\0\1\u01a6\1\7\2\0"+
    "\14\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\1\u01a7\1\7\2\0\14\7\2\0\1\7\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\14\7"+
    "\3\0\6\7\2\0\2\7\2\0\14\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\3\7\1\u01a8\10\7\3\0\6\7\2\0\2\7"+
    "\2\0\13\7\1\u01a9\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\14\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\3\7\1\u01aa\10\7\3\0\5\7\1\366\2\0\2\7"+
    "\2\0\14\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\1\u01ab\1\7\2\0\14\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\14\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\11\7\1\u01ac\2\7\3\0\6\7\2\0"+
    "\2\7\2\0\6\7\1\u01ad\5\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\3\7\1\u01ae"+
    "\10\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\2\7\2\0\6\7\1\371\5\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\10\7\1\u0192"+
    "\3\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\14\7\3\0\6\7\2\0"+
    "\2\7\2\0\5\7\1\u01af\6\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\14\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\3\7\1\u01b0\10\7\3\0\6\7\2\0"+
    "\2\7\2\0\6\7\1\u01b1\5\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\13\7\1\120"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\14\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\1\7\1\172\12\7"+
    "\3\0\6\7\2\0\2\7\2\0\14\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\1\7\1\254\12\7\3\0\6\7\2\0\2\7"+
    "\2\0\14\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\1\7\1\u01b2\12\7"+
    "\3\0\6\7\2\0\2\7\2\0\14\7\2\0\1\7"+
    "\1\0\4\7\1\u01b3\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\5\7\1\u016b\6\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\6\7\1\161\5\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\3\7\1\u01b4\10\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\1\u01b5\1\7\2\0\14\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\5\7"+
    "\1\u01b6\6\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\2\7\2\0\12\7\1\u0114\1\7\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\12\7"+
    "\1\u01b7\1\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\2\7\2\0\14\7\2\0\1\172\1\0\5\7"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\14\7"+
    "\3\0\6\7\2\0\2\7\2\0\5\7\1\u01b8\6\7"+
    "\2\0\1\7\1\0\5\7\14\0\3\7\1\0\1\7"+
    "\1\0\2\7\3\0\14\7\3\0\6\7\2\0\2\7"+
    "\2\0\14\7\2\0\1\7\1\0\4\7\1\u01b9\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\14\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\7\7\1\u0114\4\7\3\0\6\7\2\0\2\7\2\0"+
    "\5\7\1\u01ba\6\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\2\7\1\u01bb\11\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\14\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\1\7\1\u01bc\12\7\3\0"+
    "\6\7\2\0\2\7\2\0\10\7\1\u01bd\3\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\12\7\1\u01be\1\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\6\7\1\u01bf\5\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\10\7\1\u01c0\3\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\10\7\1\u01c1\3\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\7\7\1\u01c2\4\7\3\0\6\7\2\0"+
    "\2\7\2\0\14\7\2\0\1\7\1\0\4\7\1\u01c3"+
    "\14\0\3\7\1\0\1\7\1\0\2\7\3\0\14\7"+
    "\3\0\6\7\2\0\1\u0192\1\7\2\0\14\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\6\7\1\u01c4\5\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\14\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\6\7\1\172\5\7\3\0\6\7\2\0\2\7\2\0"+
    "\3\7\1\u01c5\10\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\3\7\1\u01c6\10\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\6\7\1\u01c7\5\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\13\7\1\167\2\0\1\7"+
    "\1\0\5\7\14\0\3\7\1\0\1\7\1\0\2\7"+
    "\3\0\14\7\3\0\6\7\2\0\2\7\2\0\7\7"+
    "\1\u0114\4\7\2\0\1\7\1\0\5\7\14\0\3\7"+
    "\1\0\1\7\1\0\2\7\3\0\14\7\3\0\6\7"+
    "\2\0\2\7\2\0\14\7\2\0\1\7\1\0\4\7"+
    "\1\u01c8\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\14\7\3\0\6\7\2\0\2\7\2\0\14\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\u01c9\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\14\7\2\0\1\7\1\0\5\7\14\0\3\7\1\0"+
    "\1\7\1\0\2\7\3\0\3\7\1\u01ca\10\7\3\0"+
    "\6\7\2\0\2\7\2\0\5\7\1\u010c\6\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\5\7\1\u0199\6\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\14\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\2\7\1\u01cb\11\7\3\0\6\7\2\0\2\7\2\0"+
    "\5\7\1\u01cc\6\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\14\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\1\7\1\u01cd\12\7\3\0\6\7\2\0\2\7\2\0"+
    "\1\7\1\u01ce\12\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\6\7\1\u01cf\5\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\2\7\1\u01d0\11\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\14\7\2\0\1\7\1\0"+
    "\5\7\14\0\3\7\1\0\1\7\1\0\2\7\3\0"+
    "\1\7\1\120\12\7\3\0\6\7\2\0\2\7\2\0"+
    "\3\7\1\u01d1\10\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7\3\0"+
    "\6\7\2\0\2\7\2\0\4\7\1\u01d2\7\7\2\0"+
    "\1\7\1\0\5\7\14\0\3\7\1\0\1\7\1\0"+
    "\2\7\3\0\14\7\3\0\6\7\2\0\2\7\2\0"+
    "\5\7\1\357\6\7\2\0\1\7\1\0\5\7\14\0"+
    "\3\7\1\0\1\7\1\0\2\7\3\0\14\7";

  private static int [] zzUnpackTrans() {
    int [] result = new int[31311];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\1\2\0\2\11\10\1\2\11\14\1\1\11\4\1"+
    "\1\11\17\1\1\11\3\1\1\11\15\1\1\11\3\0"+
    "\70\1\4\0\24\1\1\11\4\0\6\1\3\0\104\1"+
    "\2\0\1\11\26\1\4\0\3\1\2\0\52\1\2\0"+
    "\14\1\1\0\1\1\1\0\1\1\2\0\47\1\2\0"+
    "\1\1\1\0\137\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[466];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */


	/**
	 * Constructor.  This must be here because JFlex does not generate a
	 * no-parameter constructor.
	 */
	public ClojureTokenMaker() {
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 * @see #addToken(int, int, int)
	 */
	private void addHyperlinkToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so, true);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 * @see #addHyperlinkToken(int, int, int)
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so, false);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 * @param hyperlink Whether this token is a hyperlink.
	 */
	public void addToken(char[] array, int start, int end, int tokenType,
						int startOffset, boolean hyperlink) {
		super.addToken(array, start,end, tokenType, startOffset, hyperlink);
		zzStartRead = zzMarkedPos;
	}


	/**
	 * Returns the text to place at the beginning and end of a
	 * line to "comment" it in a this programming language.
	 *
	 * @return The start and end strings to add to a line to "comment"
	 *         it out.
	 */
	public String[] getLineCommentStartAndEnd() {
		return new String[] { ";", null };
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *        <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;

		// Start off in the proper state.
		int state = Token.NULL;
		switch (initialTokenType) {
			/*case Token.COMMENT_MULTILINE:
				state = MLC;
				start = text.offset;
				break;
			case Token.COMMENT_DOCUMENTATION:
				state = DOCCOMMENT;
				start = text.offset;
				break;*/
			case Token.LITERAL_STRING_DOUBLE_QUOTE:
				state = STRING;
				start = text.offset;
				break;
			default:
				state = Token.NULL;
		}

		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new DefaultToken();
		}

	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 * @exception   IOException  if any I/O-Error occurs.
	 */
	private boolean zzRefill() throws java.io.IOException {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream
	 */
	public final void yyreset(java.io.Reader reader) throws java.io.IOException {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtEOF  = false;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public ClojureTokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public ClojureTokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 160) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 14: 
          { addToken(Token.PREPROCESSOR);
          }
        case 24: break;
        case 6: 
          { addNullToken(); return firstToken;
          }
        case 25: break;
        case 18: 
          { addToken(Token.LITERAL_CHAR);
          }
        case 26: break;
        case 9: 
          { addToken(Token.WHITESPACE);
          }
        case 27: break;
        case 16: 
          { addToken(Token.LITERAL_NUMBER_HEXADECIMAL);
          }
        case 28: break;
        case 17: 
          { addToken(Token.LITERAL_NUMBER_FLOAT);
          }
        case 29: break;
        case 19: 
          { addToken(Token.RESERVED_WORD);
          }
        case 30: break;
        case 8: 
          { addToken(Token.SEPARATOR);
          }
        case 31: break;
        case 1: 
          { addToken(Token.IDENTIFIER);
          }
        case 32: break;
        case 13: 
          { addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
          }
        case 33: break;
        case 20: 
          { addToken(Token.FUNCTION);
          }
        case 34: break;
        case 21: 
          { addToken(Token.DATA_TYPE);
          }
        case 35: break;
        case 2: 
          { addToken(Token.ERROR_IDENTIFIER);
          }
        case 36: break;
        case 22: 
          { addToken(Token.LITERAL_BOOLEAN);
          }
        case 37: break;
        case 11: 
          { addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); return firstToken;
          }
        case 38: break;
        case 23: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_EOL); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_EOL); start = zzMarkedPos;
          }
        case 39: break;
        case 15: 
          { addToken(Token.ERROR_NUMBER_FORMAT);
          }
        case 40: break;
        case 7: 
          { start = zzMarkedPos-1; yybegin(STRING);
          }
        case 41: break;
        case 3: 
          { start = zzMarkedPos-1; yybegin(EOL_COMMENT);
          }
        case 42: break;
        case 5: 
          { addToken(Token.LITERAL_NUMBER_DECIMAL_INT);
          }
        case 43: break;
        case 4: 
          { addToken(Token.OPERATOR);
          }
        case 44: break;
        case 12: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead, Token.LITERAL_STRING_DOUBLE_QUOTE);
          }
        case 45: break;
        case 10: 
          { 
          }
        case 46: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case EOL_COMMENT: {
              addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
            }
            case 467: break;
            case STRING: {
              addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); return firstToken;
            }
            case 468: break;
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 469: break;
            default:
            return null;
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
