/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ListCellRenderer;
import org.fife.rsta.ac.LanguageSupport;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public abstract class AbstractLanguageSupport
implements LanguageSupport {
    private Map textAreaToAutoCompletion;
    private boolean autoCompleteEnabled;
    private boolean autoActivationEnabled;
    private int autoActivationDelay;
    private boolean parameterAssistanceEnabled;
    private boolean showDescWindow;
    private ListCellRenderer renderer;

    protected AbstractLanguageSupport() {
        this.setDefaultCompletionCellRenderer(null);
        this.textAreaToAutoCompletion = new HashMap();
        this.autoCompleteEnabled = true;
        this.autoActivationEnabled = false;
        this.autoActivationDelay = 300;
    }

    protected AutoCompletion createAutoCompletion(CompletionProvider p) {
        AutoCompletion ac = new AutoCompletion(p);
        ac.setListCellRenderer(this.getDefaultCompletionCellRenderer());
        ac.setAutoCompleteEnabled(this.isAutoCompleteEnabled());
        ac.setAutoActivationEnabled(this.isAutoActivationEnabled());
        ac.setAutoActivationDelay(this.getAutoActivationDelay());
        ac.setParameterAssistanceEnabled(this.isParameterAssistanceEnabled());
        ac.setShowDescWindow(this.getShowDescWindow());
        return ac;
    }

    protected ListCellRenderer createDefaultCompletionCellRenderer() {
        return new DefaultListCellRenderer();
    }

    public int getAutoActivationDelay() {
        return this.autoActivationDelay;
    }

    protected AutoCompletion getAutoCompletionFor(RSyntaxTextArea textArea) {
        return (AutoCompletion)this.textAreaToAutoCompletion.get(textArea);
    }

    public ListCellRenderer getDefaultCompletionCellRenderer() {
        return this.renderer;
    }

    public boolean getShowDescWindow() {
        return this.showDescWindow;
    }

    protected Set getTextAreas() {
        return this.textAreaToAutoCompletion.keySet();
    }

    protected void installImpl(RSyntaxTextArea textArea, AutoCompletion ac) {
        this.textAreaToAutoCompletion.put(textArea, ac);
    }

    public boolean isAutoActivationEnabled() {
        return this.autoActivationEnabled;
    }

    public boolean isAutoCompleteEnabled() {
        return this.autoCompleteEnabled;
    }

    public boolean isParameterAssistanceEnabled() {
        return this.parameterAssistanceEnabled;
    }

    public void setAutoActivationDelay(int ms) {
        if ((ms = Math.max(0, ms)) != this.autoActivationDelay) {
            this.autoActivationDelay = ms;
            Iterator i = this.textAreaToAutoCompletion.values().iterator();
            while (i.hasNext()) {
                AutoCompletion ac = (AutoCompletion)i.next();
                ac.setAutoActivationDelay(this.autoActivationDelay);
            }
        }
    }

    public void setAutoActivationEnabled(boolean enabled) {
        if (enabled != this.autoActivationEnabled) {
            this.autoActivationEnabled = enabled;
            Iterator i = this.textAreaToAutoCompletion.values().iterator();
            while (i.hasNext()) {
                AutoCompletion ac = (AutoCompletion)i.next();
                ac.setAutoActivationEnabled(enabled);
            }
        }
    }

    public void setAutoCompleteEnabled(boolean enabled) {
        if (enabled != this.autoCompleteEnabled) {
            this.autoCompleteEnabled = enabled;
            Iterator i = this.textAreaToAutoCompletion.values().iterator();
            while (i.hasNext()) {
                AutoCompletion ac = (AutoCompletion)i.next();
                ac.setAutoCompleteEnabled(enabled);
            }
        }
    }

    public void setDefaultCompletionCellRenderer(ListCellRenderer r) {
        if (r == null) {
            r = this.createDefaultCompletionCellRenderer();
        }
        this.renderer = r;
    }

    public void setParameterAssistanceEnabled(boolean enabled) {
        if (enabled != this.parameterAssistanceEnabled) {
            this.parameterAssistanceEnabled = enabled;
            Iterator i = this.textAreaToAutoCompletion.values().iterator();
            while (i.hasNext()) {
                AutoCompletion ac = (AutoCompletion)i.next();
                ac.setParameterAssistanceEnabled(enabled);
            }
        }
    }

    public void setShowDescWindow(boolean show) {
        if (show != this.showDescWindow) {
            this.showDescWindow = show;
            Iterator i = this.textAreaToAutoCompletion.values().iterator();
            while (i.hasNext()) {
                AutoCompletion ac = (AutoCompletion)i.next();
                ac.setShowDescWindow(show);
            }
        }
    }

    protected void uninstallImpl(RSyntaxTextArea textArea) {
        AutoCompletion ac = this.getAutoCompletionFor(textArea);
        if (ac != null) {
            ac.uninstall();
        }
        this.textAreaToAutoCompletion.remove(textArea);
    }
}

