/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jsonSchema.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.types.AdditionalItemsDeserializer;
import com.fasterxml.jackson.module.jsonSchema.types.ContainerTypeSchema;
import java.util.Map;

public class ArraySchema
extends ContainerTypeSchema {
    @JsonProperty
    private AdditionalItems additionalItems;
    @JsonProperty
    private Items items;
    @JsonProperty
    private Integer maxItems;
    @JsonProperty
    private Integer minItems;
    @JsonProperty
    private Boolean uniqueItems = null;

    @Override
    public ArraySchema asArraySchema() {
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ArraySchema) {
            ArraySchema that = (ArraySchema)obj;
            return ArraySchema.equals(this.getAdditionalItems(), that.getAdditionalItems()) && ArraySchema.equals(this.getItems(), that.getItems()) && ArraySchema.equals(this.getMaxItems(), that.getMaxItems()) && ArraySchema.equals(this.getMinItems(), that.getMinItems()) && ArraySchema.equals(this.getUniqueItems(), that.getUniqueItems()) && super.equals(obj);
        }
        return false;
    }

    public AdditionalItems getAdditionalItems() {
        return this.additionalItems;
    }

    public Items getItems() {
        return this.items;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    @Override
    public JsonFormatTypes getType() {
        return JsonFormatTypes.ARRAY;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    @Override
    public boolean isArraySchema() {
        return true;
    }

    public void setAdditionalItems(AdditionalItems additionalItems) {
        this.additionalItems = additionalItems;
    }

    public void setItems(Items items) {
        this.items = items;
    }

    public void setItemsSchema(JsonSchema jsonSchema) {
        this.items = new SingleItems(jsonSchema);
    }

    public void setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
    }

    public void setMinItems(Integer minItems) {
        this.minItems = minItems;
    }

    public void setUniqueItems(Boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
    }

    public static class SingleItems
    extends Items {
        @JsonIgnore
        private JsonSchema jsonSchema;

        public SingleItems(JsonSchema jsonSchema) {
            this.jsonSchema = jsonSchema;
        }

        public boolean equals(Object obj) {
            return obj instanceof SingleItems && ArraySchema.equals(this.getSchema(), ((SingleItems)obj).getSchema());
        }

        @JsonValue
        public JsonSchema getSchema() {
            return this.jsonSchema;
        }

        public void setSchema(JsonSchema jsonSchema) {
            this.jsonSchema = jsonSchema;
        }

        @Override
        public boolean isSingleItems() {
            return true;
        }

        @Override
        public SingleItems asSingleItems() {
            return this;
        }
    }

    public static class SchemaAdditionalItems
    extends AdditionalItems {
        @JsonIgnore
        private JsonSchema jsonSchema;

        public SchemaAdditionalItems(JsonSchema schema) {
            this.jsonSchema = schema;
        }

        public boolean equals(Object obj) {
            return obj instanceof SchemaAdditionalItems && ArraySchema.equals(this.getJsonSchema(), ((SchemaAdditionalItems)obj).getJsonSchema());
        }

        @JsonValue
        public JsonSchema getJsonSchema() {
            return this.jsonSchema;
        }
    }

    public static class NoAdditionalItems
    extends AdditionalItems {
        public boolean equals(Object obj) {
            return obj instanceof NoAdditionalItems;
        }

        @JsonValue
        public Boolean value() {
            return false;
        }
    }

    public static abstract class Items {
        @JsonIgnore
        public boolean isSingleItems() {
            return false;
        }

        @JsonIgnore
        public boolean isArrayItems() {
            return false;
        }

        public SingleItems asSingleItems() {
            return null;
        }

        public ArrayItems asArrayItems() {
            return null;
        }

        @JsonCreator
        public static Items jsonCreator(Map<String, Object> props) {
            Object typeFound = props.get("type");
            if (typeFound == null || !(typeFound instanceof String)) {
                return null;
            }
            String type = (String)typeFound;
            JsonSchema schema = JsonSchema.minimalForFormat(JsonFormatTypes.forValue((String)type));
            return new SingleItems(schema);
        }
    }

    public static class ArrayItems
    extends Items {
        @JsonProperty
        private JsonSchema[] jsonSchemas;

        @Override
        public ArrayItems asArrayItems() {
            return this;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Items) {
                ArrayItems that = (ArrayItems)obj;
                return ArraySchema.equals(this.getJsonSchemas(), that.getJsonSchemas());
            }
            return false;
        }

        public JsonSchema[] getJsonSchemas() {
            return this.jsonSchemas;
        }

        @Override
        public boolean isArrayItems() {
            return true;
        }
    }

    @JsonDeserialize(using=AdditionalItemsDeserializer.class)
    public static abstract class AdditionalItems {
        @JsonCreator
        public static Items jsonCreator(Map<String, Object> props) {
            return null;
        }
    }
}

