/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.admin.api;

import com.docusign.admin.client.ApiClient;
import com.docusign.admin.client.ApiException;
import com.docusign.admin.client.ApiResponse;
import com.docusign.admin.client.Configuration;
import com.docusign.admin.client.Pair;
import com.docusign.admin.model.AddUserResponse;
import com.docusign.admin.model.DeleteMembershipsRequest;
import com.docusign.admin.model.DeleteMembershipsResponse;
import com.docusign.admin.model.DeleteResponse;
import com.docusign.admin.model.DeleteUserIdentityRequest;
import com.docusign.admin.model.ForceActivateMembershipRequest;
import com.docusign.admin.model.NewAccountUserRequest;
import com.docusign.admin.model.NewMultiProductUserAddRequest;
import com.docusign.admin.model.NewUserRequest;
import com.docusign.admin.model.NewUserResponse;
import com.docusign.admin.model.OrganizationUsersResponse;
import com.docusign.admin.model.UpdateResponse;
import com.docusign.admin.model.UpdateUsersEmailRequest;
import com.docusign.admin.model.UpdateUsersRequest;
import com.docusign.admin.model.UsersDrilldownResponse;
import com.docusign.admin.model.UsersUpdateResponse;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;

public class UsersApi {
    private ApiClient apiClient;

    public UsersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UsersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public UpdateResponse activateMembership(UUID organizationId, UUID userId, UUID membershipId, ForceActivateMembershipRequest request) throws ApiException {
        ApiResponse<UpdateResponse> localVarResponse = this.activateMembershipWithHttpInfo(organizationId, userId, membershipId, request);
        return localVarResponse.getData();
    }

    public ApiResponse<UpdateResponse> activateMembershipWithHttpInfo(UUID organizationId, UUID userId, UUID membershipId, ForceActivateMembershipRequest request) throws ApiException {
        ForceActivateMembershipRequest localVarPostBody = request;
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling activateMembership");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling activateMembership");
        }
        if (membershipId == null) {
            throw new ApiException(400, "Missing the required parameter 'membershipId' when calling activateMembership");
        }
        if (request == null) {
            throw new ApiException(400, "Missing the required parameter 'request' when calling activateMembership");
        }
        String localVarPath = "/v2/organizations/{organizationId}/users/{userId}/memberships/{membershipId}".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{membershipId\\}", this.apiClient.escapeString(membershipId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UpdateResponse> localVarReturnType = new GenericType<UpdateResponse>(){};
        UpdateResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<UpdateResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public AddUserResponse addOrUpdateUser(UUID organizationId, UUID accountId, NewMultiProductUserAddRequest request) throws ApiException {
        ApiResponse<AddUserResponse> localVarResponse = this.addOrUpdateUserWithHttpInfo(organizationId, accountId, request);
        return localVarResponse.getData();
    }

    public ApiResponse<AddUserResponse> addOrUpdateUserWithHttpInfo(UUID organizationId, UUID accountId, NewMultiProductUserAddRequest request) throws ApiException {
        NewMultiProductUserAddRequest localVarPostBody = request;
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling addOrUpdateUser");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling addOrUpdateUser");
        }
        if (request == null) {
            throw new ApiException(400, "Missing the required parameter 'request' when calling addOrUpdateUser");
        }
        String localVarPath = "/v2.1/organizations/{organizationId}/accounts/{accountId}/users".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<AddUserResponse> localVarReturnType = new GenericType<AddUserResponse>(){};
        AddUserResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<AddUserResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public NewUserResponse addUsers(UUID organizationId, UUID accountId, NewAccountUserRequest request) throws ApiException {
        ApiResponse<NewUserResponse> localVarResponse = this.addUsersWithHttpInfo(organizationId, accountId, request);
        return localVarResponse.getData();
    }

    public ApiResponse<NewUserResponse> addUsersWithHttpInfo(UUID organizationId, UUID accountId, NewAccountUserRequest request) throws ApiException {
        NewAccountUserRequest localVarPostBody = request;
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling addUsers");
        }
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling addUsers");
        }
        if (request == null) {
            throw new ApiException(400, "Missing the required parameter 'request' when calling addUsers");
        }
        String localVarPath = "/v2/organizations/{organizationId}/accounts/{accountId}/users".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<NewUserResponse> localVarReturnType = new GenericType<NewUserResponse>(){};
        NewUserResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<NewUserResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DeleteMembershipsResponse closeMemberships(UUID organizationId, UUID userId, DeleteMembershipsRequest request) throws ApiException {
        ApiResponse<DeleteMembershipsResponse> localVarResponse = this.closeMembershipsWithHttpInfo(organizationId, userId, request);
        return localVarResponse.getData();
    }

    public ApiResponse<DeleteMembershipsResponse> closeMembershipsWithHttpInfo(UUID organizationId, UUID userId, DeleteMembershipsRequest request) throws ApiException {
        DeleteMembershipsRequest localVarPostBody = request;
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling closeMemberships");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling closeMemberships");
        }
        if (request == null) {
            throw new ApiException(400, "Missing the required parameter 'request' when calling closeMemberships");
        }
        String localVarPath = "/v2/organizations/{organizationId}/users/{userId}/accounts".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DeleteMembershipsResponse> localVarReturnType = new GenericType<DeleteMembershipsResponse>(){};
        DeleteMembershipsResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DeleteMembershipsResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public NewUserResponse createUser(UUID organizationId, NewUserRequest request) throws ApiException {
        ApiResponse<NewUserResponse> localVarResponse = this.createUserWithHttpInfo(organizationId, request);
        return localVarResponse.getData();
    }

    public ApiResponse<NewUserResponse> createUserWithHttpInfo(UUID organizationId, NewUserRequest request) throws ApiException {
        NewUserRequest localVarPostBody = request;
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling createUser");
        }
        if (request == null) {
            throw new ApiException(400, "Missing the required parameter 'request' when calling createUser");
        }
        String localVarPath = "/v2/organizations/{organizationId}/users".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<NewUserResponse> localVarReturnType = new GenericType<NewUserResponse>(){};
        NewUserResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<NewUserResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DeleteResponse deleteIdentities(UUID organizationId, UUID userId, DeleteUserIdentityRequest requestModel) throws ApiException {
        ApiResponse<DeleteResponse> localVarResponse = this.deleteIdentitiesWithHttpInfo(organizationId, userId, requestModel);
        return localVarResponse.getData();
    }

    public ApiResponse<DeleteResponse> deleteIdentitiesWithHttpInfo(UUID organizationId, UUID userId, DeleteUserIdentityRequest requestModel) throws ApiException {
        DeleteUserIdentityRequest localVarPostBody = requestModel;
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling deleteIdentities");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling deleteIdentities");
        }
        if (requestModel == null) {
            throw new ApiException(400, "Missing the required parameter 'requestModel' when calling deleteIdentities");
        }
        String localVarPath = "/v2/organizations/{organizationId}/users/{userId}/identities".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DeleteResponse> localVarReturnType = new GenericType<DeleteResponse>(){};
        DeleteResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DeleteResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public UsersDrilldownResponse getUserDSProfile(UUID organizationId, UUID userId) throws ApiException {
        return this.getUserDSProfile(organizationId, userId, null);
    }

    public UsersDrilldownResponse getUserDSProfile(UUID organizationId, UUID userId, GetUserDSProfileOptions options) throws ApiException {
        ApiResponse<UsersDrilldownResponse> localVarResponse = this.getUserDSProfileWithHttpInfo(organizationId, userId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<UsersDrilldownResponse> getUserDSProfileWithHttpInfo(UUID organizationId, UUID userId, GetUserDSProfileOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getUserDSProfile");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getUserDSProfile");
        }
        String localVarPath = "/v2.1/organizations/{organizationId}/users/{userId}/dsprofile".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", options.sort));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UsersDrilldownResponse> localVarReturnType = new GenericType<UsersDrilldownResponse>(){};
        UsersDrilldownResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<UsersDrilldownResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public UsersDrilldownResponse getUserDSProfilesByEmail(UUID organizationId) throws ApiException {
        return this.getUserDSProfilesByEmail(organizationId, null);
    }

    public UsersDrilldownResponse getUserDSProfilesByEmail(UUID organizationId, GetUserDSProfilesByEmailOptions options) throws ApiException {
        ApiResponse<UsersDrilldownResponse> localVarResponse = this.getUserDSProfilesByEmailWithHttpInfo(organizationId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<UsersDrilldownResponse> getUserDSProfilesByEmailWithHttpInfo(UUID organizationId, GetUserDSProfilesByEmailOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getUserDSProfilesByEmail");
        }
        String localVarPath = "/v2.1/organizations/{organizationId}/users/dsprofile".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("email", options.email));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", options.sort));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UsersDrilldownResponse> localVarReturnType = new GenericType<UsersDrilldownResponse>(){};
        UsersDrilldownResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<UsersDrilldownResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public UsersDrilldownResponse getUserProfiles(UUID organizationId) throws ApiException {
        return this.getUserProfiles(organizationId, null);
    }

    public UsersDrilldownResponse getUserProfiles(UUID organizationId, GetUserProfilesOptions options) throws ApiException {
        ApiResponse<UsersDrilldownResponse> localVarResponse = this.getUserProfilesWithHttpInfo(organizationId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<UsersDrilldownResponse> getUserProfilesWithHttpInfo(UUID organizationId, GetUserProfilesOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getUserProfiles");
        }
        String localVarPath = "/v2/organizations/{organizationId}/users/profile".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("email", options.email));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UsersDrilldownResponse> localVarReturnType = new GenericType<UsersDrilldownResponse>(){};
        UsersDrilldownResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<UsersDrilldownResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public OrganizationUsersResponse getUsers(UUID organizationId) throws ApiException {
        return this.getUsers(organizationId, null);
    }

    public OrganizationUsersResponse getUsers(UUID organizationId, GetUsersOptions options) throws ApiException {
        ApiResponse<OrganizationUsersResponse> localVarResponse = this.getUsersWithHttpInfo(organizationId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<OrganizationUsersResponse> getUsersWithHttpInfo(UUID organizationId, GetUsersOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getUsers");
        }
        String localVarPath = "/v2/organizations/{organizationId}/users".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start", options.start));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("take", options.take));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("end", options.end));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("email", options.email));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("email_user_name_like", options.emailUserNameLike));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("status", options.status));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("membership_status", options.membershipStatus));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", options.accountId));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("organization_reserved_domain_id", options.organizationReservedDomainId));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("last_modified_since", options.lastModifiedSince));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_ds_groups", options.includeDsGroups));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<OrganizationUsersResponse> localVarReturnType = new GenericType<OrganizationUsersResponse>(){};
        OrganizationUsersResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<OrganizationUsersResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public UsersUpdateResponse updateEmailAddress(UUID organizationId, UpdateUsersEmailRequest request) throws ApiException {
        ApiResponse<UsersUpdateResponse> localVarResponse = this.updateEmailAddressWithHttpInfo(organizationId, request);
        return localVarResponse.getData();
    }

    public ApiResponse<UsersUpdateResponse> updateEmailAddressWithHttpInfo(UUID organizationId, UpdateUsersEmailRequest request) throws ApiException {
        UpdateUsersEmailRequest localVarPostBody = request;
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling updateEmailAddress");
        }
        if (request == null) {
            throw new ApiException(400, "Missing the required parameter 'request' when calling updateEmailAddress");
        }
        String localVarPath = "/v2/organizations/{organizationId}/users/email_addresses".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UsersUpdateResponse> localVarReturnType = new GenericType<UsersUpdateResponse>(){};
        UsersUpdateResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<UsersUpdateResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public UsersUpdateResponse updateUser(UUID organizationId, UpdateUsersRequest request) throws ApiException {
        ApiResponse<UsersUpdateResponse> localVarResponse = this.updateUserWithHttpInfo(organizationId, request);
        return localVarResponse.getData();
    }

    public ApiResponse<UsersUpdateResponse> updateUserWithHttpInfo(UUID organizationId, UpdateUsersRequest request) throws ApiException {
        UpdateUsersRequest localVarPostBody = request;
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling updateUser");
        }
        if (request == null) {
            throw new ApiException(400, "Missing the required parameter 'request' when calling updateUser");
        }
        String localVarPath = "/v2/organizations/{organizationId}/users/profiles".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<UsersUpdateResponse> localVarReturnType = new GenericType<UsersUpdateResponse>(){};
        UsersUpdateResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<UsersUpdateResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public class GetUsersOptions {
        private Integer start = null;
        private Integer take = null;
        private Integer end = null;
        private String email = null;
        private String emailUserNameLike = null;
        private String status = null;
        private String membershipStatus = null;
        private UUID accountId = null;
        private UUID organizationReservedDomainId = null;
        private String lastModifiedSince = null;
        private Boolean includeDsGroups = null;

        public void setStart(Integer start) {
            this.start = start;
        }

        public Integer getStart() {
            return this.start;
        }

        public void setTake(Integer take) {
            this.take = take;
        }

        public Integer getTake() {
            return this.take;
        }

        public void setEnd(Integer end) {
            this.end = end;
        }

        public Integer getEnd() {
            return this.end;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmailUserNameLike(String emailUserNameLike) {
            this.emailUserNameLike = emailUserNameLike;
        }

        public String getEmailUserNameLike() {
            return this.emailUserNameLike;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public void setMembershipStatus(String membershipStatus) {
            this.membershipStatus = membershipStatus;
        }

        public String getMembershipStatus() {
            return this.membershipStatus;
        }

        public void setAccountId(UUID accountId) {
            this.accountId = accountId;
        }

        public UUID getAccountId() {
            return this.accountId;
        }

        public void setOrganizationReservedDomainId(UUID organizationReservedDomainId) {
            this.organizationReservedDomainId = organizationReservedDomainId;
        }

        public UUID getOrganizationReservedDomainId() {
            return this.organizationReservedDomainId;
        }

        public void setLastModifiedSince(String lastModifiedSince) {
            this.lastModifiedSince = lastModifiedSince;
        }

        public String getLastModifiedSince() {
            return this.lastModifiedSince;
        }

        public void setIncludeDsGroups(Boolean includeDsGroups) {
            this.includeDsGroups = includeDsGroups;
        }

        public Boolean getIncludeDsGroups() {
            return this.includeDsGroups;
        }
    }

    public class GetUserProfilesOptions {
        private String email = null;

        public void setEmail(String email) {
            this.email = email;
        }

        public String getEmail() {
            return this.email;
        }
    }

    public class GetUserDSProfilesByEmailOptions {
        private String email = null;
        private Boolean sort = null;

        public void setEmail(String email) {
            this.email = email;
        }

        public String getEmail() {
            return this.email;
        }

        public void setSort(Boolean sort) {
            this.sort = sort;
        }

        public Boolean getSort() {
            return this.sort;
        }
    }

    public class GetUserDSProfileOptions {
        private Boolean sort = null;

        public void setSort(Boolean sort) {
            this.sort = sort;
        }

        public Boolean getSort() {
            return this.sort;
        }
    }
}

