/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.BrowseFacet;
import com.browseengine.bobo.api.BrowseSelection;
import com.browseengine.bobo.api.ComparatorFactory;
import com.browseengine.bobo.api.FacetIterator;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.api.FieldValueAccessor;
import com.browseengine.bobo.facets.FacetCountCollector;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.data.TermDoubleList;
import com.browseengine.bobo.facets.data.TermFloatList;
import com.browseengine.bobo.facets.data.TermIntList;
import com.browseengine.bobo.facets.data.TermLongList;
import com.browseengine.bobo.facets.data.TermShortList;
import com.browseengine.bobo.facets.data.TermValueList;
import com.browseengine.bobo.facets.impl.DefaultDoubleFacetIterator;
import com.browseengine.bobo.facets.impl.DefaultFacetIterator;
import com.browseengine.bobo.facets.impl.DefaultFloatFacetIterator;
import com.browseengine.bobo.facets.impl.DefaultIntFacetIterator;
import com.browseengine.bobo.facets.impl.DefaultLongFacetIterator;
import com.browseengine.bobo.facets.impl.DefaultShortFacetIterator;
import com.browseengine.bobo.facets.impl.FacetHitcountComparatorFactory;
import com.browseengine.bobo.util.BigSegmentedArray;
import com.browseengine.bobo.util.IntBoundedPriorityQueue;
import com.browseengine.bobo.util.MemoryManager;
import com.browseengine.bobo.util.MemoryManagerAdminMBean;
import java.lang.management.ManagementFactory;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;

public abstract class DefaultFacetCountCollector
implements FacetCountCollector {
    private static final Logger log = Logger.getLogger((String)DefaultFacetCountCollector.class.getName());
    protected final FacetSpec _ospec;
    public int[] _count;
    public int _countlength;
    protected FacetDataCache _dataCache;
    private final String _name;
    protected final BrowseSelection _sel;
    protected final BigSegmentedArray _array;
    private int _docBase;
    protected final LinkedList<int[]> intarraylist = new LinkedList();
    private Iterator _iterator;
    private boolean _closed = false;
    protected static MemoryManager<int[]> intarraymgr = new MemoryManager<int[]>(new MemoryManager.Initializer<int[]>(){

        @Override
        public void init(int[] buf) {
            Arrays.fill(buf, 0);
        }

        @Override
        public int[] newInstance(int size) {
            return new int[size];
        }

        @Override
        public int size(int[] buf) {
            assert (buf != null);
            return buf.length;
        }
    });

    public DefaultFacetCountCollector(String name, FacetDataCache dataCache, int docBase, BrowseSelection sel, FacetSpec ospec) {
        this._sel = sel;
        this._ospec = ospec;
        this._name = name;
        this._dataCache = dataCache;
        if (this._dataCache.freqs.length <= 3096) {
            this._countlength = this._dataCache.freqs.length;
            this._count = new int[this._countlength];
        } else {
            this._countlength = this._dataCache.freqs.length;
            this._count = intarraymgr.get(this._countlength);
            this.intarraylist.add(this._count);
        }
        this._array = this._dataCache.orderArray;
        this._docBase = docBase;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public abstract void collect(int var1);

    @Override
    public abstract void collectAll();

    @Override
    public BrowseFacet getFacet(String value) {
        if (this._closed) {
            throw new IllegalStateException("This instance of count collector for " + this._name + " was already closed");
        }
        BrowseFacet facet = null;
        int index = this._dataCache.valArray.indexOf(value);
        facet = index >= 0 ? new BrowseFacet(this._dataCache.valArray.get(index), this._count[index]) : new BrowseFacet(this._dataCache.valArray.format(value), 0);
        return facet;
    }

    @Override
    public int getFacetHitsCount(Object value) {
        if (this._closed) {
            throw new IllegalStateException("This instance of count collector for " + this._name + " was already closed");
        }
        int index = this._dataCache.valArray.indexOf(value);
        if (index >= 0) {
            return this._count[index];
        }
        return 0;
    }

    @Override
    public int[] getCountDistribution() {
        return this._count;
    }

    public FacetDataCache getFacetDataCache() {
        return this._dataCache;
    }

    public static List<BrowseFacet> getFacets(FacetSpec ospec, int[] count, int countlength, final TermValueList<?> valList) {
        if (ospec != null) {
            AbstractList facetColl;
            FacetSpec.FacetSortSpec sortspec;
            int minCount = ospec.getMinHitCount();
            int max = ospec.getMaxCount();
            if (max <= 0) {
                max = countlength;
            }
            if ((sortspec = ospec.getOrderBy()) == FacetSpec.FacetSortSpec.OrderValueAsc) {
                facetColl = new ArrayList<BrowseFacet>(max);
                for (int i = 1; i < countlength; ++i) {
                    int hits = count[i];
                    if (hits >= minCount) {
                        BrowseFacet facet = new BrowseFacet(valList.get(i), hits);
                        facetColl.add((BrowseFacet)facet);
                    }
                    if (facetColl.size() < max) {
                        continue;
                    }
                    break;
                }
            } else {
                int val;
                ComparatorFactory comparatorFactory = sortspec == FacetSpec.FacetSortSpec.OrderHitsDesc ? new FacetHitcountComparatorFactory() : ospec.getCustomComparatorFactory();
                if (comparatorFactory == null) {
                    throw new IllegalArgumentException("facet comparator factory not specified");
                }
                IntBoundedPriorityQueue.IntComparator comparator = comparatorFactory.newComparator(new FieldValueAccessor(){

                    @Override
                    public String getFormatedValue(int index) {
                        return valList.get(index);
                    }

                    @Override
                    public Object getRawValue(int index) {
                        return valList.getRawValue(index);
                    }
                }, count);
                facetColl = new LinkedList();
                int forbidden = -1;
                IntBoundedPriorityQueue pq = new IntBoundedPriorityQueue(comparator, max, -1);
                for (int i = 1; i < countlength; ++i) {
                    int hits = count[i];
                    if (hits < minCount) continue;
                    pq.offer(i);
                }
                while ((val = pq.pollInt()) != -1) {
                    BrowseFacet facet = new BrowseFacet(valList.get(val), count[val]);
                    ((LinkedList)facetColl).addFirst(facet);
                }
            }
            return facetColl;
        }
        return FacetCountCollector.EMPTY_FACET_LIST;
    }

    @Override
    public List<BrowseFacet> getFacets() {
        if (this._closed) {
            throw new IllegalStateException("This instance of count collector for " + this._name + " was already closed");
        }
        return DefaultFacetCountCollector.getFacets(this._ospec, this._count, this._countlength, this._dataCache.valArray);
    }

    @Override
    public void close() {
        if (this._closed) {
            log.warn((Object)("This instance of count collector for '" + this._name + "' was already closed. This operation is no-op."));
            return;
        }
        this._closed = true;
        while (!this.intarraylist.isEmpty()) {
            intarraymgr.release(this.intarraylist.poll());
        }
    }

    @Override
    public FacetIterator iterator() {
        if (this._closed) {
            throw new IllegalStateException("This instance of count collector for '" + this._name + "' was already closed");
        }
        if (this._dataCache.valArray.getType().equals(Integer.class)) {
            return new DefaultIntFacetIterator((TermIntList)this._dataCache.valArray, this._count, this._countlength, false);
        }
        if (this._dataCache.valArray.getType().equals(Long.class)) {
            return new DefaultLongFacetIterator((TermLongList)this._dataCache.valArray, this._count, this._countlength, false);
        }
        if (this._dataCache.valArray.getType().equals(Short.class)) {
            return new DefaultShortFacetIterator((TermShortList)this._dataCache.valArray, this._count, this._countlength, false);
        }
        if (this._dataCache.valArray.getType().equals(Float.class)) {
            return new DefaultFloatFacetIterator((TermFloatList)this._dataCache.valArray, this._count, this._countlength, false);
        }
        if (this._dataCache.valArray.getType().equals(Double.class)) {
            return new DefaultDoubleFacetIterator((TermDoubleList)this._dataCache.valArray, this._count, this._countlength, false);
        }
        return new DefaultFacetIterator(this._dataCache.valArray, this._count, this._countlength, false);
    }

    static {
        try {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName mbeanName = new ObjectName("bobo", "name", "DefaultFacetCountCollector-MemoryManager");
            StandardMBean mbean = new StandardMBean(intarraymgr.getAdminMBean(), MemoryManagerAdminMBean.class);
            mbeanServer.registerMBean(mbean, mbeanName);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

