/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.beanbox;

import com.bbn.openmap.tools.beanbox.MessageHeader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class Manifest {
    private Vector entries = new Vector();
    static final boolean debug = false;

    static final void debug(String s) {
    }

    public Manifest() {
    }

    public Manifest(byte[] bytes) throws IOException {
        this(new ByteArrayInputStream(bytes));
    }

    public Manifest(InputStream is) throws IOException {
        while (is.available() != 0) {
            MessageHeader m = new MessageHeader(is);
            this.entries.addElement(m);
        }
    }

    public Manifest(String[] files) throws IOException {
        MessageHeader globals = new MessageHeader();
        globals.add("Manifest-Version", "1.0");
        this.addEntry(globals);
        this.addFiles(null, files);
    }

    public void addEntry(MessageHeader entry) {
        this.entries.addElement(entry);
    }

    public MessageHeader getEntry(String name) {
        Enumeration enumeration = this.entries();
        while (enumeration.hasMoreElements()) {
            MessageHeader mh = (MessageHeader)enumeration.nextElement();
            String nameVal = mh.findValue("Name");
            if (nameVal == null || !nameVal.equals(name)) continue;
            return mh;
        }
        return null;
    }

    public MessageHeader entryAt(int i) {
        return (MessageHeader)this.entries.elementAt(i);
    }

    public Enumeration entries() {
        return this.entries.elements();
    }

    public void addFiles(File dir, String[] files) throws IOException {
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = dir == null ? new File(files[i]) : new File(dir, files[i]);
            if (file.isDirectory()) {
                this.addFiles(file, file.list());
                continue;
            }
            this.addFile(file);
        }
    }

    public void addFile(File f) throws IOException {
        MessageHeader mh = new MessageHeader();
        mh.add("Name", f.getPath());
        this.addEntry(mh);
    }

    public void stream(OutputStream os, Vector extraFiles) throws IOException {
        MessageHeader globals = (MessageHeader)this.entries.elementAt(0);
        if (globals.findValue("Manifest-Version") == null) {
            throw new IOException("Manifest file requires Manifest-Version: 1.0 in 1st header");
        }
        PrintWriter ps = new PrintWriter(os);
        globals.print(ps);
        for (int i = 1; i < this.entries.size(); ++i) {
            MessageHeader mh = (MessageHeader)this.entries.elementAt(i);
            mh.print(ps);
            String name = mh.findValue("name");
            if (extraFiles == null || name == null) continue;
            extraFiles.addElement(name);
        }
    }

    public static boolean isManifestName(String name) {
        if (name.charAt(0) == '/') {
            name = name.substring(1, name.length());
        }
        return (name = name.toUpperCase()).equals("META-INF/MANIFEST.MF");
    }
}

