/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.layer.util.stateMachine.State;
import com.bbn.openmap.omGraphics.EditableOMGraphic;
import com.bbn.openmap.omGraphics.GrabPoint;
import com.bbn.openmap.omGraphics.GraphicAttributes;
import com.bbn.openmap.omGraphics.HorizontalGrabPoint;
import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OffsetGrabPoint;
import com.bbn.openmap.omGraphics.VerticalGrabPoint;
import com.bbn.openmap.omGraphics.editable.CircleStateMachine;
import com.bbn.openmap.omGraphics.editable.GraphicEditState;
import com.bbn.openmap.omGraphics.editable.GraphicSelectedState;
import com.bbn.openmap.omGraphics.editable.GraphicSetOffsetState;
import com.bbn.openmap.proj.DrawUtil;
import com.bbn.openmap.proj.GeoProj;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

public class EditableOMCircle
extends EditableOMGraphic {
    protected VerticalGrabPoint gpn;
    protected HorizontalGrabPoint gpw;
    protected VerticalGrabPoint gps;
    protected HorizontalGrabPoint gpe;
    protected GrabPoint gpnw;
    protected GrabPoint gpne;
    protected GrabPoint gpsw;
    protected GrabPoint gpse;
    protected OffsetGrabPoint gpc;
    protected GrabPoint gpr;
    protected OffsetGrabPoint gpo;
    protected OffsetGrabPoint gpm;
    protected OMCircle circle;
    public static final int CENTER_POINT_INDEX = 0;
    public static final int NW_POINT_INDEX = 1;
    public static final int N_POINT_INDEX = 2;
    public static final int NE_POINT_INDEX = 3;
    public static final int W_POINT_INDEX = 4;
    public static final int E_POINT_INDEX = 5;
    public static final int SW_POINT_INDEX = 6;
    public static final int S_POINT_INDEX = 7;
    public static final int SE_POINT_INDEX = 8;
    public static final int RADIUS_POINT_INDEX = 9;
    public static final int OFFSET_POINT_INDEX = 10;
    protected int lastRenderType = -1;

    public EditableOMCircle() {
        this.createGraphic(null);
    }

    public EditableOMCircle(GraphicAttributes ga) {
        this.createGraphic(ga);
    }

    public EditableOMCircle(OMCircle omc) {
        this.setGraphic(omc);
    }

    public void init() {
        this.setCanGrabGraphic(false);
        Debug.message("eomg", "EditableOMCircle.init()");
        this.setStateMachine(new CircleStateMachine(this));
        this.gPoints = new GrabPoint[11];
    }

    public void setGraphic(OMGraphic graphic) {
        this.init();
        if (graphic instanceof OMCircle) {
            this.circle = (OMCircle)graphic;
            this.stateMachine.setSelected();
            this.setGrabPoints(this.circle);
        } else {
            this.createGraphic(null);
        }
    }

    public void createGraphic(GraphicAttributes ga) {
        this.init();
        this.stateMachine.setUndefined();
        int renderType = 0;
        if (ga != null) {
            renderType = ga.getRenderType();
        }
        if (Debug.debugging("eomc")) {
            Debug.output("EditableOMCircle.createGraphic(): rendertype = " + renderType);
        }
        switch (renderType) {
            case 1: {
                this.circle = new OMCircle(90.0, -180.0, 0.0);
                break;
            }
            case 3: {
                this.circle = new OMCircle(90.0, -180.0, 0, 0, 1, 1);
                break;
            }
            default: {
                this.circle = new OMCircle(-1, -1, 1, 1);
            }
        }
        if (ga != null) {
            ga.setTo(this.circle, true);
        }
    }

    public boolean getCanGrabGraphic() {
        return this.canGrabGraphic || this.circle.renderType == 1;
    }

    public OMGraphic getGraphic() {
        return this.circle;
    }

    public void attachToMovingGrabPoint(OffsetGrabPoint gp) {
        gp.addGrabPoint(this.gpo);
    }

    public void detachFromMovingGrabPoint(OffsetGrabPoint gp) {
        gp.removeGrabPoint(this.gpo);
    }

    public void setMovingPoint(GrabPoint gp) {
        super.setMovingPoint(gp);
        this.gpm = null;
    }

    public GrabPoint getMovingPoint(MouseEvent e) {
        this.movingPoint = null;
        GrabPoint[] gb = this.getGrabPoints();
        Point2D pnt = this.getProjectionPoint(e);
        int x = (int)pnt.getX();
        int y = (int)pnt.getY();
        for (int i = gb.length - 1; i >= 0; --i) {
            if (i == 9 || gb[i] == null || gb[i].distance(x, y) != 0.0f) continue;
            this.setMovingPoint(gb[i]);
            break;
        }
        return this.movingPoint;
    }

    public void assertGrabPoints() {
        int rt = this.getGraphic().getRenderType();
        if (rt != this.lastRenderType) {
            this.clearGrabPoints();
            this.lastRenderType = rt;
        }
        if (this.gpr == null) {
            this.gPoints[9] = this.gpr = new GrabPoint(-1, -1);
        }
        if (this.gpnw == null) {
            this.gPoints[1] = this.gpnw = new GrabPoint(-1, -1);
        }
        if (this.gpn == null) {
            this.gpn = new VerticalGrabPoint(-1, -1);
            this.gPoints[2] = this.gpn;
        }
        if (this.gpne == null) {
            this.gPoints[3] = this.gpne = new GrabPoint(-1, -1);
        }
        if (this.gpw == null) {
            this.gpw = new HorizontalGrabPoint(-1, -1);
            this.gPoints[4] = this.gpw;
        }
        if (this.gpe == null) {
            this.gpe = new HorizontalGrabPoint(-1, -1);
            this.gPoints[5] = this.gpe;
        }
        if (this.gpsw == null) {
            this.gPoints[6] = this.gpsw = new GrabPoint(-1, -1);
        }
        if (this.gps == null) {
            this.gps = new VerticalGrabPoint(-1, -1);
            this.gPoints[7] = this.gps;
        }
        if (this.gpse == null) {
            this.gPoints[8] = this.gpse = new GrabPoint(-1, -1);
        }
        if (this.gpc == null) {
            this.gpc = new OffsetGrabPoint(-1, -1);
            this.gPoints[0] = this.gpc;
            if (this.getGraphic().getRenderType() != 1) {
                this.gpc.addGrabPoint(this.gpnw);
                this.gpc.addGrabPoint(this.gpn);
                this.gpc.addGrabPoint(this.gpne);
                this.gpc.addGrabPoint(this.gpw);
                this.gpc.addGrabPoint(this.gpe);
                this.gpc.addGrabPoint(this.gpsw);
                this.gpc.addGrabPoint(this.gps);
                this.gpc.addGrabPoint(this.gpse);
            }
        }
        if (this.gpo == null) {
            this.gpo = new OffsetGrabPoint(-1, -1);
            this.gPoints[10] = this.gpo;
            this.gpo.addGrabPoint(this.gpc);
        }
    }

    protected void clearGrabPoints() {
        this.gpc = null;
        this.gpr = null;
        this.gpnw = null;
        this.gpn = null;
        this.gpne = null;
        this.gpw = null;
        this.gpe = null;
        this.gpsw = null;
        this.gps = null;
        this.gpse = null;
        this.gpo = null;
        this.gPoints[0] = this.gpc;
        this.gPoints[9] = this.gpr;
        this.gPoints[1] = this.gpnw;
        this.gPoints[2] = this.gpn;
        this.gPoints[3] = this.gpne;
        this.gPoints[4] = this.gpw;
        this.gPoints[5] = this.gpe;
        this.gPoints[6] = this.gpsw;
        this.gPoints[7] = this.gps;
        this.gPoints[8] = this.gpse;
        this.gPoints[10] = this.gpo;
    }

    public void setGrabPoints(OMGraphic graphic) {
        if (!(graphic instanceof OMCircle)) {
            return;
        }
        this.assertGrabPoints();
        OMCircle circle = (OMCircle)graphic;
        boolean ntr = circle.getNeedToRegenerate();
        int renderType = circle.getRenderType();
        int centerx = 0;
        int centery = 0;
        if (!ntr) {
            if (renderType == 1 || renderType == 3) {
                if (this.projection != null) {
                    LatLonPoint center = circle.getLatLon();
                    Point2D p = this.projection.forward(center);
                    centerx = (int)p.getX();
                    centery = (int)p.getY();
                }
                if (renderType == 3) {
                    this.gpo.setX(centerx);
                    this.gpo.setY(centery);
                    centerx += circle.getOffX();
                    centery += circle.getOffY();
                }
            } else if (renderType == 2) {
                centerx = circle.getX();
                centery = circle.getY();
            }
            if (renderType == 1) {
                Debug.message("eomg", "EditableOMCircle: modifying lat/lon circle");
                if (this.projection != null) {
                    this.gpc.set(centerx, centery);
                }
            } else {
                Debug.message("eomg", "EditableOMCircle: modifying x/y or offset standard circle");
                int height = circle.getHeight() / 2;
                int width = circle.getWidth() / 2;
                this.gpc.set(centerx, centery);
                this.gpe.set(centerx + width, centery, true);
                this.gps.set(centerx, centery + height, true);
                this.gpw.set(centerx - width, centery, true);
                this.gpn.set(centerx, centery - height, true);
                this.gpne.set(this.gpe.getX(), this.gpn.getY());
                this.gpnw.set(this.gpw.getX(), this.gpn.getY());
                this.gpse.set(this.gpe.getX(), this.gps.getY());
                this.gpsw.set(this.gpw.getX(), this.gps.getY());
                this.gpc.updateOffsets();
            }
            if (circle.getRenderType() == 3) {
                this.gpo.updateOffsets();
            }
        } else {
            Debug.message("eomg", "EditableOMCircle.setGrabPoints: graphic needs to be regenerated");
        }
    }

    public void setGrabPoints() {
        boolean settingOffset;
        int renderType = this.circle.getRenderType();
        Debug.message("eomg", "EditableOMCircle.setGrabPoints()");
        if (renderType == 1 || renderType == 3) {
            OffsetGrabPoint llgp = renderType == 3 ? this.gpo : this.gpc;
            if (this.projection != null) {
                LatLonPoint llp = this.projection.inverse(llgp.getX(), llgp.getY(), new LatLonPoint.Double());
                this.circle.setCenter(llp);
                if (renderType == 1 && this.movingPoint == this.gpr) {
                    LatLonPoint llpm = this.projection.inverse(this.gpr.getX(), this.gpr.getY(), new LatLonPoint.Double());
                    double radius = this.projection instanceof GeoProj ? Length.DECIMAL_DEGREE.fromRadians(llpm.distance(llp)) : DrawUtil.distance(llpm.getX(), llpm.getY(), llp.getX(), llp.getY());
                    this.setRadius(radius);
                }
            } else {
                Debug.message("eomg", "EditableOMCircle.setGrabPoints: projection is null, can't figure out LATLON points for circle.");
            }
        }
        boolean bl = settingOffset = this.getStateMachine().getState() instanceof GraphicSetOffsetState && this.movingPoint == this.gpo;
        if (renderType == 3 && (settingOffset || this.movingPoint == this.gpc)) {
            this.circle.setOffX(this.gpc.getX() - this.gpo.getX());
            this.circle.setOffY(this.gpc.getY() - this.gpo.getY());
            Debug.message("eomg", "EditableOMCircle: updating offset distance, ox:" + this.circle.getOffX() + ", oy:" + this.circle.getOffY());
        }
        if (renderType == 2 || renderType == 3 && !settingOffset) {
            if (renderType == 2) {
                this.circle.setX(this.gpc.getX());
                this.circle.setY(this.gpc.getY());
            }
            if (this.movingPoint instanceof HorizontalGrabPoint) {
                this.circle.setWidth(Math.abs(this.movingPoint.getX() - this.gpc.getX()) * 2);
            } else if (this.movingPoint instanceof VerticalGrabPoint) {
                this.circle.setHeight(Math.abs(this.movingPoint.getY() - this.gpc.getY()) * 2);
            } else if (this.movingPoint != this.gpo && this.movingPoint != this.gpc) {
                this.circle.setWidth(Math.abs(this.movingPoint.getX() - this.gpc.getX()) * 2);
                this.circle.setHeight(Math.abs(this.movingPoint.getY() - this.gpc.getY()) * 2);
            }
        }
        if (this.projection != null) {
            this.regenerate(this.projection);
        }
    }

    protected void setRadius(double radius) {
        if (this.circle != null) {
            this.circle.setRadius(radius);
        }
    }

    public void move(MouseEvent e) {
        if (this.getGraphic().getRenderType() == 1 && this.isMouseEventTouchingTheEdge(e)) {
            if (this.gpr == null) {
                this.gpr = new GrabPoint(-1, -1);
            }
            this.gpr.set(e.getX(), e.getY());
            this.movingPoint = this.gpr;
        }
    }

    public boolean generate(Projection proj) {
        Debug.message("eomg", "EditableOMCircle.generate()");
        if (this.circle != null) {
            this.circle.generate(proj);
        }
        for (int i = 0; i < this.gPoints.length; ++i) {
            GrabPoint gp = this.gPoints[i];
            if (gp == null) continue;
            gp.generate(proj);
        }
        return true;
    }

    public void regenerate(Projection proj) {
        Debug.message("eomg", "EditableOMCircle.regenerate()");
        if (this.circle != null) {
            this.circle.regenerate(proj);
        }
        this.setGrabPoints(this.circle);
        this.generate(proj);
    }

    public void render(Graphics graphics) {
        Debug.message("eomg", "EditableOMCircle.render()");
        State state = this.getStateMachine().getState();
        if (this.circle != null) {
            this.circle.setVisible(true);
            this.circle.render(graphics);
            this.circle.setVisible(false);
        } else {
            Debug.message("eomg", "EditableOMCircle.render: null circle.");
        }
        int renderType = this.circle.getRenderType();
        if (state instanceof GraphicSelectedState || state instanceof GraphicEditState) {
            for (int i = 0; i < this.gPoints.length; ++i) {
                GrabPoint gp = this.gPoints[i];
                if (gp == null || i == 9 || renderType == 1 && i != 0 || (i != 10 || renderType != 3 || this.movingPoint != this.gpo) && (!(state instanceof GraphicSelectedState) || (i == 10 || renderType == 3) && renderType != 3)) continue;
                gp.setVisible(true);
                gp.render(graphics);
                gp.setVisible(false);
            }
        }
    }

    public Component getGUI(GraphicAttributes graphicAttributes) {
        Debug.message("eomg", "EditableOMCircle.getGUI");
        if (graphicAttributes != null) {
            return graphicAttributes.getColorAndLineGUI();
        }
        return null;
    }
}

