/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.layer.rpf.RpfCoverageBox;
import com.bbn.openmap.layer.rpf.RpfFrameProvider;
import com.bbn.openmap.layer.rpf.RpfIndexedImageData;
import com.bbn.openmap.layer.rpf.RpfSubframe;
import com.bbn.openmap.layer.rpf.RpfViewAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RpfCacheHandler {
    public static final int SUBFRAME_CACHE_SIZE = 20;
    public static final int MAX_NUM_DESC = 20;
    public static final int MAX_DESC_LEN = 512;
    public static final int DEFAULT_SUBFRAMEBUFFER = 5;
    public static final int NOT_CACHED = -1;
    public static final int NOT_PRESENT = -2;
    protected int scalingHeight = 256;
    protected int scalingWidth = 256;
    protected SubframeCache cache;
    protected Vector<RpfCoverageBox> coverageBoxes;
    protected byte[][] subframeIndex;
    protected byte[][] subframeVersion;
    protected int subframeCacheSize = 20;
    protected RpfViewAttributes viewAttributes;
    protected RpfFrameProvider frameProvider;
    protected Point start = new Point();
    protected Point end = new Point();
    protected boolean goodData = false;
    protected int subframeBuffer = 5;
    protected boolean DEBUG_RPF = Debug.debugging("rpf");
    protected boolean DEBUG_RPFDETAIL = Debug.debugging("rpfdetail");

    public RpfCacheHandler(RpfFrameProvider provider, RpfViewAttributes rva) {
        this(provider, rva, 20);
    }

    public RpfCacheHandler(RpfFrameProvider provider, RpfViewAttributes rva, int subframe_cache_size) {
        this.frameProvider = provider;
        this.viewAttributes = rva;
        this.updateViewAttributes();
        if (subframe_cache_size > 127) {
            this.subframeCacheSize = 127;
        } else if (subframe_cache_size >= 0) {
            this.subframeCacheSize = subframe_cache_size;
        }
        this.initCache(true);
        if (this.DEBUG_RPF) {
            Debug.output("RpfCacheHandler: Created with cache size of " + this.subframeCacheSize);
        }
    }

    public void setViewAttributes(RpfViewAttributes rva) {
        this.viewAttributes = rva;
        this.updateViewAttributes();
        this.clearCache();
    }

    public RpfViewAttributes getViewAttributes() {
        if (this.viewAttributes == null) {
            this.viewAttributes = new RpfViewAttributes();
        }
        return this.viewAttributes;
    }

    public void setFrameProvider(RpfFrameProvider fp) {
        this.frameProvider = fp;
        if (this.frameProvider != null) {
            this.frameProvider.setViewAttributes(this.getViewAttributes());
        }
        this.clearCache();
    }

    public RpfFrameProvider getFrameProvider() {
        return this.frameProvider;
    }

    public void updateViewAttributes() {
        if (this.frameProvider != null) {
            this.frameProvider.setViewAttributes(this.getViewAttributes());
        }
    }

    public Vector<RpfCoverageBox> getCoverageBoxes() {
        return this.coverageBoxes;
    }

    public synchronized void setCache(float ullat, float ullon, float lrlat, float lrlon, Projection proj) {
        boolean needNewCoverage = true;
        Object oldID = null;
        RpfCoverageBox currentBox = null;
        if (needNewCoverage) {
            if (this.DEBUG_RPF) {
                Debug.output("RpfCacheHandler: Need new Coverage.");
            }
            this.coverageBoxes = this.frameProvider != null ? this.frameProvider.getCoverage(ullat, ullon, lrlat, lrlon, proj) : null;
            if (this.coverageBoxes == null || this.coverageBoxes.isEmpty()) {
                this.goodData = false;
                return;
            }
            currentBox = this.coverageBoxes.elementAt(0);
            if (!currentBox.getID().equals(oldID)) {
                this.resetSubframeIndex(currentBox.verticalSubframes(), currentBox.horizontalSubframes());
                this.initCache(false);
            }
            this.start = currentBox.startIndexes;
            this.end = currentBox.endIndexes;
            this.goodData = true;
        }
        for (int i = 1; i < this.coverageBoxes.size(); ++i) {
            this.coverageBoxes.elementAt(i).setPercentCoverage(ullat, ullon, lrlat, lrlon);
        }
        if (this.DEBUG_RPF) {
            Debug.output("RpfCachehandler: ####################");
            Debug.output("" + currentBox);
            Debug.output(" Starting point " + this.start);
            Debug.output(" Ending point " + this.end);
        }
        if (this.getViewAttributes().scaleImages && currentBox != null) {
            Object refllpt = proj.getUpperLeft();
            ((Point2D)refllpt).setLocation(((Point2D)refllpt).getX() + (double)((float)currentBox.subframeLonInterval), ((Point2D)refllpt).getY() - (double)((float)currentBox.subframeLatInterval));
            Point refpt = (Point)proj.forward((Point2D)refllpt, new Point());
            this.scalingWidth = refpt.x;
            this.scalingHeight = refpt.y;
        } else {
            this.scalingWidth = 256;
            this.scalingHeight = 256;
        }
    }

    protected OMGraphicList getSubframes(float ullat, float ullon, float lrlat, float lrlon, Projection proj, OMGraphicList omGraphics) {
        this.setCache(ullat, ullon, lrlat, lrlon, proj);
        int subframeRunningCount = 0;
        if (omGraphics == null) {
            omGraphics = new OMGraphicList();
        }
        for (int subx = this.start.x; subx <= this.end.x; ++subx) {
            for (int suby = this.start.y; suby <= this.end.y; ++suby) {
                RpfSubframe subframe = this.getCached(subx, suby, subframeRunningCount);
                if (subframe == null) {
                    if (Debug.debugging("rpf")) {
                        Debug.output("RpfCacheManager: checking other TOCs for subframe.");
                    }
                    subframe = this.getSubframeFromOtherTOC(subx, suby, subframeRunningCount);
                }
                if (subframe != null) {
                    OMGraphic image = subframe.getImage(proj);
                    if (image != null) {
                        image.setSelected(this.viewAttributes.showInfo);
                        omGraphics.add(image);
                        if (Debug.debugging("rpf")) {
                            Debug.output("RpfCacheManager: Adding subframe " + subx + ", " + suby);
                        }
                    }
                } else if (Debug.debugging("rpf")) {
                    Debug.output("RpfCacheManager: subframe " + subx + ", " + suby + " empty");
                }
                ++subframeRunningCount;
            }
        }
        return omGraphics;
    }

    protected void resetSubframeIndex(int vertFrames, int horizFrames) {
        if (this.subframeCacheSize > 0) {
            int matrixheight = vertFrames * 6 + this.subframeBuffer * 2;
            int matrixwidth = horizFrames * 6 + this.subframeBuffer * 2;
            this.subframeIndex = new byte[matrixheight][matrixwidth];
            this.subframeVersion = new byte[matrixheight][matrixwidth];
            this.clearCache();
        } else {
            this.subframeIndex = null;
            this.subframeVersion = null;
        }
    }

    public void clearCache() {
        if (this.subframeIndex != null && this.subframeVersion != null) {
            for (int i = 0; i < this.subframeIndex.length; ++i) {
                for (int j = 0; j < this.subframeIndex[0].length; ++j) {
                    this.subframeIndex[i][j] = -1;
                    this.subframeVersion[i][j] = -1;
                }
            }
        }
        this.initCache(false);
    }

    public boolean getGoodData() {
        return this.goodData;
    }

    protected void initCache(boolean newCache) {
        if (this.subframeCacheSize <= 0) {
            this.cache = null;
            return;
        }
        if (newCache || this.cache == null) {
            this.cache = new SubframeCache(this.subframeCacheSize);
        }
        this.cache.LRU_head = 0;
        this.cache.LRU_tail = this.subframeCacheSize - 1;
        for (int i = 0; i < this.subframeCacheSize; ++i) {
            if (newCache) {
                try {
                    this.cache.subframe[i] = new RpfSubframe();
                }
                catch (OutOfMemoryError oome) {
                    Debug.error("RpfCacheHandler: \n\tRan out of memory allocating the image cache.\tConsider increasing the java memory heap using the -Xmx option.");
                    this.cache = null;
                    this.subframeCacheSize = i;
                    if (this.DEBUG_RPF) {
                        Debug.output("RpfCacheHandler: resetting cache size to " + this.subframeCacheSize);
                    }
                    this.initCache(true);
                    return;
                }
            }
            RpfSubframe subframe = this.cache.subframe[i];
            subframe.version = 0;
            subframe.nextSubframe = i < this.subframeCacheSize - 1 ? i + 1 : 0;
            subframe.prevSubframe = i > 0 ? i - 1 : this.subframeCacheSize - 1;
        }
    }

    protected int getLRU() {
        if (this.cache != null) {
            return this.cache.LRU_tail;
        }
        return -1;
    }

    protected void freeCache(int index) {
        if (this.cache == null) {
            return;
        }
        if (index == this.cache.LRU_tail) {
            return;
        }
        if (index == this.cache.LRU_head) {
            this.cache.LRU_head = this.cache.subframe[this.cache.LRU_head].nextSubframe;
        } else {
            int prev;
            int next = this.cache.subframe[index].nextSubframe;
            this.cache.subframe[next].prevSubframe = prev = this.cache.subframe[index].prevSubframe;
            this.cache.subframe[prev].nextSubframe = next;
        }
        this.cache.subframe[this.cache.LRU_tail].nextSubframe = index;
        this.cache.subframe[index].prevSubframe = this.cache.LRU_tail;
        this.cache.LRU_tail = index;
    }

    protected void referenceCache(int index) {
        if (this.cache == null) {
            return;
        }
        if (index == this.cache.LRU_head) {
            return;
        }
        if (index == this.cache.LRU_tail) {
            this.cache.LRU_tail = this.cache.subframe[this.cache.LRU_tail].prevSubframe;
        } else {
            int prev;
            int next = this.cache.subframe[index].nextSubframe;
            this.cache.subframe[next].prevSubframe = prev = this.cache.subframe[index].prevSubframe;
            this.cache.subframe[prev].nextSubframe = next;
        }
        this.cache.subframe[this.cache.LRU_head].prevSubframe = index;
        this.cache.subframe[index].nextSubframe = this.cache.LRU_head;
        this.cache.LRU_head = index;
    }

    public int getCacheSize() {
        return this.subframeCacheSize;
    }

    protected RpfSubframe getSubframeFromOtherTOC(int x, int y) {
        return this.getSubframeFromOtherTOC(x, y, -1);
    }

    protected RpfSubframe getSubframeFromOtherTOC(int x, int y, int subframeCount) {
        int size = this.coverageBoxes.size();
        RpfCoverageBox currentBox = null;
        boolean cacheIt = false;
        RpfSubframe ret = null;
        int index = 0;
        if (size < 2) {
            return null;
        }
        if (this.subframeIndex == null || y < 0 || x < 0 || y >= this.subframeIndex.length || x >= this.subframeIndex[0].length || subframeCount >= this.subframeCacheSize) {
            cacheIt = false;
        }
        for (int i = 1; i < size; ++i) {
            try {
                currentBox = this.coverageBoxes.elementAt(i);
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                return null;
            }
            int offsetX = x - this.start.x;
            int offsetY = y - this.start.y;
            int newX = currentBox.startIndexes.x + offsetX;
            int newY = currentBox.startIndexes.y + offsetY;
            if (cacheIt) {
                index = this.getLRU();
                if (index < 0 || index >= this.subframeCacheSize || subframeCount >= this.subframeCacheSize) {
                    ret = null;
                } else {
                    this.referenceCache(index);
                    RpfSubframe subframe = this.cache.subframe[index];
                    this.subframeIndex[y][x] = (byte)index;
                    this.subframeVersion[y][x] = subframe.version;
                    ret = this.cache.subframe[index];
                }
            }
            if (ret == null) {
                try {
                    ret = new RpfSubframe();
                }
                catch (OutOfMemoryError oome) {
                    Debug.error("RpfCacheHandler: Out of memory!  No subframe for you!  Next up!");
                    return null;
                }
            }
            if (this.loadSubframe(ret, currentBox, newX, newY)) {
                return ret;
            }
            if (!cacheIt) continue;
            this.freeCache(index);
            this.subframeIndex[y][x] = -2;
        }
        return null;
    }

    protected RpfSubframe getCached(int cbx, int cby) {
        return this.getCached(cbx, cby, -1);
    }

    /*
     * Unable to fully structure code
     */
    protected RpfSubframe getCached(int cbx, int cby, int subframeCount) {
        currentBox = null;
        viewAttributes = this.getViewAttributes();
        x = cbx + this.subframeBuffer;
        y = cby + this.subframeBuffer;
        if (this.subframeIndex != null && (this.coverageBoxes == null || this.coverageBoxes.isEmpty() || y < 0 || x < 0 || y >= this.subframeIndex.length || x >= this.subframeIndex[0].length)) {
            return null;
        }
        try {
            currentBox = this.coverageBoxes.elementAt(0);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return null;
        }
        index = -1;
        if (this.subframeIndex != null) {
            index = this.subframeIndex[y][x];
        }
        if (index == -2) {
            return null;
        }
        if (index != -1 && this.cache != null && this.cache.subframe[index].version == this.subframeVersion[y][x] && subframeCount < this.subframeCacheSize) {
            this.referenceCache(index);
            ret = this.cache.subframe[index];
            if (this.DEBUG_RPF) {
                Debug.output("RpfCacheHandler: found subframe " + x + ", " + y + " in cache.");
            }
            ret.setTransparent(viewAttributes.opaqueness);
            if (this.frameProvider != null && viewAttributes.showInfo && (ret.getAttributeText() == null || ret.getAttributeText().length() == 0)) {
                ret.setAttributeText(this.frameProvider.getSubframeAttributes(currentBox.tocNumber, currentBox.entryNumber, x, y));
            }
            return ret;
        }
        index = this.getLRU();
        if (index < 0 || index >= this.subframeCacheSize || subframeCount >= this.subframeCacheSize) {
            try {
                ret = new RpfSubframe();
                if (!this.DEBUG_RPF) ** GOTO lbl41
                Debug.output("RpfCacheHandler: using uncached subframe.");
            }
            catch (OutOfMemoryError oome) {
                Debug.error("RpfCacheHandler: Out of memory!  No subframe for you!  Next up!");
                return null;
            }
        } else {
            this.referenceCache(index);
            this.cache.subframe[index].version = (byte)(this.cache.subframe[index].version + 1);
            this.subframeIndex[y][x] = (byte)index;
            this.subframeVersion[y][x] = this.cache.subframe[index].version;
            ret = this.cache.subframe[index];
        }
lbl41:
        // 3 sources

        if (this.loadSubframe(ret, currentBox, cbx, cby)) {
            return ret;
        }
        this.freeCache(index);
        if (this.subframeIndex != null) {
            this.subframeIndex[y][x] = -2;
        }
        return null;
    }

    protected boolean loadSubframe(RpfSubframe subframe, RpfCoverageBox coverageBox, int x, int y) {
        boolean good = false;
        int[] pixels = null;
        if (this.frameProvider == null) {
            Debug.message("rpf", "RpfCacheHandler.loadSubframes(): null frameProvider");
            return false;
        }
        RpfViewAttributes viewAttributes = this.getViewAttributes();
        subframe.opaqueness = viewAttributes.opaqueness;
        if (viewAttributes.colorModel == 0) {
            pixels = this.frameProvider.getSubframeData(coverageBox.tocNumber, coverageBox.entryNumber, x, y);
            if (pixels != null) {
                subframe.setPixels(pixels);
                good = true;
            }
        } else if (viewAttributes.colorModel == 1) {
            RpfIndexedImageData riid = this.frameProvider.getRawSubframeData(coverageBox.tocNumber, coverageBox.entryNumber, x, y);
            if (riid != null && riid.imageData != null && riid.colortable != null) {
                subframe.setBitsAndColors(riid.imageData, riid.colortable);
                subframe.setTransparent(viewAttributes.opaqueness);
                good = true;
            }
        } else {
            Debug.error("RpfCacheHandler: Frame Provider colormodel not handled.");
            return false;
        }
        if (good) {
            double ylloffset = (double)y * coverageBox.subframeLatInterval;
            double xlloffset = (double)x * coverageBox.subframeLonInterval;
            double lat = coverageBox.nw_lat - ylloffset;
            double lon = coverageBox.nw_lon + xlloffset;
            double lat2 = lat - coverageBox.subframeLatInterval;
            double lon2 = lon + coverageBox.subframeLonInterval;
            String data = viewAttributes != null && (viewAttributes.autofetchAttributes || viewAttributes.showInfo) ? this.frameProvider.getSubframeAttributes(coverageBox.tocNumber, coverageBox.entryNumber, x, y) : "";
            if (this.DEBUG_RPFDETAIL) {
                Debug.output("Attribute data for subframe " + x + ", " + y + ":\n" + data);
            }
            subframe.setLocation(lat, lon, lat2, lon2);
            subframe.setAttributeText(data);
            return true;
        }
        subframe.setAttributeText("");
        return false;
    }

    public static class SubframeCache {
        RpfSubframe[] subframe;
        int LRU_head;
        int LRU_tail;

        public SubframeCache(int numSubframes) {
            this.subframe = new RpfSubframe[numSubframes];
        }
    }
}

