/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.menu;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.gui.ToolPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JMenuItem;

public class ToolPanelToggleMenuItem
extends JMenuItem
implements ActionListener,
ComponentListener,
PropertyChangeListener {
    protected ToolPanel toolPanel = null;
    public static final String HideLabelProperty = "hide";
    public static final String DisplayLabelProperty = "display";
    protected static final String DefaultHideLabel = "Hide";
    protected static final String DefaultDisplayLabel = "Display";
    protected static final String DefaultToolPanelName = "Tool Panel";
    protected String hideLabel = "Hide";
    protected String displayLabel = "Display";

    public ToolPanelToggleMenuItem() {
        super(DefaultHideLabel);
        this.init(null);
    }

    public ToolPanelToggleMenuItem(ToolPanel tp) {
        super(tp.isVisible() ? DefaultHideLabel : DefaultDisplayLabel);
        this.init(tp);
    }

    public void init(ToolPanel tp) {
        this.setI18NLabels(tp);
        this.setToolPanel(tp);
        this.addActionListener(this);
    }

    public void setToolPanel(ToolPanel tp) {
        if (this.toolPanel != null) {
            this.toolPanel.removeComponentListener(this);
            this.toolPanel.removePropertyChangeListener(this);
        }
        this.toolPanel = tp;
        this.setVisible(this.toolPanel != null);
        if (this.toolPanel != null) {
            this.toolPanel.addComponentListener(this);
            this.toolPanel.addPropertyChangeListener(this);
            this.stateCheck();
        }
    }

    public ToolPanel getToolPanel() {
        return this.toolPanel;
    }

    public boolean forToolPanel(ToolPanel tp) {
        return tp == this.toolPanel;
    }

    public void actionPerformed(ActionEvent ae) {
        if (this.toolPanel != null) {
            boolean selected = this.toolPanel.isVisible();
            this.toolPanel.setVisible(!selected);
            this.setText(selected ? this.displayLabel : this.hideLabel);
        }
    }

    public void dispose() {
        this.setToolPanel(null);
    }

    public void stateCheck() {
        if (this.toolPanel != null) {
            this.setEnabled(this.toolPanel.areComponentsVisible());
            this.setText(this.toolPanel.isVisible() ? this.hideLabel : this.displayLabel);
        }
    }

    public void componentHidden(ComponentEvent ce) {
        this.stateCheck();
    }

    public void componentMoved(ComponentEvent ce) {
    }

    public void componentResized(ComponentEvent ce) {
    }

    public void componentShown(ComponentEvent ce) {
        this.stateCheck();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName.equals("membership")) {
            this.stateCheck();
        }
    }

    protected void setI18NLabels(ToolPanel tp) {
        I18n i18n = Environment.getI18n();
        String name = DefaultToolPanelName;
        if (tp != null) {
            name = tp.getName();
        }
        String interString = i18n.get(ToolPanelToggleMenuItem.class, HideLabelProperty, 3, this.hideLabel);
        this.hideLabel = interString + " " + name;
        interString = i18n.get(ToolPanelToggleMenuItem.class, DisplayLabelProperty, 3, this.displayLabel);
        this.displayLabel = interString + " " + name;
    }
}

