/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestorage.model;

import com.baidubce.BceClientException;
import com.baidubce.services.tablestorage.TableStorageConstants;
import com.baidubce.services.tablestorage.model.DeleteRow;
import com.baidubce.services.tablestorage.model.GetRow;
import com.baidubce.services.tablestorage.model.PutRow;
import com.baidubce.services.tablestorage.model.TableStorageCell;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TableStorageRow {
    protected String rowkey;
    protected List<TableStorageCell> cells = new ArrayList<TableStorageCell>();
    protected int rowSize = 0;

    public TableStorageRow(String rowkey) {
        this.rowkey = rowkey;
    }

    public String getRowkey() {
        return this.rowkey;
    }

    public List<TableStorageCell> getCells() {
        return Collections.unmodifiableList(this.cells);
    }

    public int getRowSize() {
        return this.rowSize;
    }

    protected static void checkRow(TableStorageRow row) {
        if (row == null) {
            return;
        }
        if (row.rowkey == null || row.rowkey.isEmpty()) {
            throw new BceClientException("The rowkey's value should not be null or be empty.");
        }
        if (row.rowkey.length() > 4096) {
            throw new BceClientException("The rowkey's size should not exceed the limit 4096. rowkeySize=" + row.rowkey.length() + ".");
        }
        if (row instanceof PutRow && row.rowSize > 0x800000) {
            throw new BceClientException("The row's size should not exceed the limit 8388608. rowkey=" + row.rowkey + ", rowSize=" + row.rowSize + ".");
        }
        if ((row instanceof PutRow || row instanceof DeleteRow) && row.cells.size() > 1024) {
            throw new BceClientException("The number of cells should not exceed the limit 1024. rowkey=" + row.rowkey + ", cellNum=" + row.cells.size() + ".");
        }
        if (row instanceof GetRow && row.cells.size() > 128) {
            throw new BceClientException("The number of cells should not exceed the limit 128. rowkey=" + row.rowkey + ", cellNum=" + row.cells.size() + ".");
        }
        for (TableStorageCell cell : row.cells) {
            TableStorageCell.checkCell(cell);
        }
    }

    public String toJsonString() {
        TableStorageRow.checkRow(this);
        StringBuffer buffer = new StringBuffer("{\"rowkey\":\"");
        try {
            buffer.append(URLEncoder.encode(this.rowkey, TableStorageConstants.DEFAULT_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("The rowkey don't support " + TableStorageConstants.DEFAULT_ENCODING + " encode, rowkey=" + this.rowkey + ".");
        }
        buffer.append("\",\"cells\":[");
        for (int i = 0; i < this.cells.size(); ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            TableStorageCell cell = this.cells.get(i);
            buffer.append(cell.toJsonString());
        }
        buffer.append("]}");
        return buffer.toString();
    }
}

