/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.sms;

import com.baidubce.BceServiceException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.internal.InternalRequest;
import com.baidubce.services.sms.SmsClientConfiguration;
import com.baidubce.services.sms.SmsClientSupport;
import com.baidubce.services.sms.model.GetTemplateDetailRequest;
import com.baidubce.services.sms.model.GetTemplateDetailResponse;
import com.baidubce.services.sms.model.ListTemplateResponse;
import com.baidubce.services.sms.model.QueryMessageDetailRequest;
import com.baidubce.services.sms.model.QueryMessageDetailResponse;
import com.baidubce.services.sms.model.QueryQuotaResponse;
import com.baidubce.services.sms.model.SendMessageRequest;
import com.baidubce.services.sms.model.SendMessageResponse;
import com.baidubce.services.sms.model.SendMessageV2Request;
import com.baidubce.services.sms.model.SendMessageV2Response;
import com.baidubce.services.sms.model.SendMessageV3Request;
import com.baidubce.services.sms.model.SendMessageV3Response;
import com.baidubce.services.sms.model.SmsRequest;
import com.baidubce.services.sms.model.SmsResponse;
import com.baidubce.services.sms.model.StatReceiverRequest;
import com.baidubce.services.sms.model.StatReceiverResponse;
import com.baidubce.services.sms.model.v3.CreateSignatureRequest;
import com.baidubce.services.sms.model.v3.CreateSignatureResponse;
import com.baidubce.services.sms.model.v3.CreateTemplateRequest;
import com.baidubce.services.sms.model.v3.CreateTemplateResponse;
import com.baidubce.services.sms.model.v3.DeleteSignatureRequest;
import com.baidubce.services.sms.model.v3.DeleteTemplateRequest;
import com.baidubce.services.sms.model.v3.GetSignatureRequest;
import com.baidubce.services.sms.model.v3.GetSignatureResponse;
import com.baidubce.services.sms.model.v3.GetTemplateRequest;
import com.baidubce.services.sms.model.v3.GetTemplateResponse;
import com.baidubce.services.sms.model.v3.ListSignatureRequest;
import com.baidubce.services.sms.model.v3.ListSignatureResponse;
import com.baidubce.services.sms.model.v3.ListTemplateRequest;
import com.baidubce.services.sms.model.v3.ModifySignatureRequest;
import com.baidubce.services.sms.model.v3.ModifyTemplateRequest;
import com.baidubce.services.sms.model.v3.QueryQuotaRateResponse;
import com.baidubce.services.sms.model.v3.UpdateQuotaRateRequest;
import com.baidubce.util.JsonUtils;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class SmsClient
extends SmsClientSupport {
    public SmsClient() {
        this(new SmsClientConfiguration());
    }

    public SmsClient(SmsClientConfiguration config) {
        super(config, SMS_HANDLERS);
    }

    @Deprecated
    public SendMessageResponse sendMessage(SendMessageRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null.");
        this.assertStringNotNullOrEmpty(request.getTemplateId(), "string templateId of request should not be null or empty.");
        this.assertListNotNullOrEmpty(request.getReceiver(), "list receiver of request should not be null or empty.");
        for (String receiver : request.getReceiver()) {
            this.assertStringNotNullOrEmpty(receiver, "receiver should not be null or empty.");
        }
        InternalRequest internalRequest = this.createRequest("message", request, HttpMethodName.POST, new String[0]);
        internalRequest = this.fillRequestPayload(internalRequest, JsonUtils.toJsonString(request));
        return this.invokeHttpClient(internalRequest, SendMessageResponse.class);
    }

    @Deprecated
    public SendMessageV2Response sendMessage(SendMessageV2Request request) {
        Preconditions.checkNotNull((Object)request, (Object)"request is required.");
        this.assertStringNotNullOrEmpty(request.getInvokeId(), "invokeId is required.");
        this.assertStringNotNullOrEmpty(request.getPhoneNumber(), "phoneNumber is required.");
        this.assertStringNotNullOrEmpty(request.getTemplateCode(), "templateCode is required.");
        InternalRequest internalRequest = this.createGeneralRequest("bce/v2/message", request, HttpMethodName.POST, new String[0]);
        internalRequest = this.fillRequestPayload(internalRequest, JsonUtils.toJsonString(request));
        SendMessageV2Response response = null;
        try {
            response = this.invokeHttpClient(internalRequest, SendMessageV2Response.class);
        }
        catch (BceServiceException exception) {
            response = new SendMessageV2Response();
            response.setCode(exception.getErrorCode());
            response.setMessage(exception.getErrorMessage());
            response.setRequestId(exception.getRequestId());
        }
        return response;
    }

    public SendMessageV3Response sendMessage(SendMessageV3Request request) {
        SendMessageV3Response response;
        Preconditions.checkNotNull((Object)request, (Object)"request is required.");
        this.assertStringNotNullOrEmpty(request.getMobile(), "mobile is required.");
        this.assertStringNotNullOrEmpty(request.getSignatureId(), "signatureId is required.");
        this.assertStringNotNullOrEmpty(request.getTemplate(), "template is required.");
        InternalRequest internalRequest = this.createGeneralRequest("api/v3/sendsms", request, HttpMethodName.POST, new String[0]);
        if (!StringUtils.isBlank((CharSequence)request.getClientToken())) {
            internalRequest.addParameter("clientToken", request.getClientToken());
        }
        internalRequest = this.fillRequestPayload(internalRequest, JsonUtils.toJsonString(request));
        try {
            response = this.invokeHttpClient(internalRequest, SendMessageV3Response.class);
        }
        catch (BceServiceException exception) {
            response = new SendMessageV3Response();
            response.setCode(exception.getErrorCode());
            response.setMessage(exception.getErrorMessage());
            response.setRequestId(exception.getRequestId());
        }
        return response;
    }

    public QueryMessageDetailResponse queryMessageDetail(QueryMessageDetailRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null.");
        this.assertStringNotNullOrEmpty(request.getMessageId(), "object messageId should not be null or empty.");
        InternalRequest internalRequest = this.createRequest("message", request, HttpMethodName.GET, request.getMessageId());
        return this.invokeHttpClient(internalRequest, QueryMessageDetailResponse.class);
    }

    public com.baidubce.services.sms.model.CreateTemplateResponse createTemplate(com.baidubce.services.sms.model.CreateTemplateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request is required.");
        this.assertStringNotNullOrEmpty(request.getName(), "template name is required.");
        this.assertStringNotNullOrEmpty(request.getContent(), "template content is required.");
        this.assertStringNotNullOrEmpty(request.getInvokeId(), "template invokeId is required.");
        InternalRequest internalRequest = this.createGeneralRequest("bce/v2/applyTemplate", request, HttpMethodName.POST, new String[0]);
        internalRequest = this.fillRequestPayload(internalRequest, JsonUtils.toJsonString(request));
        com.baidubce.services.sms.model.CreateTemplateResponse response = null;
        try {
            response = this.invokeHttpClient(internalRequest, com.baidubce.services.sms.model.CreateTemplateResponse.class);
        }
        catch (BceServiceException exception) {
            response = new com.baidubce.services.sms.model.CreateTemplateResponse();
            response.setCode(exception.getErrorCode());
            response.setMessage(exception.getErrorMessage());
            response.setRequestId(exception.getRequestId());
        }
        return response;
    }

    public CreateTemplateResponse createTemplate(CreateTemplateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null");
        this.assertStringNotNullOrEmpty(request.getContent(), "content should not be null or empty");
        this.assertStringNotNullOrEmpty(request.getCountryType(), "countryType should not be null or empty");
        this.assertStringNotNullOrEmpty(request.getName(), "name should not be null or empty");
        this.assertStringNotNullOrEmpty(request.getSmsType(), "smsType should not be null or empty");
        InternalRequest internalRequest = this.createGeneralRequest("/sms/v3/template", request, HttpMethodName.POST, new String[0]);
        internalRequest = this.fillRequestPayload(internalRequest, JsonUtils.toJsonString(request));
        internalRequest.addParameter("clientToken", UUID.randomUUID().toString());
        return this.invokeHttpClient(internalRequest, CreateTemplateResponse.class);
    }

    public void deleteTemplate(com.baidubce.services.sms.model.DeleteTemplateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null.");
        this.assertStringNotNullOrEmpty(request.getTemplateId(), "object templateId should not be null or empty.");
        InternalRequest internalRequest = this.createRequest("template", request, HttpMethodName.DELETE, request.getTemplateId());
        this.invokeHttpClient(internalRequest, SmsResponse.class);
    }

    public void deleteTemplate(DeleteTemplateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null");
        this.assertStringNotNullOrEmpty(request.getTemplateId(), "templateId should not be null or empty");
        InternalRequest internalRequest = this.createGeneralRequest("/sms/v3/template", request, HttpMethodName.DELETE, request.getTemplateId());
        this.invokeHttpClient(internalRequest, SmsResponse.class);
    }

    @Deprecated
    public GetTemplateDetailResponse getTemplateDetail(GetTemplateDetailRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null.");
        this.assertStringNotNullOrEmpty(request.getTemplateId(), "object templateId should not be null or empty.");
        InternalRequest internalRequest = this.createRequest("template", request, HttpMethodName.GET, request.getTemplateId());
        return this.invokeHttpClient(internalRequest, GetTemplateDetailResponse.class);
    }

    public ListTemplateResponse listTemplate(SmsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null.");
        InternalRequest internalRequest = this.createRequest("template", request, HttpMethodName.GET, new String[0]);
        return this.invokeHttpClient(internalRequest, ListTemplateResponse.class);
    }

    public com.baidubce.services.sms.model.v3.ListTemplateResponse listTemplate(ListTemplateRequest request) {
        InternalRequest internalRequest = this.createGeneralRequest("/sms/v3/template", new SmsRequest(), HttpMethodName.GET, new String[0]);
        if (request.getContent() != null && request.getContent().trim().length() > 0) {
            internalRequest.addParameter("contentLike", request.getContent());
        }
        if (request.getCountryType() != null && request.getCountryType().trim().length() > 0) {
            internalRequest.addParameter("countryType", request.getCountryType());
        }
        if (request.getName() != null && request.getName().trim().length() > 0) {
            internalRequest.addParameter("nameLike", request.getName());
        }
        if (request.getSmsType() != null && request.getSmsType().trim().length() > 0) {
            internalRequest.addParameter("smsType", request.getSmsType());
        }
        if (request.getStatus() != null && request.getSmsType().trim().length() > 0) {
            internalRequest.addParameter("status", request.getStatus());
        }
        if (request.getTemplateId() != null && request.getTemplateId().trim().length() > 0) {
            internalRequest.addParameter("templateIdLike", request.getTemplateId());
        }
        Preconditions.checkNotNull((Object)request.getPageNo(), (Object)"Require pageNo not null");
        Preconditions.checkNotNull((Object)request.getPageSize(), (Object)"Require pageSize not null");
        internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        internalRequest.addParameter("isIgnoreDeprecated", "true");
        return this.invokeHttpClient(internalRequest, com.baidubce.services.sms.model.v3.ListTemplateResponse.class);
    }

    public QueryQuotaResponse queryQuota(SmsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null.");
        InternalRequest internalRequest = this.createRequest("quota", request, HttpMethodName.GET, new String[0]);
        return this.invokeHttpClient(internalRequest, QueryQuotaResponse.class);
    }

    public StatReceiverResponse statReceiver(StatReceiverRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null.");
        this.assertStringNotNullOrEmpty(request.getPhoneNumber(), "object phoneNumber should not be null or empty.");
        InternalRequest internalRequest = this.createRequest("receiver", request, HttpMethodName.GET, request.getPhoneNumber());
        return this.invokeHttpClient(internalRequest, StatReceiverResponse.class);
    }

    public CreateSignatureResponse createSignature(CreateSignatureRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null");
        this.assertStringNotNullOrEmpty(request.getContent(), "content should not be null or empty");
        this.assertStringNotNullOrEmpty(request.getContentType(), "contentType should not be null or empty");
        this.assertStringNotNullOrEmpty(request.getCountryType(), "countryType should not be null or empty");
        InternalRequest internalRequest = this.createGeneralRequest("/sms/v3/signatureApply", request, HttpMethodName.POST, new String[0]);
        internalRequest = this.fillRequestPayload(internalRequest, JsonUtils.toJsonString(request));
        internalRequest.addParameter("clientToken", UUID.randomUUID().toString());
        return this.invokeHttpClient(internalRequest, CreateSignatureResponse.class);
    }

    public void deleteSignature(DeleteSignatureRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null");
        this.assertStringNotNullOrEmpty(request.getSignatureId(), "signatureId should not be null or empty");
        InternalRequest internalRequest = this.createGeneralRequest("/sms/v3/signatureApply", request, HttpMethodName.DELETE, request.getSignatureId());
        this.invokeHttpClient(internalRequest, SmsResponse.class);
    }

    public void modifySignature(ModifySignatureRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null");
        this.assertStringNotNullOrEmpty(request.getSignatureId(), "signatureId should not be null or empty");
        this.assertStringNotNullOrEmpty(request.getContent(), "content should not be null or empty");
        this.assertStringNotNullOrEmpty(request.getContentType(), "contentType should not be null or empty");
        this.assertStringNotNullOrEmpty(request.getCountryType(), "countryType should not be null or empty");
        InternalRequest internalRequest = this.createGeneralRequest("/sms/v3/signatureApply", request, HttpMethodName.PUT, request.getSignatureId());
        internalRequest = this.fillRequestPayload(internalRequest, JsonUtils.toJsonString(request));
        this.invokeHttpClient(internalRequest, SmsResponse.class);
    }

    public GetSignatureResponse getSignature(GetSignatureRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null");
        this.assertStringNotNullOrEmpty(request.getSignatureId(), "signatureId should not be null or empty");
        InternalRequest internalRequest = this.createGeneralRequest("/sms/v3/signatureApply", request, HttpMethodName.GET, request.getSignatureId());
        return this.invokeHttpClient(internalRequest, GetSignatureResponse.class);
    }

    public void modifyTemplate(ModifyTemplateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null");
        this.assertStringNotNullOrEmpty(request.getTemplateId(), "templateId should not be null or empty");
        InternalRequest internalRequest = this.createGeneralRequest("/sms/v3/template", request, HttpMethodName.PUT, request.getTemplateId());
        internalRequest = this.fillRequestPayload(internalRequest, JsonUtils.toJsonString(request));
        this.invokeHttpClient(internalRequest, SmsResponse.class);
    }

    public GetTemplateResponse getTemplate(GetTemplateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null");
        this.assertStringNotNullOrEmpty(request.getTemplateId(), "templateId should not be null or empty");
        InternalRequest internalRequest = this.createGeneralRequest("/sms/v3/template", request, HttpMethodName.GET, request.getTemplateId());
        return this.invokeHttpClient(internalRequest, GetTemplateResponse.class);
    }

    public void updateQuotaRate(UpdateQuotaRateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"object request should not be null");
        Preconditions.checkNotNull((Object)request.getQuotaPerDay(), (Object)"quotaPerDay should not be null or empty");
        Preconditions.checkNotNull((Object)request.getQuotaPerMonth(), (Object)"quotaPerMonth should not be null or empty");
        Preconditions.checkNotNull((Object)request.getRateLimitPerDay(), (Object)"rateLimitPerDay should not be null or empty");
        Preconditions.checkNotNull((Object)request.getRateLimitPerHour(), (Object)"rateLimitPerHour should not be null or empty");
        Preconditions.checkNotNull((Object)request.getRateLimitPerMinute(), (Object)"rateLimitPerMinute should not be null or empty");
        InternalRequest internalRequest = this.createGeneralRequest("/sms/v3/quota", request, HttpMethodName.PUT, new String[0]);
        internalRequest = this.fillRequestPayload(internalRequest, JsonUtils.toJsonString(request));
        this.invokeHttpClient(internalRequest, SmsResponse.class);
    }

    public QueryQuotaRateResponse queryQuotaRate() {
        InternalRequest internalRequest = this.createGeneralRequest("/sms/v3/quota", new SmsRequest(), HttpMethodName.GET, new String[0]);
        internalRequest.addParameter("userQuery", "");
        return this.invokeHttpClient(internalRequest, QueryQuotaRateResponse.class);
    }

    public ListSignatureResponse listSignature(ListSignatureRequest request) {
        InternalRequest internalRequest = this.createGeneralRequest("/sms/v3/signatureApply", new SmsRequest(), HttpMethodName.GET, new String[0]);
        if (request.getContent() != null && request.getContent().trim().length() > 0) {
            internalRequest.addParameter("contentLike", request.getContent());
        }
        if (request.getSignatureId() != null && request.getSignatureId().trim().length() > 0) {
            internalRequest.addParameter("signatureIdLike", request.getSignatureId());
        }
        if (request.getCountryType() != null && request.getCountryType().trim().length() > 0) {
            internalRequest.addParameter("countryType", request.getCountryType());
        }
        if (request.getStatus() != null && request.getStatus().trim().length() > 0) {
            internalRequest.addParameter("status", request.getStatus());
        }
        Preconditions.checkNotNull((Object)request.getPageNo(), (Object)"Require pageNo not null");
        Preconditions.checkNotNull((Object)request.getPageSize(), (Object)"Require pageSize not null");
        internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        internalRequest.addParameter("isIgnoreDeprecated", "true");
        return this.invokeHttpClient(internalRequest, ListSignatureResponse.class);
    }
}

