/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.nat;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.nat.NatClientConfiguration;
import com.baidubce.services.nat.model.BindDnatEipRequest;
import com.baidubce.services.nat.model.BindEipRequest;
import com.baidubce.services.nat.model.CreateDnatRuleRequest;
import com.baidubce.services.nat.model.CreateNatRequest;
import com.baidubce.services.nat.model.CreateNatResponse;
import com.baidubce.services.nat.model.CreateNatRuleResponse;
import com.baidubce.services.nat.model.CreateSnatRuleRequest;
import com.baidubce.services.nat.model.DeleteNatRuleRequest;
import com.baidubce.services.nat.model.GetNatRequest;
import com.baidubce.services.nat.model.GetNatResponse;
import com.baidubce.services.nat.model.ListDnatRuleResponse;
import com.baidubce.services.nat.model.ListNatRequest;
import com.baidubce.services.nat.model.ListNatResponse;
import com.baidubce.services.nat.model.ListNatRuleRequest;
import com.baidubce.services.nat.model.ListSnatRuleResponse;
import com.baidubce.services.nat.model.ModifyNatRequest;
import com.baidubce.services.nat.model.PurchaseReservedNatRequest;
import com.baidubce.services.nat.model.ReleaseNatRequest;
import com.baidubce.services.nat.model.UpdateDnatRuleRequest;
import com.baidubce.services.nat.model.UpdateSnatRuleRequest;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NatClient
extends AbstractBceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(NatClient.class);
    private static final String VERSION = "v1";
    private static final String NAT_PREFIX = "nat";
    private static final String CLIENT_TOKEN = "clientToken";
    private static final String SNAT_RULE_PREFIX = "snatRule";
    private static final String DNAT_RULE_PREFIX = "dnatRule";
    private static final HttpResponseHandler[] natHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public NatClient() {
        this(new NatClientConfiguration());
    }

    public NatClient(NatClientConfiguration clientConfiguration) {
        super(clientConfiguration, natHandlers);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }

    public CreateNatResponse createNat(CreateNatRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        Preconditions.checkNotNull((Object)request.getBilling(), (Object)"billing should not be empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, NAT_PREFIX);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateNatResponse.class);
    }

    public ListNatResponse listNat(ListNatRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getVpcId(), "vpcId should not be empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, NAT_PREFIX);
        if (StringUtils.isNotBlank((CharSequence)request.getMarker())) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        internalRequest.addParameter("vpcId", request.getVpcId());
        if (StringUtils.isNotBlank((CharSequence)request.getNatId())) {
            internalRequest.addParameter("natId", request.getNatId());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getName())) {
            internalRequest.addParameter("name", request.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getIp())) {
            internalRequest.addParameter("ip", request.getIp());
        }
        return this.invokeHttpClient(internalRequest, ListNatResponse.class);
    }

    public GetNatResponse getNat(String natId) {
        Validate.checkStringNotEmpty(natId, "natId should not be empty.");
        GetNatRequest request = new GetNatRequest().withNatId(natId);
        return this.getNat(request);
    }

    public GetNatResponse getNat(GetNatRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getNatId(), "natId should not be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, NAT_PREFIX, request.getNatId());
        return this.invokeHttpClient(internalRequest, GetNatResponse.class);
    }

    public void modifyNat(ModifyNatRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getNatId(), "natId should not be null.");
        Validate.checkStringNotEmpty(request.getName(), "name should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, NAT_PREFIX, request.getNatId());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void bindEip(BindEipRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Preconditions.checkNotNull(request.getEips(), (Object)"eips should not be null.");
        Validate.checkStringNotEmpty(request.getNatId(), "natId should not be empty.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, NAT_PREFIX, request.getNatId());
        internalRequest.addParameter("bind", null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void unbindEip(BindEipRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Preconditions.checkNotNull(request.getEips(), (Object)"eips should not be null.");
        Validate.checkStringNotEmpty(request.getNatId(), "natId should not be empty.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, NAT_PREFIX, request.getNatId());
        internalRequest.addParameter("unbind", null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void releaseNat(ReleaseNatRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getNatId(), "natId should not be empty.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, NAT_PREFIX, request.getNatId());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void purchaseReservedNat(PurchaseReservedNatRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getNatId(), "natId should not be empty.");
        Preconditions.checkNotNull((Object)request.getBilling(), (Object)"billing should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, NAT_PREFIX, request.getNatId());
        internalRequest.addParameter("purchaseReserved", null);
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void bindDnatEip(BindDnatEipRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getNatId(), "natId should not be empty.");
        Preconditions.checkNotNull(request.getDnatEips(), (Object)"dnatEips should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, NAT_PREFIX, request.getNatId());
        internalRequest.addParameter("bind", null);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void unbindDnatEip(BindDnatEipRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getNatId(), "natId should not be empty.");
        Preconditions.checkNotNull(request.getDnatEips(), (Object)"dnatEips should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, NAT_PREFIX, request.getNatId());
        internalRequest.addParameter("unbind", null);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public CreateNatRuleResponse createSnatRule(CreateSnatRuleRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getNatId(), "natId should not be empty.");
        Validate.checkStringNotEmpty(request.getRuleName(), "ruleName should not be empty.");
        Validate.checkStringNotEmpty(request.getSourceCIDR(), "sourceCIDR should not be empty.");
        Preconditions.checkNotNull(request.getPublicIpsAddress(), (Object)"publicIpsAddress should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, NAT_PREFIX, request.getNatId(), SNAT_RULE_PREFIX);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateNatRuleResponse.class);
    }

    public void deleteSnatRule(DeleteNatRuleRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getNatId(), "natId should not be empty.");
        Validate.checkStringNotEmpty(request.getRuleId(), "ruleId should not be empty.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, NAT_PREFIX, request.getNatId(), SNAT_RULE_PREFIX, request.getRuleId());
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateSnatRule(UpdateSnatRuleRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getNatId(), "natId should not be empty.");
        Validate.checkStringNotEmpty(request.getRuleId(), "ruleId should not be empty.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, NAT_PREFIX, request.getNatId(), SNAT_RULE_PREFIX, request.getRuleId());
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListSnatRuleResponse listSnatRule(String natId) {
        Validate.checkStringNotEmpty(natId, "natId should not be empty.");
        return this.listSnatRule(new ListNatRuleRequest().withNatId(natId));
    }

    public ListSnatRuleResponse listSnatRule(ListNatRuleRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getNatId(), "natId should not be empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, NAT_PREFIX, request.getNatId(), SNAT_RULE_PREFIX);
        if (StringUtils.isNotBlank((CharSequence)request.getMarker())) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        return this.invokeHttpClient(internalRequest, ListSnatRuleResponse.class);
    }

    public CreateNatRuleResponse createDnatRule(CreateDnatRuleRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getNatId(), "natId should not be empty.");
        Validate.checkStringNotEmpty(request.getPublicIpAddress(), "publicIpAddress should not be empty.");
        Validate.checkStringNotEmpty(request.getPrivateIpAddress(), "privateIpAddress should not be empty.");
        Validate.checkStringNotEmpty(request.getProtocol(), "protocol should not be empty.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, NAT_PREFIX, request.getNatId(), DNAT_RULE_PREFIX);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateNatRuleResponse.class);
    }

    public void deleteDnatRule(DeleteNatRuleRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getNatId(), "natId should not be empty.");
        Validate.checkStringNotEmpty(request.getRuleId(), "ruleId should not be empty.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, NAT_PREFIX, request.getNatId(), DNAT_RULE_PREFIX, request.getRuleId());
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateDnatRule(UpdateDnatRuleRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getNatId(), "natId should not be empty.");
        Validate.checkStringNotEmpty(request.getRuleId(), "ruleId should not be empty.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, NAT_PREFIX, request.getNatId(), DNAT_RULE_PREFIX, request.getRuleId());
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListDnatRuleResponse listDnatRule(String natId) {
        Validate.checkStringNotEmpty(natId, "natId should not be empty.");
        return this.listDnatRule(new ListNatRuleRequest().withNatId(natId));
    }

    public ListDnatRuleResponse listDnatRule(ListNatRuleRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getNatId(), "natId should not be empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, NAT_PREFIX, request.getNatId(), DNAT_RULE_PREFIX);
        if (StringUtils.isNotBlank((CharSequence)request.getMarker())) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        return this.invokeHttpClient(internalRequest, ListDnatRuleResponse.class);
    }
}

