/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iothisk.device.utils;

import com.google.common.primitives.UnsignedLongs;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.StringUtils;

public class ByteUtils {
    public static byte[] toBytesFromHex(String data) {
        if (data.length() % 2 == 1) {
            data = StringUtils.leftPad((String)data, (int)(data.length() + 1), (char)'0');
        }
        return DatatypeConverter.parseHexBinary((String)data);
    }

    public static String toHexStringFromBytes(byte[] data) {
        return DatatypeConverter.printHexBinary((byte[])data);
    }

    public static byte[] toBytesFromInt(int number) {
        try {
            String hexNumber = Integer.toHexString(number);
            return ByteUtils.toBytesFromHex(hexNumber);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid int data");
        }
    }

    public static long toLongFromBytes(byte[] data) {
        try {
            return UnsignedLongs.parseUnsignedLong((String)DatatypeConverter.printHexBinary((byte[])data), (int)16);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid bytes");
        }
    }

    public static byte[] getCounterBytes(long counter) {
        try {
            String hexCounter = Long.toHexString(counter);
            hexCounter = StringUtils.leftPad((String)hexCounter, (int)8, (char)'0');
            return ByteUtils.toBytesFromHex(hexCounter);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The counter to be encrypted or decrypted is invalid.");
        }
    }
}

