/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iothisk.device.crypto;

import java.security.Key;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class AesEncrypt {
    private static final String AES_ALGORITHM = "AES";
    private static final String AES_CTR_NO_PADDING_CIPHER = "AES/CTR/NoPadding";
    private static final Set<String> AES_MODES_WITH_IV = new HashSet<String>(Arrays.asList("CBC", "CFB", "CTR", "OFB", "PCBC"));
    private static final Set<String> AES_MODES_WITHOUT_IV = new HashSet<String>(Arrays.asList("ECB"));

    public static SecretKey loadKey(byte[] key, String algorithm) {
        return new SecretKeySpec(key, algorithm);
    }

    public static byte[] encrypt(byte[] data, SecretKey key, String cipherName) {
        return AesEncrypt.encrypt(data, key, null, cipherName);
    }

    public static byte[] encrypt(byte[] data, SecretKey key, IvParameterSpec iv, String cipherName) {
        try {
            Cipher cipher = Cipher.getInstance(cipherName);
            String mode = AesEncrypt.getModeName(cipherName);
            if (AES_MODES_WITHOUT_IV.contains(mode)) {
                cipher.init(1, key);
            } else {
                iv = iv == null ? new IvParameterSpec(new byte[cipher.getBlockSize()]) : iv;
                cipher.init(1, (Key)key, iv);
            }
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new IllegalStateException("AES encrypt failed", e);
        }
    }

    public static byte[] decrypt(byte[] data, SecretKey key, IvParameterSpec iv, String cipherName) {
        try {
            Cipher cipher = Cipher.getInstance(cipherName);
            String mode = AesEncrypt.getModeName(cipherName);
            if (AES_MODES_WITHOUT_IV.contains(mode)) {
                cipher.init(2, key);
            } else {
                iv = iv == null ? new IvParameterSpec(new byte[cipher.getBlockSize()]) : iv;
                cipher.init(2, (Key)key, iv);
            }
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new IllegalStateException("AES decrypt failed", e);
        }
    }

    public static byte[] encryptByCTRNoPadding(byte[] data, byte[] key, byte[] iv) {
        return AesEncrypt.encrypt(data, AesEncrypt.loadKey(key, AES_ALGORITHM), new IvParameterSpec(iv), AES_CTR_NO_PADDING_CIPHER);
    }

    public static byte[] decryptByCTRNoPadding(byte[] data, byte[] key, byte[] iv) {
        return AesEncrypt.decrypt(data, AesEncrypt.loadKey(key, AES_ALGORITHM), new IvParameterSpec(iv), AES_CTR_NO_PADDING_CIPHER);
    }

    private static String getModeName(String cipherName) {
        String mode;
        if (StringUtils.contains((CharSequence)cipherName, (CharSequence)"/") && (AES_MODES_WITHOUT_IV.contains(mode = StringUtils.split((String)cipherName, (String)"/")[1]) || AES_MODES_WITH_IV.contains(mode))) {
            return mode;
        }
        throw new IllegalArgumentException("Invalid AES cipher name.");
    }
}

