/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.dugo.core.protocol.http;

import com.baidubce.BceClientConfiguration;
import com.baidubce.auth.BceCredentials;
import com.baidubce.auth.BceV1Signer;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.BceHttpClient;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.util.DateUtils;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BceIotHttpClient {
    private static final String CONTENT_TYPE = "application/json;charset=utf-8";
    private InternalRequest internalRequest;
    private BceCredentials bceCredentials;
    private URI uri;

    public URI getUri() {
        return this.uri;
    }

    public BceIotHttpClient withAuth(String ak, String sk) {
        this.initBceCredentials(ak, sk);
        return this;
    }

    public String getHost() {
        return this.uri.getHost();
    }

    public BceIotHttpClient withMethod(HttpMethodName methodName, URI uri) {
        this.uri = uri;
        this.initInternalRequest(methodName, uri);
        return this;
    }

    public InternalRequest getInternalRequest() {
        return this.internalRequest;
    }

    private void initBceCredentials(String ak, String sk) {
        this.bceCredentials = new DefaultBceCredentials(ak, sk);
    }

    private void initInternalRequest(HttpMethodName methodName, URI uri) {
        this.internalRequest = new InternalRequest(methodName, uri);
        this.internalRequest.setCredentials(this.bceCredentials);
        this.internalRequest.setSignOptions(this.initSignOptions());
        this.internalRequest.setHeaders(this.initHeaders(uri));
        this.internalRequest.addHeader("Content-Type", CONTENT_TYPE);
    }

    public void addParams(String key, String value) {
        this.internalRequest.addParameter(key, value);
    }

    private Map<String, String> initHeaders(URI uri) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-bce-date", DateUtils.formatAlternateIso8601Date(new Date()));
        headers.put("Host", uri.getHost());
        return headers;
    }

    public void addHeader(String key, String value) {
        this.internalRequest.addHeader(key, value);
    }

    private SignOptions initSignOptions() {
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(this.getHeadersToSign());
        signOptions.setExpirationInSeconds(3600);
        return signOptions;
    }

    private Set<String> getHeadersToSign() {
        HashSet<String> signHeaders = new HashSet<String>();
        signHeaders.add("Host");
        signHeaders.add("x-bce-date");
        return signHeaders;
    }

    public BceIotHttpClient withPayload(byte[] payload) {
        if (payload == null) {
            return this;
        }
        this.internalRequest.setContent(RestartableInputStream.wrap(payload));
        this.internalRequest.addHeader("Content-Length", "" + payload.length);
        this.internalRequest.addHeader("Content-Length", Integer.toString(payload.length));
        this.internalRequest.addHeader("Content-Type", CONTENT_TYPE);
        return this;
    }

    public <T extends AbstractBceResponse> T exec(Class<T> responseClass, HttpResponseHandler[] hadlers) {
        this.checkClient();
        BceClientConfiguration config = new BceClientConfiguration();
        BceV1Signer signer = new BceV1Signer();
        BceHttpClient httpClient = new BceHttpClient(config, signer);
        return httpClient.execute(this.internalRequest, responseClass, hadlers);
    }

    public <T extends AbstractBceResponse> T exec(Class<T> responseClass) {
        HttpResponseHandler[] responseHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceJsonResponseHandler(), new BceErrorResponseHandler()};
        return this.exec(responseClass, responseHandlers);
    }

    private void checkClient() {
        if (this.bceCredentials == null || this.bceCredentials.getAccessKeyId() == null || this.bceCredentials.getSecretKey() == null) {
            throw new IllegalArgumentException("accessKey and secretKey should not be null");
        }
    }
}

