/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.cdn.model.stat;

import com.baidubce.services.cdn.model.CdnRequest;
import com.baidubce.services.cdn.model.GetStatMetricMapping;
import com.baidubce.util.DateUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class GetStatMetricRequest
extends CdnRequest {
    private String metric;
    private String startTime;
    private String endTime;
    private Integer period = 300;
    @JsonProperty(value="key_type")
    private Integer keyType = 0;
    private List<String> key;
    private String groupBy = "key";
    private String prov;
    private String isp;
    private String level;
    private String protocol;
    private Integer extra;
    private String sortKey;

    public GetStatMetricRequest withMetric(String metric) {
        this.metric = metric;
        return this;
    }

    public GetStatMetricRequest withSortKey(String sortKey) {
        this.sortKey = sortKey;
        return this;
    }

    public GetStatMetricRequest withStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    public GetStatMetricRequest withDateStartTime(Date startTime) {
        this.startTime = DateUtils.formatAlternateIso8601Date(startTime);
        return this;
    }

    public GetStatMetricRequest withEndTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    public GetStatMetricRequest withDateEndTime(Date endTime) {
        this.endTime = DateUtils.formatAlternateIso8601Date(endTime);
        return this;
    }

    public GetStatMetricRequest withPeriod(Integer period) {
        this.period = period;
        return this;
    }

    public GetStatMetricRequest withKeyType(Integer keyType) {
        this.keyType = keyType;
        return this;
    }

    public GetStatMetricRequest withKey(List<String> key) {
        this.key = key;
        return this;
    }

    public GetStatMetricRequest withKey(String key) {
        if (null == this.key) {
            this.key = new ArrayList<String>();
        }
        this.key.add(key);
        return this;
    }

    public GetStatMetricRequest withGroupBy(String groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    public GetStatMetricRequest withProv(String prov) {
        this.prov = (String)GetStatMetricMapping.PROVINCE_MAP.inverse().get((Object)prov);
        this.prov = StringUtils.isEmpty((CharSequence)this.prov) ? prov : this.prov;
        return this;
    }

    public GetStatMetricRequest withIsp(String isp) {
        this.isp = (String)GetStatMetricMapping.ISP_MAP.inverse().get((Object)isp);
        this.isp = StringUtils.isEmpty((CharSequence)this.isp) ? isp : this.isp;
        return this;
    }

    public GetStatMetricRequest withLevel(String level) {
        this.level = level;
        return this;
    }

    public GetStatMetricRequest withProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public GetStatMetricRequest withExtra(Integer extra) {
        this.extra = extra;
        return this;
    }

    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Integer getPeriod() {
        return this.period;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public Integer getKeyType() {
        return this.keyType;
    }

    public void setKeyType(Integer keyType) {
        this.keyType = keyType;
    }

    public List<String> getKey() {
        return this.key;
    }

    public void setKey(List<String> key) {
        this.key = key;
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    public String getProv() {
        return this.prov;
    }

    public void setProv(String prov) {
        this.prov = prov;
    }

    public String getIsp() {
        return this.isp;
    }

    public void setIsp(String isp) {
        this.isp = isp;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public Integer getExtra() {
        return this.extra;
    }

    public void setExtra(Integer extra) {
        this.extra = extra;
    }

    public String getSortKey() {
        return this.sortKey;
    }

    public void setSortKey(String sortKey) {
        this.sortKey = sortKey;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Field[] declaredFields;
            for (Field field : declaredFields = this.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                map.put(field.getName(), field.get(this));
            }
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return map;
        }
    }
}

