/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bos.model;

import com.baidubce.services.bos.BosObjectInputStream;
import com.baidubce.services.bos.model.BosObject;
import com.baidubce.services.bos.model.GetObjectResponse;
import com.baidubce.util.Base64Utils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SelectObjectResponse
extends GetObjectResponse {
    private String recordDelimiter;
    private Messages messages;

    public Messages getMessages() {
        return this.messages;
    }

    public void initMessages(BosObject object) {
        if (this.messages != null) {
            return;
        }
        this.messages = new Messages(object);
    }

    public String getRecordDelimiter() {
        return this.recordDelimiter;
    }

    public void setRecordDelimiter(String delimiterBase64) {
        this.recordDelimiter = delimiterBase64;
    }

    private Map<String, String> parseMessages(byte[] headers) {
        int valLen;
        HashMap<String, String> map = new HashMap<String, String>();
        for (int index = 0; index < headers.length; index += valLen) {
            int keyLen = headers[index] & 0xFF;
            String headerKey = new String(Arrays.copyOfRange(headers, ++index, index + keyLen));
            byte[] v = new byte[]{0, 0, headers[index += keyLen], headers[index + 1]};
            valLen = ByteBuffer.wrap(v).getInt();
            String headerVal = new String(Arrays.copyOfRange(headers, index += 2, index + valLen));
            map.put(headerKey, headerVal);
        }
        return map;
    }

    public class EndMessage
    extends CommonMessage {
        EndMessage(Prelude prelude, Map<String, String> headers, int crc32) {
            super(prelude, headers, crc32);
            this.Type = "End";
        }

        public String toString() {
            return "EndMessage{Prelude=" + this.Prelude.toString() + ", Headers=" + this.Headers + ", Crc32=" + super.getCrc32() + '}';
        }
    }

    public class ContinuationMessage
    extends CommonMessage {
        public int BytesScanned;
        public int BytesReturned;

        ContinuationMessage(Prelude prelude, Map<String, String> headers, int bytesScanned, int bytesReturned, int crc32) {
            super(prelude, headers, crc32);
            this.Type = "Cont";
            this.BytesScanned = bytesScanned;
            this.BytesReturned = bytesReturned;
        }

        public String toString() {
            return "ContinuationMessage{Prelude=" + this.Prelude.toString() + ", Headers=" + this.Headers + ", BytesScanned=" + this.BytesScanned + ", BytesReturned=" + this.BytesReturned + ", Crc32=" + super.getCrc32() + '}';
        }
    }

    public class RecordsMessage
    extends CommonMessage {
        RecordsMessage(Prelude prelude, Map<String, String> headers, String[] records, int crc32) {
            super(prelude, headers, crc32);
            super.setRecords(records);
            this.Type = "Records";
        }

        public String toString() {
            return "RecordsMessage{Prelude=" + this.Prelude.toString() + ", Headers=" + this.Headers + ", Records=" + Arrays.toString(super.getRecords()) + ", Crc32=" + super.getCrc32() + '}';
        }
    }

    public class CommonMessage {
        public String Type;
        public Prelude Prelude;
        public Map Headers;
        private int Crc32;
        private String[] Records;

        CommonMessage(Prelude prelude, Map headers, int crc32) {
            this.Prelude = prelude;
            this.Headers = headers;
            this.Crc32 = crc32;
        }

        public int getCrc32() {
            return this.Crc32;
        }

        public void setCrc32(int crc32) {
            this.Crc32 = crc32;
        }

        public String[] getRecords() {
            return this.Records;
        }

        public void setRecords(String[] records) {
            this.Records = records;
        }
    }

    public class Prelude {
        int TotalLen;
        int HeadersLen;

        Prelude(int totalLen, int headersLen) {
            this.TotalLen = totalLen;
            this.HeadersLen = headersLen;
        }

        public String toString() {
            return "Prelude{TotalLen=" + this.TotalLen + ", HeadersLen=" + this.HeadersLen + '}';
        }
    }

    public class Messages
    implements Iterator {
        BosObject object;
        BosObjectInputStream inputStream;
        private String messageType = "";

        Messages(BosObject object) {
            this.object = object;
            this.inputStream = object.getObjectContent();
        }

        @Override
        public boolean hasNext() {
            if (this.messageType.equals("End") || this.messageType.equals("EndMessage lost")) {
                try {
                    if (this.inputStream != null) {
                        this.inputStream.close();
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException("the EndMessage may have been lost.", e);
                }
                return false;
            }
            return true;
        }

        public CommonMessage next() {
            try {
                byte[] temp_4 = new byte[4];
                this.inputStream.read(temp_4);
                int totalLen = ByteBuffer.wrap(temp_4).getInt();
                this.inputStream.read(temp_4);
                int headerLen = ByteBuffer.wrap(temp_4).getInt();
                byte[] temp_headers = new byte[headerLen];
                this.inputStream.read(temp_headers);
                Map headers = SelectObjectResponse.this.parseMessages(temp_headers);
                if (((String)headers.get("message-type")).equals("Records")) {
                    this.messageType = "Records";
                    int payloadLen = totalLen - headerLen - 12;
                    byte[] temp_payLoad = new byte[payloadLen];
                    this.inputStream.read(temp_payLoad);
                    String payload = new String(temp_payLoad);
                    this.inputStream.read(temp_4);
                    int crc = ByteBuffer.wrap(temp_4).getInt();
                    Prelude prelude = new Prelude(totalLen, headerLen);
                    String delimiter = "\n";
                    if (SelectObjectResponse.this.recordDelimiter != null) {
                        delimiter = Base64Utils.decode(SelectObjectResponse.this.recordDelimiter);
                    }
                    return new RecordsMessage(prelude, headers, payload.split(delimiter), crc);
                }
                if (((String)headers.get("message-type")).equals("Cont")) {
                    this.messageType = "Cont";
                    byte[] temp_8 = new byte[8];
                    this.inputStream.read(temp_8);
                    int bytesScanned = ByteBuffer.wrap(temp_8).getInt();
                    this.inputStream.read(temp_8);
                    int bytesReturned = ByteBuffer.wrap(temp_8).getInt();
                    this.inputStream.read(temp_4);
                    int crc = ByteBuffer.wrap(temp_4).getInt();
                    Prelude prelude = new Prelude(totalLen, headerLen);
                    return new ContinuationMessage(prelude, headers, bytesScanned, bytesReturned, crc);
                }
                if (((String)headers.get("message-type")).equals("End")) {
                    this.messageType = "End";
                    this.inputStream.read(temp_4);
                    int crc = ByteBuffer.wrap(temp_4).getInt();
                    Prelude prelude = new Prelude(totalLen, headerLen);
                    this.inputStream.close();
                    return new EndMessage(prelude, (Map<String, String>)headers, crc);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to parse parameters.", e);
            }
            this.messageType = "EndMessage lost";
            return null;
        }

        @Override
        @Deprecated
        public void remove() {
        }
    }
}

