/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.vcr;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.vcr.model.CancelStreamRequest;
import com.baidubce.services.vcr.model.CancelStreamResponse;
import com.baidubce.services.vcr.model.GetAudioRequest;
import com.baidubce.services.vcr.model.GetAudioResponse;
import com.baidubce.services.vcr.model.GetImageAsyncRequest;
import com.baidubce.services.vcr.model.GetImageAsyncResponse;
import com.baidubce.services.vcr.model.GetMediaCharacterResponse;
import com.baidubce.services.vcr.model.GetMediaRequest;
import com.baidubce.services.vcr.model.GetMediaResponse;
import com.baidubce.services.vcr.model.GetMediaSpeechResponse;
import com.baidubce.services.vcr.model.GetStreamCheckTaskListRequest;
import com.baidubce.services.vcr.model.GetStreamCheckTaskListResponse;
import com.baidubce.services.vcr.model.GetStreamRequest;
import com.baidubce.services.vcr.model.GetStreamResponse;
import com.baidubce.services.vcr.model.LibBriefRequest;
import com.baidubce.services.vcr.model.LibBriefResponse;
import com.baidubce.services.vcr.model.LibImageRequest;
import com.baidubce.services.vcr.model.LibImageResponse;
import com.baidubce.services.vcr.model.LibResponse;
import com.baidubce.services.vcr.model.PutAudioRequest;
import com.baidubce.services.vcr.model.PutAudioResponse;
import com.baidubce.services.vcr.model.PutImageAsyncRequest;
import com.baidubce.services.vcr.model.PutImageAsyncResponse;
import com.baidubce.services.vcr.model.PutImageRequest;
import com.baidubce.services.vcr.model.PutImageResponse;
import com.baidubce.services.vcr.model.PutMediaRequest;
import com.baidubce.services.vcr.model.PutMediaResponse;
import com.baidubce.services.vcr.model.PutStreamRequest;
import com.baidubce.services.vcr.model.PutStreamResponse;
import com.baidubce.services.vcr.model.PutTextRequest;
import com.baidubce.services.vcr.model.PutTextResponse;
import com.baidubce.util.DateUtils;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class VcrClient
extends AbstractBceClient {
    private static final String VERSION = "v1";
    private static final String VERSION_V2 = "v2";
    private static final String MEDIA = "media";
    private static final String AUDIO = "audio";
    private static final String STREAM = "stream";
    private static final String IMAGE = "image";
    private static final String TEXT = "text";
    private static final String FACE_LIB = "face/lib";
    private static final String LOGO_LIB = "logo/lib";
    private static final String PARAM_SOURCE = "source";
    private static final String CHECK = "check";
    private static final String CANCEL = "cancel";
    private static final String LIST = "list";
    private static final String PARAM_MAXKEYS = "maxKeys";
    private static final String PARAM_MARKER = "marker";
    private static final String PARAM_STATUS = "status";
    private static final long MILLIS_PER_HOUR = 3600000L;
    private static HttpResponseHandler[] vcrHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public VcrClient() {
        this(new BceClientConfiguration());
    }

    public VcrClient(BceClientConfiguration config) {
        super(config, vcrHandlers);
    }

    public PutMediaResponse putMedia(String source) {
        PutMediaRequest request = new PutMediaRequest();
        request.setSource(source);
        return this.putMedia(request);
    }

    public PutMediaResponse putMedia(PutMediaRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, VERSION, MEDIA);
        return this.invokeHttpClient(internalRequest, PutMediaResponse.class);
    }

    public GetMediaResponse getMedia(String source) {
        GetMediaRequest request = new GetMediaRequest();
        request.setSource(source);
        return this.getMedia(request);
    }

    public GetMediaResponse getMedia(GetMediaRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, VERSION, MEDIA);
        internalRequest.addParameter(PARAM_SOURCE, request.getSource());
        return this.invokeHttpClient(internalRequest, GetMediaResponse.class);
    }

    public GetMediaSpeechResponse getMediaSpeech(String source) {
        GetMediaRequest request = new GetMediaRequest();
        request.setSource(source);
        return this.getMediaSpeech(request);
    }

    public GetMediaSpeechResponse getMediaSpeech(GetMediaRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, VERSION, MEDIA);
        internalRequest.addParameter(PARAM_SOURCE, request.getSource());
        internalRequest.addParameter("speech", "");
        return this.invokeHttpClient(internalRequest, GetMediaSpeechResponse.class);
    }

    public GetMediaCharacterResponse getMediaCharacter(String source) {
        GetMediaRequest request = new GetMediaRequest();
        request.setSource(source);
        return this.getMediaCharacter(request);
    }

    public GetMediaCharacterResponse getMediaCharacter(GetMediaRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, VERSION, MEDIA);
        internalRequest.addParameter(PARAM_SOURCE, request.getSource());
        internalRequest.addParameter("character", "");
        return this.invokeHttpClient(internalRequest, GetMediaCharacterResponse.class);
    }

    @Deprecated
    public PutStreamResponse putStream(String source) {
        PutStreamRequest request = new PutStreamRequest();
        request.setSource(source);
        return this.putStream(request);
    }

    @Deprecated
    public PutStreamResponse putStream(PutStreamRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, VERSION, STREAM);
        return this.invokeHttpClient(internalRequest, PutStreamResponse.class);
    }

    public PutStreamResponse putStreamV2(PutStreamRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, VERSION_V2, STREAM, CHECK);
        return this.invokeHttpClient(internalRequest, PutStreamResponse.class);
    }

    public CancelStreamResponse cancelStreamV2(CancelStreamRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, VERSION_V2, STREAM, CANCEL);
        return this.invokeHttpClient(internalRequest, CancelStreamResponse.class);
    }

    @Deprecated
    public GetStreamResponse getStream(String source) {
        GetStreamRequest request = new GetStreamRequest();
        Date endTime = new Date();
        Date startTime = new Date(endTime.getTime() - 3600000L);
        request.setSource(source);
        request.setEndTime(DateUtils.formatAlternateIso8601Date(endTime));
        request.setStartTime(DateUtils.formatAlternateIso8601Date(startTime));
        return this.getStream(request);
    }

    @Deprecated
    public GetStreamResponse getStream(GetStreamRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, VERSION, STREAM);
        internalRequest.addParameter(PARAM_SOURCE, request.getSource());
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", request.getStartTime());
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", request.getEndTime());
        }
        return this.invokeHttpClient(internalRequest, GetStreamResponse.class);
    }

    public GetStreamResponse getStreamV2(String source) {
        GetStreamRequest request = new GetStreamRequest();
        request.setSource(source);
        return this.getStreamV2(request);
    }

    public GetStreamResponse getStreamV2(GetStreamRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, VERSION_V2, STREAM);
        internalRequest.addParameter(PARAM_SOURCE, request.getSource());
        return this.invokeHttpClient(internalRequest, GetStreamResponse.class);
    }

    public GetStreamCheckTaskListResponse getStreamCheckTaskListV2(Integer maxKeys, String marker, String status) {
        GetStreamCheckTaskListRequest request = new GetStreamCheckTaskListRequest();
        request.setMaxKeys(maxKeys);
        request.setMarker(marker);
        request.setStatus(status);
        return this.getStreamCheckTaskListV2(request);
    }

    public GetStreamCheckTaskListResponse getStreamCheckTaskListV2(GetStreamCheckTaskListRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, VERSION_V2, STREAM, LIST);
        internalRequest.addParameter(PARAM_MAXKEYS, String.valueOf(request.getMaxKeys()));
        internalRequest.addParameter(PARAM_MARKER, request.getMarker());
        internalRequest.addParameter(PARAM_STATUS, request.getStatus());
        return this.invokeHttpClient(internalRequest, GetStreamCheckTaskListResponse.class);
    }

    public PutAudioResponse putAudio(String source) {
        PutAudioRequest request = new PutAudioRequest();
        request.setSource(source);
        return this.putAudio(request);
    }

    public PutAudioResponse putAudio(PutAudioRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, VERSION_V2, AUDIO);
        return this.invokeHttpClient(internalRequest, PutAudioResponse.class);
    }

    public GetAudioResponse getAudio(String source) {
        GetAudioRequest request = new GetAudioRequest();
        request.setSource(source);
        return this.getAudio(request);
    }

    public GetAudioResponse getAudio(GetAudioRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, VERSION_V2, AUDIO);
        internalRequest.addParameter(PARAM_SOURCE, request.getSource());
        return this.invokeHttpClient(internalRequest, GetAudioResponse.class);
    }

    public PutImageResponse putImage(String source) {
        return this.putImage(source, null);
    }

    public PutImageResponse putImage(String source, String preset) {
        PutImageRequest request = new PutImageRequest();
        request.setSource(source);
        request.setPreset(preset);
        return this.putImage(request);
    }

    public PutImageResponse putImage(PutImageRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, VERSION, IMAGE);
        return this.invokeHttpClient(internalRequest, PutImageResponse.class);
    }

    public PutImageAsyncResponse putImageAsync(String source, String preset, String notification) {
        PutImageAsyncRequest request = new PutImageAsyncRequest();
        request.setSource(source);
        request.setPreset(preset);
        request.setNotification(notification);
        return this.putImageAsync(request);
    }

    public PutImageAsyncResponse putImageAsync(PutImageAsyncRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, VERSION_V2, IMAGE);
        return this.invokeHttpClient(internalRequest, PutImageAsyncResponse.class);
    }

    public GetImageAsyncResponse getImageAsync(String source, String preset) {
        GetImageAsyncRequest request = new GetImageAsyncRequest();
        request.setSource(source);
        request.setPreset(preset);
        return this.getImageAsync(request);
    }

    public GetImageAsyncResponse getImageAsync(GetImageAsyncRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, VERSION_V2, IMAGE);
        internalRequest.addParameter(PARAM_SOURCE, request.getSource());
        internalRequest.addParameter("preset", StringUtils.isEmpty((CharSequence)request.getPreset()) ? "" : request.getPreset());
        return this.invokeHttpClient(internalRequest, GetImageAsyncResponse.class);
    }

    public PutTextResponse putText(String text) {
        PutTextRequest request = new PutTextRequest();
        request.setText(text);
        return this.putText(request);
    }

    public PutTextResponse putText(PutTextRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, VERSION, TEXT);
        return this.invokeHttpClient(internalRequest, PutTextResponse.class);
    }

    public LibResponse addFaceImage(String lib, String brief, String image) {
        return this.addFaceImage(new LibImageRequest(lib, brief, image));
    }

    public LibResponse addFaceImage(LibImageRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, VERSION, FACE_LIB, request.getLib());
        return this.invokeHttpClient(internalRequest, LibResponse.class);
    }

    public LibResponse delFaceBrief(String lib, String brief) {
        return this.delFaceBrief(new LibBriefRequest(lib, brief));
    }

    public LibResponse delFaceBrief(LibBriefRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.DELETE, request, VERSION, FACE_LIB, request.getLib());
        internalRequest.addParameter("brief", request.getBrief());
        return this.invokeHttpClient(internalRequest, LibResponse.class);
    }

    public LibResponse delFaceImage(String lib, String brief, String image) {
        return this.delFaceImage(new LibImageRequest(lib, brief, image));
    }

    public LibResponse delFaceImage(LibImageRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.DELETE, request, VERSION, FACE_LIB, request.getLib());
        internalRequest.addParameter("brief", request.getBrief());
        internalRequest.addParameter(IMAGE, request.getImage());
        return this.invokeHttpClient(internalRequest, LibResponse.class);
    }

    public LibBriefResponse getFaceLib(String lib) {
        LibBriefRequest request = new LibBriefRequest();
        request.setLib(lib);
        return this.getFaceLib(request);
    }

    public LibBriefResponse getFaceLib(LibBriefRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, VERSION, FACE_LIB, request.getLib());
        return this.invokeHttpClient(internalRequest, LibBriefResponse.class);
    }

    public LibImageResponse getFaceBrief(String lib, String brief) {
        return this.getFaceBrief(new LibBriefRequest(lib, brief));
    }

    public LibImageResponse getFaceBrief(LibBriefRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, VERSION, FACE_LIB, request.getLib());
        internalRequest.addParameter("brief", request.getBrief());
        return this.invokeHttpClient(internalRequest, LibImageResponse.class);
    }

    public LibResponse addLogoImage(String lib, String brief, String image) {
        return this.addLogoImage(new LibImageRequest(lib, brief, image));
    }

    public LibResponse addLogoImage(LibImageRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, VERSION, LOGO_LIB, request.getLib());
        return this.invokeHttpClient(internalRequest, LibResponse.class);
    }

    public LibResponse delLogoBrief(String lib, String brief) {
        return this.delLogoBrief(new LibBriefRequest(lib, brief));
    }

    public LibResponse delLogoBrief(LibBriefRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.DELETE, request, VERSION, LOGO_LIB, request.getLib());
        internalRequest.addParameter("brief", request.getBrief());
        return this.invokeHttpClient(internalRequest, LibResponse.class);
    }

    public LibResponse delLogoImage(String lib, String image) {
        return this.delLogoImage(new LibImageRequest(lib, "", image));
    }

    public LibResponse delLogoImage(LibImageRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.DELETE, request, VERSION, LOGO_LIB, request.getLib());
        internalRequest.addParameter(IMAGE, request.getImage());
        return this.invokeHttpClient(internalRequest, LibResponse.class);
    }

    public LibBriefResponse getLogoLib(String lib) {
        LibBriefRequest request = new LibBriefRequest();
        request.setLib(lib);
        return this.getLogoLib(request);
    }

    public LibBriefResponse getLogoLib(LibBriefRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, VERSION, LOGO_LIB, request.getLib());
        return this.invokeHttpClient(internalRequest, LibBriefResponse.class);
    }

    public LibImageResponse getLogoBrief(String lib, String brief) {
        return this.getLogoBrief(new LibBriefRequest(lib, brief));
    }

    public LibImageResponse getLogoBrief(LibBriefRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, VERSION, LOGO_LIB, request.getLib());
        internalRequest.addParameter("brief", request.getBrief());
        return this.invokeHttpClient(internalRequest, LibImageResponse.class);
    }

    private InternalRequest createRequest(HttpMethodName httpMethod, AbstractBceRequest request, String ... pathVariables) {
        ArrayList<String> pathComponents = new ArrayList<String>();
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                pathComponents.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), pathComponents.toArray(new String[pathComponents.size()]));
        InternalRequest internalRequest = new InternalRequest(httpMethod, uri);
        internalRequest.setCredentials(request.getRequestCredentials());
        if (httpMethod == HttpMethodName.POST || httpMethod == HttpMethodName.PUT) {
            this.fillRequestPayload(internalRequest, request);
        }
        return internalRequest;
    }

    private InternalRequest fillRequestPayload(InternalRequest internalRequest, AbstractBceRequest request) {
        String strJson = JsonUtils.toJsonString(request);
        byte[] requestJson = null;
        try {
            requestJson = strJson.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Unsupported encode.", e);
        }
        internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
        internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        return internalRequest;
    }
}

