/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestoragehbaseclient.hbase;

import com.baidubce.services.tablestoragehbaseclient.adaptor.TablestorageConfiguration;
import com.baidubce.services.tablestoragehbaseclient.hbase.TablestorageAdmin;
import com.baidubce.services.tablestoragehbaseclient.hbase.TablestorageBufferedMutator;
import com.baidubce.services.tablestoragehbaseclient.hbase.TablestorageRegionLocator;
import com.baidubce.services.tablestoragehbaseclient.hbase.TablestorageTable;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.security.User;

public class TablestorageConnection
implements Connection {
    private final Configuration config;
    private final TablestorageConfiguration tablestorageConfiguration;
    private volatile boolean closed = false;
    private volatile boolean aborted = false;

    public TablestorageConnection(Configuration conf) throws IOException {
        this.config = conf;
        this.tablestorageConfiguration = this.toTablestorageConfiguration(this.config);
    }

    public TablestorageConnection(Configuration conf, boolean managed, ExecutorService pool, User user) {
        if (managed) {
            throw new UnsupportedOperationException("Tablestorage does not support managed connections.");
        }
        this.config = conf;
        this.tablestorageConfiguration = this.toTablestorageConfiguration(this.config);
    }

    private TablestorageConfiguration toTablestorageConfiguration(Configuration config) {
        String endpoint = config.get("tablestorage.client.endpoint");
        String ak = config.get("tablestorage.client.accesskeyid");
        String sk = config.get("tablestorage.client.secretaccesskey");
        String instanceName = config.get("tablestorage.client.instancename");
        return new TablestorageConfiguration(endpoint, instanceName, ak, sk);
    }

    public TablestorageConfiguration getTablestorageConfiguration() {
        return this.tablestorageConfiguration;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public Table getTable(TableName tableName) throws IOException {
        return this.getTable(tableName, null);
    }

    public Table getTable(TableName tableName, ExecutorService pool) throws IOException {
        return new TablestorageTable(this, tableName);
    }

    public BufferedMutator getBufferedMutator(TableName tableName) throws IOException {
        return new TablestorageBufferedMutator(this, tableName);
    }

    public BufferedMutator getBufferedMutator(BufferedMutatorParams params) throws IOException {
        Preconditions.checkNotNull((Object)params, (Object)"params should not be null");
        return new TablestorageBufferedMutator(this, params.getTableName());
    }

    public RegionLocator getRegionLocator(TableName tableName) throws IOException {
        return new TablestorageRegionLocator(this, tableName);
    }

    public Admin getAdmin() throws IOException {
        return new TablestorageAdmin(this);
    }

    public void close() throws IOException {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void abort(String why, Throwable e) {
        this.aborted = true;
        throw new RuntimeException(why, e);
    }

    public boolean isAborted() {
        return this.aborted;
    }
}

