/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestoragehbaseclient.adaptor;

import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.BceServiceException;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.tablestorage.TableStorageClient;
import com.baidubce.services.tablestorage.model.BatchDeleteRowRequest;
import com.baidubce.services.tablestorage.model.BatchGetRowRequest;
import com.baidubce.services.tablestorage.model.BatchGetRowResponse;
import com.baidubce.services.tablestorage.model.BatchPutRowRequest;
import com.baidubce.services.tablestorage.model.CompressType;
import com.baidubce.services.tablestorage.model.CreateTableRequest;
import com.baidubce.services.tablestorage.model.DeleteRow;
import com.baidubce.services.tablestorage.model.DeleteRowRequest;
import com.baidubce.services.tablestorage.model.DropTableRequest;
import com.baidubce.services.tablestorage.model.GetRow;
import com.baidubce.services.tablestorage.model.GetRowRequest;
import com.baidubce.services.tablestorage.model.GetRowResponse;
import com.baidubce.services.tablestorage.model.ListKeyRangesRequest;
import com.baidubce.services.tablestorage.model.ListKeyRangesResponse;
import com.baidubce.services.tablestorage.model.ListTablesRequest;
import com.baidubce.services.tablestorage.model.ListTablesResponse;
import com.baidubce.services.tablestorage.model.PutRow;
import com.baidubce.services.tablestorage.model.PutRowRequest;
import com.baidubce.services.tablestorage.model.ScanRequest;
import com.baidubce.services.tablestorage.model.ScanResponse;
import com.baidubce.services.tablestorage.model.ShowTableRequest;
import com.baidubce.services.tablestorage.model.ShowTableResponse;
import com.baidubce.services.tablestorage.model.TableOption;
import com.baidubce.services.tablestorage.model.TableState;
import com.baidubce.services.tablestorage.model.TableStorageResult;
import com.baidubce.services.tablestorage.model.UpdateTableRequest;
import com.baidubce.services.tablestoragehbaseclient.adaptor.TablestorageConvertor;
import com.baidubce.util.DateUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;

public class TableStorageAdaptor {
    private TableStorageClient internalClient;

    public TableStorageAdaptor(String endpoint, String instanceName, String accessKeyId, String secretAccessKey) {
        DefaultBceCredentials credentials = new DefaultBceCredentials(accessKeyId, secretAccessKey);
        BceClientConfiguration configuration = new BceClientConfiguration();
        configuration.setCredentials(credentials);
        configuration.setEndpoint(endpoint);
        this.internalClient = new TableStorageClient(configuration, instanceName);
    }

    public HTableDescriptor getTable(String tableName) throws IOException {
        ShowTableResponse response = null;
        try {
            response = this.internalClient.showTable(new ShowTableRequest(tableName));
        }
        catch (BceClientException e) {
            if (e instanceof BceServiceException && ((BceServiceException)e).getErrorCode().equals("TableNotExist")) {
                return null;
            }
            throw new IOException(e.getMessage(), e);
        }
        HTableDescriptor descriptor = new HTableDescriptor(TableName.valueOf((String)tableName));
        HColumnDescriptor familyDescriptor = new HColumnDescriptor("cf0");
        familyDescriptor.setCompressionType(TablestorageConvertor.toCompressionAlgorithm(response.getCompressType()));
        familyDescriptor.setTimeToLive(response.getTimeToLive());
        descriptor.addFamily(familyDescriptor);
        return descriptor;
    }

    public List<String> listTable() throws IOException {
        ListTablesRequest listTablesRequest = new ListTablesRequest();
        ListTablesResponse response = null;
        try {
            response = this.internalClient.listTables(listTablesRequest);
        }
        catch (BceClientException e) {
            throw new IOException(e.getMessage(), e);
        }
        ArrayList<String> tableNames = new ArrayList<String>(response.getTables().size());
        for (ListTablesResponse.TableInfo info : response.getTables()) {
            tableNames.add(info.getTableName());
        }
        return tableNames;
    }

    public void createTable(String tableName, CompressType compressType, int maxVersions, int ttl) throws IOException {
        TableOption option = new TableOption();
        option.setCompressType(compressType);
        option.setTableVersion(0L);
        option.setMaxVersions(maxVersions);
        option.setTimeToLive(ttl);
        CreateTableRequest request = new CreateTableRequest(tableName, option);
        try {
            this.internalClient.createTable(request);
        }
        catch (BceClientException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public void dropTable(String tableName) throws IOException {
        DropTableRequest request = new DropTableRequest(tableName);
        try {
            this.internalClient.dropTable(request);
        }
        catch (BceClientException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public boolean isTableAvailable(String tableName) throws IOException {
        ShowTableResponse response = null;
        try {
            response = this.internalClient.showTable(new ShowTableRequest(tableName));
        }
        catch (BceClientException e) {
            if (e instanceof BceServiceException && ((BceServiceException)e).getErrorCode().equals("TableNotExist")) {
                return false;
            }
            throw new IOException(e.getMessage(), e);
        }
        long createTime = DateUtils.parseIso8601Date(response.getCreateTime()).getTime();
        return System.currentTimeMillis() - createTime > 60000L && response.getTableState() == TableState.Normal;
    }

    public void updateTable(String tableName, CompressType compressType, int maxVersions, int ttl) throws IOException {
        ShowTableResponse response = null;
        try {
            response = this.internalClient.showTable(new ShowTableRequest(tableName));
        }
        catch (BceClientException e) {
            throw new IOException(e.getMessage(), e);
        }
        TableOption option = new TableOption();
        option.setTableVersion(response.getTableVersion());
        option.setMaxVersions(maxVersions);
        option.setCompressType(compressType);
        option.setTimeToLive(ttl);
        UpdateTableRequest request = new UpdateTableRequest(tableName, option);
        try {
            this.internalClient.updateTable(request);
        }
        catch (BceClientException e) {
            if (e instanceof BceServiceException && ((BceServiceException)e).getErrorCode().equals("InvalidTableVersion")) {
                throw new IOException("Update failed, please try again! RequestId=" + ((BceServiceException)e).getRequestId(), e);
            }
            throw new IOException(e.getMessage(), e);
        }
    }

    public Object[] batch(String tableName, List<? extends Row> actions) throws IOException {
        ArrayList<Result> resultList = new ArrayList<Result>();
        ArrayList<Put> putList = new ArrayList<Put>();
        ArrayList<Delete> deleteList = new ArrayList<Delete>();
        ArrayList<Get> getList = new ArrayList<Get>();
        int type = 0;
        int lastType = 0;
        int num = 0;
        for (int i = 0; i <= actions.size(); ++i) {
            ++num;
            if (i < actions.size()) {
                Row row = actions.get(i);
                if (row instanceof Put) {
                    type = 1;
                    putList.add((Put)row);
                } else if (row instanceof Delete) {
                    type = 2;
                    deleteList.add((Delete)row);
                } else if (row instanceof Get) {
                    type = 3;
                    getList.add((Get)row);
                }
            } else {
                type = 0;
            }
            if (lastType != 0 && type != lastType) {
                switch (lastType) {
                    case 1: {
                        this.batchPutRow(tableName, putList);
                        Object[] results = new Object[num - 1];
                        resultList.addAll(Arrays.asList(results));
                        putList.clear();
                        num = 1;
                        break;
                    }
                    case 2: {
                        this.batchDeleteRow(tableName, deleteList);
                        Object[] results = new Object[num - 1];
                        resultList.addAll(Arrays.asList(results));
                        deleteList.clear();
                        num = 1;
                        break;
                    }
                    case 3: {
                        Object[] results = this.batchGetRow(tableName, getList);
                        resultList.addAll(Arrays.asList(results));
                        getList.clear();
                        num = 1;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("batch operation only support Put, Delete and Get");
                    }
                }
            }
            lastType = type;
        }
        Object[] result = new Object[actions.size()];
        return resultList.toArray(result);
    }

    public Result getRow(String tableName, Get get) throws IOException {
        GetRowRequest request = new GetRowRequest(tableName, Bytes.toString((byte[])get.getRow()));
        if (get.getFamilyMap().size() > 1) {
            throw new UnsupportedOperationException("Table only support one Family named cf0");
        }
        for (Map.Entry familyEntry : get.getFamilyMap().entrySet()) {
            if (!"cf0".equals(Bytes.toString((byte[])((byte[])familyEntry.getKey())))) {
                throw new UnsupportedOperationException("Table only support one Family named cf0");
            }
            if (familyEntry.getValue() == null || ((NavigableSet)familyEntry.getValue()).isEmpty()) continue;
            for (byte[] qualifier : (NavigableSet)familyEntry.getValue()) {
                request.addCell(Bytes.toString((byte[])qualifier));
            }
        }
        request.setMaxVersions(get.getMaxVersions());
        try {
            GetRowResponse response = this.internalClient.getRow(request);
            TableStorageResult result = response.getResult();
            return TablestorageConvertor.toHBaseResult(result);
        }
        catch (BceClientException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public Result[] batchGetRow(String tableName, List<Get> gets) throws IOException {
        BatchGetRowRequest request = new BatchGetRowRequest(tableName);
        for (Get get : gets) {
            GetRow getRow = new GetRow(Bytes.toString((byte[])get.getRow()));
            if (get.getFamilyMap().size() > 1) {
                throw new UnsupportedOperationException("Table only support one Family named cf0");
            }
            for (Map.Entry familyEntry : get.getFamilyMap().entrySet()) {
                if (!"cf0".equals(Bytes.toString((byte[])((byte[])familyEntry.getKey())))) {
                    throw new UnsupportedOperationException("Table only support one Family named cf0");
                }
                if (familyEntry.getValue() == null || ((NavigableSet)familyEntry.getValue()).isEmpty()) continue;
                for (byte[] qualifier : (NavigableSet)familyEntry.getValue()) {
                    getRow.addCell(Bytes.toString((byte[])qualifier));
                }
            }
            getRow.setMaxVersions(get.getMaxVersions());
            request.addGetRow(getRow);
        }
        try {
            BatchGetRowResponse batchGetRowResponse = this.internalClient.batchGetRow(request);
            List<TableStorageResult> tableStorageResults = batchGetRowResponse.getResults();
            return TablestorageConvertor.toBatchGetHBaseResults(gets, tableStorageResults);
        }
        catch (BceClientException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public void putRow(String tableName, Put put) throws IOException {
        PutRowRequest request = new PutRowRequest(tableName, Bytes.toString((byte[])put.getRow()));
        if (put.getFamilyCellMap().size() != 1) {
            throw new UnsupportedOperationException("Table only support one Family named cf0");
        }
        for (Map.Entry entry : put.getFamilyCellMap().entrySet()) {
            if (!"cf0".equals(Bytes.toString((byte[])((byte[])entry.getKey())))) {
                throw new UnsupportedOperationException("Table only support one Family named cf0");
            }
            for (Cell cell : (List)entry.getValue()) {
                String column = Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)cell));
                String value = Bytes.toString((byte[])CellUtil.cloneValue((Cell)cell));
                request.addCell(column, value);
            }
        }
        try {
            this.internalClient.putRow(request);
        }
        catch (BceClientException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public void batchPutRow(String tableName, List<Put> puts) throws IOException {
        BatchPutRowRequest request = new BatchPutRowRequest(tableName);
        for (Put put : puts) {
            PutRow putRow = new PutRow(Bytes.toString((byte[])put.getRow()));
            if (put.getFamilyCellMap().size() > 1) {
                throw new UnsupportedOperationException("Table only support one Family named cf0");
            }
            for (Map.Entry entry : put.getFamilyCellMap().entrySet()) {
                if (!"cf0".equals(Bytes.toString((byte[])((byte[])entry.getKey())))) {
                    throw new UnsupportedOperationException("Table only support one Family named cf0");
                }
                for (Cell cell : (List)entry.getValue()) {
                    String column = Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)cell));
                    String value = Bytes.toString((byte[])CellUtil.cloneValue((Cell)cell));
                    putRow.addCell(column, value);
                }
            }
            request.addPutRow(putRow);
        }
        try {
            this.internalClient.batchPutRow(request);
        }
        catch (BceClientException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public void deleteRow(String tableName, Delete delete) throws IOException {
        DeleteRowRequest request = new DeleteRowRequest(tableName, Bytes.toString((byte[])delete.getRow()));
        if (delete.getFamilyCellMap().size() > 1) {
            throw new UnsupportedOperationException("Table only support one Family named cf0");
        }
        for (Map.Entry entry : delete.getFamilyCellMap().entrySet()) {
            if (!"cf0".equals(Bytes.toString((byte[])((byte[])entry.getKey())))) {
                throw new UnsupportedOperationException("Table only support one Family named cf0");
            }
            for (Cell cell : (List)entry.getValue()) {
                String column = Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)cell));
                request.addCell(column);
            }
        }
        try {
            this.internalClient.deleteRow(request);
        }
        catch (BceClientException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public void batchDeleteRow(String tableName, List<Delete> deletes) throws IOException {
        BatchDeleteRowRequest request = new BatchDeleteRowRequest(tableName);
        for (Delete delete : deletes) {
            DeleteRow deleteRow = new DeleteRow(Bytes.toString((byte[])delete.getRow()));
            if (delete.getFamilyCellMap().size() > 1) {
                throw new UnsupportedOperationException("Table only support one Family named cf0");
            }
            for (Map.Entry entry : delete.getFamilyCellMap().entrySet()) {
                if (!"cf0".equals(Bytes.toString((byte[])((byte[])entry.getKey())))) {
                    throw new UnsupportedOperationException("Table only support one Family named cf0");
                }
                for (Cell cell : (List)entry.getValue()) {
                    String column = Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)cell));
                    deleteRow.addCell(column);
                }
            }
            request.addDeleteRow(deleteRow);
        }
        try {
            this.internalClient.batchDeleteRow(request);
        }
        catch (BceClientException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public List<Result> scan(String tableName, Scan scan, String startRowkey, ByteArrayOutputStream nextStartRowkeyStream) throws IOException {
        ArrayList<Result> results = new ArrayList<Result>();
        ScanRequest request = new ScanRequest(tableName);
        if (scan.getFamilyMap().size() > 1) {
            throw new UnsupportedOperationException("Table only support one Family named cf0");
        }
        for (Map.Entry entry : scan.getFamilyMap().entrySet()) {
            if (!"cf0".equals(Bytes.toString((byte[])((byte[])entry.getKey())))) {
                throw new UnsupportedOperationException("Table only support one Family named cf0");
            }
            if (null == entry.getValue()) continue;
            for (byte[] columnBytes : (NavigableSet)entry.getValue()) {
                String columnStr = Bytes.toString((byte[])columnBytes);
                request.addSelector(columnStr);
            }
        }
        String scanStartRowkey = Bytes.toString((byte[])scan.getStartRow());
        if (startRowkey.compareTo(scanStartRowkey) > 0) {
            request.setStartRowkey(startRowkey, true);
        } else {
            request.setStartRowkey(scanStartRowkey, true);
        }
        if (Bytes.compareTo((byte[])scan.getStopRow(), (byte[])HConstants.EMPTY_END_ROW) != 0) {
            request.setStopRowkey(Bytes.toString((byte[])scan.getStopRow()), false);
        }
        request.setMaxVersions(scan.getMaxVersions());
        try {
            ScanResponse response = this.internalClient.scan(request);
            nextStartRowkeyStream.write(response.getNextStartKey().getBytes());
            for (TableStorageResult tablestorageResult : response.getResults()) {
                results.add(TablestorageConvertor.toHBaseResult(tablestorageResult));
            }
        }
        catch (BceClientException e) {
            throw new IOException(e.getMessage(), e);
        }
        return results;
    }

    public byte[][] getStartKeys(String tableName) throws IOException {
        ListKeyRangesRequest request = new ListKeyRangesRequest(tableName);
        try {
            ListKeyRangesResponse response = this.internalClient.listKeyRanges(request);
            List<Pair<String, String>> keyRanges = response.getKeyRanges();
            byte[][] startKeys = new byte[keyRanges.size()][];
            int index = 0;
            for (Pair<String, String> keyRange : keyRanges) {
                startKeys[index++] = ((String)keyRange.getLeft()).getBytes();
            }
            return startKeys;
        }
        catch (BceClientException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public byte[][] getEndKeys(String tableName) throws IOException {
        ListKeyRangesRequest request = new ListKeyRangesRequest(tableName);
        try {
            ListKeyRangesResponse response = this.internalClient.listKeyRanges(request);
            List<Pair<String, String>> keyRanges = response.getKeyRanges();
            byte[][] endKeys = new byte[keyRanges.size()][];
            int index = 0;
            for (Pair<String, String> keyRange : keyRanges) {
                endKeys[index++] = ((String)keyRange.getRight()).getBytes();
            }
            return endKeys;
        }
        catch (BceClientException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public org.apache.hadoop.hbase.util.Pair<byte[][], byte[][]> getStartEndKeys(String tableName) throws IOException {
        ListKeyRangesRequest request = new ListKeyRangesRequest(tableName);
        try {
            ListKeyRangesResponse response = this.internalClient.listKeyRanges(request);
            List<Pair<String, String>> keyRanges = response.getKeyRanges();
            byte[][] startKeys = new byte[keyRanges.size()][];
            byte[][] endKeys = new byte[keyRanges.size()][];
            int index = 0;
            for (Pair<String, String> keyRange : keyRanges) {
                startKeys[index] = ((String)keyRange.getLeft()).getBytes();
                endKeys[index] = ((String)keyRange.getRight()).getBytes();
                ++index;
            }
            return new org.apache.hadoop.hbase.util.Pair((Object)startKeys, (Object)endKeys);
        }
        catch (BceClientException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public void close() {
        this.internalClient.shutdown();
    }
}

