/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestorage.model.transform;

import com.baidubce.BceClientException;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.tablestorage.model.ShowTableStateResponse;
import com.baidubce.services.tablestorage.model.TableState;
import com.baidubce.services.tablestorage.model.transform.Unmarshaller;
import com.baidubce.services.tablestorage.model.transform.Unmarshallers;
import com.baidubce.util.JsonUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;

public class ShowTableStateResponseUnmarshaller
implements Unmarshaller<ShowTableStateResponse, InputStream> {
    private ShowTableStateResponse result;

    public ShowTableStateResponseUnmarshaller(AbstractBceResponse response) {
        this.result = (ShowTableStateResponse)response;
    }

    @Override
    public ShowTableStateResponse unmarshall(InputStream in) throws Exception {
        String streamContents = Unmarshallers.readStreamContents(in);
        JsonNode root = JsonUtils.jsonNodeOf(streamContents);
        if (!root.isObject()) {
            throw new BceClientException("The input json object:" + root.toString() + " is not an object.");
        }
        String state = root.get("tableState").asText();
        this.result.setTableState(TableState.valueOf(state));
        return this.result;
    }
}

