/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestorage.model.transform;

import com.baidubce.BceClientException;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.tablestorage.TableStorageConstants;
import com.baidubce.services.tablestorage.model.ScanResponse;
import com.baidubce.services.tablestorage.model.TableStorageResult;
import com.baidubce.services.tablestorage.model.transform.TableStorageResultUnmarshaller;
import com.baidubce.services.tablestorage.model.transform.Unmarshaller;
import com.baidubce.services.tablestorage.model.transform.Unmarshallers;
import com.baidubce.util.JsonUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;

public class ScanResponseUnmarshaller
implements Unmarshaller<ScanResponse, InputStream> {
    private ScanResponse result;

    public ScanResponseUnmarshaller(AbstractBceResponse response) {
        this.result = (ScanResponse)response;
    }

    @Override
    public ScanResponse unmarshall(InputStream in) throws Exception {
        String streamContents = Unmarshallers.readStreamContents(in);
        JsonNode root = JsonUtils.jsonNodeOf(streamContents);
        if (!root.isObject()) {
            throw new BceClientException("The input json object:" + root.toString() + " is not an object.");
        }
        String nextStartKey = "";
        if (root.has("nextStartKey")) {
            nextStartKey = root.get("nextStartKey").asText();
        }
        this.result.setNextStartKey(URLDecoder.decode(nextStartKey, TableStorageConstants.DEFAULT_ENCODING));
        JsonNode resultsNode = root.get("result");
        ArrayList<TableStorageResult> results = new ArrayList<TableStorageResult>();
        if (resultsNode != null) {
            Iterator resultList = resultsNode.elements();
            TableStorageResultUnmarshaller unmarshaller = new TableStorageResultUnmarshaller();
            while (resultList.hasNext()) {
                JsonNode resultNode = (JsonNode)resultList.next();
                TableStorageResult result = unmarshaller.unmarshall(resultNode);
                results.add(result);
            }
        }
        this.result.setResults(results);
        return this.result;
    }
}

