/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestorage.model;

import com.baidubce.services.tablestorage.TableStorageConstants;
import com.baidubce.services.tablestorage.model.AbstractTableStorageResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class ListKeyRangesResponse
extends AbstractTableStorageResponse {
    private List<Pair<String, String>> keyRanges = new ArrayList<Pair<String, String>>();

    public boolean setKeyRanges(List<Pair<String, String>> keyRanges) {
        Collections.sort(keyRanges, new StringPairCompare());
        if (!this.isKeyRangeListLegal(keyRanges)) {
            return false;
        }
        this.keyRanges = keyRanges;
        return true;
    }

    private boolean isKeyRangeListLegal(List<Pair<String, String>> keyRangeList) {
        String lastStopKey = "";
        for (Pair<String, String> keyRange : keyRangeList) {
            if (!((String)keyRange.getKey()).equals(lastStopKey)) {
                return false;
            }
            lastStopKey = (String)keyRange.getValue();
        }
        return lastStopKey.equals(TableStorageConstants.MAX_ROWKEY);
    }

    public Pair<String, String> getKeyRange(String rowkey) {
        for (Pair<String, String> keyRange : this.keyRanges) {
            if (((String)keyRange.getKey()).compareTo(rowkey) < 0) continue;
            return keyRange;
        }
        return null;
    }

    public List<Pair<String, String>> getKeyRanges() {
        return Collections.unmodifiableList(this.keyRanges);
    }

    private static class StringPairCompare
    implements Comparator<Pair<String, String>> {
        private StringPairCompare() {
        }

        @Override
        public int compare(Pair<String, String> o1, Pair<String, String> o2) {
            int ret = ((String)o1.getKey()).compareTo((String)o2.getKey());
            if (ret == 0) {
                ret = ((String)o1.getValue()).compareTo((String)o2.getValue());
            }
            return ret;
        }
    }
}

