/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.ruleengine;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.model.GenericAccountRequest;
import com.baidubce.services.ruleengine.model.dict.CreateDictRequest;
import com.baidubce.services.ruleengine.model.dict.Dict;
import com.baidubce.services.ruleengine.model.dict.ListDictRequest;
import com.baidubce.services.ruleengine.model.dict.ListDictResponse;
import com.baidubce.services.ruleengine.model.dict.ResultStatus;
import com.baidubce.services.ruleengine.model.dict.UpdateDictRequest;
import com.baidubce.services.ruleengine.model.dict.UuidResult;
import com.baidubce.services.ruleengine.model.dict.WriteDictDataRequest;
import com.baidubce.services.ruleengine.model.dict.WriteDictDataResult;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class RuleDictClient
extends AbstractBceClient {
    private static final String CONTENT_TYPE = "application/json;charset=UTF-8";
    private static final String VERSION = "v1";
    private static final String DICT = "dict";
    private static final String DATA = "data";
    private static final String ENDPOINT = "iotredata.gz.baidubce.com";
    private static final HttpResponseHandler[] HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public RuleDictClient(BceClientConfiguration config) {
        super(config.getEndpoint() == null ? config.withEndpoint(ENDPOINT) : config, HANDLERS);
    }

    public RuleDictClient(String accessKey, String secretKey) {
        this(new BceClientConfiguration().withCredentials(new DefaultBceCredentials(accessKey, secretKey)).withEndpoint(ENDPOINT));
    }

    public UuidResult createDict(CreateDictRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, DICT);
        return this.invokeHttpClient(internalRequest, UuidResult.class);
    }

    public ResultStatus updateDict(UpdateDictRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, DICT, request.getUuid());
        return this.invokeHttpClient(internalRequest, ResultStatus.class);
    }

    public Dict getDict(String uuid) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DICT, uuid);
        return this.invokeHttpClient(internalRequest, Dict.class);
    }

    public ListDictResponse listDict(ListDictRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, DICT);
        if (request.getPageNo() > 0) {
            internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        }
        if (request.getPageSize() > 0) {
            internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        }
        return this.invokeHttpClient(internalRequest, ListDictResponse.class);
    }

    public void deleteDict(String uuid) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, DICT, uuid);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public WriteDictDataResult writeDictData(WriteDictDataRequest request) {
        Map<String, String> body = request.getData();
        String jsonStr = JsonUtils.toJsonString(body);
        InternalRequest internalRequest = this.createRequest(jsonStr, new GenericAccountRequest(), HttpMethodName.PUT, DICT, DATA, request.getUuid());
        return this.invokeHttpClient(internalRequest, WriteDictDataResult.class);
    }

    public ResultStatus getDictData(String dictUuid, String key) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.GET, DICT, DATA, dictUuid);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("key", key);
        internalRequest.setParameters(parameters);
        return this.invokeHttpClient(internalRequest, ResultStatus.class);
    }

    public ResultStatus deleteDictData(String dictUuid, String key) {
        InternalRequest internalRequest = this.createRequest(new GenericAccountRequest(), HttpMethodName.DELETE, DICT, DATA, dictUuid);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("key", key);
        internalRequest.setParameters(parameters);
        return this.invokeHttpClient(internalRequest, ResultStatus.class);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        if (httpMethod == HttpMethodName.POST || httpMethod == HttpMethodName.PUT) {
            this.fillInHeadAndBody(bceRequest, request);
        }
        return request;
    }

    private InternalRequest createRequest(String body, AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        if (httpMethod == HttpMethodName.POST || httpMethod == HttpMethodName.PUT) {
            this.fillInHeadAndBody(body.getBytes(), request);
        }
        return request;
    }

    private void fillInHeadAndBody(AbstractBceRequest bceRequest, InternalRequest request) {
        byte[] content = this.toJson(bceRequest);
        request.addHeader("Content-Length", Integer.toString(content.length));
        request.addHeader("Content-Type", CONTENT_TYPE);
        request.setContent(RestartableInputStream.wrap(content));
    }

    private void fillInHeadAndBody(byte[] content, InternalRequest request) {
        request.addHeader("Content-Length", Integer.toString(content.length));
        request.addHeader("Content-Type", CONTENT_TYPE);
        request.setContent(RestartableInputStream.wrap(content));
    }

    private byte[] toJson(AbstractBceRequest bceRequest) {
        String jsonStr = JsonUtils.toJsonString(bceRequest);
        try {
            return jsonStr.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
    }
}

