/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.moladb.model.transform;

import com.baidubce.services.moladb.model.Key;
import com.baidubce.services.moladb.model.KeysAndAttributes;
import com.baidubce.services.moladb.model.transform.KeyUnmarshaller;
import com.baidubce.services.moladb.model.transform.Unmarshaller;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class KeysAndAttributesUnmarshaller
implements Unmarshaller<KeysAndAttributes, JsonNode> {
    @Override
    public KeysAndAttributes unmarshall(JsonNode jsonObj) throws Exception {
        KeysAndAttributes result = new KeysAndAttributes();
        JsonNode attrsNode = jsonObj.get("attributesToGet");
        JsonNode consistentRead = jsonObj.get("consistentRead");
        if (consistentRead != null) {
            result.withConsistentRead(consistentRead.asBoolean());
        }
        if (attrsNode != null) {
            List<String> attrsToGet = this.deserializeAttributes(attrsNode);
            result.setAttributesToGet(attrsToGet);
        }
        JsonNode keyListObj = jsonObj.get("keys");
        result.withKeys(this.deserializeKeys(keyListObj));
        return result;
    }

    private List<String> deserializeAttributes(JsonNode jsonObj) {
        ArrayList<String> attributes = new ArrayList<String>();
        Iterator elements = jsonObj.elements();
        while (elements.hasNext()) {
            attributes.add(((JsonNode)elements.next()).asText());
        }
        return attributes;
    }

    private List<Key> deserializeKeys(JsonNode jsonObj) throws Exception {
        ArrayList<Key> keyList = new ArrayList<Key>();
        Iterator keys = jsonObj.elements();
        while (keys.hasNext()) {
            KeyUnmarshaller unmarshaller = new KeyUnmarshaller();
            Key key = unmarshaller.unmarshall((JsonNode)keys.next());
            keyList.add(key);
        }
        return keyList;
    }
}

