/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.moladb.model.transform;

import com.baidubce.BceClientException;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.moladb.model.AttributeDefinition;
import com.baidubce.services.moladb.model.GetTableResponse;
import com.baidubce.services.moladb.model.KeySchemaElement;
import com.baidubce.services.moladb.model.ProvisionedThroughputDescription;
import com.baidubce.services.moladb.model.transform.KeySchemaUnmarshaller;
import com.baidubce.services.moladb.model.transform.ProvisionedThroughputUnmarshaller;
import com.baidubce.services.moladb.model.transform.Unmarshaller;
import com.baidubce.services.moladb.model.transform.Unmarshallers;
import com.baidubce.util.JsonUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class DescribeTableUnmarshaller
implements Unmarshaller<GetTableResponse, InputStream> {
    private GetTableResponse result;

    public DescribeTableUnmarshaller(AbstractBceResponse response) {
        this.result = (GetTableResponse)response;
    }

    @Override
    public GetTableResponse unmarshall(InputStream inputStream) throws Exception {
        String streamContents = Unmarshallers.readStreamContents(inputStream);
        JsonNode root = JsonUtils.jsonNodeOf(streamContents);
        if (!root.isObject()) {
            throw new BceClientException("input json object:" + root.toString() + " is not an object");
        }
        JsonNode tableObj = root;
        JsonNode attrListObj = tableObj.get("attributeDefinitions");
        List<AttributeDefinition> attrDef = this.parseAttributesDefinistion(attrListObj);
        JsonNode keySchemaNode = tableObj.get("keySchema");
        this.parseKeySchema(keySchemaNode, this.result);
        JsonNode provisionNode = tableObj.get("provisionedThroughput");
        this.parseProvision(provisionNode, this.result);
        this.result.setAttributeDefinitions(attrDef);
        String time = tableObj.get("creationDateTime").asText();
        SimpleDateFormat formarter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        Date date = formarter.parse(time);
        this.result.setCreationDateTime(date);
        this.result.setItemCount(tableObj.get("itemCount").asLong());
        this.result.setTableName(tableObj.get("tableName").asText());
        this.result.setTableStatus(tableObj.get("tableStatus").asText());
        this.result.setTableSizeInBytes(tableObj.get("tableSizeInBytes").asLong());
        return this.result;
    }

    private void parseProvision(JsonNode provisionNode, GetTableResponse result) throws Exception {
        ProvisionedThroughputDescription provision = new ProvisionedThroughputUnmarshaller().unmarshall(provisionNode);
        result.setProvisionedThroughput(provision);
    }

    private void parseKeySchema(JsonNode keyNode, GetTableResponse result) throws Exception {
        List<KeySchemaElement> keySchema = new KeySchemaUnmarshaller().unmarshall(keyNode);
        result.setKeySchema(keySchema);
    }

    private List<AttributeDefinition> parseAttributesDefinistion(JsonNode attrListObj) {
        if (!attrListObj.isArray()) {
            throw new BceClientException("Invalid json responseContent. attributeDefinitions is not an array.");
        }
        ArrayList<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>();
        Iterator attrList = attrListObj.elements();
        while (attrList.hasNext()) {
            JsonNode attrObj = (JsonNode)attrList.next();
            String name = attrObj.get("attributeName").asText();
            String type = attrObj.get("attributeType").asText();
            AttributeDefinition attr = new AttributeDefinition();
            attr.withAttributeName(name).withAttributeType(type);
            attributes.add(attr);
        }
        return attributes;
    }
}

