/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.mms;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.mms.model.InsertVideoResultResponse;
import com.baidubce.services.mms.model.MmsBaseResponse;
import com.baidubce.services.mms.model.SearchImageResponse;
import com.baidubce.services.mms.model.SearchVideoResponse;
import com.baidubce.services.mms.model.SourceAndDescRequest;
import com.baidubce.services.mms.model.SourceRequest;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;

public class MmsClient
extends AbstractBceClient {
    private static final String VERSION = "v2";
    private static final String VIDEO_LIB = "videolib";
    private static final String IMAGE_LIB = "imagelib";
    private static final String SEARCH_BY_IMAGE = "searchByImage";
    private static final String SEARCH_BY_VIDEO = "searchByVideo";
    private static final String DELETE_VIDEO = "deleteVideo";
    private static final String DELETE_IMAGE = "deleteImage";
    private static final String SOURCE = "source";
    private static HttpResponseHandler[] mmsHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public MmsClient(BceClientConfiguration config) {
        super(config, mmsHandlers);
    }

    public MmsBaseResponse insertVideo(String libName, SourceAndDescRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, VERSION, VIDEO_LIB, libName);
        return this.invokeHttpClient(internalRequest, MmsBaseResponse.class);
    }

    public InsertVideoResultResponse getInsertVideoResult(String libName, SourceRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, VERSION, VIDEO_LIB, libName);
        internalRequest.addParameter(SOURCE, request.getSource());
        return this.invokeHttpClient(internalRequest, InsertVideoResultResponse.class);
    }

    public MmsBaseResponse searchVideoByVideo(String libName, SourceAndDescRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, VERSION, VIDEO_LIB, libName);
        internalRequest.addParameter(SEARCH_BY_VIDEO, "");
        return this.invokeHttpClient(internalRequest, MmsBaseResponse.class);
    }

    public SearchVideoResponse getSearchVideoByVideoResult(String libName, SourceRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, VERSION, VIDEO_LIB, libName);
        internalRequest.addParameter(SOURCE, request.getSource());
        internalRequest.addParameter(SEARCH_BY_VIDEO, "");
        return this.invokeHttpClient(internalRequest, SearchVideoResponse.class);
    }

    public SearchVideoResponse searchVideoByImage(String libName, SourceAndDescRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, VERSION, VIDEO_LIB, libName);
        internalRequest.addParameter(SOURCE, request.getSource());
        internalRequest.addParameter(SEARCH_BY_IMAGE, "");
        return this.invokeHttpClient(internalRequest, SearchVideoResponse.class);
    }

    public MmsBaseResponse deleteVideo(String libName, SourceRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, VERSION, VIDEO_LIB, libName);
        internalRequest.addParameter(SOURCE, request.getSource());
        internalRequest.addParameter(DELETE_VIDEO, "");
        return this.invokeHttpClient(internalRequest, MmsBaseResponse.class);
    }

    public MmsBaseResponse insertImage(String libName, SourceAndDescRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, VERSION, IMAGE_LIB, libName);
        return this.invokeHttpClient(internalRequest, MmsBaseResponse.class);
    }

    public SearchImageResponse searchImageByImage(String libName, SourceAndDescRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, VERSION, IMAGE_LIB, libName);
        internalRequest.addParameter(SEARCH_BY_IMAGE, "");
        return this.invokeHttpClient(internalRequest, SearchImageResponse.class);
    }

    public MmsBaseResponse deleteImage(String libName, SourceRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, VERSION, IMAGE_LIB, libName);
        internalRequest.addParameter(SOURCE, request.getSource());
        internalRequest.addParameter(DELETE_IMAGE, "");
        return this.invokeHttpClient(internalRequest, MmsBaseResponse.class);
    }

    private InternalRequest createRequest(HttpMethodName httpMethod, AbstractBceRequest request, String ... pathVariables) {
        ArrayList<String> pathComponents = new ArrayList<String>();
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                pathComponents.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), pathComponents.toArray(new String[pathComponents.size()]));
        InternalRequest internalRequest = new InternalRequest(httpMethod, uri);
        internalRequest.setCredentials(request.getRequestCredentials());
        if (httpMethod == HttpMethodName.POST || httpMethod == HttpMethodName.PUT) {
            this.fillRequestPayload(internalRequest, request);
        }
        return internalRequest;
    }

    private InternalRequest fillRequestPayload(InternalRequest internalRequest, AbstractBceRequest request) {
        String strJson = JsonUtils.toJsonString(request);
        byte[] requestJson = null;
        try {
            requestJson = strJson.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Unsupported encode.", e);
        }
        internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
        internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        return internalRequest;
    }
}

