/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.media.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.media.model.Audio;
import com.baidubce.services.media.model.Clip;
import com.baidubce.services.media.model.Encryption;
import com.baidubce.services.media.model.ExtraCfg;
import com.baidubce.services.media.model.GetPresetResponse;
import com.baidubce.services.media.model.TransCfg;
import com.baidubce.services.media.model.Video;
import com.baidubce.services.media.model.Watermarks;
import com.baidubce.util.Validate;

public class UpdatePresetRequest
extends AbstractBceRequest {
    private String presetName = null;
    private String description = null;
    private String container = null;
    private Boolean transmux = null;
    private Clip clip = null;
    private Audio audio = null;
    private Video video = null;
    private Encryption encryption = null;
    private String watermarkId = null;
    private Watermarks watermarks = null;
    private TransCfg transCfg = null;
    private ExtraCfg extraCfg = null;

    public UpdatePresetRequest withPreset(GetPresetResponse preset) {
        Validate.checkStringNotEmpty(preset.getPresetName(), "The parameter presetName should NOT be null or empty string.");
        this.presetName = preset.getPresetName();
        this.description = preset.getDescription();
        this.container = preset.getContainer();
        this.transmux = preset.getTransmux();
        this.clip = preset.getClip();
        this.audio = preset.getAudio();
        this.video = preset.getVideo();
        this.encryption = preset.getEncryption();
        this.watermarkId = preset.getWatermarkId();
        this.watermarks = preset.getWatermarks();
        this.transCfg = preset.getTransCfg();
        this.extraCfg = preset.getExtraCfg();
        return this;
    }

    public UpdatePresetRequest withPresetName(String presetName) {
        Validate.checkStringNotEmpty(presetName, "The parameter presetName should NOT be null or empty string.");
        this.presetName = presetName;
        return this;
    }

    public UpdatePresetRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    public UpdatePresetRequest withContainer(String container) {
        Validate.checkNotNull(container, "The parameter container should NOT be null.");
        this.container = container;
        return this;
    }

    public UpdatePresetRequest withTransmux(Boolean transmux) {
        this.transmux = transmux;
        return this;
    }

    public UpdatePresetRequest withClip(Clip clip) {
        this.clip = clip;
        return this;
    }

    public UpdatePresetRequest withAudio(Audio audio) {
        this.audio = audio;
        return this;
    }

    public UpdatePresetRequest withVideo(Video video) {
        this.video = video;
        return this;
    }

    public UpdatePresetRequest withEncryption(Encryption encryption) {
        this.encryption = encryption;
        return this;
    }

    public UpdatePresetRequest withWatermarkId(String watermarkId) {
        this.watermarkId = watermarkId;
        return this;
    }

    public UpdatePresetRequest withWatermarks(Watermarks watermarks) {
        this.watermarks = watermarks;
        return this;
    }

    public UpdatePresetRequest withTransCfg(TransCfg transCfg) {
        this.transCfg = transCfg;
        return this;
    }

    public UpdatePresetRequest withExtraCfg(ExtraCfg extraCfg) {
        this.extraCfg = extraCfg;
        return this;
    }

    @Override
    public UpdatePresetRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreatePresetRequest {\n");
        sb.append("    presetName: ").append(this.presetName).append("\n");
        sb.append("    description: ").append(this.description).append("\n");
        sb.append("    container: ").append(this.container).append("\n");
        sb.append("    transmux: ").append(this.transmux).append("\n");
        sb.append("    clip: ").append(this.clip).append("\n");
        sb.append("    audio: ").append(this.audio).append("\n");
        sb.append("    video: ").append(this.video).append("\n");
        sb.append("    encryption: ").append(this.encryption).append("\n");
        sb.append("    watermarkId: ").append(this.watermarkId).append("\n");
        sb.append("    watermarks: ").append(this.watermarks).append("\n");
        sb.append("    transCfg: ").append(this.transCfg).append("\n");
        sb.append("    extraCfg: ").append(this.extraCfg).append("\n");
        sb.append("}\n");
        return sb.toString();
    }

    public String getPresetName() {
        return this.presetName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getContainer() {
        return this.container;
    }

    public Boolean getTransmux() {
        return this.transmux;
    }

    public Clip getClip() {
        return this.clip;
    }

    public Audio getAudio() {
        return this.audio;
    }

    public Video getVideo() {
        return this.video;
    }

    public Encryption getEncryption() {
        return this.encryption;
    }

    public String getWatermarkId() {
        return this.watermarkId;
    }

    public Watermarks getWatermarks() {
        return this.watermarks;
    }

    public TransCfg getTransCfg() {
        return this.transCfg;
    }

    public ExtraCfg getExtraCfg() {
        return this.extraCfg;
    }

    public void setPresetName(String presetName) {
        this.presetName = presetName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public void setTransmux(Boolean transmux) {
        this.transmux = transmux;
    }

    public void setClip(Clip clip) {
        this.clip = clip;
    }

    public void setAudio(Audio audio) {
        this.audio = audio;
    }

    public void setVideo(Video video) {
        this.video = video;
    }

    public void setEncryption(Encryption encryption) {
        this.encryption = encryption;
    }

    public void setWatermarkId(String watermarkId) {
        this.watermarkId = watermarkId;
    }

    public void setWatermarks(Watermarks watermarks) {
        this.watermarks = watermarks;
    }

    public void setTransCfg(TransCfg transCfg) {
        this.transCfg = transCfg;
    }

    public void setExtraCfg(ExtraCfg extraCfg) {
        this.extraCfg = extraCfg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdatePresetRequest)) {
            return false;
        }
        UpdatePresetRequest other = (UpdatePresetRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$presetName = this.getPresetName();
        String other$presetName = other.getPresetName();
        if (this$presetName == null ? other$presetName != null : !this$presetName.equals(other$presetName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$container = this.getContainer();
        String other$container = other.getContainer();
        if (this$container == null ? other$container != null : !this$container.equals(other$container)) {
            return false;
        }
        Boolean this$transmux = this.getTransmux();
        Boolean other$transmux = other.getTransmux();
        if (this$transmux == null ? other$transmux != null : !((Object)this$transmux).equals(other$transmux)) {
            return false;
        }
        Clip this$clip = this.getClip();
        Clip other$clip = other.getClip();
        if (this$clip == null ? other$clip != null : !this$clip.equals(other$clip)) {
            return false;
        }
        Audio this$audio = this.getAudio();
        Audio other$audio = other.getAudio();
        if (this$audio == null ? other$audio != null : !this$audio.equals(other$audio)) {
            return false;
        }
        Video this$video = this.getVideo();
        Video other$video = other.getVideo();
        if (this$video == null ? other$video != null : !this$video.equals(other$video)) {
            return false;
        }
        Encryption this$encryption = this.getEncryption();
        Encryption other$encryption = other.getEncryption();
        if (this$encryption == null ? other$encryption != null : !this$encryption.equals(other$encryption)) {
            return false;
        }
        String this$watermarkId = this.getWatermarkId();
        String other$watermarkId = other.getWatermarkId();
        if (this$watermarkId == null ? other$watermarkId != null : !this$watermarkId.equals(other$watermarkId)) {
            return false;
        }
        Watermarks this$watermarks = this.getWatermarks();
        Watermarks other$watermarks = other.getWatermarks();
        if (this$watermarks == null ? other$watermarks != null : !this$watermarks.equals(other$watermarks)) {
            return false;
        }
        TransCfg this$transCfg = this.getTransCfg();
        TransCfg other$transCfg = other.getTransCfg();
        if (this$transCfg == null ? other$transCfg != null : !this$transCfg.equals(other$transCfg)) {
            return false;
        }
        ExtraCfg this$extraCfg = this.getExtraCfg();
        ExtraCfg other$extraCfg = other.getExtraCfg();
        return !(this$extraCfg == null ? other$extraCfg != null : !((Object)this$extraCfg).equals(other$extraCfg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UpdatePresetRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $presetName = this.getPresetName();
        result = result * 59 + ($presetName == null ? 43 : $presetName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $container = this.getContainer();
        result = result * 59 + ($container == null ? 43 : $container.hashCode());
        Boolean $transmux = this.getTransmux();
        result = result * 59 + ($transmux == null ? 43 : ((Object)$transmux).hashCode());
        Clip $clip = this.getClip();
        result = result * 59 + ($clip == null ? 43 : $clip.hashCode());
        Audio $audio = this.getAudio();
        result = result * 59 + ($audio == null ? 43 : $audio.hashCode());
        Video $video = this.getVideo();
        result = result * 59 + ($video == null ? 43 : $video.hashCode());
        Encryption $encryption = this.getEncryption();
        result = result * 59 + ($encryption == null ? 43 : $encryption.hashCode());
        String $watermarkId = this.getWatermarkId();
        result = result * 59 + ($watermarkId == null ? 43 : $watermarkId.hashCode());
        Watermarks $watermarks = this.getWatermarks();
        result = result * 59 + ($watermarks == null ? 43 : $watermarks.hashCode());
        TransCfg $transCfg = this.getTransCfg();
        result = result * 59 + ($transCfg == null ? 43 : $transCfg.hashCode());
        ExtraCfg $extraCfg = this.getExtraCfg();
        result = result * 59 + ($extraCfg == null ? 43 : ((Object)$extraCfg).hashCode());
        return result;
    }
}

