/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.lps;

import com.baidubce.BceClientConfiguration;
import com.baidubce.http.HttpMethodName;
import com.baidubce.internal.InternalRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.lps.BaseLpsClient;
import com.baidubce.services.lps.model.ListRouteResponse;
import com.baidubce.services.lps.model.UploadRouteRequest;
import com.baidubce.services.lps.model.UploadRouteResponse;
import com.baidubce.util.JsonUtils;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LpsRouteClient
extends BaseLpsClient {
    private static final Logger log = LoggerFactory.getLogger(LpsRouteClient.class);
    private static final String UPLOAD_ROUTE_URL_PATH = "/v1/lps/route/upload";
    private static final String LIST_ROUTE_URL_PATH = "/v1/lps/route/list";
    private static final String ROUTE_URL_PATH = "/v1/lps/route";
    private static final String PAGE_NO = "pageNo";
    private static final String PAGE_SIZE = "pageSize";

    public LpsRouteClient() {
    }

    public LpsRouteClient(BceClientConfiguration configuration) {
        super(configuration);
    }

    public LpsRouteClient(String accessKey, String secretKey) {
        super(accessKey, secretKey);
    }

    public UploadRouteResponse uploadRouteInfo(UploadRouteRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, UPLOAD_ROUTE_URL_PATH);
        log.info("uploadRouteInfo request: {}", (Object)JsonUtils.toJsonString(internalRequest));
        return this.invokeHttpClient(internalRequest, UploadRouteResponse.class);
    }

    public ListRouteResponse listRouteInfo(int pageNo, int pageSize) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PAGE_NO, String.valueOf(pageNo));
        params.put(PAGE_SIZE, String.valueOf(pageSize));
        InternalRequest internalRequest = this.createRequest(null, HttpMethodName.GET, LIST_ROUTE_URL_PATH);
        internalRequest.setParameters(params);
        log.info("listRouteInfo request: {}", (Object)JsonUtils.toJsonString(internalRequest));
        return this.invokeHttpClient(internalRequest, ListRouteResponse.class);
    }

    public void deleteRouteInfo(String routeId) {
        InternalRequest internalRequest = this.createRequest(null, HttpMethodName.DELETE, "/v1/lps/route/" + routeId);
        log.info("deleteRouteInfo request: {}", (Object)JsonUtils.toJsonString(internalRequest));
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }
}

