/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iothisk;

import com.baidubce.BceClientConfiguration;
import com.baidubce.http.HttpMethodName;
import com.baidubce.internal.InternalRequest;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.iothisk.AbstractIotHiskBceClient;
import com.baidubce.services.iothisk.model.ActiveRequest;
import com.baidubce.services.iothisk.model.ActiveResponse;
import com.baidubce.services.iothisk.model.AuthRequest;
import com.baidubce.services.iothisk.model.CipherRequest;
import com.baidubce.services.iothisk.model.CipherResponse;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;

public class IotHiskClient
extends AbstractIotHiskBceClient {
    private static final String ENDPOINT = "hisk.baidubce.com";
    private static final String VERSION = "v1";
    private static final String TSM = "tsm";
    private static final String DEVICE = "device";
    private static final String DECRYPT = "decrypt";
    private static final String ENCRYPT = "encrypt";
    private static final String ACTIVE = "active";
    private static final String AUTH = "auth";
    private static final String NULL_DEVICE_ID = "device id should not be null.";
    private static final String NULL_REQUEST = "request should not be null.";

    public IotHiskClient(BceClientConfiguration config) {
        super(config.getEndpoint() == null ? config.withEndpoint(ENDPOINT) : config, HANDLERS);
    }

    public CipherResponse encrypt(String deviceId, CipherRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)NULL_REQUEST);
        Preconditions.checkNotNull((Object)deviceId, (Object)NULL_DEVICE_ID);
        InternalRequest internalRequest = this.createTsmDeviceRequest(request, HttpMethodName.POST, deviceId, ENCRYPT);
        return this.invokeHttpClient(internalRequest, CipherResponse.class);
    }

    public CipherResponse decrypt(String deviceId, CipherRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)NULL_REQUEST);
        Preconditions.checkNotNull((Object)deviceId, (Object)NULL_DEVICE_ID);
        InternalRequest internalRequest = this.createTsmDeviceRequest(request, HttpMethodName.POST, deviceId, DECRYPT);
        return this.invokeHttpClient(internalRequest, CipherResponse.class);
    }

    public ActiveResponse active(String deviceId, ActiveRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)NULL_REQUEST);
        Preconditions.checkNotNull((Object)deviceId, (Object)NULL_DEVICE_ID);
        InternalRequest internalRequest = this.createTsmDeviceRequest(request, HttpMethodName.POST, deviceId, ACTIVE);
        return this.invokeHttpClient(internalRequest, ActiveResponse.class);
    }

    public void auth(String deviceId, AuthRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)NULL_REQUEST);
        Preconditions.checkNotNull((Object)deviceId, (Object)NULL_DEVICE_ID);
        InternalRequest internalRequest = this.createTsmDeviceRequest(request, HttpMethodName.POST, deviceId, AUTH);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    private InternalRequest createTsmDeviceRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String deviceId, String action) {
        ArrayList<String> path = new ArrayList<String>();
        path.addAll(Arrays.asList(VERSION, TSM, DEVICE));
        return this.createRequest(bceRequest, httpMethod, null, path, deviceId, action);
    }
}

