/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce;

import com.baidubce.BceClientConfiguration;
import com.baidubce.auth.BceV1Signer;
import com.baidubce.http.BceHttpClient;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.util.DateUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import org.apache.http.annotation.ThreadSafe;

@ThreadSafe
public abstract class AbstractBceClient {
    public static final String DEFAULT_SERVICE_DOMAIN = "baidubce.com";
    public static final String URL_PREFIX = "v1";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String DEFAULT_CONTENT_TYPE = "application/json; charset=utf-8";
    private String serviceId = this.computeServiceId();
    private URI endpoint;
    private BceHttpClient client;
    protected BceClientConfiguration config;
    private HttpResponseHandler[] responseHandlers;

    public AbstractBceClient(BceClientConfiguration config, HttpResponseHandler[] responseHandlers, boolean isHttpAsyncPutEnabled) {
        this.config = config;
        this.endpoint = this.computeEndpoint();
        this.client = new BceHttpClient(config, new BceV1Signer(), isHttpAsyncPutEnabled);
        this.responseHandlers = responseHandlers;
    }

    public AbstractBceClient(BceClientConfiguration config, HttpResponseHandler[] responseHandlers) {
        this(config, responseHandlers, false);
    }

    public boolean isRegionSupported() {
        return true;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public BceHttpClient getClient() {
        return this.client;
    }

    public void setClient(BceHttpClient client) {
        this.client = client;
    }

    public void shutdown() {
        this.client.shutdown();
    }

    protected <T extends AbstractBceResponse> T invokeHttpClient(InternalRequest request, Class<T> responseClass) {
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        if (!request.getHeaders().containsKey("Date")) {
            request.addHeader("Date", DateUtils.formatRfc822Date(new Date()));
        }
        return this.client.execute(request, responseClass, this.responseHandlers);
    }

    public String computeServiceId() {
        String prefix;
        String packageName = this.getClass().getPackage().getName();
        if (!packageName.startsWith(prefix = AbstractBceClient.class.getPackage().getName() + ".services.")) {
            throw new IllegalStateException("Unrecognized prefix for the client package : " + packageName + ", '" + prefix + "' expected");
        }
        String serviceId = packageName.substring(prefix.length());
        if (serviceId.endsWith(".v2")) {
            serviceId = serviceId.substring(0, serviceId.length() - 3);
        }
        if (serviceId.indexOf(46) != -1) {
            throw new IllegalStateException("The client class should be put in package like " + prefix + "XXX");
        }
        String className = this.getClass().getName();
        String expectedClassName = packageName + '.' + Character.toUpperCase(serviceId.charAt(0)) + serviceId.substring(1) + "Client";
        return serviceId;
    }

    private URI computeEndpoint() {
        String endpoint = this.config.getEndpoint();
        try {
            if (endpoint == null) {
                endpoint = this.isRegionSupported() ? String.format("%s://%s.%s.%s", new Object[]{this.config.getProtocol(), this.serviceId, this.config.getRegion(), DEFAULT_SERVICE_DOMAIN}) : String.format("%s://%s.%s", new Object[]{this.config.getProtocol(), this.serviceId, DEFAULT_SERVICE_DOMAIN});
            }
            return new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid endpoint." + endpoint, e);
        }
    }
}

